/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.IO;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ResponseHeadersTest {
    private static Server server;
    private static ServerConnector connector;
    private static URI serverUri;

    @BeforeClass
    public static void startServer() throws Exception {
        server = new Server();
        connector = new ServerConnector(server);
        server.addConnector((Connector)connector);
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/");
        server.setHandler((Handler)context);
        context.addServlet(new ServletHolder((Servlet)new SimulateUpgradeServlet()), "/*");
        server.start();
        String host = connector.getHost();
        if (host == null) {
            host = "localhost";
        }
        int port = connector.getLocalPort();
        serverUri = new URI(String.format("http://%s:%d/", host, port));
    }

    @AfterClass
    public static void stopServer() {
        try {
            server.stop();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testResponseHeaderFormat() throws IOException {
        Socket socket = new Socket();
        InetSocketAddress endpoint = new InetSocketAddress(serverUri.getHost(), serverUri.getPort());
        socket.connect(endpoint);
        StringBuilder req = new StringBuilder();
        req.append("GET / HTTP/1.1\r\n");
        req.append(String.format("Host: %s:%d\r\n", serverUri.getHost(), serverUri.getPort()));
        req.append("\r\n");
        OutputStream out = null;
        InputStream in = null;
        try {
            out = socket.getOutputStream();
            in = socket.getInputStream();
            out.write(req.toString().getBytes());
            out.flush();
            String respHeader = this.readResponseHeader(in);
            Assert.assertThat((String)"Response Code", (Object)respHeader, (Matcher)Matchers.startsWith((String)"HTTP/1.1 101 Switching Protocols"));
            Assert.assertThat((String)"Response Header Upgrade", (Object)respHeader, (Matcher)Matchers.containsString((String)"Upgrade: WebSocket\r\n"));
            Assert.assertThat((String)"Response Header Connection", (Object)respHeader, (Matcher)Matchers.containsString((String)"Connection: Upgrade\r\n"));
        }
        catch (Throwable throwable) {
            IO.close(in);
            IO.close((OutputStream)out);
            socket.close();
            throw throwable;
        }
        IO.close((InputStream)in);
        IO.close((OutputStream)out);
        socket.close();
    }

    private String readResponseHeader(InputStream in) throws IOException {
        InputStreamReader isr = new InputStreamReader(in);
        BufferedReader reader = new BufferedReader(isr);
        StringBuilder header = new StringBuilder();
        String line = reader.readLine();
        Assert.assertNotNull((Object)line);
        Assert.assertThat((Object)line, (Matcher)Matchers.startsWith((String)"HTTP/1.1 "));
        header.append(line).append("\r\n");
        while ((line = reader.readLine()) != null && line.trim().length() != 0) {
            header.append(line).append("\r\n");
        }
        return header.toString();
    }

    private static class SimulateUpgradeServlet
    extends HttpServlet {
        private SimulateUpgradeServlet() {
        }

        protected void doGet(HttpServletRequest req, HttpServletResponse response) throws ServletException, IOException {
            response.setHeader("Upgrade", "WebSocket");
            response.addHeader("Connection", "Upgrade");
            response.addHeader("Sec-WebSocket-Accept", "123456789==");
            response.setStatus(101);
        }
    }
}

