/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.EventListener;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.ReadListener;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpTester;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.toolchain.test.AdvancedRunner;
import org.eclipse.jetty.toolchain.test.http.SimpleHttpParser;
import org.eclipse.jetty.toolchain.test.http.SimpleHttpResponse;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.log.StacklessLogging;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=AdvancedRunner.class)
public class AsyncIOServletTest {
    private Server server;
    private ServerConnector connector;
    private ServletContextHandler context;
    private String path = "/path";
    private static final ThreadLocal<Throwable> scope = new ThreadLocal();

    public void startServer(HttpServlet servlet) throws Exception {
        this.startServer(servlet, 30000L);
    }

    public void startServer(HttpServlet servlet, long idleTimeout) throws Exception {
        this.server = new Server();
        this.connector = new ServerConnector(this.server);
        this.connector.setIdleTimeout(idleTimeout);
        ((HttpConnectionFactory)this.connector.getConnectionFactory(HttpConnectionFactory.class)).getHttpConfiguration().setDelayDispatchUntilContent(false);
        this.server.addConnector((Connector)this.connector);
        this.context = new ServletContextHandler((HandlerContainer)this.server, "/", false, false);
        ServletHolder holder = new ServletHolder((Servlet)servlet);
        holder.setAsyncSupported(true);
        this.context.addServlet(holder, this.path);
        this.context.addEventListener((EventListener)new ContextHandler.ContextScopeListener(){

            public void enterScope(ContextHandler.Context context, Request request, Object reason) {
                if (scope.get() != null) {
                    System.err.println(Thread.currentThread() + " Already entered scope!!!");
                    ((Throwable)scope.get()).printStackTrace();
                    throw new IllegalStateException();
                }
                scope.set(new Throwable());
            }

            public void exitScope(ContextHandler.Context context, Request request) {
                if (scope.get() == null) {
                    throw new IllegalStateException();
                }
                scope.set(null);
            }
        });
        this.server.start();
    }

    private static void assertScope() {
        if (scope.get() == null) {
            Assert.fail((String)"Not in scope");
        }
    }

    @After
    public void stopServer() throws Exception {
        this.server.stop();
        if (scope.get() != null) {
            System.err.println("Still in scope after stop!");
            scope.get().printStackTrace();
            throw new IllegalStateException("Didn't leave scope");
        }
        scope.set(null);
    }

    @Test
    public void testAsyncReadThrowsException() throws Exception {
        this.testAsyncReadThrows(new NullPointerException("explicitly_thrown_by_test"));
    }

    @Test
    public void testAsyncReadThrowsError() throws Exception {
        this.testAsyncReadThrows(new Error("explicitly_thrown_by_test"));
    }

    private void testAsyncReadThrows(final Throwable throwable) throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        this.startServer(new HttpServlet(){

            protected void service(HttpServletRequest request, final HttpServletResponse response) throws ServletException, IOException {
                AsyncIOServletTest.assertScope();
                final AsyncContext asyncContext = request.startAsync((ServletRequest)request, (ServletResponse)response);
                request.getInputStream().setReadListener(new ReadListener(){

                    public void onDataAvailable() throws IOException {
                        AsyncIOServletTest.assertScope();
                        if (throwable instanceof RuntimeException) {
                            throw (RuntimeException)throwable;
                        }
                        if (throwable instanceof Error) {
                            throw (Error)throwable;
                        }
                        throw new IOException(throwable);
                    }

                    public void onAllDataRead() throws IOException {
                        AsyncIOServletTest.assertScope();
                    }

                    public void onError(Throwable t) {
                        AsyncIOServletTest.assertScope();
                        Assert.assertThat((String)"onError type", (Object)t, (Matcher)Matchers.instanceOf(throwable.getClass()));
                        Assert.assertThat((String)"onError message", (Object)t.getMessage(), (Matcher)Matchers.is((Object)throwable.getMessage()));
                        latch.countDown();
                        response.setStatus(500);
                        asyncContext.complete();
                    }
                });
            }
        });
        String data = "0123456789";
        String request = "GET " + this.path + " HTTP/1.1\r\n" + "Host: localhost:" + this.connector.getLocalPort() + "\r\n" + "Content-Length: " + data.length() + "\r\n" + "\r\n" + data;
        try (Socket client = new Socket("localhost", this.connector.getLocalPort());){
            client.setSoTimeout(5000);
            OutputStream output = client.getOutputStream();
            output.write(request.getBytes("UTF-8"));
            output.flush();
            BufferedReader in = new BufferedReader(new InputStreamReader(client.getInputStream()));
            String line = in.readLine();
            Assert.assertThat((Object)line, (Matcher)Matchers.containsString((String)"500 Server Error"));
            while (line.length() > 0) {
                line = in.readLine();
            }
            line = in.readLine();
            Assert.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
        }
    }

    @Test
    public void testAsyncReadIdleTimeout() throws Exception {
        int status = 567;
        this.startServer(new HttpServlet(){

            protected void service(HttpServletRequest request, final HttpServletResponse response) throws ServletException, IOException {
                AsyncIOServletTest.assertScope();
                final AsyncContext asyncContext = request.startAsync((ServletRequest)request, (ServletResponse)response);
                asyncContext.setTimeout(0L);
                final ServletInputStream inputStream = request.getInputStream();
                inputStream.setReadListener(new ReadListener(){

                    public void onDataAvailable() throws IOException {
                        AsyncIOServletTest.assertScope();
                        while (inputStream.isReady() && !inputStream.isFinished()) {
                            inputStream.read();
                        }
                    }

                    public void onAllDataRead() throws IOException {
                        AsyncIOServletTest.assertScope();
                    }

                    public void onError(Throwable t) {
                        AsyncIOServletTest.assertScope();
                        response.setStatus(567);
                        asyncContext.complete();
                    }
                });
            }
        }, 1000L);
        String data1 = "0123456789";
        String data2 = "ABCDEF";
        String request = "GET " + this.path + " HTTP/1.1\r\n" + "Host: localhost:" + this.connector.getLocalPort() + "\r\n" + "Content-Length: " + (data1.length() + data2.length()) + "\r\n" + "\r\n" + data1;
        try (Socket client = new Socket("localhost", this.connector.getLocalPort());){
            client.setSoTimeout(5000);
            OutputStream output = client.getOutputStream();
            output.write(request.getBytes("UTF-8"));
            output.flush();
            SimpleHttpParser parser = new SimpleHttpParser();
            SimpleHttpResponse response = parser.readResponse(new BufferedReader(new InputStreamReader(client.getInputStream(), "UTF-8")));
            Assert.assertEquals((Object)String.valueOf(567), (Object)response.getCode());
            Assert.assertEquals((long)-1L, (long)client.getInputStream().read());
        }
    }

    @Test
    public void testOnErrorThrows() throws Exception {
        final AtomicInteger errors = new AtomicInteger();
        this.startServer(new HttpServlet(){

            protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                AsyncIOServletTest.assertScope();
                if (request.getDispatcherType() == DispatcherType.ERROR) {
                    response.flushBuffer();
                    return;
                }
                AsyncContext asyncContext = request.startAsync((ServletRequest)request, (ServletResponse)response);
                request.getInputStream().setReadListener(new ReadListener(){

                    public void onDataAvailable() throws IOException {
                        AsyncIOServletTest.assertScope();
                        throw new NullPointerException("explicitly_thrown_by_test_1");
                    }

                    public void onAllDataRead() throws IOException {
                        AsyncIOServletTest.assertScope();
                    }

                    public void onError(final Throwable t) {
                        AsyncIOServletTest.assertScope();
                        errors.incrementAndGet();
                        throw new NullPointerException("explicitly_thrown_by_test_2"){
                            {
                                super(x0);
                                this.initCause(t);
                            }
                        };
                    }
                });
            }
        });
        String data = "0123456789";
        String request = "GET " + this.path + " HTTP/1.1\r\n" + "Host: localhost:" + this.connector.getLocalPort() + "\r\n" + "Content-Length: " + data.length() + "\r\n" + "\r\n" + data;
        try (Socket client = new Socket("localhost", this.connector.getLocalPort());
             StacklessLogging stackless = new StacklessLogging(new Class[]{HttpChannel.class});){
            OutputStream output = client.getOutputStream();
            output.write(request.getBytes("UTF-8"));
            output.flush();
            SimpleHttpParser parser = new SimpleHttpParser();
            SimpleHttpResponse response = parser.readResponse(new BufferedReader(new InputStreamReader(client.getInputStream(), "UTF-8")));
            Assert.assertEquals((Object)"500", (Object)response.getCode());
            Assert.assertEquals((long)1L, (long)errors.get());
        }
    }

    @Test
    public void testAsyncWriteThrowsException() throws Exception {
        this.testAsyncWriteThrows(new NullPointerException("explicitly_thrown_by_test"));
    }

    @Test
    public void testAsyncWriteThrowsError() throws Exception {
        this.testAsyncWriteThrows(new Error("explicitly_thrown_by_test"));
    }

    private void testAsyncWriteThrows(final Throwable throwable) throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        this.startServer(new HttpServlet(){

            protected void service(HttpServletRequest request, final HttpServletResponse response) throws ServletException, IOException {
                AsyncIOServletTest.assertScope();
                final AsyncContext asyncContext = request.startAsync((ServletRequest)request, (ServletResponse)response);
                response.getOutputStream().setWriteListener(new WriteListener(){

                    public void onWritePossible() throws IOException {
                        AsyncIOServletTest.assertScope();
                        if (throwable instanceof RuntimeException) {
                            throw (RuntimeException)throwable;
                        }
                        if (throwable instanceof Error) {
                            throw (Error)throwable;
                        }
                        throw new IOException(throwable);
                    }

                    public void onError(Throwable t) {
                        AsyncIOServletTest.assertScope();
                        latch.countDown();
                        response.setStatus(500);
                        asyncContext.complete();
                        Assert.assertSame((Object)throwable, (Object)t);
                    }
                });
            }
        });
        String request = "GET " + this.path + " HTTP/1.1\r\n" + "Host: localhost:" + this.connector.getLocalPort() + "\r\n" + "\r\n";
        try (Socket client = new Socket("localhost", this.connector.getLocalPort());){
            OutputStream output = client.getOutputStream();
            output.write(request.getBytes("UTF-8"));
            output.flush();
            SimpleHttpParser parser = new SimpleHttpParser();
            SimpleHttpResponse response = parser.readResponse(new BufferedReader(new InputStreamReader(client.getInputStream(), "UTF-8")));
            Assert.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
            Assert.assertEquals((Object)"500", (Object)response.getCode());
        }
    }

    @Test
    public void testAsyncWriteClosed() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        String text = "Now is the winter of our discontent. How Now Brown Cow. The quick brown fox jumped over the lazy dog.\n";
        for (int i = 0; i < 10; ++i) {
            text = text + text;
        }
        final byte[] data = text.getBytes(StandardCharsets.ISO_8859_1);
        this.startServer(new HttpServlet(){

            protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                AsyncIOServletTest.assertScope();
                response.flushBuffer();
                final AsyncContext async = request.startAsync();
                final ServletOutputStream out = response.getOutputStream();
                out.setWriteListener(new WriteListener(){

                    public void onWritePossible() throws IOException {
                        AsyncIOServletTest.assertScope();
                        while (out.isReady()) {
                            try {
                                Thread.sleep(100L);
                                out.write(data);
                            }
                            catch (IOException e) {
                                throw e;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }

                    public void onError(Throwable t) {
                        AsyncIOServletTest.assertScope();
                        async.complete();
                        latch.countDown();
                    }
                });
            }
        });
        String request = "GET " + this.path + " HTTP/1.1\r\n" + "Host: localhost:" + this.connector.getLocalPort() + "\r\n" + "\r\n";
        try (Socket client = new Socket("localhost", this.connector.getLocalPort());){
            OutputStream output = client.getOutputStream();
            output.write(request.getBytes("UTF-8"));
            output.flush();
            BufferedReader in = new BufferedReader(new InputStreamReader(client.getInputStream()));
            String line = in.readLine();
            Assert.assertThat((Object)line, (Matcher)Matchers.containsString((String)"200 OK"));
            while (line.length() > 0) {
                line = in.readLine();
            }
            line = in.readLine();
            Assert.assertThat((Object)line, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)" ")));
            line = in.readLine();
            Assert.assertThat((Object)line, (Matcher)Matchers.containsString((String)"discontent. How Now Brown Cow. The "));
        }
        if (!latch.await(5L, TimeUnit.SECONDS)) {
            Assert.fail();
        }
    }

    @Test
    public void testIsReadyAtEOF() throws Exception {
        String text = "TEST\n";
        final byte[] data = text.getBytes(StandardCharsets.ISO_8859_1);
        this.startServer(new HttpServlet(){

            protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                AsyncIOServletTest.assertScope();
                response.flushBuffer();
                final AsyncContext async = request.startAsync();
                final ServletInputStream in = request.getInputStream();
                final ServletOutputStream out = response.getOutputStream();
                in.setReadListener(new ReadListener(){
                    transient int _i = 0;
                    transient boolean _minusOne = false;
                    transient boolean _finished = false;

                    public void onError(Throwable t) {
                        AsyncIOServletTest.assertScope();
                        t.printStackTrace();
                        async.complete();
                    }

                    public void onDataAvailable() throws IOException {
                        AsyncIOServletTest.assertScope();
                        while (in.isReady() && !in.isFinished()) {
                            int b = in.read();
                            if (b == -1) {
                                this._minusOne = true;
                                continue;
                            }
                            if (data[this._i++] == b) continue;
                            throw new IllegalStateException();
                        }
                        if (in.isFinished()) {
                            this._finished = true;
                        }
                    }

                    public void onAllDataRead() throws IOException {
                        AsyncIOServletTest.assertScope();
                        out.write(String.format("i=%d eof=%b finished=%b", this._i, this._minusOne, this._finished).getBytes(StandardCharsets.ISO_8859_1));
                        async.complete();
                    }
                });
            }
        });
        String request = "GET " + this.path + " HTTP/1.1\r\n" + "Host: localhost:" + this.connector.getLocalPort() + "\r\n" + "Content-Type: text/plain\r\n" + "Content-Length: " + data.length + "\r\n" + "Connection: close\r\n" + "\r\n";
        try (Socket client = new Socket("localhost", this.connector.getLocalPort());){
            OutputStream output = client.getOutputStream();
            output.write(request.getBytes("UTF-8"));
            output.flush();
            output.write(data);
            output.flush();
            BufferedReader in = new BufferedReader(new InputStreamReader(client.getInputStream()));
            String line = in.readLine();
            Assert.assertThat((Object)line, (Matcher)Matchers.containsString((String)"200 OK"));
            while (line.length() > 0) {
                line = in.readLine();
            }
            line = in.readLine();
            Assert.assertThat((Object)line, (Matcher)Matchers.containsString((String)("i=" + data.length + " eof=true finished=true")));
        }
    }

    @Test
    public void testOnAllDataRead() throws Exception {
        String text = "X";
        byte[] data = text.getBytes(StandardCharsets.ISO_8859_1);
        this.startServer(new HttpServlet(){

            protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                AsyncIOServletTest.assertScope();
                response.flushBuffer();
                final AsyncContext async = request.startAsync();
                async.setTimeout(5000L);
                final ServletInputStream in = request.getInputStream();
                final ServletOutputStream out = response.getOutputStream();
                in.setReadListener(new ReadListener(){

                    public void onError(Throwable t) {
                        AsyncIOServletTest.assertScope();
                        t.printStackTrace();
                        async.complete();
                    }

                    public void onDataAvailable() throws IOException {
                        AsyncIOServletTest.assertScope();
                        try {
                            Thread.sleep(1000L);
                            if (!in.isReady()) {
                                throw new IllegalStateException();
                            }
                            if (in.read() != 88) {
                                throw new IllegalStateException();
                            }
                            if (!in.isReady()) {
                                throw new IllegalStateException();
                            }
                            if (in.read() != -1) {
                                throw new IllegalStateException();
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }

                    public void onAllDataRead() throws IOException {
                        AsyncIOServletTest.assertScope();
                        out.write("OK\n".getBytes(StandardCharsets.ISO_8859_1));
                        async.complete();
                    }
                });
            }
        });
        String request = "GET " + this.path + " HTTP/1.1\r\n" + "Host: localhost:" + this.connector.getLocalPort() + "\r\n" + "Content-Type: text/plain\r\n" + "Content-Length: " + data.length + "\r\n" + "Connection: close\r\n" + "\r\n";
        try (Socket client = new Socket("localhost", this.connector.getLocalPort());){
            client.setSoTimeout(5000);
            OutputStream output = client.getOutputStream();
            output.write(request.getBytes("UTF-8"));
            output.flush();
            Thread.sleep(100L);
            output.write(data);
            output.flush();
            BufferedReader in = new BufferedReader(new InputStreamReader(client.getInputStream()));
            String line = in.readLine();
            Assert.assertThat((Object)line, (Matcher)Matchers.containsString((String)"200 OK"));
            while (line.length() > 0) {
                line = in.readLine();
            }
            line = in.readLine();
            Assert.assertThat((Object)line, (Matcher)Matchers.containsString((String)"OK"));
        }
    }

    @Test
    public void testOtherThreadOnAllDataRead() throws Exception {
        String text = "X";
        byte[] data = text.getBytes(StandardCharsets.ISO_8859_1);
        this.startServer(new HttpServlet(){

            protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                AsyncIOServletTest.assertScope();
                response.flushBuffer();
                final AsyncContext async = request.startAsync();
                async.setTimeout(500000L);
                final ServletInputStream in = request.getInputStream();
                final ServletOutputStream out = response.getOutputStream();
                if (request.getDispatcherType() == DispatcherType.ERROR) {
                    throw new IllegalStateException();
                }
                in.setReadListener(new ReadListener(){

                    public void onError(Throwable t) {
                        AsyncIOServletTest.assertScope();
                        t.printStackTrace();
                        async.complete();
                    }

                    public void onDataAvailable() throws IOException {
                        AsyncIOServletTest.assertScope();
                        async.start(new Runnable(){

                            @Override
                            public void run() {
                                AsyncIOServletTest.assertScope();
                                try {
                                    Thread.sleep(1000L);
                                    if (!in.isReady()) {
                                        throw new IllegalStateException();
                                    }
                                    if (in.read() != 88) {
                                        throw new IllegalStateException();
                                    }
                                    if (!in.isReady()) {
                                        throw new IllegalStateException();
                                    }
                                    if (in.read() != -1) {
                                        throw new IllegalStateException();
                                    }
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        });
                    }

                    public void onAllDataRead() throws IOException {
                        out.write("OK\n".getBytes(StandardCharsets.ISO_8859_1));
                        async.complete();
                    }
                });
            }
        });
        String request = "GET " + this.path + " HTTP/1.1\r\n" + "Host: localhost:" + this.connector.getLocalPort() + "\r\n" + "Content-Type: text/plain\r\n" + "Content-Length: " + data.length + "\r\n" + "Connection: close\r\n" + "\r\n";
        try (Socket client = new Socket("localhost", this.connector.getLocalPort());){
            client.setSoTimeout(500000);
            OutputStream output = client.getOutputStream();
            output.write(request.getBytes("UTF-8"));
            output.flush();
            Thread.sleep(100L);
            output.write(data);
            output.flush();
            BufferedReader in = new BufferedReader(new InputStreamReader(client.getInputStream()));
            String line = in.readLine();
            Assert.assertThat((Object)line, (Matcher)Matchers.containsString((String)"200 OK"));
            while (line.length() > 0) {
                line = in.readLine();
            }
            line = in.readLine();
            Assert.assertThat((Object)line, (Matcher)Matchers.containsString((String)"OK"));
        }
    }

    @Test
    public void testCompleteBeforeOnAllDataRead() throws Exception {
        String text = "XYZ";
        byte[] data = text.getBytes(StandardCharsets.ISO_8859_1);
        final AtomicBoolean allDataRead = new AtomicBoolean(false);
        this.startServer(new HttpServlet(){

            protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                AsyncIOServletTest.assertScope();
                response.flushBuffer();
                final AsyncContext async = request.startAsync();
                final ServletInputStream in = request.getInputStream();
                final ServletOutputStream out = response.getOutputStream();
                in.setReadListener(new ReadListener(){

                    public void onError(Throwable t) {
                        AsyncIOServletTest.assertScope();
                        t.printStackTrace();
                    }

                    public void onDataAvailable() throws IOException {
                        AsyncIOServletTest.assertScope();
                        while (in.isReady()) {
                            int b = in.read();
                            if (b >= 0) continue;
                            out.write("OK\n".getBytes(StandardCharsets.ISO_8859_1));
                            async.complete();
                            return;
                        }
                    }

                    public void onAllDataRead() throws IOException {
                        AsyncIOServletTest.assertScope();
                        out.write("BAD!!!\n".getBytes(StandardCharsets.ISO_8859_1));
                        allDataRead.set(true);
                        throw new IllegalStateException();
                    }
                });
            }
        });
        String request = "GET " + this.path + " HTTP/1.1\r\n" + "Host: localhost:" + this.connector.getLocalPort() + "\r\n" + "Content-Type: text/plain\r\n" + "Content-Length: " + data.length + "\r\n" + "Connection: close\r\n" + "\r\n";
        try (Socket client = new Socket("localhost", this.connector.getLocalPort());){
            OutputStream output = client.getOutputStream();
            output.write(request.getBytes("UTF-8"));
            output.flush();
            Thread.sleep(100L);
            output.write(data);
            output.flush();
            BufferedReader in = new BufferedReader(new InputStreamReader(client.getInputStream()));
            String line = in.readLine();
            Assert.assertThat((Object)line, (Matcher)Matchers.containsString((String)"200 OK"));
            while (line.length() > 0) {
                line = in.readLine();
            }
            line = in.readLine();
            Assert.assertThat((Object)line, (Matcher)Matchers.containsString((String)"OK"));
            Assert.assertFalse((boolean)allDataRead.get());
        }
    }

    @Test
    public void testEmptyAsyncRead() throws Exception {
        final AtomicBoolean oda = new AtomicBoolean();
        final CountDownLatch latch = new CountDownLatch(1);
        this.startServer(new HttpServlet(){

            protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                AsyncIOServletTest.assertScope();
                final AsyncContext asyncContext = request.startAsync((ServletRequest)request, (ServletResponse)response);
                response.setStatus(200);
                response.getOutputStream().close();
                request.getInputStream().setReadListener(new ReadListener(){

                    public void onDataAvailable() throws IOException {
                        AsyncIOServletTest.assertScope();
                        oda.set(true);
                    }

                    public void onAllDataRead() throws IOException {
                        AsyncIOServletTest.assertScope();
                        asyncContext.complete();
                        latch.countDown();
                    }

                    public void onError(Throwable t) {
                        AsyncIOServletTest.assertScope();
                        t.printStackTrace();
                        asyncContext.complete();
                    }
                });
            }
        });
        String request = "GET " + this.path + " HTTP/1.1\r\n" + "Host: localhost:" + this.connector.getLocalPort() + "\r\n" + "Connection: close\r\n" + "\r\n";
        try (Socket client = new Socket("localhost", this.connector.getLocalPort());){
            OutputStream output = client.getOutputStream();
            output.write(request.getBytes("UTF-8"));
            output.flush();
            String response = IO.toString((InputStream)client.getInputStream());
            Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)" 200 OK"));
            latch.await();
        }
        Assert.assertFalse((boolean)oda.get());
    }

    @Test
    public void testWriteFromOnDataAvailable() throws Exception {
        final ConcurrentLinkedQueue errors = new ConcurrentLinkedQueue();
        final CountDownLatch writeLatch = new CountDownLatch(1);
        this.startServer(new HttpServlet(){

            protected void service(final HttpServletRequest request, final HttpServletResponse response) throws ServletException, IOException {
                final AsyncContext asyncContext = request.startAsync();
                request.getInputStream().setReadListener(new ReadListener(){

                    public void onDataAvailable() throws IOException {
                        ServletInputStream input = request.getInputStream();
                        ServletOutputStream output = response.getOutputStream();
                        while (input.isReady()) {
                            byte[] buffer = new byte[512];
                            int read = input.read(buffer);
                            if (read < 0) {
                                asyncContext.complete();
                                break;
                            }
                            if (output.isReady()) {
                                output.write(buffer, 0, read);
                                continue;
                            }
                            Assert.fail();
                        }
                    }

                    public void onAllDataRead() throws IOException {
                    }

                    public void onError(Throwable t) {
                        errors.offer(t);
                    }
                });
                response.getOutputStream().setWriteListener(new WriteListener(){

                    public void onWritePossible() throws IOException {
                        writeLatch.countDown();
                    }

                    public void onError(Throwable t) {
                        errors.offer(t);
                    }
                });
            }
        });
        String content = "0123456789ABCDEF";
        try (Socket client = new Socket("localhost", this.connector.getLocalPort());){
            OutputStream output = client.getOutputStream();
            String request = "POST " + this.path + " HTTP/1.1\r\n" + "Host: localhost:" + this.connector.getLocalPort() + "\r\n" + "Transfer-Encoding: chunked\r\n" + "\r\n" + "10\r\n" + content + "\r\n";
            output.write(request.getBytes("UTF-8"));
            output.flush();
            Assert.assertTrue((boolean)writeLatch.await(5L, TimeUnit.SECONDS));
            request = "0\r\n\r\n";
            output.write(request.getBytes("UTF-8"));
            output.flush();
            HttpTester.Input input = HttpTester.from((InputStream)client.getInputStream());
            HttpTester.Response response = HttpTester.parseResponse((HttpTester.Input)input);
            Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)200));
            Assert.assertThat((Object)response.getContent(), (Matcher)Matchers.equalTo((Object)content));
            Assert.assertThat(errors, (Matcher)Matchers.hasSize((int)0));
        }
    }
}

