/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpTester;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.util.IO;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GzipHandlerTest {
    private static final String __content = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. In quis felis nunc. Quisque suscipit mauris et ante auctor ornare rhoncus lacus aliquet. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum sit amet felis augue, vel convallis dolor. Cras accumsan vehicula diam at faucibus. Etiam in urna turpis, sed congue mi. Morbi et lorem eros. Donec vulputate velit in risus suscipit lobortis. Aliquam id urna orci, nec sollicitudin ipsum. Cras a orci turpis. Donec suscipit vulputate cursus. Mauris nunc tellus, fermentum eu auctor ut, mollis at diam. Quisque porttitor ultrices metus, vitae tincidunt massa sollicitudin a. Vivamus porttitor libero eget purus hendrerit cursus. Integer aliquam consequat mauris quis luctus. Cras enim nibh, dignissim eu faucibus ac, mollis nec neque. Aliquam purus mauris, consectetur nec convallis lacinia, porta sed ante. Suspendisse et cursus magna. Donec orci enim, molestie a lobortis eu, imperdiet vitae neque.";
    private static final String __micro = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. In quis felis nunc. Quisque suscipit mauris et ante auctor ornare rhoncus lacus aliquet. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum sit amet felis augue, vel convallis dolor. Cras accumsan vehicula diam at faucibus. Etiam in urna turpis, sed congue mi. Morbi et lorem eros. Donec vulputate velit in risus suscipit lobortis. Aliquam id urna orci, nec sollicitudin ipsum. Cras a orci turpis. Donec suscipit vulputate cursus. Mauris nunc tellus, fermentum eu auctor ut, mollis at diam. Quisque porttitor ultrices metus, vitae tincidunt massa sollicitudin a. Vivamus porttitor libero eget purus hendrerit cursus. Integer aliquam consequat mauris quis luctus. Cras enim nibh, dignissim eu faucibus ac, mollis nec neque. Aliquam purus mauris, consectetur nec convallis lacinia, porta sed ante. Suspendisse et cursus magna. Donec orci enim, molestie a lobortis eu, imperdiet vitae neque.".substring(0, 10);
    private static final String __contentETag = String.format("W/\"%x\"", "Lorem ipsum dolor sit amet, consectetur adipiscing elit. In quis felis nunc. Quisque suscipit mauris et ante auctor ornare rhoncus lacus aliquet. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum sit amet felis augue, vel convallis dolor. Cras accumsan vehicula diam at faucibus. Etiam in urna turpis, sed congue mi. Morbi et lorem eros. Donec vulputate velit in risus suscipit lobortis. Aliquam id urna orci, nec sollicitudin ipsum. Cras a orci turpis. Donec suscipit vulputate cursus. Mauris nunc tellus, fermentum eu auctor ut, mollis at diam. Quisque porttitor ultrices metus, vitae tincidunt massa sollicitudin a. Vivamus porttitor libero eget purus hendrerit cursus. Integer aliquam consequat mauris quis luctus. Cras enim nibh, dignissim eu faucibus ac, mollis nec neque. Aliquam purus mauris, consectetur nec convallis lacinia, porta sed ante. Suspendisse et cursus magna. Donec orci enim, molestie a lobortis eu, imperdiet vitae neque.".hashCode());
    private static final String __contentETagGzip = String.format("W/\"%x--gzip\"", "Lorem ipsum dolor sit amet, consectetur adipiscing elit. In quis felis nunc. Quisque suscipit mauris et ante auctor ornare rhoncus lacus aliquet. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum sit amet felis augue, vel convallis dolor. Cras accumsan vehicula diam at faucibus. Etiam in urna turpis, sed congue mi. Morbi et lorem eros. Donec vulputate velit in risus suscipit lobortis. Aliquam id urna orci, nec sollicitudin ipsum. Cras a orci turpis. Donec suscipit vulputate cursus. Mauris nunc tellus, fermentum eu auctor ut, mollis at diam. Quisque porttitor ultrices metus, vitae tincidunt massa sollicitudin a. Vivamus porttitor libero eget purus hendrerit cursus. Integer aliquam consequat mauris quis luctus. Cras enim nibh, dignissim eu faucibus ac, mollis nec neque. Aliquam purus mauris, consectetur nec convallis lacinia, porta sed ante. Suspendisse et cursus magna. Donec orci enim, molestie a lobortis eu, imperdiet vitae neque.".hashCode());
    private static final String __icontent = "BEFORELorem ipsum dolor sit amet, consectetur adipiscing elit. In quis felis nunc. Quisque suscipit mauris et ante auctor ornare rhoncus lacus aliquet. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum sit amet felis augue, vel convallis dolor. Cras accumsan vehicula diam at faucibus. Etiam in urna turpis, sed congue mi. Morbi et lorem eros. Donec vulputate velit in risus suscipit lobortis. Aliquam id urna orci, nec sollicitudin ipsum. Cras a orci turpis. Donec suscipit vulputate cursus. Mauris nunc tellus, fermentum eu auctor ut, mollis at diam. Quisque porttitor ultrices metus, vitae tincidunt massa sollicitudin a. Vivamus porttitor libero eget purus hendrerit cursus. Integer aliquam consequat mauris quis luctus. Cras enim nibh, dignissim eu faucibus ac, mollis nec neque. Aliquam purus mauris, consectetur nec convallis lacinia, porta sed ante. Suspendisse et cursus magna. Donec orci enim, molestie a lobortis eu, imperdiet vitae neque.AFTER";
    private Server _server;
    private LocalConnector _connector;

    @Before
    public void init() throws Exception {
        this._server = new Server();
        this._connector = new LocalConnector(this._server);
        this._server.addConnector((Connector)this._connector);
        GzipHandler gzipHandler = new GzipHandler();
        gzipHandler.setExcludedAgentPatterns(new String[0]);
        gzipHandler.setMinGzipSize(16);
        ServletContextHandler context = new ServletContextHandler((HandlerContainer)gzipHandler, "/ctx");
        ServletHandler servlets = context.getServletHandler();
        this._server.setHandler((Handler)gzipHandler);
        gzipHandler.setHandler((Handler)context);
        servlets.addServletWithMapping(MicroServlet.class, "/micro");
        servlets.addServletWithMapping(MicroChunkedServlet.class, "/microchunked");
        servlets.addServletWithMapping(TestServlet.class, "/content");
        servlets.addServletWithMapping(ForwardServlet.class, "/forward");
        servlets.addServletWithMapping(IncludeServlet.class, "/include");
        this._server.start();
    }

    @After
    public void destroy() throws Exception {
        this._server.stop();
        this._server.join();
    }

    @Test
    public void testNotGzipHandler() throws Exception {
        HttpTester.Request request = HttpTester.newRequest();
        request.setMethod("GET");
        request.setURI("/ctx/content");
        request.setVersion("HTTP/1.0");
        request.setHeader("Host", "tester");
        HttpTester.Response response = HttpTester.parseResponse((ByteBuffer)this._connector.getResponses(request.generate()));
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        Assert.assertThat((Object)response.get("Content-Encoding"), (Matcher)Matchers.not((Matcher)Matchers.equalToIgnoringCase((String)"gzip")));
        Assert.assertThat((Object)response.get("ETag"), (Matcher)Matchers.is((Object)__contentETag));
        Assert.assertThat((Object)response.get("Vary"), (Matcher)Matchers.is((Object)"Accept-Encoding"));
        ByteArrayInputStream testIn = new ByteArrayInputStream(response.getContentBytes());
        ByteArrayOutputStream testOut = new ByteArrayOutputStream();
        IO.copy((InputStream)testIn, (OutputStream)testOut);
        Assert.assertEquals((Object)__content, (Object)testOut.toString("UTF8"));
    }

    @Test
    public void testGzipHandler() throws Exception {
        HttpTester.Request request = HttpTester.newRequest();
        request.setMethod("GET");
        request.setURI("/ctx/content");
        request.setVersion("HTTP/1.0");
        request.setHeader("Host", "tester");
        request.setHeader("accept-encoding", "gzip");
        HttpTester.Response response = HttpTester.parseResponse((ByteBuffer)this._connector.getResponses(request.generate()));
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        Assert.assertThat((Object)response.get("Content-Encoding"), (Matcher)Matchers.equalToIgnoringCase((String)"gzip"));
        Assert.assertThat((Object)response.get("ETag"), (Matcher)Matchers.is((Object)__contentETagGzip));
        Assert.assertThat((Object)response.get("Vary"), (Matcher)Matchers.is((Object)"Accept-Encoding"));
        GZIPInputStream testIn = new GZIPInputStream(new ByteArrayInputStream(response.getContentBytes()));
        ByteArrayOutputStream testOut = new ByteArrayOutputStream();
        IO.copy((InputStream)testIn, (OutputStream)testOut);
        Assert.assertEquals((Object)__content, (Object)testOut.toString("UTF8"));
    }

    @Test
    public void testGzipNotMicro() throws Exception {
        HttpTester.Request request = HttpTester.newRequest();
        request.setMethod("GET");
        request.setURI("/ctx/micro");
        request.setVersion("HTTP/1.0");
        request.setHeader("Host", "tester");
        request.setHeader("Accept-Encoding", "gzip");
        HttpTester.Response response = HttpTester.parseResponse((ByteBuffer)this._connector.getResponses(request.generate()));
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        Assert.assertThat((Object)response.get("Content-Encoding"), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"gzip")));
        Assert.assertThat((Object)response.get("ETag"), (Matcher)Matchers.is((Object)__contentETag));
        Assert.assertThat((Object)response.get("Vary"), (Matcher)Matchers.is((Object)"Accept-Encoding"));
        ByteArrayInputStream testIn = new ByteArrayInputStream(response.getContentBytes());
        ByteArrayOutputStream testOut = new ByteArrayOutputStream();
        IO.copy((InputStream)testIn, (OutputStream)testOut);
        Assert.assertEquals((Object)__micro, (Object)testOut.toString("UTF8"));
    }

    @Test
    public void testGzipNotMicroChunked() throws Exception {
        HttpTester.Request request = HttpTester.newRequest();
        request.setMethod("GET");
        request.setURI("/ctx/microchunked");
        request.setVersion("HTTP/1.1");
        request.setHeader("Host", "tester");
        request.setHeader("Accept-Encoding", "gzip");
        ByteBuffer rawresponse = this._connector.getResponse(request.generate());
        HttpTester.Response response = HttpTester.parseResponse((ByteBuffer)rawresponse);
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        Assert.assertThat((Object)response.get("Transfer-Encoding"), (Matcher)Matchers.containsString((String)"chunked"));
        Assert.assertThat((Object)response.get("Content-Encoding"), (Matcher)Matchers.containsString((String)"gzip"));
        Assert.assertThat((Object)response.get("Vary"), (Matcher)Matchers.is((Object)"Accept-Encoding"));
        GZIPInputStream testIn = new GZIPInputStream(new ByteArrayInputStream(response.getContentBytes()));
        ByteArrayOutputStream testOut = new ByteArrayOutputStream();
        IO.copy((InputStream)testIn, (OutputStream)testOut);
        Assert.assertEquals((Object)__micro, (Object)testOut.toString("UTF8"));
    }

    @Test
    public void testETagNotGzipHandler() throws Exception {
        HttpTester.Request request = HttpTester.newRequest();
        request.setMethod("GET");
        request.setURI("/ctx/content");
        request.setVersion("HTTP/1.0");
        request.setHeader("Host", "tester");
        request.setHeader("If-None-Match", __contentETag);
        request.setHeader("accept-encoding", "gzip");
        HttpTester.Response response = HttpTester.parseResponse((ByteBuffer)this._connector.getResponses(request.generate()));
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)304));
        Assert.assertThat((Object)response.get("Content-Encoding"), (Matcher)Matchers.not((Matcher)Matchers.equalToIgnoringCase((String)"gzip")));
        Assert.assertThat((Object)response.get("ETag"), (Matcher)Matchers.is((Object)__contentETag));
    }

    @Test
    public void testETagGzipHandler() throws Exception {
        HttpTester.Request request = HttpTester.newRequest();
        request.setMethod("GET");
        request.setURI("/ctx/content");
        request.setVersion("HTTP/1.0");
        request.setHeader("Host", "tester");
        request.setHeader("If-None-Match", __contentETagGzip);
        request.setHeader("accept-encoding", "gzip");
        HttpTester.Response response = HttpTester.parseResponse((ByteBuffer)this._connector.getResponses(request.generate()));
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)304));
        Assert.assertThat((Object)response.get("Content-Encoding"), (Matcher)Matchers.not((Matcher)Matchers.equalToIgnoringCase((String)"gzip")));
        Assert.assertThat((Object)response.get("ETag"), (Matcher)Matchers.is((Object)__contentETagGzip));
    }

    @Test
    public void testForwardGzipHandler() throws Exception {
        HttpTester.Request request = HttpTester.newRequest();
        request.setMethod("GET");
        request.setVersion("HTTP/1.0");
        request.setHeader("Host", "tester");
        request.setHeader("accept-encoding", "gzip");
        request.setURI("/ctx/forward");
        HttpTester.Response response = HttpTester.parseResponse((ByteBuffer)this._connector.getResponses(request.generate()));
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        Assert.assertThat((Object)response.get("Content-Encoding"), (Matcher)Matchers.equalToIgnoringCase((String)"gzip"));
        Assert.assertThat((Object)response.get("ETag"), (Matcher)Matchers.is((Object)__contentETagGzip));
        Assert.assertThat((Object)response.get("Vary"), (Matcher)Matchers.is((Object)"Accept-Encoding"));
        GZIPInputStream testIn = new GZIPInputStream(new ByteArrayInputStream(response.getContentBytes()));
        ByteArrayOutputStream testOut = new ByteArrayOutputStream();
        IO.copy((InputStream)testIn, (OutputStream)testOut);
        Assert.assertEquals((Object)__content, (Object)testOut.toString("UTF8"));
    }

    @Test
    public void testIncludeGzipHandler() throws Exception {
        HttpTester.Request request = HttpTester.newRequest();
        request.setMethod("GET");
        request.setVersion("HTTP/1.0");
        request.setHeader("Host", "tester");
        request.setHeader("accept-encoding", "gzip");
        request.setURI("/ctx/include");
        HttpTester.Response response = HttpTester.parseResponse((ByteBuffer)this._connector.getResponses(request.generate()));
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        Assert.assertThat((Object)response.get("Content-Encoding"), (Matcher)Matchers.equalToIgnoringCase((String)"gzip"));
        Assert.assertThat((Object)response.get("ETag"), (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)response.get("Vary"), (Matcher)Matchers.is((Object)"Accept-Encoding"));
        GZIPInputStream testIn = new GZIPInputStream(new ByteArrayInputStream(response.getContentBytes()));
        ByteArrayOutputStream testOut = new ByteArrayOutputStream();
        IO.copy((InputStream)testIn, (OutputStream)testOut);
        Assert.assertEquals((Object)__icontent, (Object)testOut.toString("UTF8"));
    }

    @Test
    public void testAddGetPaths() {
        GzipHandler gzip = new GzipHandler();
        gzip.addIncludedPaths(new String[]{"/foo"});
        gzip.addIncludedPaths(new String[]{"^/bar.*$"});
        String[] includedPaths = gzip.getIncludedPaths();
        Assert.assertThat((String)"Included Paths.size", (Object)includedPaths.length, (Matcher)Matchers.is((Object)2));
        Assert.assertThat((String)"Included Paths", Arrays.asList(includedPaths), (Matcher)Matchers.contains((Object[])new String[]{"/foo", "^/bar.*$"}));
    }

    public static class IncludeServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            response.getWriter().write("BEFORE");
            this.getServletContext().getRequestDispatcher("/content").include((ServletRequest)request, (ServletResponse)response);
            response.getWriter().write("AFTER");
        }
    }

    public static class ForwardServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            this.getServletContext().getRequestDispatcher("/content").forward((ServletRequest)request, (ServletResponse)response);
        }
    }

    public static class TestServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest req, HttpServletResponse response) throws ServletException, IOException {
            response.setHeader("ETag", __contentETag);
            String ifnm = req.getHeader("If-None-Match");
            if (ifnm != null && ifnm.equals(__contentETag)) {
                response.sendError(304);
            } else {
                PrintWriter writer = response.getWriter();
                writer.write(GzipHandlerTest.__content);
            }
        }
    }

    public static class MicroChunkedServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest req, HttpServletResponse response) throws ServletException, IOException {
            PrintWriter writer = response.getWriter();
            writer.write(__micro);
            response.flushBuffer();
        }
    }

    public static class MicroServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest req, HttpServletResponse response) throws ServletException, IOException {
            response.setHeader("ETag", __contentETag);
            String ifnm = req.getHeader("If-None-Match");
            if (ifnm != null && ifnm.equals(__contentETag)) {
                response.sendError(304);
            } else {
                PrintWriter writer = response.getWriter();
                writer.write(__micro);
            }
        }
    }
}

