/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.io.IOException;
import java.util.EnumSet;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.URIUtil;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class EncodedURITest {
    private Server _server;
    private LocalConnector _connector;
    private ContextHandlerCollection _contextCollection;
    private ServletContextHandler _context0;
    private ServletContextHandler _context1;
    private ResourceHandler _resourceHandler;

    @Before
    public void init() throws Exception {
        this._server = new Server();
        this._connector = new LocalConnector(this._server);
        ((HttpConfiguration.ConnectionFactory)this._connector.getConnectionFactory(HttpConfiguration.ConnectionFactory.class)).getHttpConfiguration().setSendServerVersion(false);
        ((HttpConfiguration.ConnectionFactory)this._connector.getConnectionFactory(HttpConfiguration.ConnectionFactory.class)).getHttpConfiguration().setSendDateHeader(false);
        this._server.addConnector((Connector)this._connector);
        this._contextCollection = new ContextHandlerCollection();
        this._server.setHandler((Handler)this._contextCollection);
        this._context0 = new ServletContextHandler();
        this._context0.setContextPath("/context path");
        this._contextCollection.addHandler((Handler)this._context0);
        this._context0.addFilter(AsyncFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        this._context0.addServlet(TestServlet.class, "/test servlet/*");
        this._context0.addServlet(AsyncServlet.class, "/async servlet/*");
        this._context1 = new ServletContextHandler();
        this._context1.setContextPath("/redirecting context");
        this._contextCollection.addHandler((Handler)this._context1);
        this._server.start();
    }

    @After
    public void destroy() throws Exception {
        this._server.stop();
        this._server.join();
    }

    @Test
    public void testTestServlet() throws Exception {
        String response = this._connector.getResponse("GET /c%6Fntext%20path/test%20servlet/path%20info HTTP/1.0\n\n");
        Assert.assertThat((Object)response, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200 "));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"requestURI=/c%6Fntext%20path/test%20servlet/path%20info"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"contextPath=/context path"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"servletPath=/test servlet"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"pathInfo=/path info"));
    }

    @Test
    public void testAsyncFilterTestServlet() throws Exception {
        String response = this._connector.getResponse("GET /context%20path/test%20servlet/path%20info?async=true HTTP/1.0\n\n");
        Assert.assertThat((Object)response, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200 "));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"requestURI=/context%20path/test%20servlet/path%20info"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"contextPath=/context path"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"servletPath=/test servlet"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"pathInfo=/path info"));
    }

    @Test
    public void testAsyncFilterWrapTestServlet() throws Exception {
        String response = this._connector.getResponse("GET /context%20path/test%20servlet/path%20info?async=true&wrap=true HTTP/1.0\n\n");
        Assert.assertThat((Object)response, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200 "));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"requestURI=/context%20path/test%20servlet/path%20info"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"contextPath=/context path"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"servletPath=/test servlet"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"pathInfo=/path info"));
    }

    @Test
    public void testAsyncServletTestServlet() throws Exception {
        String response = this._connector.getResponse("GET /context%20path/async%20servlet/path%20info HTTP/1.0\n\n");
        Assert.assertThat((Object)response, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200 "));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"requestURI=/context%20path/test servlet/path info"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"contextPath=/context path"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"servletPath=/test servlet"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"pathInfo=/path info"));
    }

    @Test
    public void testAsyncServletTestServletEncoded() throws Exception {
        String response = this._connector.getResponse("GET /context%20path/async%20servlet/path%20info?encode=true HTTP/1.0\n\n");
        Assert.assertThat((Object)response, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200 "));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"requestURI=/context%20path/test%20servlet/path%20info"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"contextPath=/context path"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"servletPath=/test servlet"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"pathInfo=/path info"));
    }

    public static class AsyncFilter
    implements Filter {
        public void init(FilterConfig filterConfig) throws ServletException {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            if (Boolean.parseBoolean(request.getParameter("async")) && !Boolean.parseBoolean((String)request.getAttribute("async"))) {
                request.setAttribute("async", (Object)"true");
                AsyncContext async = Boolean.parseBoolean(request.getParameter("wrap")) ? request.startAsync(request, response) : request.startAsync();
                async.dispatch();
                return;
            }
            chain.doFilter(request, response);
        }

        public void destroy() {
        }
    }

    public static class AsyncServlet
    extends HttpServlet {
        public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            AsyncContext async;
            AsyncContext asyncContext = async = Boolean.parseBoolean(request.getParameter("wrap")) ? request.startAsync((ServletRequest)request, (ServletResponse)response) : request.startAsync();
            if (Boolean.parseBoolean(request.getParameter("encode"))) {
                async.dispatch("/test%20servlet" + URIUtil.encodePath((String)request.getPathInfo()));
            } else {
                async.dispatch("/test servlet/path info" + request.getPathInfo());
            }
        }
    }

    public static class TestServlet
    extends HttpServlet {
        public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            response.setContentType("text/plain");
            response.getWriter().println("requestURI=" + request.getRequestURI());
            response.getWriter().println("contextPath=" + request.getContextPath());
            response.getWriter().println("servletPath=" + request.getServletPath());
            response.getWriter().println("pathInfo=" + request.getPathInfo());
        }
    }
}

