/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URI;
import javax.servlet.DispatcherType;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.toolchain.test.IO;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IncludedServletTest {
    private Server server;
    private URI baseUri;

    @Before
    public void startServer() throws Exception {
        this.server = new Server();
        ServerConnector connector = new ServerConnector(this.server);
        connector.setHost("localhost");
        connector.setPort(0);
        this.server.addConnector((Connector)connector);
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/");
        context.addServlet(TopServlet.class, "/top");
        context.addServlet(IncludedServlet.class, "/included");
        this.server.setHandler((Handler)context);
        this.server.start();
        int port = connector.getLocalPort();
        String host = connector.getHost();
        this.baseUri = URI.create("http://" + host + ":" + port + "/");
    }

    @After
    public void stopServer() throws Exception {
        this.server.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTopWithIncludedHeader() throws IOException {
        URI uri = this.baseUri.resolve("/top");
        System.out.println("GET (String): " + uri.toASCIIString());
        InputStream in = null;
        InputStreamReader reader = null;
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)uri.toURL().openConnection();
            connection.connect();
            if (200 != connection.getResponseCode()) {
                String body = this.getPotentialBody(connection);
                String err = String.format("GET request failed (%d %s) %s%n%s", connection.getResponseCode(), connection.getResponseMessage(), uri.toASCIIString(), body);
                throw new IOException(err);
            }
            in = connection.getInputStream();
            reader = new InputStreamReader(in);
            StringWriter writer = new StringWriter();
            IO.copy((Reader)reader, (Writer)writer);
            String response = writer.toString();
            Assert.assertThat((String)"Response", (Object)response, (Matcher)Matchers.containsString((String)"<h2> Hello, this is the top page."));
            Assert.assertThat((String)"Response", (Object)response, (Matcher)Matchers.containsString((String)"<h3> This is the included page"));
            Assert.assertThat((String)"Response Header[main-page-key]", (Object)connection.getHeaderField("main-page-key"), (Matcher)Matchers.is((Object)"main-page-value"));
            Assert.assertThat((String)"Response Header[included-page-key]", (Object)connection.getHeaderField("included-page-key"), (Matcher)Matchers.is((Object)"included-page-value"));
        }
        catch (Throwable throwable) {
            IO.close(reader);
            IO.close(in);
            throw throwable;
        }
        IO.close((Closeable)reader);
        IO.close((Closeable)in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPotentialBody(HttpURLConnection connection) {
        String string;
        InputStream in = null;
        InputStreamReader reader = null;
        try {
            in = connection.getInputStream();
            reader = new InputStreamReader(in);
            StringWriter writer = new StringWriter();
            IO.copy((Reader)reader, (Writer)writer);
            string = writer.toString();
        }
        catch (IOException e) {
            String string2;
            try {
                string2 = "<no body:" + e.getMessage() + ">";
            }
            catch (Throwable throwable) {
                IO.close(reader);
                IO.close((Closeable)in);
                throw throwable;
            }
            IO.close((Closeable)reader);
            IO.close((Closeable)in);
            return string2;
        }
        IO.close((Closeable)reader);
        IO.close((Closeable)in);
        return string;
    }

    public static class IncludedServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            String headerPrefix = "";
            if (req.getDispatcherType() == DispatcherType.INCLUDE) {
                headerPrefix = "org.eclipse.jetty.server.include.";
            }
            resp.setHeader(headerPrefix + "included-page-key", "included-page-value");
            resp.getWriter().println("<h3> This is the included page");
        }
    }

    public static class TopServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            req.getRequestDispatcher("/included").include((ServletRequest)req, (ServletResponse)resp);
            resp.setHeader("main-page-key", "main-page-value");
            PrintWriter out = resp.getWriter();
            out.println("<h2> Hello, this is the top page.");
        }
    }
}

