/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.eclipse.jetty.http.DateGenerator;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AllowSymLinkAliasChecker;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.FilterMapping;
import org.eclipse.jetty.servlet.NoJspServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.toolchain.test.FS;
import org.eclipse.jetty.toolchain.test.MavenTestingUtils;
import org.eclipse.jetty.toolchain.test.OS;
import org.eclipse.jetty.toolchain.test.TestingDir;
import org.eclipse.jetty.util.IO;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class DefaultServletTest {
    @Rule
    public TestingDir testdir = new TestingDir();
    private Server server;
    private LocalConnector connector;
    private ServletContextHandler context;

    @Before
    public void init() throws Exception {
        this.server = new Server();
        this.connector = new LocalConnector(this.server);
        ((HttpConfiguration.ConnectionFactory)this.connector.getConnectionFactory(HttpConfiguration.ConnectionFactory.class)).getHttpConfiguration().setSendServerVersion(false);
        this.context = new ServletContextHandler();
        this.context.setContextPath("/context");
        this.context.setWelcomeFiles(new String[]{"index.html", "index.jsp", "index.htm"});
        this.server.setHandler((Handler)this.context);
        this.server.addConnector((Connector)this.connector);
        this.server.start();
    }

    @After
    public void destroy() throws Exception {
        this.server.stop();
        this.server.join();
    }

    @Test
    public void testListingWithSession() throws Exception {
        ServletHolder defholder = this.context.addServlet(DefaultServlet.class, "/*");
        defholder.setInitParameter("dirAllowed", "true");
        defholder.setInitParameter("redirectWelcome", "false");
        defholder.setInitParameter("gzip", "false");
        this.testdir.ensureEmpty();
        File resBase = this.testdir.getPathFile("docroot").toFile();
        Assert.assertTrue((boolean)resBase.mkdirs());
        Assert.assertTrue((boolean)new File(resBase, "one").mkdir());
        Assert.assertTrue((boolean)new File(resBase, "two").mkdir());
        Assert.assertTrue((boolean)new File(resBase, "three").mkdir());
        String resBasePath = resBase.getAbsolutePath();
        defholder.setInitParameter("resourceBase", resBasePath);
        StringBuffer req1 = new StringBuffer();
        req1.append("GET /context/;JSESSIONID=1234567890 HTTP/1.0\n\n");
        String response = this.connector.getResponses(req1.toString());
        this.assertResponseContains("/one/;JSESSIONID=1234567890", response);
        this.assertResponseContains("/two/;JSESSIONID=1234567890", response);
        this.assertResponseContains("/three/;JSESSIONID=1234567890", response);
        this.assertResponseNotContains("<script>", response);
    }

    @Test
    public void testListingXSS() throws Exception {
        ServletHolder defholder = this.context.addServlet(DefaultServlet.class, "/*");
        defholder.setInitParameter("dirAllowed", "true");
        defholder.setInitParameter("redirectWelcome", "false");
        defholder.setInitParameter("gzip", "false");
        this.testdir.ensureEmpty();
        File resBase = this.testdir.getPathFile("docroot").toFile();
        FS.ensureDirExists((File)resBase);
        Assert.assertTrue((boolean)new File(resBase, "one").mkdir());
        Assert.assertTrue((boolean)new File(resBase, "two").mkdir());
        Assert.assertTrue((boolean)new File(resBase, "three").mkdir());
        if (!OS.IS_WINDOWS) {
            Assert.assertTrue((String)"Creating dir 'f??r' (Might not work in Windows)", (boolean)new File(resBase, "f??r").mkdir());
        }
        String resBasePath = resBase.getAbsolutePath();
        defholder.setInitParameter("resourceBase", resBasePath);
        StringBuffer req1 = new StringBuffer();
        req1.append("GET /context/;<script>window.alert(\"hi\");</script> HTTP/1.0\n");
        req1.append("\n");
        String response = this.connector.getResponses(req1.toString());
        this.assertResponseNotContains("<script>", response);
    }

    @Test
    public void testListingProperUrlEncoding() throws Exception {
        ServletHolder defholder = this.context.addServlet(DefaultServlet.class, "/*");
        defholder.setInitParameter("dirAllowed", "true");
        defholder.setInitParameter("redirectWelcome", "false");
        defholder.setInitParameter("gzip", "false");
        this.testdir.ensureEmpty();
        File resBase = this.testdir.getPathFile("docroot").toFile();
        Assert.assertTrue((boolean)resBase.mkdirs());
        File wackyDir = new File(resBase, "dir;");
        Assert.assertTrue((boolean)wackyDir.mkdirs());
        Assert.assertTrue((boolean)new File(wackyDir, "four").mkdir());
        Assert.assertTrue((boolean)new File(wackyDir, "five").mkdir());
        Assert.assertTrue((boolean)new File(wackyDir, "six").mkdir());
        String resBasePath = resBase.getAbsolutePath();
        defholder.setInitParameter("resourceBase", resBasePath);
        String response = this.connector.getResponses("GET /context/dir;/ HTTP/1.0\r\n\r\n");
        this.assertResponseContains("HTTP/1.1 404 Not Found", response);
        response = this.connector.getResponses("GET /context/dir%3B/ HTTP/1.0\r\n\r\n");
        this.assertResponseNotContains("%253B", response);
        this.assertResponseContains("/dir%3B/", response);
        this.assertResponseContains("/dir%3B/four/", response);
        this.assertResponseContains("/dir%3B/five/", response);
        this.assertResponseContains("/dir%3B/six/", response);
    }

    @Test
    public void testListingContextBreakout() throws Exception {
        ServletHolder defholder = this.context.addServlet(DefaultServlet.class, "/");
        defholder.setInitParameter("dirAllowed", "true");
        defholder.setInitParameter("redirectWelcome", "false");
        defholder.setInitParameter("gzip", "false");
        defholder.setInitParameter("aliases", "true");
        this.testdir.ensureEmpty();
        File resBase = this.testdir.getPathFile("docroot").toFile();
        Assert.assertTrue((boolean)resBase.mkdirs());
        File index = new File(resBase, "index.html");
        this.createFile(index, "<h1>Hello Index</h1>");
        File wackyDir = new File(resBase, "dir?");
        if (!OS.IS_WINDOWS) {
            FS.ensureDirExists((File)wackyDir);
        }
        wackyDir = new File(resBase, "dir;");
        Assert.assertTrue((boolean)wackyDir.mkdirs());
        File sekret = this.testdir.getFile("sekret");
        Assert.assertTrue((boolean)sekret.mkdirs());
        File pass = new File(sekret, "pass");
        this.createFile(pass, "Sssh, you shouldn't be seeing this");
        String resBasePath = resBase.getAbsolutePath();
        defholder.setInitParameter("resourceBase", resBasePath);
        String response = this.connector.getResponses("GET /context/ HTTP/1.0\r\n\r\n");
        this.assertResponseContains("<h1>Hello Index</h1>", response);
        response = this.connector.getResponses("GET /context/dir?/ HTTP/1.0\r\n\r\n");
        this.assertResponseContains("404", response);
        if (!OS.IS_WINDOWS) {
            response = this.connector.getResponses("GET /context/dir%3F/ HTTP/1.0\r\n\r\n");
            this.assertResponseContains("Directory: /context/dir?/<", response);
        } else {
            this.assertResponseContains("404", response);
        }
        response = this.connector.getResponses("GET /context/index.html HTTP/1.0\r\n\r\n");
        this.assertResponseContains("Hello Index", response);
        response = this.connector.getResponses("GET /context/dir%3F/../index.html HTTP/1.0\r\n\r\n");
        this.assertResponseContains("Hello Index", response);
        response = this.connector.getResponses("GET /context/dir%3F/../../ HTTP/1.0\r\n\r\n");
        this.assertResponseNotContains("Directory: ", response);
        response = this.connector.getResponses("GET /context/dir%3F/../../sekret/pass HTTP/1.0\r\n\r\n");
        this.assertResponseNotContains("Sssh", response);
        response = this.connector.getResponses("GET /context/dir?/../../ HTTP/1.0\r\n\r\n");
        this.assertResponseNotContains("Directory: ", response);
        response = this.connector.getResponses("GET /context/dir?/../../sekret/pass HTTP/1.0\r\n\r\n");
        this.assertResponseNotContains("Sssh", response);
        response = this.connector.getResponses("GET /context/ HTTP/1.0\r\n\r\n");
        this.assertResponseContains("<h1>Hello Index</h1>", response);
        response = this.connector.getResponses("GET /context/dir;/ HTTP/1.0\r\n\r\n");
        this.assertResponseContains("404", response);
        response = this.connector.getResponses("GET /context/dir%3B/ HTTP/1.0\r\n\r\n");
        this.assertResponseContains("Directory: /context/dir;/<", response);
        response = this.connector.getResponses("GET /context/index.html HTTP/1.0\r\n\r\n");
        this.assertResponseContains("Hello Index", response);
        response = this.connector.getResponses("GET /context/dir%3B/../index.html HTTP/1.0\r\n\r\n");
        this.assertResponseContains("Hello Index", response);
        response = this.connector.getResponses("GET /context/dir%3B/../../ HTTP/1.0\r\n\r\n");
        this.assertResponseNotContains("Directory: ", response);
        response = this.connector.getResponses("GET /context/dir%3B/../../sekret/pass HTTP/1.0\r\n\r\n");
        this.assertResponseNotContains("Sssh", response);
        response = this.connector.getResponses("GET /context/dir;/../../ HTTP/1.0\r\n\r\n");
        this.assertResponseNotContains("Directory: ", response);
        response = this.connector.getResponses("GET /context/dir;/../../sekret/pass HTTP/1.0\r\n\r\n");
        this.assertResponseNotContains("Sssh", response);
    }

    @Test
    public void testWelcome() throws Exception {
        this.testdir.ensureEmpty();
        File resBase = this.testdir.getPathFile("docroot").toFile();
        FS.ensureDirExists((File)resBase);
        File inde = new File(resBase, "index.htm");
        File index = new File(resBase, "index.html");
        String resBasePath = resBase.getAbsolutePath();
        ServletHolder defholder = this.context.addServlet(DefaultServlet.class, "/");
        defholder.setInitParameter("dirAllowed", "false");
        defholder.setInitParameter("redirectWelcome", "false");
        defholder.setInitParameter("welcomeServlets", "false");
        defholder.setInitParameter("gzip", "false");
        defholder.setInitParameter("resourceBase", resBasePath);
        defholder.setInitParameter("maxCacheSize", "1024000");
        defholder.setInitParameter("maxCachedFileSize", "512000");
        defholder.setInitParameter("maxCachedFiles", "100");
        ServletHolder jspholder = this.context.addServlet(NoJspServlet.class, "*.jsp");
        String response = this.connector.getResponses("GET /context/ HTTP/1.0\r\n\r\n");
        this.assertResponseContains("403", response);
        this.createFile(index, "<h1>Hello Index</h1>");
        response = this.connector.getResponses("GET /context/ HTTP/1.0\r\n\r\n");
        this.assertResponseContains("<h1>Hello Index</h1>", response);
        this.createFile(inde, "<h1>Hello Inde</h1>");
        response = this.connector.getResponses("GET /context/ HTTP/1.0\r\n\r\n");
        this.assertResponseContains("<h1>Hello Index</h1>", response);
        Assert.assertTrue((boolean)index.delete());
        response = this.connector.getResponses("GET /context/ HTTP/1.0\r\n\r\n");
        this.assertResponseContains("<h1>Hello Inde</h1>", response);
        Assert.assertTrue((boolean)inde.delete());
        response = this.connector.getResponses("GET /context/ HTTP/1.0\r\n\r\n");
        this.assertResponseContains("403", response);
    }

    @Test
    public void testWelcomeServlet() throws Exception {
        this.testdir.ensureEmpty();
        File resBase = this.testdir.getPathFile("docroot").toFile();
        FS.ensureDirExists((File)resBase);
        File inde = new File(resBase, "index.htm");
        File index = new File(resBase, "index.html");
        String resBasePath = resBase.getAbsolutePath();
        ServletHolder defholder = this.context.addServlet(DefaultServlet.class, "/");
        defholder.setInitParameter("dirAllowed", "false");
        defholder.setInitParameter("redirectWelcome", "false");
        defholder.setInitParameter("welcomeServlets", "true");
        defholder.setInitParameter("gzip", "false");
        defholder.setInitParameter("resourceBase", resBasePath);
        ServletHolder jspholder = this.context.addServlet(NoJspServlet.class, "*.jsp");
        String response = this.connector.getResponses("GET /context/ HTTP/1.0\r\n\r\n");
        this.assertResponseContains("JSP support not configured", response);
        this.createFile(index, "<h1>Hello Index</h1>");
        response = this.connector.getResponses("GET /context/ HTTP/1.0\r\n\r\n");
        this.assertResponseContains("<h1>Hello Index</h1>", response);
        this.createFile(inde, "<h1>Hello Inde</h1>");
        response = this.connector.getResponses("GET /context/ HTTP/1.0\r\n\r\n");
        this.assertResponseContains("<h1>Hello Index</h1>", response);
        if (!OS.IS_WINDOWS) {
            this.deleteFile(index);
            response = this.connector.getResponses("GET /context/ HTTP/1.0\r\n\r\n");
            this.assertResponseContains("<h1>Hello Inde</h1>", response);
            this.deleteFile(inde);
            response = this.connector.getResponses("GET /context/ HTTP/1.0\r\n\r\n");
            this.assertResponseContains("JSP support not configured", response);
        }
    }

    @Test
    public void testResourceBase() throws Exception {
        this.testdir.ensureEmpty();
        File resBase = this.testdir.getPathFile("docroot").toFile();
        FS.ensureDirExists((File)resBase);
        File foobar = new File(resBase, "foobar.txt");
        File link = new File(resBase, "link.txt");
        this.createFile(foobar, "Foo Bar");
        String resBasePath = resBase.getAbsolutePath();
        ServletHolder defholder = this.context.addServlet(DefaultServlet.class, "/");
        defholder.setInitParameter("resourceBase", resBasePath);
        defholder.setInitParameter("gzip", "false");
        String response = this.connector.getResponses("GET /context/foobar.txt HTTP/1.0\r\n\r\n");
        this.assertResponseContains("Foo Bar", response);
        if (!OS.IS_WINDOWS) {
            this.context.clearAliasChecks();
            Files.createSymbolicLink(link.toPath(), foobar.toPath(), new FileAttribute[0]);
            response = this.connector.getResponses("GET /context/link.txt HTTP/1.0\r\n\r\n");
            this.assertResponseContains("404", response);
            this.context.addAliasCheck((ContextHandler.AliasCheck)new AllowSymLinkAliasChecker());
            response = this.connector.getResponses("GET /context/link.txt HTTP/1.0\r\n\r\n");
            this.assertResponseContains("Foo Bar", response);
        }
    }

    @Test
    public void testWelcomeExactServlet() throws Exception {
        this.testdir.ensureEmpty();
        File resBase = this.testdir.getPathFile("docroot").toFile();
        FS.ensureDirExists((File)resBase);
        File inde = new File(resBase, "index.htm");
        File index = new File(resBase, "index.html");
        String resBasePath = resBase.getAbsolutePath();
        ServletHolder defholder = this.context.addServlet(DefaultServlet.class, "/");
        defholder.setInitParameter("dirAllowed", "false");
        defholder.setInitParameter("redirectWelcome", "false");
        defholder.setInitParameter("welcomeServlets", "exact");
        defholder.setInitParameter("gzip", "false");
        defholder.setInitParameter("resourceBase", resBasePath);
        ServletHolder jspholder = this.context.addServlet(NoJspServlet.class, "*.jsp");
        this.context.addServlet(jspholder, "/index.jsp");
        String response = this.connector.getResponses("GET /context/ HTTP/1.0\r\n\r\n");
        this.assertResponseContains("JSP support not configured", response);
        this.createFile(index, "<h1>Hello Index</h1>");
        response = this.connector.getResponses("GET /context/ HTTP/1.0\r\n\r\n");
        this.assertResponseContains("<h1>Hello Index</h1>", response);
        this.createFile(inde, "<h1>Hello Inde</h1>");
        response = this.connector.getResponses("GET /context/ HTTP/1.0\r\n\r\n");
        this.assertResponseContains("<h1>Hello Index</h1>", response);
        if (!OS.IS_WINDOWS) {
            this.deleteFile(index);
            response = this.connector.getResponses("GET /context/ HTTP/1.0\r\n\r\n");
            this.assertResponseContains("<h1>Hello Inde</h1>", response);
            this.deleteFile(inde);
            response = this.connector.getResponses("GET /context/ HTTP/1.0\r\n\r\n");
            this.assertResponseContains("JSP support not configured", response);
        }
    }

    @Test
    public void testRangeRequests() throws Exception {
        this.testdir.ensureEmpty();
        File resBase = this.testdir.getPathFile("docroot").toFile();
        FS.ensureDirExists((File)resBase);
        File data = new File(resBase, "data.txt");
        this.createFile(data, "01234567890123456789012345678901234567890123456789012345678901234567890123456789");
        String resBasePath = resBase.getAbsolutePath();
        ServletHolder defholder = this.context.addServlet(DefaultServlet.class, "/");
        defholder.setInitParameter("dirAllowed", "false");
        defholder.setInitParameter("redirectWelcome", "false");
        defholder.setInitParameter("welcomeServlets", "false");
        defholder.setInitParameter("gzip", "false");
        defholder.setInitParameter("acceptRanges", "true");
        defholder.setInitParameter("resourceBase", resBasePath);
        String response = this.connector.getResponses("GET /context/data.txt HTTP/1.1\r\nHost: localhost\r\nConnection: close\r\n\r\n");
        this.assertResponseContains("200 OK", response);
        this.assertResponseContains("Accept-Ranges: bytes", response);
        response = this.connector.getResponses("GET /context/data.txt HTTP/1.1\r\nHost: localhost\r\nConnection: close\r\nRange: bytes=0-9\r\n\r\n");
        this.assertResponseContains("206 Partial", response);
        this.assertResponseContains("Content-Type: text/plain", response);
        this.assertResponseContains("Content-Length: 10", response);
        this.assertResponseContains("Content-Range: bytes 0-9/80", response);
        response = this.connector.getResponses("GET /context/data.txt HTTP/1.1\r\nHost: localhost\r\nConnection: close\r\nRange: bytes=0-9,20-29,40-49\r\n\r\n");
        int start = response.indexOf("--jetty");
        String body = response.substring(start);
        String boundary = body.substring(0, body.indexOf("\r\n"));
        this.assertResponseContains("206 Partial", response);
        this.assertResponseContains("Content-Type: multipart/byteranges; boundary=", response);
        this.assertResponseContains("Content-Range: bytes 0-9/80", response);
        this.assertResponseContains("Content-Range: bytes 20-29/80", response);
        this.assertResponseContains("Content-Length: " + body.length(), response);
        Assert.assertTrue((boolean)body.endsWith(boundary + "--\r\n"));
        response = this.connector.getResponses("GET /context/data.txt HTTP/1.1\r\nHost: localhost\r\nConnection: close\r\nRange: bytes=0-9,20-29,40-49,70-79\r\n\r\n");
        start = response.indexOf("--jetty");
        body = response.substring(start);
        boundary = body.substring(0, body.indexOf("\r\n"));
        this.assertResponseContains("206 Partial", response);
        this.assertResponseContains("Content-Type: multipart/byteranges; boundary=", response);
        this.assertResponseContains("Content-Range: bytes 0-9/80", response);
        this.assertResponseContains("Content-Range: bytes 20-29/80", response);
        this.assertResponseContains("Content-Range: bytes 70-79/80", response);
        this.assertResponseContains("Content-Length: " + body.length(), response);
        Assert.assertTrue((boolean)body.endsWith(boundary + "--\r\n"));
        response = this.connector.getResponses("GET /context/data.txt HTTP/1.1\r\nHost: localhost\r\nConnection: close\r\nRange: bytes=0-9,20-29,40-49,60-60,70-79\r\n\r\n");
        start = response.indexOf("--jetty");
        body = response.substring(start);
        boundary = body.substring(0, body.indexOf("\r\n"));
        this.assertResponseContains("206 Partial", response);
        this.assertResponseContains("Content-Type: multipart/byteranges; boundary=", response);
        this.assertResponseContains("Content-Range: bytes 0-9/80", response);
        this.assertResponseContains("Content-Range: bytes 20-29/80", response);
        this.assertResponseContains("Content-Range: bytes 60-60/80", response);
        this.assertResponseContains("Content-Range: bytes 70-79/80", response);
        this.assertResponseContains("Content-Length: " + body.length(), response);
        Assert.assertTrue((boolean)body.endsWith(boundary + "--\r\n"));
        File nofilesuffix = new File(resBase, "nofilesuffix");
        this.createFile(nofilesuffix, "01234567890123456789012345678901234567890123456789012345678901234567890123456789");
        response = this.connector.getResponses("GET /context/nofilesuffix HTTP/1.1\r\nHost: localhost\r\nConnection: close\r\n\r\n");
        this.assertResponseContains("200 OK", response);
        this.assertResponseContains("Accept-Ranges: bytes", response);
        response = this.connector.getResponses("GET /context/nofilesuffix HTTP/1.1\r\nHost: localhost\r\nConnection: close\r\nRange: bytes=0-9\r\n\r\n");
        this.assertResponseContains("206 Partial", response);
        this.assertResponseContains("Content-Length: 10", response);
        Assert.assertTrue((!response.contains("Content-Type:") ? 1 : 0) != 0);
        this.assertResponseContains("Content-Range: bytes 0-9/80", response);
        response = this.connector.getResponses("GET /context/nofilesuffix HTTP/1.1\r\nHost: localhost\r\nConnection: close\r\nRange: bytes=0-9,20-29,40-49\r\n\r\n");
        start = response.indexOf("--jetty");
        body = response.substring(start);
        boundary = body.substring(0, body.indexOf("\r\n"));
        this.assertResponseContains("206 Partial", response);
        this.assertResponseContains("Content-Type: multipart/byteranges; boundary=", response);
        this.assertResponseContains("Content-Range: bytes 0-9/80", response);
        this.assertResponseContains("Content-Range: bytes 20-29/80", response);
        this.assertResponseContains("Content-Length: " + body.length(), response);
        Assert.assertTrue((boolean)body.endsWith(boundary + "--\r\n"));
        response = this.connector.getResponses("GET /context/nofilesuffix HTTP/1.1\r\nHost: localhost\r\nConnection: close\r\nRange: bytes=0-9,20-29,40-49,60-60,70-79\r\n\r\n");
        start = response.indexOf("--jetty");
        body = response.substring(start);
        boundary = body.substring(0, body.indexOf("\r\n"));
        this.assertResponseContains("206 Partial", response);
        this.assertResponseContains("Content-Type: multipart/byteranges; boundary=", response);
        this.assertResponseContains("Content-Range: bytes 0-9/80", response);
        this.assertResponseContains("Content-Range: bytes 20-29/80", response);
        this.assertResponseContains("Content-Range: bytes 60-60/80", response);
        this.assertResponseContains("Content-Range: bytes 70-79/80", response);
        this.assertResponseContains("Content-Length: " + body.length(), response);
        Assert.assertTrue((boolean)body.endsWith(boundary + "--\r\n"));
    }

    @Test
    public void testFiltered() throws Exception {
        this.testdir.ensureEmpty();
        File resBase = this.testdir.getPathFile("docroot").toFile();
        FS.ensureDirExists((File)resBase);
        File file0 = new File(resBase, "data0.txt");
        this.createFile(file0, "Hello Text 0");
        String resBasePath = resBase.getAbsolutePath();
        ServletHolder defholder = this.context.addServlet(DefaultServlet.class, "/");
        defholder.setInitParameter("dirAllowed", "false");
        defholder.setInitParameter("redirectWelcome", "false");
        defholder.setInitParameter("welcomeServlets", "false");
        defholder.setInitParameter("gzip", "false");
        defholder.setInitParameter("resourceBase", resBasePath);
        String response = this.connector.getResponses("GET /context/data0.txt HTTP/1.0\r\n\r\n");
        this.assertResponseContains("Content-Length: 12", response);
        this.assertResponseNotContains("Extra Info", response);
        this.server.stop();
        this.context.addFilter(OutputFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        this.server.start();
        response = this.connector.getResponses("GET /context/data0.txt HTTP/1.0\r\n\r\n");
        this.assertResponseContains("Content-Length: 2", response);
        this.assertResponseContains("Extra Info", response);
        this.assertResponseNotContains("Content-Length: 12", response);
        this.server.stop();
        this.context.getServletHandler().setFilterMappings(new FilterMapping[0]);
        this.context.getServletHandler().setFilters(new FilterHolder[0]);
        this.context.addFilter(WriterFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        this.server.start();
        response = this.connector.getResponses("GET /context/data0.txt HTTP/1.0\r\n\r\n");
        this.assertResponseContains("Content-Length: 2", response);
        this.assertResponseContains("Extra Info", response);
        this.assertResponseNotContains("Content-Length: 12", response);
    }

    @Test
    public void testGzip() throws Exception {
        this.testdir.ensureEmpty();
        File resBase = this.testdir.getPathFile("docroot").toFile();
        FS.ensureDirExists((File)resBase);
        File file0 = new File(resBase, "data0.txt");
        this.createFile(file0, "Hello Text 0");
        File file0gz = new File(resBase, "data0.txt.gz");
        this.createFile(file0gz, "fake gzip");
        String resBasePath = resBase.getAbsolutePath();
        ServletHolder defholder = this.context.addServlet(DefaultServlet.class, "/");
        defholder.setInitParameter("dirAllowed", "false");
        defholder.setInitParameter("redirectWelcome", "false");
        defholder.setInitParameter("welcomeServlets", "false");
        defholder.setInitParameter("gzip", "true");
        defholder.setInitParameter("etags", "true");
        defholder.setInitParameter("resourceBase", resBasePath);
        String response = this.connector.getResponses("GET /context/data0.txt HTTP/1.0\r\nHost:localhost:8080\r\n\r\n");
        this.assertResponseContains("Content-Length: 12", response);
        this.assertResponseContains("Content-Type: text/plain", response);
        this.assertResponseContains("Hello Text 0", response);
        this.assertResponseContains("Vary: Accept-Encoding", response);
        this.assertResponseContains("ETag: ", response);
        this.assertResponseNotContains("Content-Encoding: gzip", response);
        int e = response.indexOf("ETag: ");
        String etag = response.substring(e + 6, response.indexOf(34, e + 11) + 1);
        String etag_gzip = etag.substring(0, etag.length() - 1) + "--gzip\"";
        response = this.connector.getResponses("GET /context/data0.txt HTTP/1.0\r\nHost:localhost:8080\r\nAccept-Encoding:gzip\r\n\r\n");
        this.assertResponseContains("Content-Length: 9", response);
        this.assertResponseContains("fake gzip", response);
        this.assertResponseContains("Content-Type: text/plain", response);
        this.assertResponseContains("Vary: Accept-Encoding", response);
        this.assertResponseContains("Content-Encoding: gzip", response);
        this.assertResponseContains("ETag: " + etag_gzip, response);
        response = this.connector.getResponses("GET /context/data0.txt.gz HTTP/1.0\r\nHost:localhost:8080\r\nAccept-Encoding:gzip\r\n\r\n");
        this.assertResponseContains("Content-Length: 9", response);
        this.assertResponseContains("fake gzip", response);
        this.assertResponseContains("Content-Type: application/gzip", response);
        this.assertResponseNotContains("Vary: Accept-Encoding", response);
        this.assertResponseNotContains("Content-Encoding: gzip", response);
        this.assertResponseNotContains("ETag: " + etag_gzip, response);
        this.assertResponseContains("ETag: ", response);
        response = this.connector.getResponses("GET /context/data0.txt.gz HTTP/1.0\r\nHost:localhost:8080\r\nAccept-Encoding:gzip\r\nIf-None-Match: W/\"wobble\"\r\n\r\n");
        this.assertResponseContains("Content-Length: 9", response);
        this.assertResponseContains("fake gzip", response);
        this.assertResponseContains("Content-Type: application/gzip", response);
        this.assertResponseNotContains("Vary: Accept-Encoding", response);
        this.assertResponseNotContains("Content-Encoding: gzip", response);
        this.assertResponseNotContains("ETag: " + etag_gzip, response);
        this.assertResponseContains("ETag: ", response);
        response = this.connector.getResponses("GET /context/data0.txt HTTP/1.0\r\nHost:localhost:8080\r\nAccept-Encoding:gzip\r\nIf-None-Match: " + etag_gzip + "\r\n\r\n");
        this.assertResponseContains("304 Not Modified", response);
        this.assertResponseContains("ETag: " + etag_gzip, response);
        response = this.connector.getResponses("GET /context/data0.txt HTTP/1.0\r\nHost:localhost:8080\r\nAccept-Encoding:gzip\r\nIf-None-Match: " + etag + "\r\n\r\n");
        this.assertResponseContains("304 Not Modified", response);
        this.assertResponseContains("ETag: " + etag, response);
        response = this.connector.getResponses("GET /context/data0.txt HTTP/1.0\r\nHost:localhost:8080\r\nAccept-Encoding:gzip\r\nIf-None-Match: W/\"foobar\"," + etag_gzip + "\r\n\r\n");
        this.assertResponseContains("304 Not Modified", response);
        this.assertResponseContains("ETag: " + etag_gzip, response);
        response = this.connector.getResponses("GET /context/data0.txt HTTP/1.0\r\nHost:localhost:8080\r\nAccept-Encoding:gzip\r\nIf-None-Match: W/\"foobar\"," + etag + "\r\n\r\n");
        this.assertResponseContains("304 Not Modified", response);
        this.assertResponseContains("ETag: " + etag, response);
    }

    @Test
    public void testCachedGzip() throws Exception {
        this.testdir.ensureEmpty();
        File resBase = this.testdir.getPathFile("docroot").toFile();
        FS.ensureDirExists((File)resBase);
        File file0 = new File(resBase, "data0.txt");
        this.createFile(file0, "Hello Text 0");
        File file0gz = new File(resBase, "data0.txt.gz");
        this.createFile(file0gz, "fake gzip");
        String resBasePath = resBase.getAbsolutePath();
        ServletHolder defholder = this.context.addServlet(DefaultServlet.class, "/");
        defholder.setInitParameter("dirAllowed", "false");
        defholder.setInitParameter("redirectWelcome", "false");
        defholder.setInitParameter("welcomeServlets", "false");
        defholder.setInitParameter("gzip", "true");
        defholder.setInitParameter("etags", "true");
        defholder.setInitParameter("resourceBase", resBasePath);
        defholder.setInitParameter("maxCachedFiles", "1024");
        defholder.setInitParameter("maxCachedFileSize", "200000000");
        defholder.setInitParameter("maxCacheSize", "256000000");
        String response = this.connector.getResponses("GET /context/data0.txt HTTP/1.0\r\nHost:localhost:8080\r\n\r\n");
        this.assertResponseContains("Content-Length: 12", response);
        this.assertResponseContains("Content-Type: text/plain", response);
        this.assertResponseContains("Hello Text 0", response);
        this.assertResponseContains("Vary: Accept-Encoding", response);
        this.assertResponseContains("ETag: ", response);
        this.assertResponseNotContains("Content-Encoding: gzip", response);
        int e = response.indexOf("ETag: ");
        String etag = response.substring(e + 6, response.indexOf(34, e + 11) + 1);
        String etag_gzip = etag.substring(0, etag.length() - 1) + "--gzip\"";
        response = this.connector.getResponses("GET /context/data0.txt HTTP/1.0\r\nHost:localhost:8080\r\nAccept-Encoding:gzip\r\n\r\n");
        this.assertResponseContains("Content-Length: 9", response);
        this.assertResponseContains("fake gzip", response);
        this.assertResponseContains("Content-Type: text/plain", response);
        this.assertResponseContains("Vary: Accept-Encoding", response);
        this.assertResponseContains("Content-Encoding: gzip", response);
        this.assertResponseContains("ETag: " + etag_gzip, response);
        response = this.connector.getResponses("GET /context/data0.txt.gz HTTP/1.0\r\nHost:localhost:8080\r\nAccept-Encoding:gzip\r\n\r\n");
        this.assertResponseContains("Content-Length: 9", response);
        this.assertResponseContains("fake gzip", response);
        this.assertResponseContains("Content-Type: application/gzip", response);
        this.assertResponseNotContains("Vary: Accept-Encoding", response);
        this.assertResponseNotContains("Content-Encoding: gzip", response);
        this.assertResponseNotContains("ETag: " + etag_gzip, response);
        this.assertResponseContains("ETag: ", response);
        response = this.connector.getResponses("GET /context/data0.txt HTTP/1.0\r\nHost:localhost:8080\r\nAccept-Encoding:gzip\r\nIf-None-Match: " + etag_gzip + "\r\n\r\n");
        this.assertResponseContains("304 Not Modified", response);
        this.assertResponseContains("ETag: " + etag_gzip, response);
        response = this.connector.getResponses("GET /context/data0.txt HTTP/1.0\r\nHost:localhost:8080\r\nAccept-Encoding:gzip\r\nIf-None-Match: " + etag + "\r\n\r\n");
        this.assertResponseContains("304 Not Modified", response);
        this.assertResponseContains("ETag: " + etag, response);
        response = this.connector.getResponses("GET /context/data0.txt HTTP/1.0\r\nHost:localhost:8080\r\nAccept-Encoding:gzip\r\nIf-None-Match: W/\"foobar\"," + etag_gzip + "\r\n\r\n");
        this.assertResponseContains("304 Not Modified", response);
        this.assertResponseContains("ETag: " + etag_gzip, response);
        response = this.connector.getResponses("GET /context/data0.txt HTTP/1.0\r\nHost:localhost:8080\r\nAccept-Encoding:gzip\r\nIf-None-Match: W/\"foobar\"," + etag + "\r\n\r\n");
        this.assertResponseContains("304 Not Modified", response);
        this.assertResponseContains("ETag: " + etag, response);
    }

    @Test
    public void testIfModifiedSmall() throws Exception {
        this.testIfModified("Hello World");
    }

    @Test
    public void testIfModifiedLarge() throws Exception {
        this.testIfModified("Now is the time for all good men to come to the aid of the party");
    }

    public void testIfModified(String content) throws Exception {
        this.testdir.ensureEmpty();
        File resBase = this.testdir.getPathFile("docroot").toFile();
        FS.ensureDirExists((File)resBase);
        File file = new File(resBase, "file.txt");
        String resBasePath = resBase.getAbsolutePath();
        ServletHolder defholder = this.context.addServlet(DefaultServlet.class, "/");
        defholder.setInitParameter("resourceBase", resBasePath);
        defholder.setInitParameter("maxCacheSize", "4096");
        defholder.setInitParameter("maxCachedFileSize", "25");
        defholder.setInitParameter("maxCachedFiles", "100");
        String response = this.connector.getResponses("GET /context/file.txt HTTP/1.0\r\n\r\n");
        this.assertResponseContains("404", response);
        this.createFile(file, content);
        response = this.connector.getResponses("GET /context/file.txt HTTP/1.1\r\nHost:test\r\nConnection:close\r\n\r\n");
        this.assertResponseContains("200", response);
        this.assertResponseContains("Last-Modified", response);
        String last_modified = this.getHeaderValue("Last-Modified", response);
        response = this.connector.getResponses("GET /context/file.txt HTTP/1.1\r\nHost:test\r\nConnection:close\r\nIf-Modified-Since: " + last_modified + "\r\n\r\n");
        this.assertResponseContains("304", response);
        response = this.connector.getResponses("GET /context/file.txt HTTP/1.1\r\nHost:test\r\nConnection:close\r\nIf-Modified-Since: " + DateGenerator.formatDate((long)(System.currentTimeMillis() - 10000L)) + "\r\n\r\n");
        this.assertResponseContains("200", response);
        response = this.connector.getResponses("GET /context/file.txt HTTP/1.1\r\nHost:test\r\nConnection:close\r\nIf-Modified-Since: " + DateGenerator.formatDate((long)(System.currentTimeMillis() + 10000L)) + "\r\n\r\n");
        this.assertResponseContains("304", response);
        response = this.connector.getResponses("GET /context/file.txt HTTP/1.1\r\nHost:test\r\nConnection:close\r\nIf-Unmodified-Since: " + DateGenerator.formatDate((long)(System.currentTimeMillis() + 10000L)) + "\r\n\r\n");
        this.assertResponseContains("200", response);
        response = this.connector.getResponses("GET /context/file.txt HTTP/1.1\r\nHost:test\r\nConnection:close\r\nIf-Unmodified-Since: " + DateGenerator.formatDate((long)(System.currentTimeMillis() - 10000L)) + "\r\n\r\n");
        this.assertResponseContains("412", response);
    }

    @Test
    public void testIfETagSmall() throws Exception {
        this.testIfETag("Hello World");
    }

    @Test
    public void testIfETagLarge() throws Exception {
        this.testIfETag("Now is the time for all good men to come to the aid of the party");
    }

    public void testIfETag(String content) throws Exception {
        this.testdir.ensureEmpty();
        File resBase = this.testdir.getPathFile("docroot").toFile();
        FS.ensureDirExists((File)resBase);
        File file = new File(resBase, "file.txt");
        String resBasePath = resBase.getAbsolutePath();
        ServletHolder defholder = this.context.addServlet(DefaultServlet.class, "/");
        defholder.setInitParameter("resourceBase", resBasePath);
        defholder.setInitParameter("maxCacheSize", "4096");
        defholder.setInitParameter("maxCachedFileSize", "25");
        defholder.setInitParameter("maxCachedFiles", "100");
        defholder.setInitParameter("etags", "true");
        this.createFile(file, content);
        String response = this.connector.getResponses("GET /context/file.txt HTTP/1.1\r\nHost:test\r\nConnection:close\r\n\r\n");
        this.assertResponseContains("200", response);
        this.assertResponseContains("ETag", response);
        String etag = this.getHeaderValue("ETag", response);
        response = this.connector.getResponses("GET /context/file.txt HTTP/1.1\r\nHost:test\r\nConnection:close\r\nIf-None-Match: " + etag + "\r\n\r\n");
        this.assertResponseContains("304", response);
        response = this.connector.getResponses("GET /context/file.txt HTTP/1.1\r\nHost:test\r\nConnection:close\r\nIf-None-Match: wibble," + etag + ",wobble\r\n\r\n");
        this.assertResponseContains("304", response);
        response = this.connector.getResponses("GET /context/file.txt HTTP/1.1\r\nHost:test\r\nConnection:close\r\nIf-None-Match: wibble\r\n\r\n");
        this.assertResponseContains("200", response);
        response = this.connector.getResponses("GET /context/file.txt HTTP/1.1\r\nHost:test\r\nConnection:close\r\nIf-None-Match: wibble, wobble\r\n\r\n");
        this.assertResponseContains("200", response);
        response = this.connector.getResponses("GET /context/file.txt HTTP/1.1\r\nHost:test\r\nConnection:close\r\nIf-Match: " + etag + "\r\n\r\n");
        this.assertResponseContains("200", response);
        response = this.connector.getResponses("GET /context/file.txt HTTP/1.1\r\nHost:test\r\nConnection:close\r\nIf-Match: wibble," + etag + ",wobble\r\n\r\n");
        this.assertResponseContains("200", response);
        response = this.connector.getResponses("GET /context/file.txt HTTP/1.1\r\nHost:test\r\nConnection:close\r\nIf-Match: wibble\r\n\r\n");
        this.assertResponseContains("412", response);
        response = this.connector.getResponses("GET /context/file.txt HTTP/1.1\r\nHost:test\r\nConnection:close\r\nIf-Match: wibble, wobble\r\n\r\n");
        this.assertResponseContains("412", response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFile(File file, String str) throws IOException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            out.write(str.getBytes(StandardCharsets.UTF_8));
            out.flush();
        }
        catch (Throwable throwable) {
            IO.close(out);
            throw throwable;
        }
        IO.close((OutputStream)out);
    }

    private void assertResponseNotContains(String forbidden, String response) {
        Assert.assertThat((Object)response, (org.hamcrest.Matcher)Matchers.not((org.hamcrest.Matcher)Matchers.containsString((String)forbidden)));
    }

    private int assertResponseContains(String expected, String response) {
        Assert.assertThat((Object)response, (org.hamcrest.Matcher)Matchers.containsString((String)expected));
        return response.indexOf(expected);
    }

    private void deleteFile(File file) throws IOException {
        if (OS.IS_WINDOWS) {
            boolean deleted = file.delete();
            if (!deleted) {
                File deletedDir = MavenTestingUtils.getTargetFile((String)".deleted");
                FS.ensureDirExists((File)deletedDir);
                File dest = File.createTempFile(file.getName(), "deleted", deletedDir);
                boolean renamed = file.renameTo(dest);
                if (!renamed) {
                    System.err.println("WARNING: unable to move file out of the way: " + file.getName());
                }
            }
        } else {
            Assert.assertTrue((String)("Deleting: " + file.getName()), (boolean)file.delete());
        }
    }

    private String getHeaderValue(String header, String response) {
        Pattern pattern = Pattern.compile("[\\r\\n]" + header + "\\s*:\\s*(.*?)\\s*[\\r\\n]");
        Matcher matcher = pattern.matcher(response);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public static class WriterFilter
    implements Filter {
        public void init(FilterConfig filterConfig) throws ServletException {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            response.getWriter().println("Extra Info");
            chain.doFilter(request, response);
        }

        public void destroy() {
        }
    }

    public static class OutputFilter
    implements Filter {
        public void init(FilterConfig filterConfig) throws ServletException {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            response.getOutputStream().println("Extra Info");
            chain.doFilter(request, response);
        }

        public void destroy() {
        }
    }
}

