/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.log.StacklessLogging;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PostServletTest {
    private static final Logger LOG = Log.getLogger(PostServletTest.class);
    private Server server;
    private LocalConnector connector;

    @Before
    public void startServer() throws Exception {
        this.server = new Server();
        this.connector = new LocalConnector(this.server);
        this.server.addConnector((Connector)this.connector);
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/");
        context.addServlet(BasicReadPostServlet.class, "/post");
        this.server.setHandler((Handler)context);
        this.server.start();
    }

    @After
    public void stopServer() throws Exception {
        this.server.stop();
    }

    @Test
    public void testGoodPost() throws Exception {
        StringBuilder req = new StringBuilder();
        req.append("POST /post HTTP/1.1\r\n");
        req.append("Host: localhost\r\n");
        req.append("Connection: close\r\n");
        req.append("Transfer-Encoding: chunked\r\n");
        req.append("\r\n");
        req.append("6\r\n");
        req.append("Hello ");
        req.append("\r\n");
        req.append("6\r\n");
        req.append("World\n");
        req.append("\r\n");
        req.append("0\r\n");
        req.append("\r\n");
        String resp = this.connector.getResponses(req.toString());
        Assert.assertThat((String)"resp", (Object)resp, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
    }

    @Test
    public void testBadPost() throws Exception {
        StringBuilder req = new StringBuilder(16384);
        req.append("POST /post HTTP/1.1\r\n");
        req.append("Host: localhost\r\n");
        req.append("Transfer-Encoding: chunked\r\n");
        req.append("\r\n");
        int i = 1024;
        while (i-- > 0) {
            req.append("xxxxxxxxxxxx");
        }
        req.append("\r\n");
        req.append("\r\n");
        try (StacklessLogging scope = new StacklessLogging(new Class[]{ServletHandler.class});){
            String resp = this.connector.getResponses(req.toString());
            Assert.assertThat((String)"resp", (Object)resp, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 "));
            Assert.assertThat((String)"resp", (Object)resp, (Matcher)Matchers.containsString((String)"chunked"));
            Assert.assertThat((String)"resp", (Object)resp, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"\r\n0\r\n")));
        }
    }

    public static class BasicReadPostServlet
    extends HttpServlet {
        protected void doPost(HttpServletRequest request, HttpServletResponse response) {
            try {
                response.flushBuffer();
                request.getInputStream().read();
            }
            catch (Exception e0) {
                try {
                    request.getInputStream().read();
                }
                catch (Exception e1) {
                    LOG.warn(e1.toString(), new Object[0]);
                }
            }
        }
    }
}

