/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.toolchain.test.http.SimpleHttpParser;
import org.eclipse.jetty.toolchain.test.http.SimpleHttpResponse;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class AsyncContextListenersTest {
    private Server _server;
    private ServerConnector _connector;

    public void prepare(String path, HttpServlet servlet) throws Exception {
        this._server = new Server();
        this._connector = new ServerConnector(this._server);
        this._server.addConnector((Connector)this._connector);
        ServletContextHandler context = new ServletContextHandler((HandlerContainer)this._server, "/", false, false);
        context.addServlet(new ServletHolder((Servlet)servlet), path);
        this._server.start();
    }

    @After
    public void dispose() throws Exception {
        this._server.stop();
    }

    @Test
    public void testListenerClearedOnSecondRequest() throws Exception {
        final AtomicReference<CountDownLatch> completes = new AtomicReference<CountDownLatch>(new CountDownLatch(1));
        String path = "/path";
        this.prepare(path, new HttpServlet(){

            protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                AsyncContext asyncContext = request.startAsync((ServletRequest)request, (ServletResponse)response);
                asyncContext.addListener(new AsyncListener(){

                    public void onStartAsync(AsyncEvent event) throws IOException {
                    }

                    public void onComplete(AsyncEvent event) throws IOException {
                        ((CountDownLatch)completes.get()).countDown();
                    }

                    public void onTimeout(AsyncEvent event) throws IOException {
                    }

                    public void onError(AsyncEvent event) throws IOException {
                    }
                });
                asyncContext.complete();
            }
        });
        try (Socket socket = new Socket("localhost", this._connector.getLocalPort());){
            OutputStream output = socket.getOutputStream();
            String request = "GET " + path + " HTTP/1.1\r\nHost: localhost\r\n\r\n";
            output.write(request.getBytes(StandardCharsets.UTF_8));
            output.flush();
            BufferedReader reader = new BufferedReader(new InputStreamReader(socket.getInputStream(), StandardCharsets.UTF_8));
            SimpleHttpParser parser = new SimpleHttpParser();
            SimpleHttpResponse response = parser.readResponse(reader);
            Assert.assertEquals((Object)"200", (Object)response.getCode());
            completes.get().await(10L, TimeUnit.SECONDS);
            completes.set(new CountDownLatch(1));
            output.write(request.getBytes(StandardCharsets.UTF_8));
            output.flush();
            response = parser.readResponse(reader);
            Assert.assertEquals((Object)"200", (Object)response.getCode());
            completes.get().await(10L, TimeUnit.SECONDS);
        }
    }

    @Test
    public void testListenerAddedFromListener() throws Exception {
        final AtomicReference<CountDownLatch> completes = new AtomicReference<CountDownLatch>(new CountDownLatch(1));
        String path = "/path";
        this.prepare(path, new HttpServlet(){

            protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                AsyncContext asyncContext = request.startAsync((ServletRequest)request, (ServletResponse)response);
                asyncContext.addListener(new AsyncListener(){

                    public void onStartAsync(AsyncEvent event) throws IOException {
                        event.getAsyncContext().addListener((AsyncListener)this);
                    }

                    public void onComplete(AsyncEvent event) throws IOException {
                        ((CountDownLatch)completes.get()).countDown();
                    }

                    public void onTimeout(AsyncEvent event) throws IOException {
                    }

                    public void onError(AsyncEvent event) throws IOException {
                    }
                });
                asyncContext.complete();
            }
        });
        try (Socket socket = new Socket("localhost", this._connector.getLocalPort());){
            OutputStream output = socket.getOutputStream();
            String request = "GET " + path + " HTTP/1.1\r\nHost: localhost\r\n\r\n";
            output.write(request.getBytes(StandardCharsets.UTF_8));
            output.flush();
            BufferedReader reader = new BufferedReader(new InputStreamReader(socket.getInputStream(), StandardCharsets.UTF_8));
            SimpleHttpParser parser = new SimpleHttpParser();
            SimpleHttpResponse response = parser.readResponse(reader);
            Assert.assertEquals((Object)"200", (Object)response.getCode());
            completes.get().await(10L, TimeUnit.SECONDS);
            completes.set(new CountDownLatch(1));
            output.write(request.getBytes(StandardCharsets.UTF_8));
            output.flush();
            response = parser.readResponse(reader);
            Assert.assertEquals((Object)"200", (Object)response.getCode());
            completes.get().await(10L, TimeUnit.SECONDS);
        }
    }

    @Test
    public void testAsyncDispatchAsyncCompletePreservesListener() throws Exception {
        final AtomicReference<CountDownLatch> completes = new AtomicReference<CountDownLatch>(new CountDownLatch(1));
        String path = "/path";
        this.prepare("/path/*", new HttpServlet(){

            protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                String requestURI = request.getRequestURI();
                if (requestURI.endsWith("/one")) {
                    AsyncContext asyncContext = request.startAsync((ServletRequest)request, (ServletResponse)response);
                    asyncContext.addListener(new AsyncListener(){

                        public void onStartAsync(AsyncEvent event) throws IOException {
                            event.getAsyncContext().addListener((AsyncListener)this);
                        }

                        public void onComplete(AsyncEvent event) throws IOException {
                            ((CountDownLatch)completes.get()).countDown();
                        }

                        public void onTimeout(AsyncEvent event) throws IOException {
                        }

                        public void onError(AsyncEvent event) throws IOException {
                        }
                    });
                    asyncContext.dispatch("/path/two");
                } else if (requestURI.endsWith("/two")) {
                    AsyncContext asyncContext = request.startAsync((ServletRequest)request, (ServletResponse)response);
                    asyncContext.complete();
                }
            }
        });
        try (Socket socket = new Socket("localhost", this._connector.getLocalPort());){
            OutputStream output = socket.getOutputStream();
            String request = "GET /path/one HTTP/1.1\r\nHost: localhost\r\n\r\n";
            output.write(request.getBytes(StandardCharsets.UTF_8));
            output.flush();
            BufferedReader reader = new BufferedReader(new InputStreamReader(socket.getInputStream(), StandardCharsets.UTF_8));
            SimpleHttpParser parser = new SimpleHttpParser();
            SimpleHttpResponse response = parser.readResponse(reader);
            Assert.assertEquals((Object)"200", (Object)response.getCode());
            completes.get().await(10L, TimeUnit.SECONDS);
            completes.set(new CountDownLatch(1));
            output.write(request.getBytes(StandardCharsets.UTF_8));
            output.flush();
            response = parser.readResponse(reader);
            Assert.assertEquals((Object)"200", (Object)response.getCode());
            completes.get().await(10L, TimeUnit.SECONDS);
        }
    }
}

