/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import javax.servlet.UnavailableException;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.servlet.BaseHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.MultiException;
import org.eclipse.jetty.util.log.StacklessLogging;
import org.junit.Assert;
import org.junit.Test;

public class ServletHolderTest {
    @Test
    public void testTransitiveCompareTo() throws Exception {
        ServletHolder one = new ServletHolder();
        one.setInitOrder(-1);
        one.setName("Login");
        one.setClassName(null);
        ServletHolder two = new ServletHolder();
        two.setInitOrder(-1);
        two.setName("org.my.package.jsp.WEB_002dINF.pages.precompiled_002dpage_jsp");
        two.setClassName("org.my.package.jsp.WEB_002dINF.pages.precompiled_002dpage_jsp");
        ServletHolder three = new ServletHolder();
        three.setInitOrder(-1);
        three.setName("Download");
        three.setClassName("org.my.package.web.DownloadServlet");
        Assert.assertTrue((one.compareTo(two) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((two.compareTo(three) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((one.compareTo(three) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testJspFileNameToClassName() throws Exception {
        ServletHolder h = new ServletHolder();
        h.setName("test");
        Assert.assertEquals(null, (Object)h.getClassNameForJsp(null));
        Assert.assertEquals(null, (Object)h.getClassNameForJsp(""));
        Assert.assertEquals(null, (Object)h.getClassNameForJsp("/blah/"));
        Assert.assertEquals(null, (Object)h.getClassNameForJsp("//blah///"));
        Assert.assertEquals(null, (Object)h.getClassNameForJsp("/a/b/c/blah/"));
        Assert.assertEquals((Object)"org.apache.jsp.a.b.c.blah", (Object)h.getClassNameForJsp("/a/b/c/blah"));
        Assert.assertEquals((Object)"org.apache.jsp.blah_jsp", (Object)h.getClassNameForJsp("/blah.jsp"));
        Assert.assertEquals((Object)"org.apache.jsp.blah_jsp", (Object)h.getClassNameForJsp("//blah.jsp"));
        Assert.assertEquals((Object)"org.apache.jsp.blah_jsp", (Object)h.getClassNameForJsp("blah.jsp"));
        Assert.assertEquals((Object)"org.apache.jsp.a.b.c.blah_jsp", (Object)h.getClassNameForJsp("/a/b/c/blah.jsp"));
        Assert.assertEquals((Object)"org.apache.jsp.a.b.c.blah_jsp", (Object)h.getClassNameForJsp("a/b/c/blah.jsp"));
    }

    @Test
    public void testNoClassName() throws Exception {
        try (StacklessLogging stackless = new StacklessLogging(new Class[]{ServletHandler.class, ContextHandler.class, ServletContextHandler.class});){
            ServletContextHandler context = new ServletContextHandler();
            ServletHandler handler = context.getServletHandler();
            ServletHolder holder = new ServletHolder();
            holder.setName("foo");
            holder.setForcedPath("/blah/");
            handler.addServlet(holder);
            handler.start();
            Assert.fail((String)"No class in ServletHolder");
        }
        catch (UnavailableException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("foo"));
        }
        catch (MultiException e) {
            MultiException m = e;
            Assert.assertTrue((boolean)m.getCause().getMessage().contains("foo"));
        }
    }

    @Test
    public void testUnloadableClassName() throws Exception {
        try (StacklessLogging stackless = new StacklessLogging(new Class[]{BaseHolder.class, ServletHandler.class, ContextHandler.class, ServletContextHandler.class});){
            ServletContextHandler context = new ServletContextHandler();
            ServletHandler handler = context.getServletHandler();
            ServletHolder holder = new ServletHolder();
            holder.setName("foo");
            holder.setClassName("a.b.c.class");
            handler.addServlet(holder);
            handler.start();
            Assert.fail((String)"Unloadable class");
        }
        catch (UnavailableException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("foo"));
        }
        catch (MultiException e) {
            MultiException m = e;
            Assert.assertTrue((boolean)m.getCause().getMessage().contains("foo"));
        }
    }
}

