/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.util.log.StacklessLogging;
import org.junit.Assert;
import org.junit.Test;

public class FilterHolderTest {
    @Test
    public void testInitialize() throws Exception {
        ServletHandler handler = new ServletHandler();
        final AtomicInteger counter = new AtomicInteger(0);
        Filter filter = new Filter(){

            public void init(FilterConfig filterConfig) throws ServletException {
                counter.incrementAndGet();
            }

            public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            }

            public void destroy() {
            }
        };
        FilterHolder fh = new FilterHolder();
        fh.setServletHandler(handler);
        fh.setName("xx");
        fh.setFilter(filter);
        try (StacklessLogging stackless = new StacklessLogging(new Class[]{FilterHolder.class});){
            fh.initialize();
            Assert.fail((String)"Not started");
        }
        catch (Exception exception) {
            // empty catch block
        }
        fh.start();
        fh.initialize();
        Assert.assertEquals((long)1L, (long)counter.get());
        fh.initialize();
        Assert.assertEquals((long)1L, (long)counter.get());
        fh.stop();
        Assert.assertEquals((long)1L, (long)counter.get());
        fh.start();
        Assert.assertEquals((long)1L, (long)counter.get());
        fh.initialize();
        Assert.assertEquals((long)2L, (long)counter.get());
    }
}

