/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Arrays;
import java.util.Collection;
import java.util.Random;
import javax.servlet.AsyncContext;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpTester;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SSLAsyncIOServletTest {
    private Server server;
    private ServerConnector connector;
    private SslContextFactory sslContextFactory;
    private String contextPath;
    private String servletPath;

    @Parameterized.Parameters(name="ssl={0}")
    public static Collection<SslContextFactory[]> parameters() {
        return Arrays.asList({null}, {new SslContextFactory()});
    }

    public SSLAsyncIOServletTest(SslContextFactory sslContextFactory) {
        this.sslContextFactory = sslContextFactory;
        if (sslContextFactory != null) {
            sslContextFactory.setEndpointIdentificationAlgorithm("");
            sslContextFactory.setKeyStorePath("src/test/resources/keystore.jks");
            sslContextFactory.setKeyStorePassword("storepwd");
            sslContextFactory.setTrustStorePath("src/test/resources/truststore.jks");
            sslContextFactory.setTrustStorePassword("storepwd");
        }
    }

    public void prepare(HttpServlet servlet) throws Exception {
        this.server = new Server();
        this.connector = new ServerConnector(this.server, this.sslContextFactory);
        this.server.addConnector((Connector)this.connector);
        this.contextPath = "/context";
        ServletContextHandler context = new ServletContextHandler((HandlerContainer)this.server, this.contextPath, true, false);
        this.servletPath = "/servlet";
        context.addServlet(new ServletHolder((Servlet)servlet), this.servletPath);
        this.server.start();
    }

    @After
    public void dispose() throws Exception {
        this.server.stop();
    }

    @Test
    public void testAsyncIOWritesWithAggregation() throws Exception {
        Random random = new Random();
        String chars = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
        final byte[] content = new byte[50000];
        for (int i = 0; i < content.length; ++i) {
            content[i] = (byte)chars.charAt(random.nextInt(chars.length()));
        }
        this.prepare(new HttpServlet(){

            protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                final AsyncContext asyncContext = request.startAsync();
                asyncContext.setTimeout(0L);
                int bufferSize = 4096;
                response.setBufferSize(4096);
                response.getOutputStream().setWriteListener(new WriteListener(){
                    private int writes;
                    private int written;

                    public void onWritePossible() throws IOException {
                        ServletOutputStream output = asyncContext.getResponse().getOutputStream();
                        do {
                            int toWrite;
                            if ((toWrite = content.length - this.written) == 0) {
                                asyncContext.complete();
                                return;
                            }
                            toWrite = Math.min(toWrite, 4096);
                            if (this.writes == 1) {
                                toWrite -= 16;
                            }
                            output.write(content, this.written, toWrite);
                            ++this.writes;
                            this.written += toWrite;
                        } while (output.isReady());
                    }

                    public void onError(Throwable t) {
                        asyncContext.complete();
                    }
                });
            }
        });
        try (Socket client = this.newClient();){
            String request = "GET " + this.contextPath + this.servletPath + " HTTP/1.1\r\nHost: localhost\r\nConnection: close\r\n\r\n";
            OutputStream output = client.getOutputStream();
            output.write(request.getBytes("UTF-8"));
            output.flush();
            InputStream inputStream = client.getInputStream();
            HttpTester.Response response = HttpTester.parseResponse((InputStream)inputStream);
            Assert.assertEquals((long)200L, (long)response.getStatus());
            Assert.assertArrayEquals((byte[])content, (byte[])response.getContent().getBytes("UTF-8"));
        }
    }

    private Socket newClient() throws IOException {
        return this.sslContextFactory == null ? new Socket("localhost", this.connector.getLocalPort()) : this.sslContextFactory.getSslContext().getSocketFactory().createSocket("localhost", this.connector.getLocalPort());
    }
}

