/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ReadListener;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.DebugListener;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AsyncServletIOTest {
    private static final Logger LOG = Log.getLogger(AsyncServletIOTest.class);
    protected AsyncIOServlet _servlet0 = new AsyncIOServlet();
    protected AsyncIOServlet2 _servlet2 = new AsyncIOServlet2();
    protected AsyncIOServlet3 _servlet3 = new AsyncIOServlet3();
    protected AsyncIOServlet4 _servlet4 = new AsyncIOServlet4();
    protected StolenAsyncReadServlet _servletStolenAsyncRead = new StolenAsyncReadServlet();
    protected int _port;
    protected WrappingQTP _wQTP;
    protected Server _server;
    protected ServletHandler _servletHandler;
    protected ServerConnector _connector;
    static AtomicInteger _owp = new AtomicInteger();
    static AtomicInteger _oda = new AtomicInteger();
    static AtomicInteger _read = new AtomicInteger();

    @Before
    public void setUp() throws Exception {
        this._wQTP = new WrappingQTP();
        this._server = new Server((ThreadPool)this._wQTP);
        HttpConfiguration http_config = new HttpConfiguration();
        http_config.setOutputBufferSize(4096);
        this._connector = new ServerConnector(this._server, new ConnectionFactory[]{new HttpConnectionFactory(http_config)});
        this._server.setConnectors(new Connector[]{this._connector});
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/ctx");
        context.addEventListener((EventListener)new DebugListener());
        this._server.setHandler((Handler)context);
        this._servletHandler = context.getServletHandler();
        ServletHolder holder = new ServletHolder((Servlet)this._servlet0);
        holder.setAsyncSupported(true);
        this._servletHandler.addServletWithMapping(holder, "/path/*");
        ServletHolder holder2 = new ServletHolder((Servlet)this._servlet2);
        holder2.setAsyncSupported(true);
        this._servletHandler.addServletWithMapping(holder2, "/path2/*");
        ServletHolder holder3 = new ServletHolder((Servlet)this._servlet3);
        holder3.setAsyncSupported(true);
        this._servletHandler.addServletWithMapping(holder3, "/path3/*");
        ServletHolder holder4 = new ServletHolder((Servlet)this._servlet4);
        holder4.setAsyncSupported(true);
        this._servletHandler.addServletWithMapping(holder4, "/path4/*");
        ServletHolder holder5 = new ServletHolder((Servlet)this._servletStolenAsyncRead);
        holder5.setAsyncSupported(true);
        this._servletHandler.addServletWithMapping(holder5, "/stolen/*");
        this._server.start();
        this._port = this._connector.getLocalPort();
        _owp.set(0);
        _oda.set(0);
        _read.set(0);
    }

    @After
    public void tearDown() throws Exception {
        this._server.stop();
    }

    @Test
    public void testEmpty() throws Exception {
        this.process(new int[0]);
    }

    @Test
    public void testWrite() throws Exception {
        this.process(10);
    }

    @Test
    public void testWrites() throws Exception {
        this.process(10, 1, 20, 10);
    }

    @Test
    public void testWritesFlushWrites() throws Exception {
        this.process(10, 1, 0, 20, 10);
    }

    @Test
    public void testBigWrite() throws Exception {
        this.process(102400);
    }

    @Test
    public void testBigWrites() throws Exception {
        this.process(102400, 102400, 102400, 102400, 102400, 102400, 102400, 102400, 102400, 102400, 102400, 102400, 102400, 102400, 102400, 102400, 102400, 102400, 102400, 102400, 102400, 102400, 102400, 102400, 102400, 102400, 102400, 102400, 102400, 102400, 102400, 102400, 102400, 102400, 102400, 102400, 102400, 102400, 102400);
        Assert.assertThat((String)"On Write Possible", (Object)_owp.get(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
    }

    @Test
    public void testRead() throws Exception {
        this.process("Hello!!!\r\n", new int[0]);
    }

    @Test
    public void testBigRead() throws Exception {
        this.process("Now is the time for all good men to come to the aid of the party. How now Brown Cow. The quick brown fox jumped over the lazy dog. The moon is blue to a fish in love.\r\n", new int[0]);
    }

    @Test
    public void testReadWrite() throws Exception {
        this.process("Hello!!!\r\n", 10);
    }

    @Test
    public void testAsync2() throws Exception {
        StringBuilder request = new StringBuilder(512);
        request.append("GET /ctx/path2/info HTTP/1.1\r\n").append("Host: localhost\r\n").append("Connection: close\r\n").append("\r\n");
        int port = this._port;
        ArrayList<String> list = new ArrayList<String>();
        try (Socket socket = new Socket("localhost", port);){
            socket.setSoTimeout(1000000);
            OutputStream out = socket.getOutputStream();
            out.write(request.toString().getBytes(StandardCharsets.ISO_8859_1));
            BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()), 102400);
            String line = in.readLine();
            LOG.debug("response-line: " + line, new Object[0]);
            Assert.assertThat((Object)line, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200 OK"));
            while (line != null) {
                line = in.readLine();
                LOG.debug("header-line: " + line, new Object[0]);
                if (line.length() != 0) continue;
            }
            while (true) {
                line = in.readLine();
                LOG.debug("body: " + line, new Object[0]);
                if (line == null) {
                    break;
                }
                list.add(line);
            }
        }
        Assert.assertEquals(list.get(0), (Object)"data");
        Assert.assertTrue((boolean)this._servlet2.completed.await(5L, TimeUnit.SECONDS));
    }

    @Test
    public void testAsyncConsumeAll() throws Exception {
        StringBuilder request = new StringBuilder(512);
        request.append("GET /ctx/path3/info HTTP/1.1\r\n").append("Host: localhost\r\n").append("Content-Type: text/plain\r\n").append("Content-Length: 10\r\n").append("\r\n").append("0");
        int port = this._port;
        try (Socket socket = new Socket("localhost", port);){
            socket.setSoTimeout(10000);
            OutputStream out = socket.getOutputStream();
            out.write(request.toString().getBytes(StandardCharsets.ISO_8859_1));
            BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()), 102400);
            String line = in.readLine();
            LOG.debug("response-line: " + line, new Object[0]);
            Assert.assertThat((Object)line, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200 OK"));
            while (line != null) {
                line = in.readLine();
                LOG.debug("header-line: " + line, new Object[0]);
                if (line.length() != 0) continue;
            }
            line = in.readLine();
            LOG.debug("body: " + line, new Object[0]);
            Assert.assertEquals((Object)"DONE", (Object)line);
            line = in.readLine();
            Assert.assertNull((Object)line);
        }
    }

    public synchronized List<String> process(String content, int ... writes) throws Exception {
        return this.process(content.getBytes(StandardCharsets.ISO_8859_1), writes);
    }

    public synchronized List<String> process(int ... writes) throws Exception {
        return this.process((byte[])null, writes);
    }

    public synchronized List<String> process(byte[] content, int ... writes) throws Exception {
        StringBuilder request = new StringBuilder(512);
        request.append("GET /ctx/path/info");
        int s = 63;
        for (int w : writes) {
            request.append((char)s).append("w=").append(w);
            s = 38;
        }
        request.append(" HTTP/1.1\r\n").append("Host: localhost\r\n").append("Connection: close\r\n");
        if (content != null) {
            request.append("Content-Length: ").append(content.length).append("\r\n").append("Content-Type: text/plain\r\n");
        }
        request.append("\r\n");
        int port = this._port;
        ArrayList<String> list = new ArrayList<String>();
        Socket socket = new Socket("localhost", port);
        Object object = null;
        try {
            socket.setSoTimeout(1000000);
            OutputStream out = socket.getOutputStream();
            out.write(request.toString().getBytes(StandardCharsets.ISO_8859_1));
            if (content != null && content.length > 0) {
                Thread.sleep(100L);
                out.write(content[0]);
                Thread.sleep(100L);
                int half = (content.length - 1) / 2;
                out.write(content, 1, half);
                Thread.sleep(100L);
                out.write(content, 1 + half, content.length - half - 1);
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()), 102400);
            String line = in.readLine();
            LOG.debug("response-line: " + line, new Object[0]);
            Assert.assertThat((Object)line, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200 OK"));
            while (line != null) {
                line = in.readLine();
                LOG.debug("header-line:  " + line, new Object[0]);
                if (line.length() != 0) continue;
            }
            while ((line = in.readLine()) != null) {
                LOG.debug("body:  " + AsyncServletIOTest.brief(line), new Object[0]);
                list.add(line);
                Thread.sleep(50L);
            }
        }
        catch (Throwable out) {
            object = out;
            throw out;
        }
        finally {
            AsyncServletIOTest.$closeResource((Throwable)object, socket);
        }
        int w = 0;
        for (String line : list) {
            LOG.debug("line:  " + AsyncServletIOTest.brief(line), new Object[0]);
            if ("-".equals(line)) continue;
            Assert.assertEquals((String)"Line Length", (long)writes[w], (long)line.length());
            Assert.assertEquals((String)"Line Contents", (long)line.charAt(0), (long)(48 + w % 10));
            if (++w >= writes.length || writes[w] > 0) continue;
            ++w;
        }
        if (content != null) {
            Assert.assertEquals((String)"Content Length", (long)content.length, (long)_read.get());
        }
        return list;
    }

    private static String brief(String line) {
        return line.length() + "\t" + (line.length() > 40 ? line.substring(0, 40) + "..." : line);
    }

    @Test
    public void testCompleteWhilePending() throws Exception {
        this._servlet4.onDA.set(0);
        this._servlet4.onWP.set(0);
        StringBuilder request = new StringBuilder(512);
        request.append("POST /ctx/path4/info HTTP/1.1\r\n").append("Host: localhost\r\n").append("Content-Type: text/plain\r\n").append("Content-Length: 20\r\n").append("\r\n").append("12345678\r\n");
        int port = this._port;
        ArrayList<String> list = new ArrayList<String>();
        try (Socket socket = new Socket("localhost", port);){
            socket.setSoTimeout(10000);
            OutputStream out = socket.getOutputStream();
            out.write(request.toString().getBytes(StandardCharsets.ISO_8859_1));
            out.flush();
            Thread.sleep(100L);
            out.write("ABC".getBytes(StandardCharsets.ISO_8859_1));
            out.flush();
            Thread.sleep(100L);
            out.write("DEF".getBytes(StandardCharsets.ISO_8859_1));
            out.flush();
            BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            String line = in.readLine();
            LOG.debug("response-line: " + line, new Object[0]);
            Assert.assertThat((Object)line, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200 OK"));
            boolean chunked = false;
            while (line != null) {
                line = in.readLine();
                LOG.debug("header-line: " + line, new Object[0]);
                chunked |= "Transfer-Encoding: chunked".equals(line);
                if (line.length() != 0) continue;
            }
            Assert.assertTrue((boolean)chunked);
            String last = null;
            try {
                while (true) {
                    last = line;
                    line = in.readLine();
                    LOG.debug("body: " + line, new Object[0]);
                    if (line != null) {
                        list.add(line);
                        continue;
                    }
                    break;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            LOG.debug("last: " + last, new Object[0]);
            Assert.assertThat((Object)last, (Matcher)Matchers.notNullValue());
            Assert.assertThat((Object)last.trim(), (Matcher)Matchers.not((Matcher)Matchers.startsWith((String)"0")));
        }
        Assert.assertTrue((boolean)this._servlet4.completed.await(5L, TimeUnit.SECONDS));
        Thread.sleep(100L);
        Assert.assertEquals((long)0L, (long)this._servlet4.onDA.get());
        Assert.assertEquals((long)0L, (long)this._servlet4.onWP.get());
    }

    @Test
    public void testStolenAsyncRead() throws Exception {
        StringBuilder request = new StringBuilder(512);
        request.append("POST /ctx/stolen/info HTTP/1.1\r\n").append("Host: localhost\r\n").append("Content-Type: text/plain\r\n").append("Content-Length: 2\r\n").append("\r\n").append("1");
        int port = this._port;
        try (Socket socket = new Socket("localhost", port);){
            socket.setSoTimeout(10000);
            OutputStream out = socket.getOutputStream();
            out.write(request.toString().getBytes(StandardCharsets.ISO_8859_1));
            out.flush();
            this._servletStolenAsyncRead.ready.await();
            CountDownLatch wait = new CountDownLatch(1);
            UnaryOperator<Runnable> old = this._wQTP.wrapper.getAndSet(r -> () -> {
                try {
                    wait.await();
                    r.run();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            });
            ServletInputStream sin = this._servletStolenAsyncRead.listener.in;
            sin.setReadListener((ReadListener)this._servletStolenAsyncRead.listener);
            Assert.assertTrue((boolean)sin.isReady());
            Assert.assertThat((Object)sin.read(), (Matcher)Matchers.is((Object)49));
            Assert.assertFalse((boolean)sin.isReady());
            this._wQTP.wrapper.set(old);
            wait.countDown();
            Assert.assertFalse((boolean)this._servletStolenAsyncRead.oda.await(500L, TimeUnit.MILLISECONDS));
            out.write(50);
            out.flush();
            Assert.assertTrue((boolean)this._servletStolenAsyncRead.oda.await(500L, TimeUnit.MILLISECONDS));
            Assert.assertTrue((boolean)sin.isReady());
            Assert.assertThat((Object)sin.read(), (Matcher)Matchers.is((Object)50));
            Assert.assertTrue((boolean)sin.isReady());
            Assert.assertThat((Object)sin.read(), (Matcher)Matchers.is((Object)-1));
            BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            String line = in.readLine();
            LOG.debug("response-line: " + line, new Object[0]);
            Assert.assertThat((Object)line, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200 OK"));
            while (line != null) {
                line = in.readLine();
                LOG.debug("header-line: " + line, new Object[0]);
                if (line.length() != 0) continue;
                break;
            }
        }
        Assert.assertTrue((boolean)this._servletStolenAsyncRead.completed.await(5L, TimeUnit.SECONDS));
    }

    private class WrappingQTP
    extends QueuedThreadPool {
        AtomicReference<UnaryOperator<Runnable>> wrapper = new AtomicReference(UnaryOperator.identity());

        private WrappingQTP() {
        }

        public void execute(Runnable job) {
            super.execute((Runnable)this.wrapper.get().apply(job));
        }
    }

    public class StolenAsyncReadServlet
    extends HttpServlet {
        public CountDownLatch ready = new CountDownLatch(1);
        public CountDownLatch oda = new CountDownLatch(1);
        public CountDownLatch completed = new CountDownLatch(1);
        public volatile StealingListener listener;

        public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
            this.listener = new StealingListener(request);
            this.ready.countDown();
        }

        public class StealingListener
        implements ReadListener,
        AsyncListener {
            final HttpServletRequest request;
            final ServletInputStream in;
            final AsyncContext asyncContext;

            StealingListener(HttpServletRequest request) throws IOException {
                this.asyncContext = request.startAsync();
                this.asyncContext.setTimeout(10000L);
                this.asyncContext.addListener((AsyncListener)this);
                this.request = request;
                this.in = request.getInputStream();
            }

            public void onDataAvailable() {
                StolenAsyncReadServlet.this.oda.countDown();
            }

            public void onAllDataRead() throws IOException {
                this.asyncContext.complete();
            }

            public void onError(Throwable t) {
                t.printStackTrace();
                this.asyncContext.complete();
            }

            public void onComplete(AsyncEvent event) {
                StolenAsyncReadServlet.this.completed.countDown();
            }

            public void onTimeout(AsyncEvent event) {
                this.asyncContext.complete();
            }

            public void onError(AsyncEvent event) {
                this.asyncContext.complete();
            }

            public void onStartAsync(AsyncEvent event) {
            }
        }
    }

    public class AsyncIOServlet4
    extends HttpServlet {
        public CountDownLatch completed = new CountDownLatch(1);
        public AtomicInteger onDA = new AtomicInteger();
        public AtomicInteger onWP = new AtomicInteger();

        public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
            final AsyncContext async = request.startAsync();
            final ServletInputStream in = request.getInputStream();
            final ServletOutputStream out = response.getOutputStream();
            in.setReadListener(new ReadListener(){

                public void onError(Throwable t) {
                    t.printStackTrace();
                }

                public void onDataAvailable() throws IOException {
                    AsyncIOServlet4.this.onDA.incrementAndGet();
                    boolean readF = false;
                    while (in.isReady()) {
                        int c = in.read();
                        if (c < 0) {
                            throw new IllegalStateException();
                        }
                        if (c != 70) continue;
                        readF = true;
                    }
                    if (readF) {
                        AsyncIOServlet4.this.onDA.set(0);
                        final byte[] buffer = new byte[65536];
                        Arrays.fill(buffer, (byte)88);
                        for (int i = 199; i < buffer.length; i += 200) {
                            buffer[i] = 10;
                        }
                        out.setWriteListener(new WriteListener(){

                            public void onWritePossible() throws IOException {
                                AsyncIOServlet4.this.onWP.incrementAndGet();
                                while (out.isReady()) {
                                    out.write(buffer);
                                }
                                try {
                                    AsyncIOServlet4.this.onWP.set(0);
                                    async.complete();
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                finally {
                                    AsyncIOServlet4.this.completed.countDown();
                                }
                            }

                            public void onError(Throwable t) {
                                t.printStackTrace();
                            }
                        });
                    }
                }

                public void onAllDataRead() throws IOException {
                    throw new IllegalStateException();
                }
            });
        }
    }

    public class AsyncIOServlet3
    extends HttpServlet {
        public CountDownLatch completed = new CountDownLatch(1);

        public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
            AsyncContext async = request.startAsync();
            request.getInputStream().setReadListener(new ReadListener(){

                public void onError(Throwable t) {
                }

                public void onDataAvailable() throws IOException {
                }

                public void onAllDataRead() throws IOException {
                }
            });
            response.setStatus(200);
            response.getOutputStream().print("DONE");
            async.complete();
        }
    }

    public class AsyncIOServlet2
    extends HttpServlet {
        public CountDownLatch completed = new CountDownLatch(1);

        public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
            new SampleAsycListener(request, response);
        }

        class SampleAsycListener
        implements WriteListener,
        AsyncListener {
            final ServletResponse response;
            final ServletOutputStream servletOutputStream;
            final AsyncContext asyncContext;
            volatile boolean written = false;

            SampleAsycListener(HttpServletRequest request, HttpServletResponse response) throws IOException {
                this.asyncContext = request.startAsync();
                this.asyncContext.setTimeout(10000L);
                this.asyncContext.addListener((AsyncListener)this);
                this.servletOutputStream = response.getOutputStream();
                this.servletOutputStream.setWriteListener((WriteListener)this);
                this.response = response;
            }

            public void onWritePossible() throws IOException {
                if (!this.written) {
                    this.written = true;
                    this.response.setContentLength(5);
                    this.servletOutputStream.write("data\n".getBytes());
                }
                if (this.servletOutputStream.isReady()) {
                    this.asyncContext.complete();
                }
            }

            public void onError(Throwable t) {
                t.printStackTrace();
                this.asyncContext.complete();
            }

            public void onComplete(AsyncEvent event) throws IOException {
                AsyncIOServlet2.this.completed.countDown();
            }

            public void onTimeout(AsyncEvent event) throws IOException {
                this.asyncContext.complete();
            }

            public void onError(AsyncEvent event) throws IOException {
                this.asyncContext.complete();
            }

            public void onStartAsync(AsyncEvent event) throws IOException {
            }
        }
    }

    private static class AsyncIOServlet
    extends HttpServlet {
        private static final long serialVersionUID = -8161977157098646562L;

        public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            final AsyncContext async = request.startAsync();
            final AtomicInteger complete = new AtomicInteger(2);
            final AtomicBoolean onDataAvailable = new AtomicBoolean(false);
            if (request.getContentLength() > 0) {
                final ServletInputStream in = request.getInputStream();
                in.setReadListener(new ReadListener(){
                    byte[] _buf = new byte[32];

                    public void onError(Throwable t) {
                        if (complete.decrementAndGet() == 0) {
                            async.complete();
                        }
                    }

                    public void onDataAvailable() throws IOException {
                        if (!onDataAvailable.compareAndSet(false, true)) {
                            throw new IllegalStateException();
                        }
                        while (in.isReady() && !in.isFinished()) {
                            _oda.incrementAndGet();
                            int len = in.read(this._buf);
                            if (len <= 0) continue;
                            _read.addAndGet(len);
                        }
                        if (!onDataAvailable.compareAndSet(true, false)) {
                            throw new IllegalStateException();
                        }
                    }

                    public void onAllDataRead() throws IOException {
                        if (onDataAvailable.get()) {
                            LOG.warn("OADR too early!", new Object[0]);
                            _read.set(-1);
                        }
                        if (complete.decrementAndGet() == 0) {
                            async.complete();
                        }
                    }
                });
            } else {
                complete.decrementAndGet();
            }
            final String[] writes = request.getParameterValues("w");
            final ServletOutputStream out = response.getOutputStream();
            out.setWriteListener(new WriteListener(){
                int _w = 0;

                public void onWritePossible() throws IOException {
                    LOG.debug("OWP", new Object[0]);
                    _owp.incrementAndGet();
                    while (writes != null && this._w < writes.length) {
                        int write;
                        if ((write = Integer.valueOf(writes[this._w++]).intValue()) == 0) {
                            out.flush();
                        } else {
                            byte[] buf = new byte[write + 1];
                            Arrays.fill(buf, (byte)(48 + (this._w - 1) % 10));
                            buf[write] = 10;
                            out.write(buf);
                        }
                        if (out.isReady()) continue;
                        return;
                    }
                    if (complete.decrementAndGet() == 0) {
                        async.complete();
                    }
                }

                public void onError(Throwable t) {
                    async.complete();
                }
            });
        }
    }
}

