/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.toolchain.test.FS;
import org.eclipse.jetty.toolchain.test.MavenTestingUtils;
import org.eclipse.jetty.toolchain.test.OS;
import org.eclipse.jetty.toolchain.test.TestingDir;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class DefaultServletRangesTest {
    public static final String DATA = "01234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWZYZ!@#$%^&*()_+/.,[]";
    @Rule
    public TestingDir testdir = new TestingDir();
    private Server server;
    private LocalConnector connector;
    private ServletContextHandler context;

    @Before
    public void init() throws Exception {
        this.server = new Server();
        this.connector = new LocalConnector(this.server);
        ((HttpConfiguration.ConnectionFactory)this.connector.getConnectionFactory(HttpConfiguration.ConnectionFactory.class)).getHttpConfiguration().setSendServerVersion(false);
        this.context = new ServletContextHandler();
        this.context.setContextPath("/context");
        this.context.setWelcomeFiles(new String[]{"index.html", "index.jsp", "index.htm"});
        this.server.setHandler((Handler)this.context);
        this.server.addConnector((Connector)this.connector);
        this.testdir.ensureEmpty();
        File resBase = this.testdir.getPathFile("docroot").toFile();
        FS.ensureDirExists((File)resBase);
        File data = new File(resBase, "data.txt");
        this.createFile(data, DATA);
        String resBasePath = resBase.getAbsolutePath();
        ServletHolder defholder = this.context.addServlet(DefaultServlet.class, "/");
        defholder.setInitParameter("acceptRanges", "true");
        defholder.setInitParameter("resourceBase", resBasePath);
        this.server.start();
    }

    @After
    public void destroy() throws Exception {
        this.server.stop();
        this.server.join();
    }

    @Test
    public void testNoRangeRequests() throws Exception {
        String response = this.connector.getResponse("GET /context/data.txt HTTP/1.1\r\nHost: localhost\r\nConnection: close\r\n\r\n");
        this.assertResponseContains("200 OK", response);
        this.assertResponseContains("Accept-Ranges: bytes", response);
        this.assertResponseContains(DATA, response);
    }

    @Test
    public void testPrefixRangeRequests() throws Exception {
        String response = this.connector.getResponse("GET /context/data.txt HTTP/1.1\r\nHost: localhost\r\nConnection: close\r\nRange: bytes=0-9\r\n\r\n");
        this.assertResponseContains("206 Partial", response);
        this.assertResponseContains("Content-Type: text/plain", response);
        this.assertResponseContains("Content-Range: bytes 0-9/80", response);
        this.assertResponseContains(DATA.substring(0, 10), response);
    }

    @Test
    public void testSingleRangeRequests() throws Exception {
        String response = this.connector.getResponse("GET /context/data.txt HTTP/1.1\r\nHost: localhost\r\nConnection: close\r\nRange: bytes=3-9\r\n\r\n");
        this.assertResponseContains("206 Partial", response);
        this.assertResponseContains("Content-Type: text/plain", response);
        this.assertResponseContains("Content-Range: bytes 3-9/80", response);
        this.assertResponseContains(DATA.substring(3, 10), response);
    }

    @Test
    public void testMultipleRangeRequests() throws Exception {
        String response = this.connector.getResponse("GET /context/data.txt HTTP/1.1\r\nHost: localhost\r\nConnection: close\r\nRange: bytes=0-9,20-29,40-49\r\n\r\n");
        int start = response.indexOf("--jetty");
        String body = response.substring(start);
        String boundary = body.substring(0, body.indexOf("\r\n"));
        this.assertResponseContains("206 Partial", response);
        this.assertResponseContains("Content-Type: multipart/byteranges; boundary=", response);
        this.assertResponseContains("Content-Range: bytes 0-9/80", response);
        this.assertResponseContains("Content-Range: bytes 20-29/80", response);
        this.assertResponseContains("Content-Range: bytes 40-49/80", response);
        this.assertResponseContains(DATA.substring(0, 10), response);
        this.assertResponseContains(DATA.substring(20, 30), response);
        this.assertResponseContains(DATA.substring(40, 50), response);
        Assert.assertTrue((boolean)body.endsWith(boundary + "--\r\n"));
    }

    @Test
    public void testMultipleSameRangeRequests() throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < 1000; ++i) {
            stringBuilder.append("10-60,");
        }
        String response = this.connector.getResponse("GET /context/data.txt HTTP/1.1\r\nHost: localhost\r\nConnection: close\r\nRange: bytes=" + stringBuilder.toString() + "0-2\r\n\r\n");
        int start = response.indexOf("--jetty");
        String body = response.substring(start);
        String boundary = body.substring(0, body.indexOf("\r\n"));
        this.assertResponseContains("206 Partial", response);
        this.assertResponseContains("Content-Type: multipart/byteranges; boundary=", response);
        this.assertResponseContains("Content-Range: bytes 10-60/80", response);
        this.assertResponseContains("Content-Range: bytes 0-2/80", response);
        Assert.assertEquals((String)("Content range 0-60/80 in response not only 1:" + response), (long)2L, (long)response.split("Content-Range: bytes 10-60/80").length);
        Assert.assertTrue((boolean)body.endsWith(boundary + "--\r\n"));
    }

    @Test
    public void testMultipleSameRangeRequestsTooLargeHeader() throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < 2000; ++i) {
            stringBuilder.append("10-60,");
        }
        String response = this.connector.getResponse("GET /context/data.txt HTTP/1.1\r\nHost: localhost\r\nConnection: close\r\nRange: bytes=" + stringBuilder.toString() + "0-2\r\n\r\n");
        int start = response.indexOf("--jetty");
        Assert.assertEquals((long)-1L, (long)start);
        this.assertResponseContains("HTTP/1.1 431 Request Header Fields Too Large", response);
    }

    @Test
    public void testOpenEndRange() throws Exception {
        String response = this.connector.getResponse("GET /context/data.txt HTTP/1.1\r\nHost: localhost\r\nConnection: close\r\nRange: bytes=20-\r\n\r\n");
        this.assertResponseContains("206 Partial", response);
        this.assertResponseNotContains("Content-Type: multipart/byteranges; boundary=", response);
        this.assertResponseContains("Content-Range: bytes 20-79/80", response);
        this.assertResponseContains(DATA.substring(60), response);
    }

    @Test
    public void testOpenStartRange() throws Exception {
        String response = this.connector.getResponse("GET /context/data.txt HTTP/1.1\r\nHost: localhost\r\nConnection: close\r\nRange: bytes=-20\r\n\r\n");
        this.assertResponseContains("206 Partial", response);
        this.assertResponseNotContains("Content-Type: multipart/byteranges; boundary=", response);
        this.assertResponseContains("Content-Range: bytes 60-79/80", response);
        this.assertResponseContains(DATA.substring(60), response);
    }

    @Test
    public void testUnsatisfiableRanges() throws Exception {
        String response = this.connector.getResponse("GET /context/data.txt HTTP/1.1\r\nHost: localhost\r\nConnection: close\r\nRange: bytes=100-110\r\n\r\n");
        this.assertResponseContains("416 Range Not Satisfiable", response);
    }

    private void createFile(File file, String str) throws IOException {
        try (OutputStream out = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
            out.write(str.getBytes(StandardCharsets.UTF_8));
            out.flush();
        }
    }

    private void assertResponseNotContains(String forbidden, String response) {
        Assert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)forbidden)));
    }

    private int assertResponseContains(String expected, String response) {
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)expected));
        return response.indexOf(expected);
    }

    private void deleteFile(File file) throws IOException {
        if (OS.IS_WINDOWS) {
            boolean deleted = file.delete();
            if (!deleted) {
                File deletedDir = MavenTestingUtils.getTargetFile((String)".deleted");
                FS.ensureDirExists((File)deletedDir);
                File dest = File.createTempFile(file.getName(), "deleted", deletedDir);
                boolean renamed = file.renameTo(dest);
                if (!renamed) {
                    System.err.println("WARNING: unable to move file out of the way: " + file.getName());
                }
            }
        } else {
            Assert.assertTrue((String)("Deleting: " + file.getName()), (boolean)file.delete());
        }
    }
}

