/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.DispatcherType;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.eclipse.jetty.http.HttpTester;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.QuietServletException;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.servlet.ErrorPageErrorHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.log.StacklessLogging;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class AsyncContextTest {
    private Server _server;
    private ServletContextHandler _contextHandler;
    private LocalConnector _connector;

    @BeforeEach
    public void setUp() throws Exception {
        this._server = new Server();
        this._connector = new LocalConnector(this._server);
        this._connector.setIdleTimeout(5000L);
        ((HttpConnectionFactory)this._connector.getConnectionFactory(HttpConnectionFactory.class)).getHttpConfiguration().setSendDateHeader(false);
        this._server.addConnector((Connector)this._connector);
        this._contextHandler = new ServletContextHandler(0);
        this._contextHandler.setContextPath("/ctx");
        this._contextHandler.addServlet(new ServletHolder((Servlet)new TestServlet()), "/servletPath");
        this._contextHandler.addServlet(new ServletHolder((Servlet)new TestServlet()), "/path with spaces/servletPath");
        this._contextHandler.addServlet(new ServletHolder((Servlet)new TestServlet2()), "/servletPath2");
        ServletHolder testHolder = new ServletHolder((Servlet)new TestServlet());
        testHolder.setInitParameter("dispatchPath", "/test2/something%2felse");
        this._contextHandler.addServlet(testHolder, "/test/*");
        this._contextHandler.addServlet(new ServletHolder((Servlet)new TestServlet2()), "/test2/*");
        this._contextHandler.addServlet(new ServletHolder((Servlet)new SelfDispatchingServlet()), "/self/*");
        this._contextHandler.addServlet(new ServletHolder((Servlet)new TestStartThrowServlet()), "/startthrow/*");
        this._contextHandler.addServlet(new ServletHolder((Servlet)new ForwardingServlet()), "/forward");
        this._contextHandler.addServlet(new ServletHolder((Servlet)new AsyncDispatchingServlet()), "/dispatchingServlet");
        this._contextHandler.addServlet(new ServletHolder((Servlet)new ExpireServlet()), "/expire/*");
        this._contextHandler.addServlet(new ServletHolder((Servlet)new BadExpireServlet()), "/badexpire/*");
        this._contextHandler.addServlet(new ServletHolder((Servlet)new ErrorServlet()), "/error/*");
        ErrorPageErrorHandler error_handler = new ErrorPageErrorHandler();
        this._contextHandler.setErrorHandler((ErrorHandler)error_handler);
        error_handler.addErrorPage(500, "/error/500");
        error_handler.addErrorPage(IOException.class.getName(), "/error/IOE");
        HandlerList handlers = new HandlerList();
        handlers.setHandlers(new Handler[]{this._contextHandler, new DefaultHandler()});
        this._server.setHandler((Handler)handlers);
        this._server.start();
    }

    @AfterEach
    public void after() throws Exception {
        this._server.stop();
    }

    @Test
    public void testSimpleAsyncContext() throws Exception {
        String request = "GET /ctx/servletPath HTTP/1.1\r\nHost: localhost\r\nConnection: close\r\n\r\n";
        HttpTester.Response response = HttpTester.parseResponse((String)this._connector.getResponse(request));
        MatcherAssert.assertThat((String)"Response.status", (Object)response.getStatus(), (Matcher)CoreMatchers.is((Object)200));
        String responseBody = response.getContent();
        MatcherAssert.assertThat((Object)responseBody, (Matcher)Matchers.containsString((String)"doGet:getServletPath:/servletPath"));
        MatcherAssert.assertThat((Object)responseBody, (Matcher)Matchers.containsString((String)"doGet:async:getServletPath:/servletPath"));
        MatcherAssert.assertThat((Object)responseBody, (Matcher)Matchers.containsString((String)"async:run:attr:servletPath:/servletPath"));
    }

    @Test
    public void testStartThrow() throws Exception {
        String request = "GET /ctx/startthrow HTTP/1.1\r\nHost: localhost\r\nConnection: close\r\n\r\n";
        HttpTester.Response response = HttpTester.parseResponse((String)this._connector.getResponse(request, 10L, TimeUnit.MINUTES));
        MatcherAssert.assertThat((String)"Response.status", (Object)response.getStatus(), (Matcher)CoreMatchers.is((Object)500));
        String responseBody = response.getContent();
        MatcherAssert.assertThat((Object)responseBody, (Matcher)Matchers.containsString((String)"ERROR: /error"));
        MatcherAssert.assertThat((Object)responseBody, (Matcher)Matchers.containsString((String)"PathInfo= /IOE"));
        MatcherAssert.assertThat((Object)responseBody, (Matcher)Matchers.containsString((String)"EXCEPTION: org.eclipse.jetty.server.QuietServletException: java.io.IOException: Test"));
    }

    @Test
    public void testStartDispatchThrow() throws Exception {
        String request = "GET /ctx/startthrow?dispatch=true HTTP/1.1\r\nHost: localhost\r\nConnection: close\r\n\r\n";
        HttpTester.Response response = HttpTester.parseResponse((String)this._connector.getResponse(request));
        MatcherAssert.assertThat((String)"Response.status", (Object)response.getStatus(), (Matcher)CoreMatchers.is((Object)500));
        String responseBody = response.getContent();
        MatcherAssert.assertThat((Object)responseBody, (Matcher)Matchers.containsString((String)"ERROR: /error"));
        MatcherAssert.assertThat((Object)responseBody, (Matcher)Matchers.containsString((String)"PathInfo= /IOE"));
        MatcherAssert.assertThat((Object)responseBody, (Matcher)Matchers.containsString((String)"EXCEPTION: org.eclipse.jetty.server.QuietServletException: java.io.IOException: Test"));
    }

    @Test
    public void testStartCompleteThrow() throws Exception {
        String request = "GET /ctx/startthrow?complete=true HTTP/1.1\r\nHost: localhost\r\nContent-Type: application/x-www-form-urlencoded\r\nConnection: close\r\n\r\n";
        HttpTester.Response response = HttpTester.parseResponse((String)this._connector.getResponse(request));
        MatcherAssert.assertThat((String)"Response.status", (Object)response.getStatus(), (Matcher)CoreMatchers.is((Object)500));
        String responseBody = response.getContent();
        MatcherAssert.assertThat((Object)responseBody, (Matcher)Matchers.containsString((String)"ERROR: /error"));
        MatcherAssert.assertThat((Object)responseBody, (Matcher)Matchers.containsString((String)"PathInfo= /IOE"));
        MatcherAssert.assertThat((Object)responseBody, (Matcher)Matchers.containsString((String)"EXCEPTION: org.eclipse.jetty.server.QuietServletException: java.io.IOException: Test"));
    }

    @Test
    public void testStartFlushCompleteThrow() throws Exception {
        try (StacklessLogging ignore = new StacklessLogging(new Class[]{HttpChannel.class});){
            String request = "GET /ctx/startthrow?flush=true&complete=true HTTP/1.1\r\nHost: localhost\r\nContent-Type: application/x-www-form-urlencoded\r\nConnection: close\r\n\r\n";
            HttpTester.Response response = HttpTester.parseResponse((String)this._connector.getResponse(request));
            MatcherAssert.assertThat((String)"Response.status", (Object)response.getStatus(), (Matcher)CoreMatchers.is((Object)200));
            String responseBody = response.getContent();
            MatcherAssert.assertThat((String)"error servlet", (Object)responseBody, (Matcher)Matchers.containsString((String)"completeBeforeThrow"));
        }
    }

    @Test
    public void testDispatchAsyncContext() throws Exception {
        String request = "GET /ctx/servletPath?dispatch=true HTTP/1.1\r\nHost: localhost\r\nContent-Type: application/x-www-form-urlencoded\r\nConnection: close\r\n\r\n";
        HttpTester.Response response = HttpTester.parseResponse((String)this._connector.getResponse(request));
        MatcherAssert.assertThat((String)"Response.status", (Object)response.getStatus(), (Matcher)CoreMatchers.is((Object)200));
        String responseBody = response.getContent();
        MatcherAssert.assertThat((String)"servlet gets right path", (Object)responseBody, (Matcher)Matchers.containsString((String)"doGet:getServletPath:/servletPath2"));
        MatcherAssert.assertThat((String)"async context gets right path in get", (Object)responseBody, (Matcher)Matchers.containsString((String)"doGet:async:getServletPath:/servletPath2"));
        MatcherAssert.assertThat((String)"servlet path attr is original", (Object)responseBody, (Matcher)Matchers.containsString((String)"async:run:attr:servletPath:/servletPath"));
        MatcherAssert.assertThat((String)"path info attr is correct", (Object)responseBody, (Matcher)Matchers.containsString((String)"async:run:attr:pathInfo:null"));
        MatcherAssert.assertThat((String)"query string attr is correct", (Object)responseBody, (Matcher)Matchers.containsString((String)"async:run:attr:queryString:dispatch=true"));
        MatcherAssert.assertThat((String)"context path attr is correct", (Object)responseBody, (Matcher)Matchers.containsString((String)"async:run:attr:contextPath:/ctx"));
        MatcherAssert.assertThat((String)"request uri attr is correct", (Object)responseBody, (Matcher)Matchers.containsString((String)"async:run:attr:requestURI:/ctx/servletPath"));
    }

    @Test
    public void testDispatchAsyncContext_EncodedUrl() throws Exception {
        String request = "GET /ctx/test/hello%2fthere?dispatch=true HTTP/1.1\r\nHost: localhost\r\nContent-Type: application/x-www-form-urlencoded\r\nConnection: close\r\n\r\n";
        HttpTester.Response response = HttpTester.parseResponse((String)this._connector.getResponse(request));
        MatcherAssert.assertThat((String)"Response.status", (Object)response.getStatus(), (Matcher)CoreMatchers.is((Object)200));
        String responseBody = response.getContent();
        MatcherAssert.assertThat((String)"servlet gets right path", (Object)responseBody, (Matcher)Matchers.containsString((String)"doGet:getServletPath:/test2"));
        MatcherAssert.assertThat((String)"request uri has correct encoding", (Object)responseBody, (Matcher)Matchers.containsString((String)"doGet:getRequestURI:/ctx/test2/something%2felse"));
        MatcherAssert.assertThat((String)"request url has correct encoding", (Object)responseBody, (Matcher)Matchers.containsString((String)"doGet:getRequestURL:http://localhost/ctx/test2/something%2felse"));
        MatcherAssert.assertThat((String)"path info has correct encoding", (Object)responseBody, (Matcher)Matchers.containsString((String)"doGet:getPathInfo:/something/else"));
        MatcherAssert.assertThat((String)"async servlet gets right path", (Object)responseBody, (Matcher)Matchers.containsString((String)"doGet:async:getServletPath:/test2"));
        MatcherAssert.assertThat((String)"async request uri has correct encoding", (Object)responseBody, (Matcher)Matchers.containsString((String)"doGet:async:getRequestURI:/ctx/test2/something%2felse"));
        MatcherAssert.assertThat((String)"async request url has correct encoding", (Object)responseBody, (Matcher)Matchers.containsString((String)"doGet:async:getRequestURL:http://localhost/ctx/test2/something%2felse"));
        MatcherAssert.assertThat((String)"async path info has correct encoding", (Object)responseBody, (Matcher)Matchers.containsString((String)"doGet:async:getPathInfo:/something/else"));
        MatcherAssert.assertThat((String)"async run attr servlet path is original", (Object)responseBody, (Matcher)Matchers.containsString((String)"async:run:attr:servletPath:/test"));
        MatcherAssert.assertThat((String)"async run attr path info has correct encoding", (Object)responseBody, (Matcher)Matchers.containsString((String)"async:run:attr:pathInfo:/hello/there"));
        MatcherAssert.assertThat((String)"async run attr query string", (Object)responseBody, (Matcher)Matchers.containsString((String)"async:run:attr:queryString:dispatch=true"));
        MatcherAssert.assertThat((String)"async run context path", (Object)responseBody, (Matcher)Matchers.containsString((String)"async:run:attr:contextPath:/ctx"));
        MatcherAssert.assertThat((String)"async run request uri has correct encoding", (Object)responseBody, (Matcher)Matchers.containsString((String)"async:run:attr:requestURI:/ctx/test/hello%2fthere"));
    }

    @Test
    public void testDispatchAsyncContext_SelfEncodedUrl() throws Exception {
        String request = "GET /ctx/self/hello%2fthere?dispatch=true HTTP/1.1\r\nHost: localhost\r\nContent-Type: application/x-www-form-urlencoded\r\nConnection: close\r\n\r\n";
        HttpTester.Response response = HttpTester.parseResponse((String)this._connector.getResponse(request));
        MatcherAssert.assertThat((String)"Response.status", (Object)response.getStatus(), (Matcher)CoreMatchers.is((Object)200));
        String responseBody = response.getContent();
        MatcherAssert.assertThat((String)"servlet request uri initial", (Object)responseBody, (Matcher)Matchers.containsString((String)"doGet.REQUEST.requestURI:/ctx/self/hello%2fthere"));
        MatcherAssert.assertThat((String)"servlet request uri async", (Object)responseBody, (Matcher)Matchers.containsString((String)"doGet.ASYNC.requestURI:/ctx/self/hello%2fthere"));
    }

    @Test
    public void testDispatchAsyncContextEncodedPathAndQueryString() throws Exception {
        String request = "GET /ctx/path%20with%20spaces/servletPath?dispatch=true&queryStringWithEncoding=space%20space HTTP/1.1\r\nHost: localhost\r\nContent-Type: application/x-www-form-urlencoded\r\nConnection: close\r\n\r\n";
        HttpTester.Response response = HttpTester.parseResponse((String)this._connector.getResponse(request));
        MatcherAssert.assertThat((String)"Response.status", (Object)response.getStatus(), (Matcher)CoreMatchers.is((Object)200));
        String responseBody = response.getContent();
        MatcherAssert.assertThat((String)"servlet gets right path", (Object)responseBody, (Matcher)Matchers.containsString((String)"doGet:getServletPath:/servletPath2"));
        MatcherAssert.assertThat((String)"async context gets right path in get", (Object)responseBody, (Matcher)Matchers.containsString((String)"doGet:async:getServletPath:/servletPath2"));
        MatcherAssert.assertThat((String)"servlet path attr is original", (Object)responseBody, (Matcher)Matchers.containsString((String)"async:run:attr:servletPath:/path with spaces/servletPath"));
        MatcherAssert.assertThat((String)"path info attr is correct", (Object)responseBody, (Matcher)Matchers.containsString((String)"async:run:attr:pathInfo:null"));
        MatcherAssert.assertThat((String)"query string attr is correct", (Object)responseBody, (Matcher)Matchers.containsString((String)"async:run:attr:queryString:dispatch=true&queryStringWithEncoding=space%20space"));
        MatcherAssert.assertThat((String)"context path attr is correct", (Object)responseBody, (Matcher)Matchers.containsString((String)"async:run:attr:contextPath:/ctx"));
        MatcherAssert.assertThat((String)"request uri attr is correct", (Object)responseBody, (Matcher)Matchers.containsString((String)"async:run:attr:requestURI:/ctx/path%20with%20spaces/servletPath"));
    }

    @Test
    public void testSimpleWithContextAsyncContext() throws Exception {
        String request = "GET /ctx/servletPath HTTP/1.1\r\nHost: localhost\r\nContent-Type: application/x-www-form-urlencoded\r\nConnection: close\r\n\r\n";
        HttpTester.Response response = HttpTester.parseResponse((String)this._connector.getResponse(request));
        MatcherAssert.assertThat((String)"Response.status", (Object)response.getStatus(), (Matcher)CoreMatchers.is((Object)200));
        String responseBody = response.getContent();
        MatcherAssert.assertThat((String)"servlet gets right path", (Object)responseBody, (Matcher)Matchers.containsString((String)"doGet:getServletPath:/servletPath"));
        MatcherAssert.assertThat((String)"async context gets right path in get", (Object)responseBody, (Matcher)Matchers.containsString((String)"doGet:async:getServletPath:/servletPath"));
        MatcherAssert.assertThat((String)"async context gets right path in async", (Object)responseBody, (Matcher)Matchers.containsString((String)"async:run:attr:servletPath:/servletPath"));
    }

    @Test
    public void testDispatchWithContextAsyncContext() throws Exception {
        String request = "GET /ctx/servletPath?dispatch=true HTTP/1.1\r\nHost: localhost\r\nContent-Type: application/x-www-form-urlencoded\r\nConnection: close\r\n\r\n";
        HttpTester.Response response = HttpTester.parseResponse((String)this._connector.getResponse(request));
        MatcherAssert.assertThat((String)"Response.status", (Object)response.getStatus(), (Matcher)CoreMatchers.is((Object)200));
        String responseBody = response.getContent();
        MatcherAssert.assertThat((String)"servlet gets right path", (Object)responseBody, (Matcher)Matchers.containsString((String)"doGet:getServletPath:/servletPath2"));
        MatcherAssert.assertThat((String)"async context gets right path in get", (Object)responseBody, (Matcher)Matchers.containsString((String)"doGet:async:getServletPath:/servletPath2"));
        MatcherAssert.assertThat((String)"servlet path attr is original", (Object)responseBody, (Matcher)Matchers.containsString((String)"async:run:attr:servletPath:/servletPath"));
        MatcherAssert.assertThat((String)"path info attr is correct", (Object)responseBody, (Matcher)Matchers.containsString((String)"async:run:attr:pathInfo:null"));
        MatcherAssert.assertThat((String)"query string attr is correct", (Object)responseBody, (Matcher)Matchers.containsString((String)"async:run:attr:queryString:dispatch=true"));
        MatcherAssert.assertThat((String)"context path attr is correct", (Object)responseBody, (Matcher)Matchers.containsString((String)"async:run:attr:contextPath:/ctx"));
        MatcherAssert.assertThat((String)"request uri attr is correct", (Object)responseBody, (Matcher)Matchers.containsString((String)"async:run:attr:requestURI:/ctx/servletPath"));
    }

    @Test
    public void testDispatch() throws Exception {
        String request = "GET /ctx/forward HTTP/1.1\r\nHost: localhost\r\nContent-Type: application/x-www-form-urlencoded\r\nConnection: close\r\n\r\n";
        String responseString = this._connector.getResponse(request);
        HttpTester.Response response = HttpTester.parseResponse((String)responseString);
        MatcherAssert.assertThat((String)"Response.status", (Object)response.getStatus(), (Matcher)CoreMatchers.is((Object)200));
        String responseBody = response.getContent();
        MatcherAssert.assertThat((String)"!ForwardingServlet", (Object)responseBody, (Matcher)Matchers.containsString((String)"Dispatched back to ForwardingServlet"));
    }

    @Test
    public void testDispatchRequestResponse() throws Exception {
        String request = "GET /ctx/forward?dispatchRequestResponse=true HTTP/1.1\r\nHost: localhost\r\nContent-Type: application/x-www-form-urlencoded\r\nConnection: close\r\n\r\n";
        String responseString = this._connector.getResponse(request);
        HttpTester.Response response = HttpTester.parseResponse((String)responseString);
        MatcherAssert.assertThat((String)"Response.status", (Object)response.getStatus(), (Matcher)CoreMatchers.is((Object)200));
        String responseBody = response.getContent();
        MatcherAssert.assertThat((String)"!AsyncDispatchingServlet", (Object)responseBody, (Matcher)Matchers.containsString((String)"Dispatched back to AsyncDispatchingServlet"));
    }

    @Test
    public void testExpire() throws Exception {
        String request = "GET /ctx/expire HTTP/1.1\r\nHost: localhost\r\nContent-Type: application/x-www-form-urlencoded\r\nConnection: close\r\n\r\n";
        HttpTester.Response response = HttpTester.parseResponse((String)this._connector.getResponse(request));
        MatcherAssert.assertThat((String)"Response.status", (Object)response.getStatus(), (Matcher)CoreMatchers.is((Object)500));
        String responseBody = response.getContent();
        MatcherAssert.assertThat((String)"error servlet", (Object)responseBody, (Matcher)Matchers.containsString((String)"ERROR: /error"));
    }

    @Test
    public void testBadExpire() throws Exception {
        String request = "GET /ctx/badexpire HTTP/1.1\r\nHost: localhost\r\nContent-Type: application/x-www-form-urlencoded\r\nConnection: close\r\n\r\n";
        HttpTester.Response response = HttpTester.parseResponse((String)this._connector.getResponse(request));
        MatcherAssert.assertThat((String)"Response.status", (Object)response.getStatus(), (Matcher)CoreMatchers.is((Object)500));
        String responseBody = response.getContent();
        MatcherAssert.assertThat((String)"error servlet", (Object)responseBody, (Matcher)Matchers.containsString((String)"ERROR: /error"));
        MatcherAssert.assertThat((String)"error servlet", (Object)responseBody, (Matcher)Matchers.containsString((String)"PathInfo= /500"));
        MatcherAssert.assertThat((String)"error servlet", (Object)responseBody, (Matcher)Matchers.containsString((String)"EXCEPTION: java.lang.RuntimeException: TEST"));
    }

    @AfterEach
    public void tearDown() throws Exception {
        this._server.stop();
        this._server.join();
    }

    private class Wrapper
    extends HttpServletResponseWrapper {
        public Wrapper(HttpServletResponse response) {
            super(response);
        }
    }

    private class AsyncRunnable
    implements Runnable {
        private AsyncContext _context;

        public AsyncRunnable(AsyncContext context) {
            this._context = context;
        }

        @Override
        public void run() {
            HttpServletRequest req = (HttpServletRequest)this._context.getRequest();
            try {
                this._context.getResponse().getOutputStream().print("async:run:attr:servletPath:" + req.getAttribute("javax.servlet.async.servlet_path") + "\n");
                this._context.getResponse().getOutputStream().print("async:run:attr:pathInfo:" + req.getAttribute("javax.servlet.async.path_info") + "\n");
                this._context.getResponse().getOutputStream().print("async:run:attr:queryString:" + req.getAttribute("javax.servlet.async.query_string") + "\n");
                this._context.getResponse().getOutputStream().print("async:run:attr:contextPath:" + req.getAttribute("javax.servlet.async.context_path") + "\n");
                this._context.getResponse().getOutputStream().print("async:run:attr:requestURI:" + req.getAttribute("javax.servlet.async.request_uri") + "\n");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this._context.complete();
        }
    }

    private class TestStartThrowServlet
    extends HttpServlet {
        private static final long serialVersionUID = 1L;

        private TestStartThrowServlet() {
        }

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            if (request.getDispatcherType() == DispatcherType.REQUEST) {
                request.startAsync((ServletRequest)request, (ServletResponse)response);
                if (Boolean.parseBoolean(request.getParameter("dispatch"))) {
                    request.getAsyncContext().dispatch();
                }
                if (Boolean.parseBoolean(request.getParameter("complete"))) {
                    response.getOutputStream().write("completeBeforeThrow".getBytes());
                    if (Boolean.parseBoolean(request.getParameter("flush"))) {
                        response.flushBuffer();
                    }
                    request.getAsyncContext().complete();
                }
                throw new QuietServletException((Throwable)new IOException("Test"));
            }
        }
    }

    private class TestServlet2
    extends HttpServlet {
        private static final long serialVersionUID = 1L;

        private TestServlet2() {
        }

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            response.getOutputStream().print("doGet:getServletPath:" + request.getServletPath() + "\n");
            response.getOutputStream().print("doGet:getRequestURI:" + request.getRequestURI() + "\n");
            response.getOutputStream().print("doGet:getRequestURL:" + request.getRequestURL() + "\n");
            response.getOutputStream().print("doGet:getPathInfo:" + request.getPathInfo() + "\n");
            AsyncContext asyncContext = request.startAsync((ServletRequest)request, (ServletResponse)response);
            HttpServletRequest asyncRequest = (HttpServletRequest)asyncContext.getRequest();
            response.getOutputStream().print("doGet:async:getServletPath:" + asyncRequest.getServletPath() + "\n");
            response.getOutputStream().print("doGet:async:getRequestURI:" + asyncRequest.getRequestURI() + "\n");
            response.getOutputStream().print("doGet:async:getRequestURL:" + asyncRequest.getRequestURL() + "\n");
            response.getOutputStream().print("doGet:async:getPathInfo:" + asyncRequest.getPathInfo() + "\n");
            asyncContext.start((Runnable)new AsyncRunnable(asyncContext));
        }
    }

    private class TestServlet
    extends HttpServlet {
        private static final long serialVersionUID = 1L;
        private String dispatchPath = "/servletPath2";

        private TestServlet() {
        }

        public void init() throws ServletException {
            String dispatchTo = this.getServletConfig().getInitParameter("dispatchPath");
            if (StringUtil.isNotBlank((String)dispatchTo)) {
                this.dispatchPath = dispatchTo;
            }
        }

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            if (request.getParameter("dispatch") != null) {
                AsyncContext asyncContext = request.startAsync((ServletRequest)request, (ServletResponse)response);
                asyncContext.dispatch(this.dispatchPath);
            } else {
                response.getOutputStream().print("doGet:getServletPath:" + request.getServletPath() + "\n");
                response.getOutputStream().print("doGet:getRequestURI:" + request.getRequestURI() + "\n");
                response.getOutputStream().print("doGet:getRequestURL:" + request.getRequestURL() + "\n");
                response.getOutputStream().print("doGet:getPathInfo:" + request.getPathInfo() + "\n");
                AsyncContext asyncContext = request.startAsync((ServletRequest)request, (ServletResponse)response);
                HttpServletRequest asyncRequest = (HttpServletRequest)asyncContext.getRequest();
                response.getOutputStream().print("doGet:async:getServletPath:" + asyncRequest.getServletPath() + "\n");
                response.getOutputStream().print("doGet:async:getRequestURI:" + asyncRequest.getRequestURI() + "\n");
                response.getOutputStream().print("doGet:async:getRequestURL:" + asyncRequest.getRequestURL() + "\n");
                response.getOutputStream().print("doGet:async:getPathInfo:" + asyncRequest.getPathInfo() + "\n");
                asyncContext.start((Runnable)new AsyncRunnable(asyncContext));
            }
        }
    }

    private class BadExpireServlet
    extends HttpServlet {
        private static final long serialVersionUID = 1L;

        private BadExpireServlet() {
        }

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            if (request.getDispatcherType() == DispatcherType.REQUEST) {
                AsyncContext asyncContext = request.startAsync();
                asyncContext.addListener(new AsyncListener(){

                    public void onTimeout(AsyncEvent event) throws IOException {
                        throw new RuntimeException("TEST");
                    }

                    public void onStartAsync(AsyncEvent event) throws IOException {
                    }

                    public void onError(AsyncEvent event) throws IOException {
                    }

                    public void onComplete(AsyncEvent event) throws IOException {
                    }
                });
                asyncContext.setTimeout(100L);
            }
        }
    }

    private class ExpireServlet
    extends HttpServlet {
        private static final long serialVersionUID = 1L;

        private ExpireServlet() {
        }

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            if (request.getDispatcherType() == DispatcherType.REQUEST) {
                AsyncContext asyncContext = request.startAsync();
                asyncContext.setTimeout(100L);
            }
        }
    }

    private class ErrorServlet
    extends HttpServlet {
        private static final long serialVersionUID = 1L;

        private ErrorServlet() {
        }

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            response.getOutputStream().print("ERROR: " + request.getServletPath() + "\n");
            response.getOutputStream().print("PathInfo= " + request.getPathInfo() + "\n");
            if (request.getAttribute("javax.servlet.error.exception") != null) {
                response.getOutputStream().print("EXCEPTION: " + request.getAttribute("javax.servlet.error.exception") + "\n");
            }
        }
    }

    private class DispatchingRunnable
    implements Runnable {
        private AsyncContext asyncContext;
        private boolean wrapped;

        public DispatchingRunnable(AsyncContext asyncContext, boolean wrapped) {
            this.asyncContext = asyncContext;
            this.wrapped = wrapped;
        }

        @Override
        public void run() {
            if (this.wrapped) {
                Assertions.assertTrue((boolean)(this.asyncContext.getResponse() instanceof Wrapper));
            }
            this.asyncContext.dispatch();
        }
    }

    private class AsyncDispatchingServlet
    extends HttpServlet {
        private static final long serialVersionUID = 1L;

        private AsyncDispatchingServlet() {
        }

        protected void doGet(HttpServletRequest req, HttpServletResponse response) throws ServletException, IOException {
            Request request = (Request)req;
            if (request.getDispatcherType() == DispatcherType.ASYNC) {
                response.getOutputStream().print("Dispatched back to AsyncDispatchingServlet");
            } else {
                AsyncContext asyncContext;
                boolean wrapped = false;
                if (request.getParameter("dispatchRequestResponse") != null) {
                    wrapped = true;
                    asyncContext = request.startAsync((ServletRequest)request, (ServletResponse)new Wrapper(response));
                } else {
                    asyncContext = request.startAsync();
                }
                new Thread(new DispatchingRunnable(asyncContext, wrapped)).start();
            }
        }
    }

    private class SelfDispatchingServlet
    extends HttpServlet {
        private static final long serialVersionUID = 1L;

        private SelfDispatchingServlet() {
        }

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            DispatcherType dispatcherType = request.getDispatcherType();
            response.getOutputStream().print("doGet." + dispatcherType.name() + ".requestURI:" + request.getRequestURI() + "\n");
            if (dispatcherType == DispatcherType.ASYNC) {
                response.getOutputStream().print("Dispatched back to " + SelfDispatchingServlet.class.getSimpleName() + "\n");
            } else {
                AsyncContext asyncContext = request.startAsync((ServletRequest)request, (ServletResponse)response);
                new Thread(() -> asyncContext.dispatch()).start();
            }
        }
    }

    private class ForwardingServlet
    extends HttpServlet {
        private static final long serialVersionUID = 1L;

        private ForwardingServlet() {
        }

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            if (request.getDispatcherType() == DispatcherType.ASYNC) {
                response.getOutputStream().print("Dispatched back to ForwardingServlet");
            } else {
                request.getRequestDispatcher("/dispatchingServlet").forward((ServletRequest)request, (ServletResponse)response);
            }
        }
    }
}

