/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.util.Collections;
import java.util.Set;
import javax.servlet.ServletRegistration;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlet.Source;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class HolderTest {
    @Test
    public void testInitParams() throws Exception {
        ServletHolder holder = new ServletHolder(Source.JAVAX_API);
        ServletRegistration.Dynamic reg = holder.getRegistration();
        try {
            reg.setInitParameter(null, "foo");
            Assertions.fail((String)"null name accepted");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            reg.setInitParameter("foo", null);
            Assertions.fail((String)"null value accepted");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        reg.setInitParameter("foo", "bar");
        Assertions.assertFalse((boolean)reg.setInitParameter("foo", "foo"));
        Set clash = reg.setInitParameters(Collections.singletonMap("foo", "bax"));
        Assertions.assertTrue((clash != null && clash.size() == 1 ? 1 : 0) != 0, (String)"should be one clash");
        try {
            reg.setInitParameters(Collections.singletonMap(null, "bax"));
            Assertions.fail((String)"null name in map accepted");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            reg.setInitParameters(Collections.singletonMap("foo", null));
            Assertions.fail((String)"null value in map accepted");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Set clash2 = reg.setInitParameters(Collections.singletonMap("FOO", "bax"));
        Assertions.assertTrue((boolean)clash2.isEmpty(), (String)"should be no clash");
        Assertions.assertEquals((int)2, (int)reg.getInitParameters().size(), (String)"setInitParameters should not replace existing non-clashing init parameters");
    }
}

