/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.FilterRegistration;
import javax.servlet.GenericServlet;
import javax.servlet.Servlet;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionIdListener;
import javax.servlet.http.HttpSessionListener;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.RoleInfo;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.AbstractHandlerContainer;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ListenerHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.DecoratedObjectFactory;
import org.eclipse.jetty.util.Decorator;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.log.StacklessLogging;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ServletContextHandlerTest {
    private Server _server;
    private LocalConnector _connector;
    private static final AtomicInteger __testServlets = new AtomicInteger();
    private static int __initIndex = 0;
    private static int __destroyIndex = 0;

    @BeforeEach
    public void createServer() {
        this._server = new Server();
        this._connector = new LocalConnector(this._server);
        this._server.addConnector((Connector)this._connector);
        __testServlets.set(0);
    }

    @AfterEach
    public void destroyServer() throws Exception {
        this._server.stop();
        this._server.join();
    }

    @Test
    public void testDestroyOrder() throws Exception {
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        this._server.setHandler((Handler)contexts);
        ServletContextHandler root = new ServletContextHandler((HandlerContainer)contexts, "/", 1);
        ListenerHolder listenerHolder = new ListenerHolder();
        StopTestListener stopTestListener = new StopTestListener();
        listenerHolder.setListener((EventListener)((Object)stopTestListener));
        root.getServletHandler().addListener(listenerHolder);
        ServletHolder servletHolder = new ServletHolder();
        StopTestServlet stopTestServlet = new StopTestServlet();
        servletHolder.setServlet((Servlet)stopTestServlet);
        root.addServlet(servletHolder, "/test");
        FilterHolder filterHolder = new FilterHolder();
        StopTestFilter stopTestFilter = new StopTestFilter();
        filterHolder.setFilter((Filter)stopTestFilter);
        root.addFilter(filterHolder, "/*", EnumSet.of(DispatcherType.REQUEST));
        this._server.start();
        this._server.stop();
        Assertions.assertEquals((int)0, (int)stopTestListener._initIndex);
        Assertions.assertEquals((int)1, (int)stopTestFilter._initIndex);
        Assertions.assertEquals((int)2, (int)stopTestServlet._initIndex);
        Assertions.assertEquals((int)0, (int)stopTestFilter._destroyIndex);
        Assertions.assertEquals((int)1, (int)stopTestServlet._destroyIndex);
        Assertions.assertEquals((int)2, (int)stopTestListener._destroyIndex);
    }

    @Test
    public void testAddSessionListener() {
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        this._server.setHandler((Handler)contexts);
        ServletContextHandler root = new ServletContextHandler((HandlerContainer)contexts, "/", 1);
        MySessionHandler sessions = new MySessionHandler();
        root.setSessionHandler((SessionHandler)sessions);
        Assertions.assertNotNull((Object)((Object)sessions));
        root.addEventListener((EventListener)((Object)new MyTestSessionListener()));
        sessions.checkSessionAttributeListeners(1);
        sessions.checkSessionIdListeners(0);
        sessions.checkSessionListeners(1);
    }

    @Test
    public void testListenerFromSCI() throws Exception {
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        this._server.setHandler((Handler)contexts);
        ServletContextHandler root = new ServletContextHandler((HandlerContainer)contexts, "/");
        root.addBean((Object)new MySCIStarter(root.getServletContext(), new MySCI()), true);
        this._server.start();
        Assertions.assertTrue((boolean)((Boolean)root.getServletContext().getAttribute("MySCI.startup")));
        Assertions.assertTrue((boolean)((Boolean)root.getServletContext().getAttribute("MyContextListener.contextInitialized")));
    }

    @Test
    public void testContextInitializationDestruction() throws Exception {
        Server server = new Server();
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        server.setHandler((Handler)contexts);
        ServletContextHandler root = new ServletContextHandler((HandlerContainer)contexts, "/");
        class TestServletContextListener
        implements ServletContextListener {
            public int initialized = 0;
            public int destroyed = 0;

            TestServletContextListener() {
            }

            public void contextInitialized(ServletContextEvent sce) {
                ++this.initialized;
            }

            public void contextDestroyed(ServletContextEvent sce) {
                ++this.destroyed;
            }
        }
        TestServletContextListener listener = new TestServletContextListener();
        root.addEventListener((EventListener)((Object)listener));
        server.start();
        server.stop();
        Assertions.assertEquals((int)1, (int)listener.initialized);
        server.stop();
        Assertions.assertEquals((int)1, (int)listener.destroyed);
    }

    @Test
    public void testListenersFromContextListener() throws Exception {
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        this._server.setHandler((Handler)contexts);
        ServletContextHandler root = new ServletContextHandler((HandlerContainer)contexts, "/", 1);
        ListenerHolder initialListener = new ListenerHolder();
        initialListener.setListener((EventListener)((Object)new InitialListener()));
        root.getServletHandler().addListener(initialListener);
        root.addServlet(TestServlet.class, "/test");
        this._server.start();
        ListenerHolder[] listenerHolders = root.getServletHandler().getListeners();
        Assertions.assertNotNull((Object)listenerHolders);
        for (ListenerHolder l : listenerHolders) {
            Assertions.assertTrue((boolean)l.isStarted());
            Assertions.assertNotNull((Object)l.getListener());
            if ("org.eclipse.jetty.servlet.ServletContextHandlerTest$InitialListener".equals(l.getClassName())) continue;
            Assertions.assertFalse((boolean)root.isDurableListener(l.getListener()));
            Assertions.assertTrue((boolean)root.isProgrammaticListener(l.getListener()));
        }
        EventListener[] listeners = root.getEventListeners();
        Assertions.assertNotNull((Object)listeners);
        ArrayList<String> listenerClassNames = new ArrayList<String>();
        for (EventListener l : listeners) {
            listenerClassNames.add(l.getClass().getName());
        }
        Assertions.assertTrue((boolean)listenerClassNames.contains("org.eclipse.jetty.servlet.ServletContextHandlerTest$MySCAListener"));
        Assertions.assertTrue((boolean)listenerClassNames.contains("org.eclipse.jetty.servlet.ServletContextHandlerTest$MyRequestListener"));
        Assertions.assertTrue((boolean)listenerClassNames.contains("org.eclipse.jetty.servlet.ServletContextHandlerTest$MyRAListener"));
        Assertions.assertTrue((boolean)listenerClassNames.contains("org.eclipse.jetty.servlet.ServletContextHandlerTest$MySListener"));
        Assertions.assertTrue((boolean)listenerClassNames.contains("org.eclipse.jetty.servlet.ServletContextHandlerTest$MySAListener"));
        Assertions.assertTrue((boolean)listenerClassNames.contains("org.eclipse.jetty.servlet.ServletContextHandlerTest$MySIListener"));
        String response = this._connector.getResponse("GET /test?req=all HTTP/1.0\r\n\r\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        Assertions.assertEquals((int)1, (int)MyRAListener.adds);
        Assertions.assertEquals((int)1, (int)MyRAListener.replaces);
        Assertions.assertEquals((int)1, (int)MyRAListener.removes);
        response = this._connector.getResponse("GET /test?session=create HTTP/1.0\r\n\r\n");
        String sessionid = response.substring(response.indexOf("JSESSIONID"), response.indexOf(";"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        Assertions.assertEquals((int)1, (int)MySListener.creates);
        Assertions.assertEquals((int)1, (int)MySAListener.adds);
        Assertions.assertEquals((int)0, (int)MySAListener.replaces);
        Assertions.assertEquals((int)0, (int)MySAListener.removes);
        StringBuffer request = new StringBuffer();
        request.append("GET /test?session=replace HTTP/1.0\n");
        request.append("Host: localhost\n");
        request.append("Cookie: ").append(sessionid).append("\n");
        request.append("\n");
        response = this._connector.getResponse(request.toString());
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        Assertions.assertEquals((int)1, (int)MySListener.creates);
        Assertions.assertEquals((int)1, (int)MySAListener.adds);
        Assertions.assertEquals((int)1, (int)MySAListener.replaces);
        Assertions.assertEquals((int)0, (int)MySAListener.removes);
        request = new StringBuffer();
        request.append("GET /test?session=remove HTTP/1.0\n");
        request.append("Host: localhost\n");
        request.append("Cookie: ").append(sessionid).append("\n");
        request.append("\n");
        response = this._connector.getResponse(request.toString());
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        Assertions.assertEquals((int)1, (int)MySListener.creates);
        Assertions.assertEquals((int)1, (int)MySAListener.adds);
        Assertions.assertEquals((int)1, (int)MySAListener.replaces);
        Assertions.assertEquals((int)1, (int)MySAListener.removes);
        request = new StringBuffer();
        request.append("GET /test?session=change HTTP/1.0\n");
        request.append("Host: localhost\n");
        request.append("Cookie: ").append(sessionid).append("\n");
        request.append("\n");
        response = this._connector.getResponse(request.toString());
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        Assertions.assertEquals((int)1, (int)MySIListener.changes);
        sessionid = response.substring(response.indexOf("JSESSIONID"), response.indexOf(";"));
        request = new StringBuffer();
        request.append("GET /test?session=delete HTTP/1.0\n");
        request.append("Host: localhost\n");
        request.append("Cookie: ").append(sessionid).append("\n");
        request.append("\n");
        response = this._connector.getResponse(request.toString());
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        Assertions.assertEquals((int)1, (int)MySListener.destroys);
        Assertions.assertEquals((int)1, (int)MySCAListener.adds);
        response = this._connector.getResponse("GET /test?ctx=all HTTP/1.0\r\n\r\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        Assertions.assertEquals((int)1, (int)MySCAListener.replaces);
        Assertions.assertEquals((int)1, (int)MySCAListener.removes);
    }

    @Test
    public void testFindContainer() throws Exception {
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        this._server.setHandler((Handler)contexts);
        ServletContextHandler root = new ServletContextHandler((HandlerContainer)contexts, "/", 1);
        SessionHandler session = root.getSessionHandler();
        ServletHandler servlet = root.getServletHandler();
        ConstraintSecurityHandler security = new ConstraintSecurityHandler();
        root.setSecurityHandler((SecurityHandler)security);
        this._server.start();
        Assertions.assertEquals((Object)root, (Object)AbstractHandlerContainer.findContainerOf((HandlerContainer)this._server, ContextHandler.class, (Handler)session));
        Assertions.assertEquals((Object)root, (Object)AbstractHandlerContainer.findContainerOf((HandlerContainer)this._server, ContextHandler.class, (Handler)security));
        Assertions.assertEquals((Object)root, (Object)AbstractHandlerContainer.findContainerOf((HandlerContainer)this._server, ContextHandler.class, (Handler)servlet));
    }

    @Test
    public void testInitOrder() throws Exception {
        ServletContextHandler context = new ServletContextHandler();
        ServletHolder holder0 = context.addServlet(TestServlet.class, "/test0");
        ServletHolder holder1 = context.addServlet(TestServlet.class, "/test1");
        ServletHolder holder2 = context.addServlet(TestServlet.class, "/test2");
        holder1.setInitOrder(1);
        holder2.setInitOrder(2);
        context.setContextPath("/");
        this._server.setHandler((Handler)context);
        this._server.start();
        Assertions.assertEquals((int)2, (int)__testServlets.get());
        String response = this._connector.getResponse("GET /test1 HTTP/1.0\r\n\r\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        Assertions.assertEquals((int)2, (int)__testServlets.get());
        response = this._connector.getResponse("GET /test2 HTTP/1.0\r\n\r\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        Assertions.assertEquals((int)2, (int)__testServlets.get());
        MatcherAssert.assertThat((Object)holder0.getServletInstance(), (Matcher)Matchers.nullValue());
        response = this._connector.getResponse("GET /test0 HTTP/1.0\r\n\r\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        Assertions.assertEquals((int)3, (int)__testServlets.get());
        MatcherAssert.assertThat((Object)holder0.getServletInstance(), (Matcher)Matchers.notNullValue(Servlet.class));
        this._server.stop();
        Assertions.assertEquals((int)0, (int)__testServlets.get());
        holder0.setInitOrder(0);
        this._server.start();
        Assertions.assertEquals((int)3, (int)__testServlets.get());
        MatcherAssert.assertThat((Object)holder0.getServletInstance(), (Matcher)Matchers.notNullValue(Servlet.class));
        this._server.stop();
        Assertions.assertEquals((int)0, (int)__testServlets.get());
    }

    @Test
    public void testAddServletFromServlet() {
        Logger logger = Log.getLogger((String)(ContextHandler.class.getName() + "ROOT"));
        try (StacklessLogging ignored = new StacklessLogging(new Logger[]{logger});){
            ServletContextHandler context = new ServletContextHandler();
            context.setLogger(logger);
            ServletHolder holder = context.addServlet(ServletAddingServlet.class, "/start");
            context.getServletHandler().setStartWithUnavailable(false);
            holder.setInitOrder(0);
            context.setContextPath("/");
            this._server.setHandler((Handler)context);
            ServletException se = (ServletException)Assertions.assertThrows(ServletException.class, () -> ((Server)this._server).start());
            MatcherAssert.assertThat((String)"Servlet can only be added from SCI or SCL", (Object)se.getCause(), (Matcher)Matchers.instanceOf(IllegalStateException.class));
        }
    }

    @Test
    public void testAddFilterFromServlet() {
        Logger logger = Log.getLogger((String)(ContextHandler.class.getName() + "ROOT"));
        try (StacklessLogging ignored = new StacklessLogging(new Logger[]{logger});){
            ServletContextHandler context = new ServletContextHandler();
            context.setLogger(logger);
            ServletHolder holder = context.addServlet(FilterAddingServlet.class, "/filter");
            context.getServletHandler().setStartWithUnavailable(false);
            holder.setInitOrder(0);
            context.setContextPath("/");
            this._server.setHandler((Handler)context);
            ServletException se = (ServletException)Assertions.assertThrows(ServletException.class, () -> ((Server)this._server).start());
            MatcherAssert.assertThat((String)"Filter can only be added from SCI or SCL", (Object)se.getCause(), (Matcher)Matchers.instanceOf(IllegalStateException.class));
        }
    }

    @Test
    public void testAddServletByClassFromFilter() {
        Logger logger = Log.getLogger((String)(ContextHandler.class.getName() + "ROOT"));
        try (StacklessLogging ignored = new StacklessLogging(new Logger[]{logger});){
            ServletContextHandler context = new ServletContextHandler();
            context.setLogger(logger);
            FilterHolder holder = new FilterHolder(new Filter(){

                public void init(FilterConfig filterConfig) {
                    ServletRegistration.Dynamic rego = filterConfig.getServletContext().addServlet("hello", HelloServlet.class);
                    rego.addMapping(new String[]{"/hello/*"});
                }

                public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) {
                }

                public void destroy() {
                }
            });
            context.addFilter(holder, "/*", EnumSet.of(DispatcherType.REQUEST));
            context.getServletHandler().setStartWithUnavailable(false);
            context.setContextPath("/");
            this._server.setHandler((Handler)context);
            Assertions.assertThrows(IllegalStateException.class, () -> ((Server)this._server).start(), (String)"Servlet can only be added from SCI or SCL");
        }
    }

    @Test
    public void testAddServletByInstanceFromFilter() {
        Logger logger = Log.getLogger((String)(ContextHandler.class.getName() + "ROOT"));
        try (StacklessLogging ignored = new StacklessLogging(new Logger[]{logger});){
            ServletContextHandler context = new ServletContextHandler();
            context.setLogger(logger);
            FilterHolder holder = new FilterHolder(new Filter(){

                public void init(FilterConfig filterConfig) {
                    ServletRegistration.Dynamic rego = filterConfig.getServletContext().addServlet("hello", (Servlet)new HelloServlet());
                    rego.addMapping(new String[]{"/hello/*"});
                }

                public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) {
                }

                public void destroy() {
                }
            });
            context.addFilter(holder, "/*", EnumSet.of(DispatcherType.REQUEST));
            context.getServletHandler().setStartWithUnavailable(false);
            context.setContextPath("/");
            this._server.setHandler((Handler)context);
            Assertions.assertThrows(IllegalStateException.class, () -> ((Server)this._server).start(), (String)"Servlet can only be added from SCI or SCL");
        }
    }

    @Test
    public void testAddServletByClassNameFromFilter() {
        Logger logger = Log.getLogger((String)(ContextHandler.class.getName() + "ROOT"));
        try (StacklessLogging ignored = new StacklessLogging(new Logger[]{logger});){
            ServletContextHandler context = new ServletContextHandler();
            context.setLogger(logger);
            FilterHolder holder = new FilterHolder(new Filter(){

                public void init(FilterConfig filterConfig) {
                    ServletRegistration.Dynamic rego = filterConfig.getServletContext().addServlet("hello", HelloServlet.class.getName());
                    rego.addMapping(new String[]{"/hello/*"});
                }

                public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) {
                }

                public void destroy() {
                }
            });
            context.addFilter(holder, "/*", EnumSet.of(DispatcherType.REQUEST));
            context.getServletHandler().setStartWithUnavailable(false);
            context.setContextPath("/");
            this._server.setHandler((Handler)context);
            Assertions.assertThrows(IllegalStateException.class, () -> ((Server)this._server).start(), (String)"Servlet can only be added from SCI or SCL");
        }
    }

    @Test
    public void testAddServletFromSCL() throws Exception {
        ServletContextHandler context = new ServletContextHandler();
        context.getServletHandler().setStartWithUnavailable(false);
        context.setContextPath("/");
        context.addEventListener((EventListener)new ServletContextListener(){

            public void contextInitialized(ServletContextEvent sce) {
                ServletRegistration.Dynamic rego = sce.getServletContext().addServlet("hello", HelloServlet.class);
                rego.addMapping(new String[]{"/hello/*"});
            }

            public void contextDestroyed(ServletContextEvent sce) {
            }
        });
        this._server.setHandler((Handler)context);
        this._server.start();
        StringBuilder request = new StringBuilder();
        request.append("GET /hello HTTP/1.0\n");
        request.append("Host: localhost\n");
        request.append("\n");
        String response = this._connector.getResponse(request.toString());
        MatcherAssert.assertThat((String)"Response", (Object)response, (Matcher)Matchers.containsString((String)"Hello World"));
    }

    @Test
    public void testAddServletFromSCI() throws Exception {
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        this._server.setHandler((Handler)contexts);
        ServletContextHandler root = new ServletContextHandler((HandlerContainer)contexts, "/");
        class ServletAddingSCI
        implements ServletContainerInitializer {
            ServletAddingSCI() {
            }

            public void onStartup(Set<Class<?>> c, ServletContext ctx) {
                ServletRegistration.Dynamic rego = ctx.addServlet("hello", HelloServlet.class);
                rego.addMapping(new String[]{"/hello/*"});
            }
        }
        root.addBean((Object)new MySCIStarter(root.getServletContext(), new ServletAddingSCI()), true);
        this._server.start();
        StringBuilder request = new StringBuilder();
        request.append("GET /hello HTTP/1.0\n");
        request.append("Host: localhost\n");
        request.append("\n");
        String response = this._connector.getResponse(request.toString());
        MatcherAssert.assertThat((String)"Response", (Object)response, (Matcher)Matchers.containsString((String)"Hello World"));
    }

    @Test
    public void testAddServletAfterStart() throws Exception {
        ServletContextHandler context = new ServletContextHandler();
        context.addServlet(TestServlet.class, "/test");
        context.setContextPath("/");
        this._server.setHandler((Handler)context);
        this._server.start();
        StringBuffer request = new StringBuffer();
        request.append("GET /test HTTP/1.0\n");
        request.append("Host: localhost\n");
        request.append("\n");
        String response = this._connector.getResponse(request.toString());
        MatcherAssert.assertThat((String)"Response", (Object)response, (Matcher)Matchers.containsString((String)"Test"));
        context.addServlet(HelloServlet.class, "/hello");
        request = new StringBuffer();
        request.append("GET /hello HTTP/1.0\n");
        request.append("Host: localhost\n");
        request.append("\n");
        response = this._connector.getResponse(request.toString());
        MatcherAssert.assertThat((String)"Response", (Object)response, (Matcher)Matchers.containsString((String)"Hello World"));
    }

    @Test
    public void testServletRegistrationByClass() throws Exception {
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/");
        ServletRegistration.Dynamic reg = context.getServletContext().addServlet("test", TestServlet.class);
        reg.addMapping(new String[]{"/test"});
        this._server.setHandler((Handler)context);
        this._server.start();
        StringBuilder request = new StringBuilder();
        request.append("GET /test HTTP/1.0\n");
        request.append("Host: localhost\n");
        request.append("\n");
        String response = this._connector.getResponse(request.toString());
        MatcherAssert.assertThat((String)"Response", (Object)response, (Matcher)Matchers.containsString((String)"Test"));
    }

    @Test
    public void testServletRegistrationByClassName() throws Exception {
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/");
        ServletRegistration.Dynamic reg = context.getServletContext().addServlet("test", TestServlet.class.getName());
        reg.addMapping(new String[]{"/test"});
        this._server.setHandler((Handler)context);
        this._server.start();
        StringBuilder request = new StringBuilder();
        request.append("GET /test HTTP/1.0\n");
        request.append("Host: localhost\n");
        request.append("\n");
        String response = this._connector.getResponse(request.toString());
        MatcherAssert.assertThat((String)"Response", (Object)response, (Matcher)Matchers.containsString((String)"Test"));
    }

    @Test
    public void testPartialServletRegistrationByName() throws Exception {
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/");
        ServletHolder partial = new ServletHolder();
        partial.setName("test");
        context.addServlet(partial, "/test");
        ServletRegistration.Dynamic reg = context.getServletContext().addServlet("test", TestServlet.class.getName());
        Assertions.assertNotNull((Object)reg);
        Assertions.assertEquals((Object)TestServlet.class.getName(), (Object)partial.getClassName());
        this._server.setHandler((Handler)context);
        this._server.start();
        StringBuilder request = new StringBuilder();
        request.append("GET /test HTTP/1.0\n");
        request.append("Host: localhost\n");
        request.append("\n");
        String response = this._connector.getResponse(request.toString());
        MatcherAssert.assertThat((String)"Response", (Object)response, (Matcher)Matchers.containsString((String)"Test"));
    }

    @Test
    public void testPartialServletRegistrationByClass() throws Exception {
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/");
        ServletHolder partial = new ServletHolder();
        partial.setName("test");
        context.addServlet(partial, "/test");
        ServletRegistration.Dynamic reg = context.getServletContext().addServlet("test", TestServlet.class);
        Assertions.assertNotNull((Object)reg);
        Assertions.assertEquals((Object)TestServlet.class.getName(), (Object)partial.getClassName());
        Assertions.assertSame(TestServlet.class, (Object)partial.getHeldClass());
        this._server.setHandler((Handler)context);
        this._server.start();
        StringBuilder request = new StringBuilder();
        request.append("GET /test HTTP/1.0\n");
        request.append("Host: localhost\n");
        request.append("\n");
        String response = this._connector.getResponse(request.toString());
        MatcherAssert.assertThat((String)"Response", (Object)response, (Matcher)Matchers.containsString((String)"Test"));
    }

    @Test
    public void testNullServletRegistration() throws Exception {
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/");
        ServletHolder full = new ServletHolder();
        full.setName("test");
        full.setHeldClass(TestServlet.class);
        context.addServlet(full, "/test");
        ServletRegistration.Dynamic reg = context.getServletContext().addServlet("test", TestServlet.class);
        Assertions.assertNull((Object)reg);
        this._server.setHandler((Handler)context);
        this._server.start();
        StringBuilder request = new StringBuilder();
        request.append("GET /test HTTP/1.0\n");
        request.append("Host: localhost\n");
        request.append("\n");
        String response = this._connector.getResponse(request.toString());
        MatcherAssert.assertThat((String)"Response", (Object)response, (Matcher)Matchers.containsString((String)"Test"));
    }

    @Test
    public void testHandlerBeforeServletHandler() throws Exception {
        ServletContextHandler context = new ServletContextHandler(1);
        HandlerWrapper extra = new HandlerWrapper();
        context.getSessionHandler().insertHandler(extra);
        context.addServlet(TestServlet.class, "/test");
        context.setContextPath("/");
        this._server.setHandler((Handler)context);
        this._server.start();
        StringBuilder request = new StringBuilder();
        request.append("GET /test HTTP/1.0\n");
        request.append("Host: localhost\n");
        request.append("\n");
        String response = this._connector.getResponse(request.toString());
        MatcherAssert.assertThat((String)"Response", (Object)response, (Matcher)Matchers.containsString((String)"Test"));
        Assertions.assertEquals((Object)extra, (Object)context.getSessionHandler().getHandler());
    }

    @Test
    public void testGzipHandlerOption() throws Exception {
        ServletContextHandler context = new ServletContextHandler(5);
        GzipHandler gzip = context.getGzipHandler();
        this._server.start();
        Assertions.assertEquals((Object)context.getSessionHandler(), (Object)context.getHandler());
        Assertions.assertEquals((Object)gzip, (Object)context.getSessionHandler().getHandler());
        Assertions.assertEquals((Object)context.getServletHandler(), (Object)gzip.getHandler());
    }

    @Test
    public void testGzipHandlerSet() throws Exception {
        ServletContextHandler context = new ServletContextHandler();
        context.setSessionHandler(new SessionHandler());
        context.setGzipHandler(new GzipHandler());
        GzipHandler gzip = context.getGzipHandler();
        this._server.start();
        Assertions.assertEquals((Object)context.getSessionHandler(), (Object)context.getHandler());
        Assertions.assertEquals((Object)gzip, (Object)context.getSessionHandler().getHandler());
        Assertions.assertEquals((Object)context.getServletHandler(), (Object)gzip.getHandler());
    }

    @Test
    public void testReplaceServletHandlerWithServlet() throws Exception {
        ServletContextHandler context = new ServletContextHandler();
        context.addServlet(TestServlet.class, "/test");
        context.setContextPath("/");
        this._server.setHandler((Handler)context);
        this._server.start();
        StringBuffer request = new StringBuffer();
        request.append("GET /test HTTP/1.0\n");
        request.append("Host: localhost\n");
        request.append("\n");
        String response = this._connector.getResponse(request.toString());
        MatcherAssert.assertThat((String)"Response", (Object)response, (Matcher)Matchers.containsString((String)"Test"));
        context.stop();
        ServletHandler srvHnd = new ServletHandler();
        srvHnd.addServletWithMapping(HelloServlet.class, "/hello");
        context.setServletHandler(srvHnd);
        context.start();
        request = new StringBuffer();
        request.append("GET /hello HTTP/1.0\n");
        request.append("Host: localhost\n");
        request.append("\n");
        response = this._connector.getResponse(request.toString());
        MatcherAssert.assertThat((String)"Response", (Object)response, (Matcher)Matchers.containsString((String)"Hello World"));
    }

    @Test
    public void testSetSecurityHandler() {
        ServletContextHandler context = new ServletContextHandler(7);
        Assertions.assertNotNull((Object)context.getSessionHandler());
        SessionHandler sessionHandler = context.getSessionHandler();
        Assertions.assertNotNull((Object)context.getSecurityHandler());
        SecurityHandler securityHandler = context.getSecurityHandler();
        Assertions.assertNotNull((Object)context.getGzipHandler());
        GzipHandler gzipHandler = context.getGzipHandler();
        HandlerWrapper h = (HandlerWrapper)context.getHandler();
        Assertions.assertSame((Object)h, (Object)sessionHandler);
        h = (HandlerWrapper)h.getHandler();
        Assertions.assertSame((Object)h, (Object)securityHandler);
        h = (HandlerWrapper)h.getHandler();
        Assertions.assertSame((Object)h, (Object)gzipHandler);
        SecurityHandler myHandler = new SecurityHandler(){

            protected RoleInfo prepareConstraintInfo(String pathInContext, Request request) {
                return null;
            }

            protected boolean checkUserDataPermissions(String pathInContext, Request request, Response response, RoleInfo constraintInfo) {
                return false;
            }

            protected boolean isAuthMandatory(Request baseRequest, Response baseResponse, Object constraintInfo) {
                return false;
            }

            protected boolean checkWebResourcePermissions(String pathInContext, Request request, Response response, Object constraintInfo, UserIdentity userIdentity) {
                return false;
            }
        };
        context.setSecurityHandler(myHandler);
        Assertions.assertSame((Object)myHandler, (Object)context.getSecurityHandler());
        h = (HandlerWrapper)context.getHandler();
        Assertions.assertSame((Object)h, (Object)sessionHandler);
        h = (HandlerWrapper)h.getHandler();
        Assertions.assertSame((Object)h, (Object)myHandler);
        h = (HandlerWrapper)h.getHandler();
        Assertions.assertSame((Object)h, (Object)gzipHandler);
    }

    @Test
    public void testReplaceServletHandlerWithoutServlet() throws Exception {
        ServletContextHandler context = new ServletContextHandler();
        context.addServlet(TestServlet.class, "/test");
        context.setContextPath("/");
        this._server.setHandler((Handler)context);
        this._server.start();
        StringBuffer request = new StringBuffer();
        request.append("GET /test HTTP/1.0\n");
        request.append("Host: localhost\n");
        request.append("\n");
        String response = this._connector.getResponse(request.toString());
        MatcherAssert.assertThat((String)"Response", (Object)response, (Matcher)Matchers.containsString((String)"Test"));
        context.stop();
        ServletHandler srvHnd = new ServletHandler();
        context.setServletHandler(srvHnd);
        context.start();
        context.addServlet(HelloServlet.class, "/hello");
        request = new StringBuffer();
        request.append("GET /hello HTTP/1.0\n");
        request.append("Host: localhost\n");
        request.append("\n");
        response = this._connector.getResponse(request.toString());
        MatcherAssert.assertThat((String)"Response", (Object)response, (Matcher)Matchers.containsString((String)"Hello World"));
    }

    @Test
    public void testReplaceHandler() throws Exception {
        ServletContextHandler servletContextHandler = new ServletContextHandler();
        ServletHolder sh = new ServletHolder((Servlet)new TestServlet());
        servletContextHandler.addServlet(sh, "/foo");
        final AtomicBoolean contextInit = new AtomicBoolean(false);
        final AtomicBoolean contextDestroy = new AtomicBoolean(false);
        servletContextHandler.addEventListener((EventListener)new ServletContextListener(){

            public void contextInitialized(ServletContextEvent sce) {
                if (sce.getServletContext() != null) {
                    contextInit.set(true);
                }
            }

            public void contextDestroyed(ServletContextEvent sce) {
                if (sce.getServletContext() != null) {
                    contextDestroy.set(true);
                }
            }
        });
        ServletHandler shandler = servletContextHandler.getServletHandler();
        ResourceHandler rh = new ResourceHandler();
        servletContextHandler.insertHandler((HandlerWrapper)rh);
        Assertions.assertEquals((Object)shandler, (Object)servletContextHandler.getServletHandler());
        Assertions.assertEquals((Object)rh, (Object)servletContextHandler.getHandler());
        Assertions.assertEquals((Object)rh.getHandler(), (Object)shandler);
        this._server.setHandler((Handler)servletContextHandler);
        this._server.start();
        Assertions.assertTrue((boolean)contextInit.get());
        this._server.stop();
        Assertions.assertTrue((boolean)contextDestroy.get());
    }

    @Test
    public void testFallThrough() throws Exception {
        HandlerList list = new HandlerList();
        this._server.setHandler((Handler)list);
        ServletContextHandler root = new ServletContextHandler((HandlerContainer)list, "/", 1);
        ServletHandler servlet = root.getServletHandler();
        servlet.setEnsureDefaultServlet(false);
        servlet.addServletWithMapping(HelloServlet.class, "/hello/*");
        list.addHandler((Handler)new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
                response.sendError(404, "Fell Through");
            }
        });
        this._server.start();
        String response = this._connector.getResponse("GET /hello HTTP/1.0\r\n\r\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        response = this._connector.getResponse("GET /other HTTP/1.0\r\n\r\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"404 Fell Through"));
    }

    @Test
    public void testLegacyDecorator() throws Exception {
        ServletContextHandler context = new ServletContextHandler();
        context.addDecorator((ServletContextHandler.Decorator)new DummyLegacyDecorator());
        this._server.setHandler((Handler)context);
        context.addServlet(DecoratedObjectFactoryServlet.class, "/objfactory/*");
        this._server.start();
        String response = this._connector.getResponse("GET /objfactory/ HTTP/1.0\r\n\r\n");
        MatcherAssert.assertThat((String)"Response status code", (Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        String expected = String.format("Attribute[%s] = %s", DecoratedObjectFactory.ATTR, DecoratedObjectFactory.class.getName());
        MatcherAssert.assertThat((String)"Has context attribute", (Object)response, (Matcher)Matchers.containsString((String)expected));
        MatcherAssert.assertThat((String)"Decorators size", (Object)response, (Matcher)Matchers.containsString((String)"Decorators.size = [2]"));
        expected = String.format("decorator[] = %s", DummyLegacyDecorator.class.getName());
        MatcherAssert.assertThat((String)"Specific Legacy Decorator", (Object)response, (Matcher)Matchers.containsString((String)expected));
    }

    @Test
    public void testUtilDecorator() throws Exception {
        ServletContextHandler context = new ServletContextHandler();
        context.getObjectFactory().addDecorator((Decorator)new DummyUtilDecorator());
        this._server.setHandler((Handler)context);
        context.addServlet(DecoratedObjectFactoryServlet.class, "/objfactory/*");
        this._server.start();
        String response = this._connector.getResponse("GET /objfactory/ HTTP/1.0\r\n\r\n");
        MatcherAssert.assertThat((String)"Response status code", (Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        String expected = String.format("Attribute[%s] = %s", DecoratedObjectFactory.ATTR, DecoratedObjectFactory.class.getName());
        MatcherAssert.assertThat((String)"Has context attribute", (Object)response, (Matcher)Matchers.containsString((String)expected));
        MatcherAssert.assertThat((String)"Decorators size", (Object)response, (Matcher)Matchers.containsString((String)"Decorators.size = [2]"));
        expected = String.format("decorator[] = %s", DummyUtilDecorator.class.getName());
        MatcherAssert.assertThat((String)"Specific Legacy Decorator", (Object)response, (Matcher)Matchers.containsString((String)expected));
    }

    public static class TestServlet
    extends HttpServlet {
        private static final long serialVersionUID = 1L;

        public void destroy() {
            super.destroy();
            __testServlets.decrementAndGet();
        }

        public void init() throws ServletException {
            __testServlets.incrementAndGet();
            super.init();
        }

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            resp.setStatus(200);
            PrintWriter writer = resp.getWriter();
            writer.write("Test");
            String action = req.getParameter("session");
            if (!Objects.isNull(action)) {
                if ("create".equalsIgnoreCase(action)) {
                    HttpSession session = req.getSession(true);
                    session.setAttribute("some", (Object)"thing");
                } else if ("change".equalsIgnoreCase(action)) {
                    req.getSession(true);
                    req.changeSessionId();
                } else if ("replace".equalsIgnoreCase(action)) {
                    HttpSession session = req.getSession(false);
                    session.setAttribute("some", (Object)"other");
                } else if ("remove".equalsIgnoreCase(action)) {
                    HttpSession session = req.getSession(false);
                    session.removeAttribute("some");
                } else if ("delete".equalsIgnoreCase(action)) {
                    HttpSession session = req.getSession(false);
                    session.invalidate();
                } else {
                    resp.setStatus(400);
                }
                return;
            }
            action = req.getParameter("req");
            if (!Objects.isNull(action)) {
                req.setAttribute("some", (Object)"value");
                req.setAttribute("some", (Object)"other");
                req.removeAttribute("some");
                return;
            }
            action = req.getParameter("ctx");
            if (!Objects.isNull(action)) {
                req.getServletContext().setAttribute("foo", (Object)"foo");
                req.getServletContext().removeAttribute("foo");
            }
        }
    }

    public static class AddedServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            resp.getWriter().write("Added");
            resp.getWriter().close();
        }
    }

    public static class FilterAddingServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            resp.getWriter().write("Filter");
            resp.getWriter().close();
        }

        public void init() throws ServletException {
            FilterRegistration.Dynamic dynamic = this.getServletContext().addFilter("filter", (Filter)new MyFilter());
            dynamic.addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST), false, new String[]{"/*"});
        }
    }

    public static class ServletAddingServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            resp.getWriter().write("Start");
            resp.getWriter().close();
        }

        public void init() throws ServletException {
            ServletRegistration.Dynamic dynamic = this.getServletContext().addServlet("added", AddedServlet.class);
            dynamic.addMapping(new String[]{"/added/*"});
        }
    }

    public static class DecoratedObjectFactoryServlet
    extends HttpServlet {
        private static final long serialVersionUID = 1L;

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            resp.setContentType("text/plain");
            resp.setStatus(200);
            PrintWriter out = resp.getWriter();
            Object obj = req.getServletContext().getAttribute(DecoratedObjectFactory.ATTR);
            out.printf("Attribute[%s] = %s%n", DecoratedObjectFactory.ATTR, obj.getClass().getName());
            if (obj instanceof DecoratedObjectFactory) {
                out.printf("Object is a DecoratedObjectFactory%n", new Object[0]);
                DecoratedObjectFactory objFactory = (DecoratedObjectFactory)obj;
                List decorators = objFactory.getDecorators();
                out.printf("Decorators.size = [%d]%n", decorators.size());
                for (Decorator decorator : decorators) {
                    out.printf(" decorator[] = %s%n", decorator.getClass().getName());
                }
            } else {
                out.printf("Object is NOT a DecoratedObjectFactory%n", new Object[0]);
            }
        }
    }

    public static class DummyLegacyDecorator
    implements ServletContextHandler.Decorator {
        public <T> T decorate(T o) {
            return o;
        }

        public void destroy(Object o) {
        }
    }

    public static class DummyUtilDecorator
    implements Decorator {
        public <T> T decorate(T o) {
            return o;
        }

        public void destroy(Object o) {
        }
    }

    public static class MyFilter
    implements Filter {
        public void init(FilterConfig filterConfig) throws ServletException {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            request.getServletContext().setAttribute("filter", (Object)"filter");
            chain.doFilter(request, response);
        }

        public void destroy() {
        }
    }

    public static class HelloServlet
    extends HttpServlet {
        private static final long serialVersionUID = 1L;

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            resp.setStatus(200);
            PrintWriter writer = resp.getWriter();
            writer.write("Hello World");
        }
    }

    public static class InitialListener
    implements ServletContextListener {
        public void contextInitialized(ServletContextEvent sce) {
            try {
                MySCAListener mySCAListener = (MySCAListener)((Object)sce.getServletContext().createListener(MySCAListener.class));
                sce.getServletContext().addListener((EventListener)((Object)mySCAListener));
                MyRequestListener myRequestListener = (MyRequestListener)((Object)sce.getServletContext().createListener(MyRequestListener.class));
                sce.getServletContext().addListener((EventListener)((Object)myRequestListener));
                MyRAListener myRAListener = (MyRAListener)((Object)sce.getServletContext().createListener(MyRAListener.class));
                sce.getServletContext().addListener((EventListener)((Object)myRAListener));
                MySListener mySListener = (MySListener)((Object)sce.getServletContext().createListener(MySListener.class));
                sce.getServletContext().addListener((EventListener)((Object)mySListener));
                MySAListener mySAListener = (MySAListener)((Object)sce.getServletContext().createListener(MySAListener.class));
                sce.getServletContext().addListener((EventListener)((Object)mySAListener));
                MySIListener mySIListener = (MySIListener)((Object)sce.getServletContext().createListener(MySIListener.class));
                sce.getServletContext().addListener((EventListener)((Object)mySIListener));
            }
            catch (Exception e) {
                Assertions.fail((Throwable)e);
            }
            try {
                MyContextListener contextListener = (MyContextListener)((Object)sce.getServletContext().createListener(MyContextListener.class));
                Assertions.assertThrows(IllegalArgumentException.class, () -> sce.getServletContext().addListener((EventListener)((Object)contextListener)), (String)"Adding SCI from an SCI!");
            }
            catch (IllegalArgumentException contextListener) {
            }
            catch (ServletException x) {
                Assertions.fail((Throwable)x);
            }
            sce.getServletContext().setAttribute("foo", (Object)"bar");
        }

        public void contextDestroyed(ServletContextEvent sce) {
        }
    }

    public static class MySIListener
    implements HttpSessionIdListener {
        public static int changes = 0;

        public void sessionIdChanged(HttpSessionEvent event, String oldSessionId) {
            ++changes;
        }
    }

    public static class MySAListener
    implements HttpSessionAttributeListener {
        public static int adds = 0;
        public static int removes = 0;
        public static int replaces = 0;

        public void attributeAdded(HttpSessionBindingEvent event) {
            ++adds;
        }

        public void attributeRemoved(HttpSessionBindingEvent event) {
            ++removes;
        }

        public void attributeReplaced(HttpSessionBindingEvent event) {
            ++replaces;
        }
    }

    public static class MySListener
    implements HttpSessionListener {
        public static int creates = 0;
        public static int destroys = 0;

        public void sessionCreated(HttpSessionEvent se) {
            ++creates;
        }

        public void sessionDestroyed(HttpSessionEvent se) {
            ++destroys;
        }
    }

    public static class MyRAListener
    implements ServletRequestAttributeListener {
        public static int adds = 0;
        public static int removes = 0;
        public static int replaces = 0;

        public void attributeAdded(ServletRequestAttributeEvent srae) {
            ++adds;
        }

        public void attributeRemoved(ServletRequestAttributeEvent srae) {
            ++removes;
        }

        public void attributeReplaced(ServletRequestAttributeEvent srae) {
            ++replaces;
        }
    }

    public static class MyRequestListener
    implements ServletRequestListener {
        public static int destroys = 0;
        public static int inits = 0;

        public void requestDestroyed(ServletRequestEvent sre) {
            ++destroys;
        }

        public void requestInitialized(ServletRequestEvent sre) {
            ++inits;
        }
    }

    public static class MySCAListener
    implements ServletContextAttributeListener {
        public static int adds = 0;
        public static int removes = 0;
        public static int replaces = 0;

        public void attributeAdded(ServletContextAttributeEvent event) {
            ++adds;
        }

        public void attributeRemoved(ServletContextAttributeEvent event) {
            ++removes;
        }

        public void attributeReplaced(ServletContextAttributeEvent event) {
            ++replaces;
        }
    }

    public static class MyTestSessionListener
    implements HttpSessionAttributeListener,
    HttpSessionListener {
        public void sessionCreated(HttpSessionEvent se) {
        }

        public void sessionDestroyed(HttpSessionEvent se) {
        }

        public void attributeAdded(HttpSessionBindingEvent event) {
        }

        public void attributeRemoved(HttpSessionBindingEvent event) {
        }

        public void attributeReplaced(HttpSessionBindingEvent event) {
        }
    }

    public static class MySessionHandler
    extends SessionHandler {
        public void checkSessionListeners(int size) {
            Assertions.assertNotNull((Object)this._sessionListeners);
            Assertions.assertEquals((int)size, (int)this._sessionListeners.size());
        }

        public void checkSessionAttributeListeners(int size) {
            Assertions.assertNotNull((Object)this._sessionAttributeListeners);
            Assertions.assertEquals((int)size, (int)this._sessionAttributeListeners.size());
        }

        public void checkSessionIdListeners(int size) {
            Assertions.assertNotNull((Object)this._sessionIdListeners);
            Assertions.assertEquals((int)size, (int)this._sessionIdListeners.size());
        }
    }

    public static class MyContextListener
    implements ServletContextListener {
        public void contextInitialized(ServletContextEvent sce) {
            Assertions.assertNull((Object)sce.getServletContext().getAttribute("MyContextListener.contextInitialized"));
            sce.getServletContext().setAttribute("MyContextListener.contextInitialized", (Object)Boolean.TRUE);
        }

        public void contextDestroyed(ServletContextEvent sce) {
            Assertions.assertNull((Object)sce.getServletContext().getAttribute("MyContextListener.contextDestroyed"));
            sce.getServletContext().setAttribute("MyContextListener.contextDestroyed", (Object)Boolean.TRUE);
        }
    }

    public static class MySCIStarter
    extends AbstractLifeCycle
    implements ServletContextHandler.ServletContainerInitializerCaller {
        ServletContainerInitializer _sci;
        ContextHandler.Context _ctx;

        MySCIStarter(ContextHandler.Context ctx, ServletContainerInitializer sci) {
            this._ctx = ctx;
            this._sci = sci;
        }

        protected void doStart() throws Exception {
            super.doStart();
            this._ctx.setExtendedListenerTypes(true);
            this._sci.onStartup(Collections.emptySet(), (ServletContext)this._ctx);
        }
    }

    public static class MySCI
    implements ServletContainerInitializer {
        public void onStartup(Set<Class<?>> c, ServletContext ctx) {
            if (ctx.getAttribute("MySCI.startup") != null) {
                throw new IllegalStateException("MySCI already called");
            }
            ctx.setAttribute("MySCI.startup", (Object)Boolean.TRUE);
            ctx.addListener((EventListener)((Object)new MyContextListener()));
        }
    }

    public static class StopTestListener
    implements ServletContextListener {
        int _initIndex;
        int _destroyIndex;

        public void contextInitialized(ServletContextEvent sce) {
            this._initIndex = __initIndex++;
        }

        public void contextDestroyed(ServletContextEvent sce) {
            this._destroyIndex = __destroyIndex++;
        }
    }

    public static class StopTestServlet
    extends GenericServlet {
        int _initIndex;
        int _destroyIndex;

        public void destroy() {
            this._destroyIndex = __destroyIndex++;
            super.destroy();
        }

        public void init() throws ServletException {
            this._initIndex = __initIndex++;
            super.init();
        }

        public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        }
    }

    public static class StopTestFilter
    implements Filter {
        int _initIndex;
        int _destroyIndex;

        public void init(FilterConfig filterConfig) throws ServletException {
            this._initIndex = __initIndex++;
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        }

        public void destroy() {
            this._destroyIndex = __destroyIndex++;
        }
    }
}

