/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Dispatcher;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpChannelState;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ErrorPageErrorHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.log.StacklessLogging;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ErrorPageTest {
    private Server _server;
    private LocalConnector _connector;
    private StacklessLogging _stackless;
    private static CountDownLatch __asyncSendErrorCompleted;
    private ErrorPageErrorHandler _errorPageErrorHandler;
    private static AtomicBoolean __destroyed;
    private ServletContextHandler _context;

    @BeforeEach
    public void init() throws Exception {
        this._server = new Server();
        this._connector = new LocalConnector(this._server);
        this._server.addConnector((Connector)this._connector);
        this._context = new ServletContextHandler(0);
        this._server.setHandler((Handler)this._context);
        this._context.setContextPath("/");
        this._context.addFilter(SingleDispatchFilter.class, "/*", EnumSet.allOf(DispatcherType.class));
        this._context.addServlet(DefaultServlet.class, "/");
        this._context.addServlet(FailServlet.class, "/fail/*");
        this._context.addServlet(FailClosedServlet.class, "/fail-closed/*");
        this._context.addServlet(ErrorServlet.class, "/error/*");
        this._context.addServlet(AppServlet.class, "/app/*");
        this._context.addServlet(LongerAppServlet.class, "/longer.app/*");
        this._context.addServlet(SyncSendErrorServlet.class, "/sync/*");
        this._context.addServlet(AsyncSendErrorServlet.class, "/async/*");
        this._context.addServlet(NotEnoughServlet.class, "/notenough/*");
        this._context.addServlet(UnavailableServlet.class, "/unavailable/*");
        this._context.addServlet(DeleteServlet.class, "/delete/*");
        this._context.addServlet(ErrorAndStatusServlet.class, "/error-and-status/*");
        HandlerWrapper noopHandler = new HandlerWrapper(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                if (target.startsWith("/noop")) {
                    return;
                }
                super.handle(target, baseRequest, request, response);
            }
        };
        this._context.insertHandler(noopHandler);
        this._errorPageErrorHandler = new ErrorPageErrorHandler();
        this._context.setErrorHandler((ErrorHandler)this._errorPageErrorHandler);
        this._errorPageErrorHandler.addErrorPage(595, "/error/595");
        this._errorPageErrorHandler.addErrorPage(597, "/sync");
        this._errorPageErrorHandler.addErrorPage(599, "/error/599");
        this._errorPageErrorHandler.addErrorPage(400, "/error/400");
        this._errorPageErrorHandler.addErrorPage(IllegalStateException.class.getCanonicalName(), "/error/TestException");
        this._errorPageErrorHandler.addErrorPage(BadMessageException.class, "/error/BadMessageException");
        this._errorPageErrorHandler.addErrorPage("org.eclipse.jetty.server.error_page.global", "/error/GlobalErrorPage");
        this._server.start();
        this._stackless = new StacklessLogging(new Class[]{ServletHandler.class});
        __asyncSendErrorCompleted = new CountDownLatch(1);
    }

    @AfterEach
    public void destroy() throws Exception {
        this._stackless.close();
        this._server.stop();
        this._server.join();
    }

    @Test
    public void testErrorOverridesStatus() throws Exception {
        String response = this._connector.getResponse("GET /error-and-status/anything HTTP/1.0\r\n\r\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 594 594"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_PAGE: /GlobalErrorPage"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_MESSAGE: custom get error"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_CODE: 594"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_EXCEPTION: null"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_EXCEPTION_TYPE: null"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_SERVLET: org.eclipse.jetty.servlet.ErrorPageTest$ErrorAndStatusServlet-"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_REQUEST_URI: /error-and-status/anything"));
    }

    @Test
    public void testHttp204CannotHaveBody() throws Exception {
        String response = this._connector.getResponse("GET /fail/code?code=204 HTTP/1.0\r\n\r\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 204 No Content"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"DISPATCH: ")));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"ERROR_PAGE: ")));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"ERROR_CODE: ")));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"ERROR_EXCEPTION: ")));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"ERROR_EXCEPTION_TYPE: ")));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"ERROR_SERVLET: ")));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"ERROR_REQUEST_URI: ")));
    }

    @Test
    public void testDeleteCannotHaveBody() throws Exception {
        String response = this._connector.getResponse("DELETE /delete/anything HTTP/1.0\r\n\r\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 595 595"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"DISPATCH: ")));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"ERROR_PAGE: ")));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"ERROR_MESSAGE: ")));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"ERROR_CODE: ")));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"ERROR_EXCEPTION: ")));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"ERROR_EXCEPTION_TYPE: ")));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"ERROR_SERVLET: ")));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"ERROR_REQUEST_URI: ")));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"This shouldn't be seen")));
    }

    @Test
    public void testGenerateAcceptableResponseNoAcceptHeader() throws Exception {
        this._errorPageErrorHandler.getErrorPages().remove("org.eclipse.jetty.server.error_page.global");
        String response = this._connector.getResponse("GET /fail/code?code=598 HTTP/1.0\r\n\r\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 598 598"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"<title>Error 598"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"<h2>HTTP ERROR 598"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"/fail/code"));
    }

    @Test
    public void testGenerateAcceptableResponseHtmlAcceptHeader() throws Exception {
        this._errorPageErrorHandler.getErrorPages().remove("org.eclipse.jetty.server.error_page.global");
        String response = this._connector.getResponse("GET /fail/code?code=598 HTTP/1.0\r\nAccept: application/bytes,text/html\r\n\r\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 598 598"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"<title>Error 598"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"<h2>HTTP ERROR 598"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"/fail/code"));
    }

    @Test
    public void testGenerateAcceptableResponseNoHtmlAcceptHeader() throws Exception {
        this._errorPageErrorHandler.getErrorPages().remove("org.eclipse.jetty.server.error_page.global");
        String response = this._connector.getResponse("GET /fail/code?code=598 HTTP/1.0\r\nAccept: application/bytes\r\n\r\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 598 598"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"<title>Error 598")));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"<h2>HTTP ERROR 598")));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"/fail/code")));
    }

    @Test
    public void testNestedSendErrorDoesNotLoop() throws Exception {
        String response = this._connector.getResponse("GET /fail/code?code=597 HTTP/1.0\r\n\r\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 597 597"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"time this error page is being accessed")));
    }

    @Test
    public void testSendErrorClosedResponse() throws Exception {
        String response = this._connector.getResponse("GET /fail-closed/ HTTP/1.0\r\n\r\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 599 599"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"DISPATCH: ERROR"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_PAGE: /599"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_CODE: 599"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_EXCEPTION: null"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_EXCEPTION_TYPE: null"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_SERVLET: org.eclipse.jetty.servlet.ErrorPageTest$FailClosedServlet-"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_REQUEST_URI: /fail-closed/"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"This shouldn't be seen")));
    }

    @Test
    public void testErrorCode() throws Exception {
        String response = this._connector.getResponse("GET /fail/code?code=599 HTTP/1.0\r\n\r\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 599 599"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_PAGE: /599"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_CODE: 599"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_EXCEPTION: null"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_EXCEPTION_TYPE: null"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_SERVLET: org.eclipse.jetty.servlet.ErrorPageTest$FailServlet-"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_REQUEST_URI: /fail/code"));
    }

    @Test
    public void testErrorException() throws Exception {
        try (StacklessLogging stackless = new StacklessLogging(new Class[]{HttpChannel.class});){
            String response = this._connector.getResponse("GET /fail/exception HTTP/1.0\r\n\r\n");
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 500 Server Error"));
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_PAGE: /TestException"));
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_CODE: 500"));
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_EXCEPTION: javax.servlet.ServletException: java.lang.IllegalStateException"));
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_EXCEPTION_TYPE: class javax.servlet.ServletException"));
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_SERVLET: org.eclipse.jetty.servlet.ErrorPageTest$FailServlet-"));
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_REQUEST_URI: /fail/exception"));
        }
    }

    @Test
    public void testGlobalErrorCode() throws Exception {
        String response = this._connector.getResponse("GET /fail/global?code=598 HTTP/1.0\r\n\r\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 598 598"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_PAGE: /GlobalErrorPage"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_CODE: 598"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_EXCEPTION: null"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_EXCEPTION_TYPE: null"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_SERVLET: org.eclipse.jetty.servlet.ErrorPageTest$FailServlet-"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_REQUEST_URI: /fail/global"));
    }

    @Test
    public void testGlobalErrorException() throws Exception {
        try (StacklessLogging stackless = new StacklessLogging(new Class[]{HttpChannel.class});){
            String response = this._connector.getResponse("GET /fail/global?code=NAN HTTP/1.0\r\n\r\n");
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 500 Server Error"));
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_PAGE: /GlobalErrorPage"));
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_CODE: 500"));
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_EXCEPTION: java.lang.NumberFormatException: For input string: \"NAN\""));
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_EXCEPTION_TYPE: class java.lang.NumberFormatException"));
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_SERVLET: org.eclipse.jetty.servlet.ErrorPageTest$FailServlet-"));
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_REQUEST_URI: /fail/global"));
        }
    }

    @Test
    public void testBadMessage() throws Exception {
        try (StacklessLogging ignore = new StacklessLogging(new Class[]{Dispatcher.class});){
            String response = this._connector.getResponse("GET /app?baa=%88%A4 HTTP/1.0\r\n\r\n");
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 400 Bad Request"));
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_PAGE: /BadMessageException"));
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_MESSAGE: Bad query encoding"));
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_CODE: 400"));
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_EXCEPTION: org.eclipse.jetty.http.BadMessageException: 400: Bad query encoding"));
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_EXCEPTION_TYPE: class org.eclipse.jetty.http.BadMessageException"));
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_SERVLET: org.eclipse.jetty.servlet.ErrorPageTest$AppServlet-"));
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_REQUEST_URI: /app"));
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"getParameterMap()= {}"));
        }
    }

    @Test
    public void testAsyncErrorPageDSC() throws Exception {
        try (StacklessLogging ignore = new StacklessLogging(new Class[]{Dispatcher.class});){
            String response = this._connector.getResponse("GET /async/info?mode=DSC HTTP/1.0\r\n\r\n");
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 599 599"));
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_PAGE: /599"));
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_CODE: 599"));
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_EXCEPTION: null"));
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_EXCEPTION_TYPE: null"));
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_SERVLET: org.eclipse.jetty.servlet.ErrorPageTest$AsyncSendErrorServlet-"));
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_REQUEST_URI: /async/info"));
            Assertions.assertTrue((boolean)__asyncSendErrorCompleted.await(10L, TimeUnit.SECONDS));
        }
    }

    @Test
    public void testAsyncErrorPageSDC() throws Exception {
        try (StacklessLogging ignore = new StacklessLogging(new Class[]{Dispatcher.class});){
            String response = this._connector.getResponse("GET /async/info?mode=SDC HTTP/1.0\r\n\r\n");
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 599 599"));
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_PAGE: /599"));
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_CODE: 599"));
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_EXCEPTION: null"));
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_EXCEPTION_TYPE: null"));
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_SERVLET: org.eclipse.jetty.servlet.ErrorPageTest$AsyncSendErrorServlet-"));
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_REQUEST_URI: /async/info"));
            Assertions.assertTrue((boolean)__asyncSendErrorCompleted.await(10L, TimeUnit.SECONDS));
        }
    }

    @Test
    public void testAsyncErrorPageSCD() throws Exception {
        try (StacklessLogging ignore = new StacklessLogging(new Class[]{Dispatcher.class});){
            String response = this._connector.getResponse("GET /async/info?mode=SCD HTTP/1.0\r\n\r\n");
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 599 599"));
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_PAGE: /599"));
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_CODE: 599"));
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_EXCEPTION: null"));
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_EXCEPTION_TYPE: null"));
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_SERVLET: org.eclipse.jetty.servlet.ErrorPageTest$AsyncSendErrorServlet-"));
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_REQUEST_URI: /async/info"));
            Assertions.assertTrue((boolean)__asyncSendErrorCompleted.await(10L, TimeUnit.SECONDS));
        }
    }

    @Test
    public void testNoop() throws Exception {
        String response = this._connector.getResponse("GET /noop/info HTTP/1.0\r\n\r\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 404 Not Found"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"DISPATCH: ERROR"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_PAGE: /GlobalErrorPage"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_CODE: 404"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_EXCEPTION: null"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_EXCEPTION_TYPE: null"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_SERVLET: org.eclipse.jetty.servlet.DefaultServlet-"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_REQUEST_URI: /noop/info"));
    }

    @Test
    public void testNotEnough() throws Exception {
        String response = this._connector.getResponse("GET /notenough/info HTTP/1.0\r\n\r\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 500 Server Error"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"DISPATCH: ERROR"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_PAGE: /GlobalErrorPage"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_CODE: 500"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_EXCEPTION: null"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_EXCEPTION_TYPE: null"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_SERVLET: org.eclipse.jetty.servlet.ErrorPageTest$NotEnoughServlet-"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"ERROR_REQUEST_URI: /notenough/info"));
    }

    @Test
    public void testNotEnoughCommitted() throws Exception {
        String response = this._connector.getResponse("GET /notenough/info?commit=true HTTP/1.0\r\n\r\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Content-Length: 1000"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.endsWith((String)"SomeBytes"));
    }

    @Test
    public void testPermanentlyUnavailable() throws Exception {
        try (StacklessLogging ignore = new StacklessLogging(new Logger[]{this._context.getLogger()});
             StacklessLogging ignore2 = new StacklessLogging(new Class[]{HttpChannel.class});){
            __destroyed = new AtomicBoolean(false);
            String response = this._connector.getResponse("GET /unavailable/info HTTP/1.0\r\n\r\n");
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 404 "));
            Assertions.assertTrue((boolean)__destroyed.get());
        }
    }

    @Test
    public void testUnavailable() throws Exception {
        try (StacklessLogging ignore = new StacklessLogging(new Logger[]{this._context.getLogger()});
             StacklessLogging ignore2 = new StacklessLogging(new Class[]{HttpChannel.class});){
            __destroyed = new AtomicBoolean(false);
            String response = this._connector.getResponse("GET /unavailable/info?for=1 HTTP/1.0\r\n\r\n");
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 503 "));
            Assertions.assertFalse((boolean)__destroyed.get());
            response = this._connector.getResponse("GET /unavailable/info?ok=true HTTP/1.0\r\n\r\n");
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 503 "));
            Assertions.assertFalse((boolean)__destroyed.get());
            Thread.sleep(1500L);
            response = this._connector.getResponse("GET /unavailable/info?ok=true HTTP/1.0\r\n\r\n");
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 "));
            Assertions.assertFalse((boolean)__destroyed.get());
        }
    }

    public static class SingleDispatchFilter
    implements Filter {
        ConcurrentMap<Integer, Thread> dispatches = new ConcurrentHashMap<Integer, Thread>();

        public void init(FilterConfig filterConfig) throws ServletException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            Thread current;
            Integer key = request.hashCode();
            Thread existing = this.dispatches.putIfAbsent(key, current = Thread.currentThread());
            if (existing != null && existing != current) {
                System.err.println("DOUBLE DISPATCH OF REQUEST!!!!!!!!!!!!!!!!!!");
                System.err.println("Thread " + existing + " :");
                for (StackTraceElement element : existing.getStackTrace()) {
                    System.err.println("\tat " + element);
                }
                IllegalStateException ex = new IllegalStateException();
                ex.printStackTrace();
                response.flushBuffer();
                throw ex;
            }
            try {
                chain.doFilter(request, response);
            }
            finally {
                if (existing == null && !this.dispatches.remove(key, current)) {
                    throw new IllegalStateException();
                }
            }
        }

        public void destroy() {
        }
    }

    public static class UnavailableServlet
    extends HttpServlet
    implements Servlet {
        protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            String ok = request.getParameter("ok");
            if (Boolean.parseBoolean(ok)) {
                response.setStatus(200);
                response.flushBuffer();
                return;
            }
            String f = request.getParameter("for");
            if (f == null) {
                throw new UnavailableException("testing permanent");
            }
            throw new UnavailableException("testing periodic", Integer.parseInt(f));
        }

        public void destroy() {
            if (__destroyed != null) {
                __destroyed.set(true);
            }
        }
    }

    public static class ErrorServlet
    extends HttpServlet
    implements Servlet {
        protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            if (request.getDispatcherType() != DispatcherType.ERROR && request.getDispatcherType() != DispatcherType.ASYNC) {
                throw new IllegalStateException("Bad Dispatcher Type " + request.getDispatcherType());
            }
            PrintWriter writer = response.getWriter();
            writer.println("DISPATCH: " + request.getDispatcherType().name());
            writer.println("ERROR_PAGE: " + request.getPathInfo());
            writer.println("ERROR_MESSAGE: " + request.getAttribute("javax.servlet.error.message"));
            writer.println("ERROR_CODE: " + request.getAttribute("javax.servlet.error.status_code"));
            writer.println("ERROR_EXCEPTION: " + request.getAttribute("javax.servlet.error.exception"));
            writer.println("ERROR_EXCEPTION_TYPE: " + request.getAttribute("javax.servlet.error.exception_type"));
            writer.println("ERROR_SERVLET: " + request.getAttribute("javax.servlet.error.servlet_name"));
            writer.println("ERROR_REQUEST_URI: " + request.getAttribute("javax.servlet.error.request_uri"));
            writer.println("getParameterMap()= " + request.getParameterMap());
        }
    }

    public static class NotEnoughServlet
    extends HttpServlet
    implements Servlet {
        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            response.setContentLength(1000);
            response.getOutputStream().write("SomeBytes".getBytes(StandardCharsets.UTF_8));
            if (Boolean.parseBoolean(request.getParameter("commit"))) {
                response.flushBuffer();
            }
        }
    }

    public static class DeleteServlet
    extends HttpServlet
    implements Servlet {
        protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            response.getWriter().append("This shouldn't be seen");
            response.sendError(595, "custom delete");
        }
    }

    public static class ErrorAndStatusServlet
    extends HttpServlet
    implements Servlet {
        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            response.sendError(594, "custom get error");
            response.setStatus(200);
        }
    }

    public static class FailClosedServlet
    extends HttpServlet
    implements Servlet {
        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            response.sendError(599);
            try {
                response.setStatus(200);
                response.getWriter().append("This shouldn't be seen");
            }
            catch (Throwable ignore) {
                Log.getLog().ignore(ignore);
            }
        }
    }

    public static class FailServlet
    extends HttpServlet
    implements Servlet {
        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            String code = request.getParameter("code");
            if (code == null) {
                throw new ServletException((Throwable)new IllegalStateException());
            }
            response.sendError(Integer.parseInt(code));
        }
    }

    public static class AsyncSendErrorServlet
    extends HttpServlet
    implements Servlet {
        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            try {
                String mode;
                CountDownLatch hold = new CountDownLatch(1);
                switch (mode = request.getParameter("mode")) {
                    case "DSC": 
                    case "SDC": 
                    case "SCD": {
                        break;
                    }
                    default: {
                        throw new IllegalStateException(mode);
                    }
                }
                boolean lateComplete = "true".equals(request.getParameter("latecomplete"));
                AsyncContext async = request.startAsync();
                async.start(() -> {
                    try {
                        switch (mode) {
                            case "SDC": {
                                response.sendError(599);
                                break;
                            }
                            case "SCD": {
                                response.sendError(599);
                                async.complete();
                                break;
                            }
                        }
                        hold.countDown();
                        while (Request.getBaseRequest((ServletRequest)request).getHttpChannelState().getState() == HttpChannelState.State.HANDLING) {
                            try {
                                Thread.sleep(10L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                        try {
                            switch (mode) {
                                case "DSC": {
                                    response.sendError(599);
                                    async.complete();
                                    return;
                                }
                                case "SDC": {
                                    async.complete();
                                    return;
                                }
                            }
                            return;
                        }
                        catch (IllegalStateException e) {
                            Log.getLog().ignore((Throwable)e);
                            return;
                        }
                        finally {
                            __asyncSendErrorCompleted.countDown();
                        }
                    }
                    catch (IOException e) {
                        Log.getLog().warn((Throwable)e);
                    }
                });
                hold.await();
            }
            catch (InterruptedException e) {
                throw new ServletException((Throwable)e);
            }
        }
    }

    public static class SyncSendErrorServlet
    extends HttpServlet
    implements Servlet {
        public static final AtomicInteger COUNTER = new AtomicInteger();

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            int count = COUNTER.incrementAndGet();
            PrintWriter writer = response.getWriter();
            writer.println("this is the " + count + " time this error page is being accessed");
            response.sendError(597, "loop #" + count);
        }
    }

    public static class LongerAppServlet
    extends HttpServlet
    implements Servlet {
        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            PrintWriter writer = response.getWriter();
            writer.println(request.getRequestURI());
        }
    }

    public static class AppServlet
    extends HttpServlet
    implements Servlet {
        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            request.getRequestDispatcher("/longer.app/").forward((ServletRequest)request, (ServletResponse)response);
        }
    }
}

