/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.DateGenerator;
import org.eclipse.jetty.http.HttpContent;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFieldsMatchers;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpTester;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.ResourceContentFactory;
import org.eclipse.jetty.server.ResourceService;
import org.eclipse.jetty.server.SameFileAliasChecker;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AllowSymLinkAliasChecker;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.FilterMapping;
import org.eclipse.jetty.servlet.NoJspServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.toolchain.test.FS;
import org.eclipse.jetty.toolchain.test.MavenTestingUtils;
import org.eclipse.jetty.toolchain.test.jupiter.WorkDir;
import org.eclipse.jetty.toolchain.test.jupiter.WorkDirExtension;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.log.StacklessLogging;
import org.eclipse.jetty.util.resource.PathResource;
import org.eclipse.jetty.util.resource.Resource;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.OS;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;

@ExtendWith(value={WorkDirExtension.class})
public class DefaultServletTest {
    public WorkDir workDir;
    public Path docRoot;
    private static final String ODD_JAR = "jar-resource-odd.jar";
    private Server server;
    private LocalConnector connector;
    private ServletContextHandler context;

    @BeforeEach
    public void init() throws Exception {
        this.docRoot = this.workDir.getEmptyPathDir().resolve("docroot");
        FS.ensureDirExists((Path)this.docRoot);
        this.server = new Server();
        this.connector = new LocalConnector(this.server);
        ((HttpConfiguration.ConnectionFactory)this.connector.getConnectionFactory(HttpConfiguration.ConnectionFactory.class)).getHttpConfiguration().setSendServerVersion(false);
        File extraJarResources = MavenTestingUtils.getTestResourceFile((String)ODD_JAR);
        URL[] urls = new URL[]{extraJarResources.toURI().toURL()};
        ClassLoader parentClassLoader = Thread.currentThread().getContextClassLoader();
        URLClassLoader extraClassLoader = new URLClassLoader(urls, parentClassLoader);
        this.context = new ServletContextHandler();
        this.context.setBaseResource((Resource)new PathResource(this.docRoot));
        this.context.setContextPath("/context");
        this.context.setWelcomeFiles(new String[]{"index.html", "index.jsp", "index.htm"});
        this.context.setClassLoader((ClassLoader)extraClassLoader);
        this.server.setHandler((Handler)this.context);
        this.server.addConnector((Connector)this.connector);
        this.server.start();
    }

    @AfterEach
    public void destroy() throws Exception {
        this.server.stop();
        this.server.join();
    }

    @Test
    public void testListingWithSession() throws Exception {
        ServletHolder defholder = this.context.addServlet(DefaultServlet.class, "/*");
        defholder.setInitParameter("dirAllowed", "true");
        defholder.setInitParameter("redirectWelcome", "false");
        defholder.setInitParameter("gzip", "false");
        FS.ensureDirExists((Path)this.docRoot.resolve("one"));
        FS.ensureDirExists((Path)this.docRoot.resolve("two"));
        FS.ensureDirExists((Path)this.docRoot.resolve("three"));
        String rawResponse = this.connector.getResponse("GET /context/;JSESSIONID=1234567890 HTTP/1.0\n\n");
        HttpTester.Response response = HttpTester.parseResponse((String)rawResponse);
        String body = response.getContent();
        MatcherAssert.assertThat((Object)body, (org.hamcrest.Matcher)Matchers.containsString((String)"/one/;JSESSIONID=1234567890"));
        MatcherAssert.assertThat((Object)body, (org.hamcrest.Matcher)Matchers.containsString((String)"/two/;JSESSIONID=1234567890"));
        MatcherAssert.assertThat((Object)body, (org.hamcrest.Matcher)Matchers.containsString((String)"/three/;JSESSIONID=1234567890"));
        MatcherAssert.assertThat((Object)body, (org.hamcrest.Matcher)Matchers.not((org.hamcrest.Matcher)Matchers.containsString((String)"<script>")));
    }

    @Test
    public void testListingXSS() throws Exception {
        ServletHolder defholder = this.context.addServlet(DefaultServlet.class, "/*");
        defholder.setInitParameter("dirAllowed", "true");
        defholder.setInitParameter("redirectWelcome", "false");
        defholder.setInitParameter("gzip", "false");
        Path one = this.docRoot.resolve("one");
        FS.ensureDirExists((Path)one);
        FS.ensureDirExists((Path)this.docRoot.resolve("two"));
        FS.ensureDirExists((Path)this.docRoot.resolve("three"));
        Path alert = one.resolve("onmouseclick='alert(oops)'");
        FS.touch((Path)alert);
        String req1 = "GET /context/;<script>window.alert(\"hi\");</script> HTTP/1.0\r\n\r\n";
        String rawResponse = this.connector.getResponse(req1);
        HttpTester.Response response = HttpTester.parseResponse((String)rawResponse);
        String body = response.getContent();
        MatcherAssert.assertThat((Object)body, (org.hamcrest.Matcher)Matchers.not((org.hamcrest.Matcher)Matchers.containsString((String)"<script>")));
        req1 = "GET /context/one/;\"onmouseover='alert(document.location)' HTTP/1.0\r\n\r\n";
        rawResponse = this.connector.getResponse(req1);
        response = HttpTester.parseResponse((String)rawResponse);
        body = response.getContent();
        MatcherAssert.assertThat((Object)body, (org.hamcrest.Matcher)Matchers.not((org.hamcrest.Matcher)Matchers.containsString((String)";\"onmouseover")));
    }

    @Test
    public void testListingWithQuestionMarks() throws Exception {
        ServletHolder defholder = this.context.addServlet(DefaultServlet.class, "/*");
        defholder.setInitParameter("dirAllowed", "true");
        defholder.setInitParameter("redirectWelcome", "false");
        defholder.setInitParameter("gzip", "false");
        FS.ensureDirExists((Path)this.docRoot.resolve("one"));
        FS.ensureDirExists((Path)this.docRoot.resolve("two"));
        FS.ensureDirExists((Path)this.docRoot.resolve("three"));
        DefaultServletTest.assumeMkDirSupported(this.docRoot, "f??r");
        String rawResponse = this.connector.getResponse("GET /context/ HTTP/1.0\r\n\r\n");
        HttpTester.Response response = HttpTester.parseResponse((String)rawResponse);
        String body = response.getContent();
        MatcherAssert.assertThat((Object)body, (org.hamcrest.Matcher)Matchers.containsString((String)"f??r"));
    }

    @Test
    public void testListingFilenamesOnly() throws Exception {
        ServletHolder defholder = this.context.addServlet(DefaultServlet.class, "/*");
        defholder.setInitParameter("dirAllowed", "true");
        defholder.setInitParameter("redirectWelcome", "false");
        defholder.setInitParameter("gzip", "false");
        FS.ensureDirExists((Path)this.docRoot);
        Path one = this.docRoot.resolve("one");
        FS.ensureDirExists((Path)one);
        Path deep = one.resolve("deep");
        FS.ensureDirExists((Path)deep);
        FS.touch((Path)deep.resolve("foo"));
        FS.ensureDirExists((Path)this.docRoot.resolve("two"));
        FS.ensureDirExists((Path)this.docRoot.resolve("three"));
        String resBasePath = this.docRoot.toAbsolutePath().toString();
        defholder.setInitParameter("resourceBase", resBasePath);
        StringBuffer req1 = new StringBuffer();
        req1.append("GET /context/one/deep/ HTTP/1.0\n");
        req1.append("\n");
        String rawResponse = this.connector.getResponse(req1.toString());
        HttpTester.Response response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)200));
        String body = response.getContent();
        MatcherAssert.assertThat((Object)body, (org.hamcrest.Matcher)Matchers.containsString((String)"/foo"));
        MatcherAssert.assertThat((Object)body, (org.hamcrest.Matcher)Matchers.not((org.hamcrest.Matcher)Matchers.containsString((String)resBasePath)));
    }

    @Test
    public void testListingFilenamesOnlyUrlResource() throws Exception {
        URL extraResource = this.context.getClassLoader().getResource("rez/one");
        Assertions.assertNotNull((Object)extraResource, (String)"Must have extra jar resource in classloader");
        String extraResourceBaseString = extraResource.toURI().toASCIIString();
        extraResourceBaseString = extraResourceBaseString.substring(0, extraResourceBaseString.length() - "/one".length());
        ServletHolder defholder = this.context.addServlet(DefaultServlet.class, "/extra/*");
        defholder.setInitParameter("resourceBase", extraResourceBaseString);
        defholder.setInitParameter("pathInfoOnly", "true");
        defholder.setInitParameter("dirAllowed", "true");
        defholder.setInitParameter("redirectWelcome", "false");
        defholder.setInitParameter("gzip", "false");
        StringBuffer req1 = new StringBuffer();
        req1.append("GET /context/extra/one HTTP/1.0\n");
        req1.append("\n");
        String rawResponse = this.connector.getResponse(req1.toString());
        HttpTester.Response response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)200));
        String body = response.getContent();
        MatcherAssert.assertThat((Object)body, (org.hamcrest.Matcher)Matchers.containsString((String)"is this the one?"));
        req1 = new StringBuffer();
        req1.append("GET /context/extra/deep/ HTTP/1.0\r\n");
        req1.append("\r\n");
        rawResponse = this.connector.getResponse(req1.toString());
        response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)200));
        body = response.getContent();
        MatcherAssert.assertThat((Object)body, (org.hamcrest.Matcher)Matchers.containsString((String)"/xxx"));
        MatcherAssert.assertThat((Object)body, (org.hamcrest.Matcher)Matchers.containsString((String)"/yyy"));
        MatcherAssert.assertThat((Object)body, (org.hamcrest.Matcher)Matchers.containsString((String)"/zzz"));
        MatcherAssert.assertThat((Object)body, (org.hamcrest.Matcher)Matchers.not((org.hamcrest.Matcher)Matchers.containsString((String)extraResourceBaseString)));
        MatcherAssert.assertThat((Object)body, (org.hamcrest.Matcher)Matchers.not((org.hamcrest.Matcher)Matchers.containsString((String)ODD_JAR)));
        req1 = new StringBuffer();
        req1.append("GET /context/extra/deep/yyy HTTP/1.0\r\n");
        req1.append("\r\n");
        rawResponse = this.connector.getResponse(req1.toString());
        response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)200));
        body = response.getContent();
        MatcherAssert.assertThat((Object)body, (org.hamcrest.Matcher)Matchers.containsString((String)"a file named yyy"));
        req1 = new StringBuffer();
        req1.append("GET /context/extra/oddities/ HTTP/1.0\r\n");
        req1.append("\r\n");
        rawResponse = this.connector.getResponse(req1.toString());
        response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)200));
        body = response.getContent();
        MatcherAssert.assertThat((Object)body, (org.hamcrest.Matcher)Matchers.containsString((String)">#hashcode&nbsp;<"));
        MatcherAssert.assertThat((Object)body, (org.hamcrest.Matcher)Matchers.containsString((String)"/oddities/%23hashcode"));
        MatcherAssert.assertThat((Object)body, (org.hamcrest.Matcher)Matchers.containsString((String)">other%2fkind%2Fof%2fslash&nbsp;<"));
        MatcherAssert.assertThat((Object)body, (org.hamcrest.Matcher)Matchers.containsString((String)"/oddities/other%252fkind%252Fof%252fslash"));
        MatcherAssert.assertThat((Object)body, (org.hamcrest.Matcher)Matchers.containsString((String)">a file with a space&nbsp;<"));
        MatcherAssert.assertThat((Object)body, (org.hamcrest.Matcher)Matchers.containsString((String)"/oddities/a%20file%20with%20a%20space"));
        MatcherAssert.assertThat((Object)body, (org.hamcrest.Matcher)Matchers.not((org.hamcrest.Matcher)Matchers.containsString((String)extraResourceBaseString)));
        MatcherAssert.assertThat((Object)body, (org.hamcrest.Matcher)Matchers.not((org.hamcrest.Matcher)Matchers.containsString((String)ODD_JAR)));
    }

    @Test
    public void testListingProperUrlEncoding() throws Exception {
        ServletHolder defholder = this.context.addServlet(DefaultServlet.class, "/*");
        defholder.setInitParameter("dirAllowed", "true");
        defholder.setInitParameter("redirectWelcome", "false");
        defholder.setInitParameter("gzip", "false");
        Path wackyDir = this.docRoot.resolve("dir;");
        FS.ensureDirExists((Path)wackyDir);
        FS.ensureDirExists((Path)wackyDir.resolve("four"));
        FS.ensureDirExists((Path)wackyDir.resolve("five"));
        FS.ensureDirExists((Path)wackyDir.resolve("six"));
        String rawResponse = this.connector.getResponse("GET /context/dir;/ HTTP/1.0\r\n\r\n");
        HttpTester.Response response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)404));
        rawResponse = this.connector.getResponse("GET /context/dir%3B/ HTTP/1.0\r\n\r\n");
        response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)200));
        String body = response.getContent();
        MatcherAssert.assertThat((Object)body, (org.hamcrest.Matcher)Matchers.not((org.hamcrest.Matcher)Matchers.containsString((String)"%253B")));
        MatcherAssert.assertThat((Object)body, (org.hamcrest.Matcher)Matchers.containsString((String)"/dir%3B/"));
        MatcherAssert.assertThat((Object)body, (org.hamcrest.Matcher)Matchers.containsString((String)"/dir%3B/four/"));
        MatcherAssert.assertThat((Object)body, (org.hamcrest.Matcher)Matchers.containsString((String)"/dir%3B/five/"));
        MatcherAssert.assertThat((Object)body, (org.hamcrest.Matcher)Matchers.containsString((String)"/dir%3B/six/"));
    }

    public static Stream<Arguments> contextBreakoutScenarios() {
        Scenarios scenarios = new Scenarios();
        scenarios.addScenario("GET normal", "GET /context/ HTTP/1.0\r\n\r\n", 200, response -> MatcherAssert.assertThat((Object)response.getContent(), (org.hamcrest.Matcher)Matchers.containsString((String)"<h1>Hello Index</h1>")));
        scenarios.addScenario("GET /context/index.html", "GET /context/index.html HTTP/1.0\r\n\r\n", 200, response -> MatcherAssert.assertThat((Object)response.getContent(), (org.hamcrest.Matcher)Matchers.containsString((String)"Hello Index")));
        ArrayList<String> notEncodedPrefixes = new ArrayList<String>();
        if (!OS.WINDOWS.isCurrentOs()) {
            notEncodedPrefixes.add("/context/dir?");
        }
        notEncodedPrefixes.add("/context/dir;");
        for (String prefix : notEncodedPrefixes) {
            scenarios.addScenario("GET " + prefix, "GET " + prefix + " HTTP/1.0\r\n\r\n", 404);
            scenarios.addScenario("GET " + prefix + "/", "GET " + prefix + "/ HTTP/1.0\r\n\r\n", 404);
            scenarios.addScenario("GET " + prefix + "/../../sekret/pass", "GET " + prefix + "/../../sekret/pass HTTP/1.0\r\n\r\n", 404, response -> MatcherAssert.assertThat((Object)response.getContent(), (org.hamcrest.Matcher)Matchers.not((org.hamcrest.Matcher)Matchers.containsString((String)"Sssh"))));
            scenarios.addScenario("GET " + prefix + "/%2E%2E/%2E%2E/sekret/pass", "GET " + prefix + "/ HTTP/1.0\r\n\r\n", 404, response -> MatcherAssert.assertThat((Object)response.getContent(), (org.hamcrest.Matcher)Matchers.not((org.hamcrest.Matcher)Matchers.containsString((String)"Sssh"))));
            if (prefix.contains("?")) {
                scenarios.addScenario("GET " + prefix + "/../index.html", "GET " + prefix + "/../index.html HTTP/1.0\r\n\r\n", 404);
                scenarios.addScenario("GET " + prefix + "/%2E%2E/index.html", "GET " + prefix + "/%2E%2E/index.html HTTP/1.0\r\n\r\n", 404);
            } else {
                scenarios.addScenario("GET " + prefix + "/../index.html", "GET " + prefix + "/../index.html HTTP/1.0\r\n\r\n", 200, response -> MatcherAssert.assertThat((Object)response.getContent(), (org.hamcrest.Matcher)Matchers.containsString((String)"Hello Index")));
                scenarios.addScenario("GET " + prefix + "/%2E%2E/index.html", "GET " + prefix + "/%2E%2E/index.html HTTP/1.0\r\n\r\n", 200, response -> MatcherAssert.assertThat((Object)response.getContent(), (org.hamcrest.Matcher)Matchers.containsString((String)"Hello Index")));
            }
            scenarios.addScenario("GET " + prefix + "/../../", "GET " + prefix + "/../../ HTTP/1.0\r\n\r\n", 404, response -> {
                String body = response.getContent();
                MatcherAssert.assertThat((Object)body, (org.hamcrest.Matcher)Matchers.not((org.hamcrest.Matcher)Matchers.containsString((String)"Directory: ")));
            });
        }
        ArrayList<String> encodedPrefixes = new ArrayList<String>();
        if (!OS.WINDOWS.isCurrentOs()) {
            encodedPrefixes.add("/context/dir%3F");
        }
        encodedPrefixes.add("/context/dir%3B");
        for (String prefix : encodedPrefixes) {
            scenarios.addScenario("GET " + prefix, "GET " + prefix + " HTTP/1.0\r\n\r\n", 302, response -> MatcherAssert.assertThat((String)"Location header", (Object)response.get(HttpHeader.LOCATION), (org.hamcrest.Matcher)Matchers.endsWith((String)(prefix + "/"))));
            scenarios.addScenario("GET " + prefix + "/", "GET " + prefix + "/ HTTP/1.0\r\n\r\n", 200);
            scenarios.addScenario("GET " + prefix + "/.%2E/.%2E/sekret/pass", "GET " + prefix + "/ HTTP/1.0\r\n\r\n", 200, response -> MatcherAssert.assertThat((Object)response.getContent(), (org.hamcrest.Matcher)Matchers.not((org.hamcrest.Matcher)Matchers.containsString((String)"Sssh"))));
            scenarios.addScenario("GET " + prefix + "/../index.html", "GET " + prefix + "/../index.html HTTP/1.0\r\n\r\n", 200, response -> MatcherAssert.assertThat((Object)response.getContent(), (org.hamcrest.Matcher)Matchers.containsString((String)"Hello Index")));
            scenarios.addScenario("GET " + prefix + "/../../", "GET " + prefix + "/../../ HTTP/1.0\r\n\r\n", 404, response -> {
                String body = response.getContent();
                MatcherAssert.assertThat((Object)body, (org.hamcrest.Matcher)Matchers.containsString((String)"/../../"));
                MatcherAssert.assertThat((Object)body, (org.hamcrest.Matcher)Matchers.not((org.hamcrest.Matcher)Matchers.containsString((String)"Directory: ")));
            });
            scenarios.addScenario("GET " + prefix + "/../../sekret/pass", "GET " + prefix + "/../../sekret/pass HTTP/1.0\r\n\r\n", 404, response -> MatcherAssert.assertThat((Object)response.getContent(), (org.hamcrest.Matcher)Matchers.not((org.hamcrest.Matcher)Matchers.containsString((String)"Sssh"))));
            scenarios.addScenario("GET " + prefix + "/../index.html", "GET " + prefix + "/../index.html HTTP/1.0\r\n\r\n", 200, response -> MatcherAssert.assertThat((Object)response.getContent(), (org.hamcrest.Matcher)Matchers.containsString((String)"Hello Index")));
        }
        return scenarios.stream();
    }

    @ParameterizedTest
    @MethodSource(value={"contextBreakoutScenarios"})
    public void testListingContextBreakout(Scenario scenario) throws Exception {
        ServletHolder defholder = this.context.addServlet(DefaultServlet.class, "/");
        defholder.setInitParameter("dirAllowed", "true");
        defholder.setInitParameter("redirectWelcome", "false");
        defholder.setInitParameter("gzip", "false");
        defholder.setInitParameter("aliases", "true");
        Path index = this.docRoot.resolve("index.html");
        this.createFile(index, "<h1>Hello Index</h1>");
        if (!OS.WINDOWS.isCurrentOs()) {
            DefaultServletTest.assumeMkDirSupported(this.docRoot, "dir?");
        }
        DefaultServletTest.assumeMkDirSupported(this.docRoot, "dir;");
        Path sekret = this.workDir.getPath().resolve("sekret");
        FS.ensureDirExists((Path)sekret);
        Path pass = sekret.resolve("pass");
        this.createFile(pass, "Sssh, you shouldn't be seeing this");
        String rawResponse = this.connector.getResponse(scenario.rawRequest);
        HttpTester.Response response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)scenario.expectedStatus));
        if (scenario.extraAsserts != null) {
            scenario.extraAsserts.accept(response);
        }
    }

    private static void addBasicWelcomeScenarios(Scenarios scenarios) {
        scenarios.addScenario("GET /context/one/ (index.htm match)", "GET /context/one/ HTTP/1.0\r\n\r\n", 200, response -> MatcherAssert.assertThat((Object)response.getContent(), (org.hamcrest.Matcher)Matchers.containsString((String)"<h1>Hello Inde</h1>")));
        scenarios.addScenario("GET /context/two/ (index.html match)", "GET /context/two/ HTTP/1.0\r\n\r\n", 200, response -> MatcherAssert.assertThat((Object)response.getContent(), (org.hamcrest.Matcher)Matchers.containsString((String)"<h1>Hello Index</h1>")));
        scenarios.addScenario("GET /context/three/ (index.html wins over index.htm)", "GET /context/three/ HTTP/1.0\r\n\r\n", 200, response -> MatcherAssert.assertThat((Object)response.getContent(), (org.hamcrest.Matcher)Matchers.containsString((String)"<h1>Three Index</h1>")));
    }

    public static Stream<Arguments> welcomeScenarios() {
        Scenarios scenarios = new Scenarios();
        scenarios.addScenario("GET /context/ - (no match)", "GET /context/ HTTP/1.0\r\n\r\n", 403);
        DefaultServletTest.addBasicWelcomeScenarios(scenarios);
        return scenarios.stream();
    }

    @ParameterizedTest
    @MethodSource(value={"welcomeScenarios"})
    public void testWelcome(Scenario scenario) throws Exception {
        Path one = this.docRoot.resolve("one");
        Path two = this.docRoot.resolve("two");
        Path three = this.docRoot.resolve("three");
        FS.ensureDirExists((Path)one);
        FS.ensureDirExists((Path)two);
        FS.ensureDirExists((Path)three);
        this.createFile(one.resolve("index.htm"), "<h1>Hello Inde</h1>");
        this.createFile(two.resolve("index.html"), "<h1>Hello Index</h1>");
        this.createFile(three.resolve("index.html"), "<h1>Three Index</h1>");
        this.createFile(three.resolve("index.htm"), "<h1>Three Inde</h1>");
        ServletHolder defholder = this.context.addServlet(DefaultServlet.class, "/");
        defholder.setInitParameter("dirAllowed", "false");
        defholder.setInitParameter("redirectWelcome", "false");
        defholder.setInitParameter("welcomeServlets", "false");
        defholder.setInitParameter("gzip", "false");
        defholder.setInitParameter("maxCacheSize", "1024000");
        defholder.setInitParameter("maxCachedFileSize", "512000");
        defholder.setInitParameter("maxCachedFiles", "100");
        ServletHolder jspholder = this.context.addServlet(NoJspServlet.class, "*.jsp");
        this.context.addServlet(jspholder, "/index.jsp");
        String rawResponse = this.connector.getResponse(scenario.rawRequest);
        HttpTester.Response response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)scenario.expectedStatus));
        if (scenario.extraAsserts != null) {
            scenario.extraAsserts.accept(response);
        }
    }

    @Test
    public void testWelcomeMultipleBasesBase() throws Exception {
        Path dir = this.docRoot.resolve("dir");
        FS.ensureDirExists((Path)dir);
        Path inde = dir.resolve("index.htm");
        Path index = dir.resolve("index.html");
        Path altRoot = this.workDir.getPath().resolve("altroot");
        Path altDir = altRoot.resolve("dir");
        FS.ensureDirExists((Path)altDir);
        Path altInde = altDir.resolve("index.htm");
        Path altIndex = altDir.resolve("index.html");
        ServletHolder altholder = this.context.addServlet(DefaultServlet.class, "/alt/*");
        altholder.setInitParameter("resourceBase", altRoot.toUri().toASCIIString());
        altholder.setInitParameter("pathInfoOnly", "true");
        altholder.setInitParameter("dirAllowed", "false");
        altholder.setInitParameter("redirectWelcome", "false");
        altholder.setInitParameter("welcomeServlets", "false");
        altholder.setInitParameter("gzip", "false");
        ServletHolder otherholder = this.context.addServlet(DefaultServlet.class, "/other/*");
        otherholder.setInitParameter("resourceBase", altRoot.toUri().toASCIIString());
        otherholder.setInitParameter("pathInfoOnly", "true");
        otherholder.setInitParameter("dirAllowed", "true");
        otherholder.setInitParameter("redirectWelcome", "false");
        otherholder.setInitParameter("welcomeServlets", "false");
        otherholder.setInitParameter("gzip", "false");
        ServletHolder defholder = this.context.addServlet(DefaultServlet.class, "/");
        defholder.setInitParameter("dirAllowed", "false");
        defholder.setInitParameter("redirectWelcome", "false");
        defholder.setInitParameter("welcomeServlets", "false");
        defholder.setInitParameter("gzip", "false");
        ServletHolder jspholder = this.context.addServlet(NoJspServlet.class, "*.jsp");
        String rawResponse = this.connector.getResponse("GET /context/other HTTP/1.0\r\n\r\n");
        HttpTester.Response response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)302));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((String)"Location", (String)"http://0.0.0.0/context/other/"));
        rawResponse = this.connector.getResponse("GET /context/alt/dir/ HTTP/1.0\r\n\r\n");
        response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)403));
        this.createFile(altIndex, "<h1>Alt Index</h1>");
        rawResponse = this.connector.getResponse("GET /context/alt/dir/index.html HTTP/1.0\r\n\r\n");
        response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response.getContent(), (org.hamcrest.Matcher)Matchers.containsString((String)"<h1>Alt Index</h1>"));
        rawResponse = this.connector.getResponse("GET /context/alt/dir/ HTTP/1.0\r\n\r\n");
        response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response.getContent(), (org.hamcrest.Matcher)Matchers.containsString((String)"<h1>Alt Index</h1>"));
        this.createFile(altInde, "<h1>Alt Inde</h1>");
        rawResponse = this.connector.getResponse("GET /context/alt/dir/ HTTP/1.0\r\n\r\n");
        response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response.getContent(), (org.hamcrest.Matcher)Matchers.containsString((String)"<h1>Alt Index</h1>"));
        if (this.deleteFile(altIndex)) {
            rawResponse = this.connector.getResponse("GET /context/alt/dir/ HTTP/1.0\r\n\r\n");
            response = HttpTester.parseResponse((String)rawResponse);
            MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)200));
            MatcherAssert.assertThat((Object)response.getContent(), (org.hamcrest.Matcher)Matchers.containsString((String)"<h1>Alt Inde</h1>"));
            if (this.deleteFile(altInde)) {
                rawResponse = this.connector.getResponse("GET /context/alt/dir/ HTTP/1.0\r\n\r\n");
                response = HttpTester.parseResponse((String)rawResponse);
                MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)403));
            }
        }
        rawResponse = this.connector.getResponse("GET /context/dir/ HTTP/1.0\r\n\r\n");
        response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)403));
        this.createFile(index, "<h1>Hello Index</h1>");
        rawResponse = this.connector.getResponse("GET /context/dir/ HTTP/1.0\r\n\r\n");
        response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response.getContent(), (org.hamcrest.Matcher)Matchers.containsString((String)"<h1>Hello Index</h1>"));
        this.createFile(inde, "<h1>Hello Inde</h1>");
        rawResponse = this.connector.getResponse("GET /context/dir/ HTTP/1.0\r\n\r\n");
        response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response.getContent(), (org.hamcrest.Matcher)Matchers.containsString((String)"<h1>Hello Index</h1>"));
        if (this.deleteFile(index)) {
            rawResponse = this.connector.getResponse("GET /context/dir/ HTTP/1.0\r\n\r\n");
            response = HttpTester.parseResponse((String)rawResponse);
            MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)200));
            MatcherAssert.assertThat((Object)response.getContent(), (org.hamcrest.Matcher)Matchers.containsString((String)"<h1>Hello Inde</h1>"));
            if (this.deleteFile(inde)) {
                rawResponse = this.connector.getResponse("GET /context/dir/ HTTP/1.0\r\n\r\n");
                response = HttpTester.parseResponse((String)rawResponse);
                MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)403));
            }
        }
    }

    @Test
    public void testIncludedWelcomeDifferentBase() throws Exception {
        Path altRoot = this.workDir.getPath().resolve("altroot");
        FS.ensureDirExists((Path)altRoot);
        Path altIndex = altRoot.resolve("index.html");
        ServletHolder defholder = this.context.addServlet(DefaultServlet.class, "/alt/*");
        defholder.setInitParameter("resourceBase", altRoot.toUri().toASCIIString());
        defholder.setInitParameter("dirAllowed", "false");
        defholder.setInitParameter("redirectWelcome", "false");
        defholder.setInitParameter("welcomeServlets", "true");
        defholder.setInitParameter("pathInfoOnly", "true");
        ServletHolder gwholder = new ServletHolder("gateway", (Servlet)new HttpServlet(){

            protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                req.getRequestDispatcher("/alt/").include((ServletRequest)req, (ServletResponse)resp);
            }
        });
        this.context.addServlet(gwholder, "/gateway");
        String rawResponse = this.connector.getResponse("GET /context/gateway HTTP/1.0\r\n\r\n");
        HttpTester.Response response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)500));
        this.createFile(altIndex, "<h1>Alt Index</h1>");
        rawResponse = this.connector.getResponse("GET /context/gateway HTTP/1.0\r\n\r\n");
        response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response.getContent(), (org.hamcrest.Matcher)Matchers.containsString((String)"<h1>Alt Index</h1>"));
    }

    @Test
    public void testWelcomeRedirect() throws Exception {
        Path dir = this.docRoot.resolve("dir");
        FS.ensureDirExists((Path)dir);
        Path inde = dir.resolve("index.htm");
        Path index = dir.resolve("index.html");
        ServletHolder defholder = this.context.addServlet(DefaultServlet.class, "/");
        defholder.setInitParameter("dirAllowed", "false");
        defholder.setInitParameter("redirectWelcome", "true");
        defholder.setInitParameter("welcomeServlets", "false");
        defholder.setInitParameter("gzip", "false");
        defholder.setInitParameter("maxCacheSize", "1024000");
        defholder.setInitParameter("maxCachedFileSize", "512000");
        defholder.setInitParameter("maxCachedFiles", "100");
        ServletHolder jspholder = this.context.addServlet(NoJspServlet.class, "*.jsp");
        String rawResponse = this.connector.getResponse("GET /context/dir/ HTTP/1.0\r\n\r\n");
        HttpTester.Response response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)403));
        this.createFile(index, "<h1>Hello Index</h1>");
        rawResponse = this.connector.getResponse("GET /context/dir/ HTTP/1.0\r\n\r\n");
        response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)302));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((String)"Location", (String)"http://0.0.0.0/context/dir/index.html"));
        this.createFile(inde, "<h1>Hello Inde</h1>");
        rawResponse = this.connector.getResponse("GET /context/dir/ HTTP/1.0\r\n\r\n");
        response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)302));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((String)"Location", (String)"http://0.0.0.0/context/dir/index.html"));
        if (this.deleteFile(index)) {
            rawResponse = this.connector.getResponse("GET /context/dir/ HTTP/1.0\r\n\r\n");
            response = HttpTester.parseResponse((String)rawResponse);
            MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)302));
            MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((String)"Location", (String)"http://0.0.0.0/context/dir/index.htm"));
            if (this.deleteFile(inde)) {
                rawResponse = this.connector.getResponse("GET /context/dir/ HTTP/1.0\r\n\r\n");
                response = HttpTester.parseResponse((String)rawResponse);
                MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)403));
            }
        }
    }

    @Test
    public void testWelcomeRedirectDirWithQuestion() throws Exception {
        FS.ensureDirExists((Path)this.docRoot);
        this.context.setBaseResource((Resource)new PathResource(this.docRoot));
        Path dir = DefaultServletTest.assumeMkDirSupported(this.docRoot, "dir?");
        Path index = dir.resolve("index.html");
        this.createFile(index, "<h1>Hello Index</h1>");
        ServletHolder defholder = this.context.addServlet(DefaultServlet.class, "/");
        defholder.setInitParameter("dirAllowed", "false");
        defholder.setInitParameter("redirectWelcome", "true");
        defholder.setInitParameter("welcomeServlets", "false");
        defholder.setInitParameter("gzip", "false");
        String rawResponse = this.connector.getResponse("GET /context/dir%3F HTTP/1.0\r\n\r\n");
        HttpTester.Response response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)302));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((String)"Location", (String)"http://0.0.0.0/context/dir%3F/"));
        rawResponse = this.connector.getResponse("GET /context/dir%3F/ HTTP/1.0\r\n\r\n");
        response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)302));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((String)"Location", (String)"http://0.0.0.0/context/dir%3F/index.html"));
    }

    @Test
    public void testWelcomeRedirectDirWithSemicolon() throws Exception {
        FS.ensureDirExists((Path)this.docRoot);
        this.context.setBaseResource((Resource)new PathResource(this.docRoot));
        Path dir = DefaultServletTest.assumeMkDirSupported(this.docRoot, "dir;");
        Path index = dir.resolve("index.html");
        this.createFile(index, "<h1>Hello Index</h1>");
        ServletHolder defholder = this.context.addServlet(DefaultServlet.class, "/");
        defholder.setInitParameter("dirAllowed", "false");
        defholder.setInitParameter("redirectWelcome", "true");
        defholder.setInitParameter("welcomeServlets", "false");
        defholder.setInitParameter("gzip", "false");
        String rawResponse = this.connector.getResponse("GET /context/dir%3B HTTP/1.0\r\n\r\n");
        HttpTester.Response response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)302));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((String)"Location", (String)"http://0.0.0.0/context/dir%3B/"));
        rawResponse = this.connector.getResponse("GET /context/dir%3B/ HTTP/1.0\r\n\r\n");
        response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)302));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((String)"Location", (String)"http://0.0.0.0/context/dir%3B/index.html"));
    }

    @Test
    public void testWelcomeServlet() throws Exception {
        Path inde = this.docRoot.resolve("index.htm");
        Path index = this.docRoot.resolve("index.html");
        ServletHolder defholder = this.context.addServlet(DefaultServlet.class, "/");
        defholder.setInitParameter("dirAllowed", "false");
        defholder.setInitParameter("redirectWelcome", "false");
        defholder.setInitParameter("welcomeServlets", "true");
        defholder.setInitParameter("gzip", "false");
        ServletHolder jspholder = this.context.addServlet(NoJspServlet.class, "*.jsp");
        String rawResponse = this.connector.getResponse("GET /context/ HTTP/1.0\r\n\r\n");
        HttpTester.Response response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)500));
        MatcherAssert.assertThat((Object)response.getContent(), (org.hamcrest.Matcher)Matchers.containsString((String)"JSP support not configured"));
        this.createFile(index, "<h1>Hello Index</h1>");
        rawResponse = this.connector.getResponse("GET /context/ HTTP/1.0\r\n\r\n");
        response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response.getContent(), (org.hamcrest.Matcher)Matchers.containsString((String)"<h1>Hello Index</h1>"));
        this.createFile(inde, "<h1>Hello Inde</h1>");
        rawResponse = this.connector.getResponse("GET /context/ HTTP/1.0\r\n\r\n");
        response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response.getContent(), (org.hamcrest.Matcher)Matchers.containsString((String)"<h1>Hello Index</h1>"));
        if (this.deleteFile(index)) {
            rawResponse = this.connector.getResponse("GET /context/ HTTP/1.0\r\n\r\n");
            response = HttpTester.parseResponse((String)rawResponse);
            MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)200));
            MatcherAssert.assertThat((Object)response.getContent(), (org.hamcrest.Matcher)Matchers.containsString((String)"<h1>Hello Inde</h1>"));
            if (this.deleteFile(inde)) {
                rawResponse = this.connector.getResponse("GET /context/ HTTP/1.0\r\n\r\n");
                response = HttpTester.parseResponse((String)rawResponse);
                MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)500));
                MatcherAssert.assertThat((Object)response.getContent(), (org.hamcrest.Matcher)Matchers.containsString((String)"JSP support not configured"));
            }
        }
    }

    @Test
    public void testSymLinks() throws Exception {
        FS.ensureDirExists((Path)this.docRoot);
        Path dir = this.docRoot.resolve("dir");
        Path dirLink = this.docRoot.resolve("dirlink");
        Path dirRLink = this.docRoot.resolve("dirrlink");
        FS.ensureDirExists((Path)dir);
        Path foobar = dir.resolve("foobar.txt");
        Path link = dir.resolve("link.txt");
        Path rLink = dir.resolve("rlink.txt");
        this.createFile(foobar, "Foo Bar");
        ServletHolder defholder = this.context.addServlet(DefaultServlet.class, "/");
        defholder.setInitParameter("gzip", "false");
        String rawResponse = this.connector.getResponse("GET /context/dir/foobar.txt HTTP/1.0\r\n\r\n");
        HttpTester.Response response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response.getContent(), (org.hamcrest.Matcher)Matchers.containsString((String)"Foo Bar"));
        if (!OS.WINDOWS.isCurrentOs()) {
            this.context.clearAliasChecks();
            Files.createSymbolicLink(dirLink, dir, new FileAttribute[0]);
            Files.createSymbolicLink(dirRLink, new File("dir").toPath(), new FileAttribute[0]);
            Files.createSymbolicLink(link, foobar, new FileAttribute[0]);
            Files.createSymbolicLink(rLink, new File("foobar.txt").toPath(), new FileAttribute[0]);
            rawResponse = this.connector.getResponse("GET /context/dir/link.txt HTTP/1.0\r\n\r\n");
            response = HttpTester.parseResponse((String)rawResponse);
            MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)404));
            rawResponse = this.connector.getResponse("GET /context/dir/rlink.txt HTTP/1.0\r\n\r\n");
            response = HttpTester.parseResponse((String)rawResponse);
            MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)404));
            rawResponse = this.connector.getResponse("GET /context/dirlink/foobar.txt HTTP/1.0\r\n\r\n");
            response = HttpTester.parseResponse((String)rawResponse);
            MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)404));
            rawResponse = this.connector.getResponse("GET /context/dirrlink/foobar.txt HTTP/1.0\r\n\r\n");
            response = HttpTester.parseResponse((String)rawResponse);
            MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)404));
            rawResponse = this.connector.getResponse("GET /context/dirlink/link.txt HTTP/1.0\r\n\r\n");
            response = HttpTester.parseResponse((String)rawResponse);
            MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)404));
            rawResponse = this.connector.getResponse("GET /context/dirrlink/rlink.txt HTTP/1.0\r\n\r\n");
            response = HttpTester.parseResponse((String)rawResponse);
            MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)404));
            this.context.addAliasCheck((ContextHandler.AliasCheck)new AllowSymLinkAliasChecker());
            rawResponse = this.connector.getResponse("GET /context/dir/link.txt HTTP/1.0\r\n\r\n");
            response = HttpTester.parseResponse((String)rawResponse);
            MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)200));
            MatcherAssert.assertThat((Object)response.getContent(), (org.hamcrest.Matcher)Matchers.containsString((String)"Foo Bar"));
            rawResponse = this.connector.getResponse("GET /context/dir/rlink.txt HTTP/1.0\r\n\r\n");
            response = HttpTester.parseResponse((String)rawResponse);
            MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)200));
            MatcherAssert.assertThat((Object)response.getContent(), (org.hamcrest.Matcher)Matchers.containsString((String)"Foo Bar"));
            rawResponse = this.connector.getResponse("GET /context/dirlink/foobar.txt HTTP/1.0\r\n\r\n");
            response = HttpTester.parseResponse((String)rawResponse);
            MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)200));
            MatcherAssert.assertThat((Object)response.getContent(), (org.hamcrest.Matcher)Matchers.containsString((String)"Foo Bar"));
            rawResponse = this.connector.getResponse("GET /context/dirrlink/foobar.txt HTTP/1.0\r\n\r\n");
            response = HttpTester.parseResponse((String)rawResponse);
            MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)200));
            MatcherAssert.assertThat((Object)response.getContent(), (org.hamcrest.Matcher)Matchers.containsString((String)"Foo Bar"));
            rawResponse = this.connector.getResponse("GET /context/dirlink/link.txt HTTP/1.0\r\n\r\n");
            response = HttpTester.parseResponse((String)rawResponse);
            MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)200));
            MatcherAssert.assertThat((Object)response.getContent(), (org.hamcrest.Matcher)Matchers.containsString((String)"Foo Bar"));
            rawResponse = this.connector.getResponse("GET /context/dirrlink/link.txt HTTP/1.0\r\n\r\n");
            response = HttpTester.parseResponse((String)rawResponse);
            MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)200));
            MatcherAssert.assertThat((Object)response.getContent(), (org.hamcrest.Matcher)Matchers.containsString((String)"Foo Bar"));
        }
    }

    public static Stream<Arguments> welcomeServletScenarios() {
        Scenarios scenarios = new Scenarios();
        scenarios.addScenario("GET /context/ - (/index.jsp servlet match)", "GET /context/ HTTP/1.0\r\n\r\n", 500, response -> MatcherAssert.assertThat((Object)response.getContent(), (org.hamcrest.Matcher)Matchers.containsString((String)"JSP support not configured")));
        DefaultServletTest.addBasicWelcomeScenarios(scenarios);
        return scenarios.stream();
    }

    @ParameterizedTest
    @MethodSource(value={"welcomeServletScenarios"})
    public void testWelcomeExactServlet(Scenario scenario) throws Exception {
        FS.ensureDirExists((Path)this.docRoot);
        Path one = this.docRoot.resolve("one");
        Path two = this.docRoot.resolve("two");
        Path three = this.docRoot.resolve("three");
        FS.ensureDirExists((Path)one);
        FS.ensureDirExists((Path)two);
        FS.ensureDirExists((Path)three);
        this.createFile(one.resolve("index.htm"), "<h1>Hello Inde</h1>");
        this.createFile(two.resolve("index.html"), "<h1>Hello Index</h1>");
        this.createFile(three.resolve("index.html"), "<h1>Three Index</h1>");
        this.createFile(three.resolve("index.htm"), "<h1>Three Inde</h1>");
        ServletHolder defholder = this.context.addServlet(DefaultServlet.class, "/");
        defholder.setInitParameter("dirAllowed", "false");
        defholder.setInitParameter("redirectWelcome", "false");
        defholder.setInitParameter("welcomeServlets", "exact");
        defholder.setInitParameter("gzip", "false");
        ServletHolder jspholder = this.context.addServlet(NoJspServlet.class, "*.jsp");
        this.context.addServlet(jspholder, "/index.jsp");
        String rawResponse = this.connector.getResponse(scenario.rawRequest);
        HttpTester.Response response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)scenario.expectedStatus));
        if (scenario.extraAsserts != null) {
            scenario.extraAsserts.accept(response);
        }
    }

    @Test
    public void testDirectFromResourceHttpContent() throws Exception {
        FS.ensureDirExists((Path)this.docRoot);
        this.context.setBaseResource(Resource.newResource((Path)this.docRoot));
        Path index = this.docRoot.resolve("index.html");
        this.createFile(index, "<h1>Hello World</h1>");
        ServletHolder defholder = this.context.addServlet(DefaultServlet.class, "/");
        defholder.setInitParameter("dirAllowed", "true");
        defholder.setInitParameter("redirectWelcome", "false");
        defholder.setInitParameter("useFileMappedBuffer", "true");
        defholder.setInitParameter("welcomeServlets", "exact");
        defholder.setInitParameter("gzip", "false");
        defholder.setInitParameter("resourceCache", "resourceCache");
        String rawResponse = this.connector.getResponse("GET /context/index.html HTTP/1.0\r\n\r\n");
        HttpTester.Response response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response.getContent(), (org.hamcrest.Matcher)Matchers.containsString((String)"<h1>Hello World</h1>"));
        ResourceContentFactory factory = (ResourceContentFactory)this.context.getServletContext().getAttribute("resourceCache");
        HttpContent content = factory.getContent("/index.html", 200);
        ByteBuffer buffer = content.getDirectBuffer();
        MatcherAssert.assertThat((String)"Buffer is direct", (Object)buffer.isDirect(), (org.hamcrest.Matcher)Matchers.is((Object)true));
        content = factory.getContent("/index.html", 5);
        buffer = content.getDirectBuffer();
        MatcherAssert.assertThat((String)"Direct buffer", (Object)buffer, (org.hamcrest.Matcher)Matchers.is((org.hamcrest.Matcher)Matchers.nullValue()));
    }

    public static Stream<Arguments> rangeScenarios() {
        Scenarios scenarios = new Scenarios();
        scenarios.addScenario("No range requested", "GET /context/data.txt HTTP/1.1\r\nHost: localhost\r\nConnection: close\r\n\r\n", 200, response -> MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.ACCEPT_RANGES, (String)"bytes")));
        scenarios.addScenario("Simple range request (no-close)", "GET /context/data.txt HTTP/1.1\r\nHost: localhost\r\nRange: bytes=0-9\r\n\r\n", 206, response -> {
            MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((String)"Content-Type", (String)"text/plain"));
            MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((String)"Content-Length", (String)"10"));
            MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((String)"Content-Range", (String)"bytes 0-9/80"));
        });
        scenarios.addScenario("Simple range request w/close", "GET /context/data.txt HTTP/1.1\r\nHost: localhost\r\nRange: bytes=0-9\r\nConnection: close\r\n\r\n", 206, response -> {
            MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((String)"Content-Type", (String)"text/plain"));
            MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((String)"Content-Range", (String)"bytes 0-9/80"));
        });
        scenarios.addScenario("Multiple ranges (x3)", "GET /context/data.txt HTTP/1.1\r\nHost: localhost\r\nRange: bytes=0-9,20-29,40-49\r\n\r\n", 206, response -> {
            String body = response.getContent();
            MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((String)"Content-Type", (String)"multipart/byteranges"));
            MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((String)"Content-Length", (String)("" + body.length())));
            HttpField contentType = response.getField(HttpHeader.CONTENT_TYPE);
            String boundary = DefaultServletTest.getContentTypeBoundary(contentType);
            MatcherAssert.assertThat((String)("Boundary expected: " + contentType.getValue()), (Object)boundary, (org.hamcrest.Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((Object)body, (org.hamcrest.Matcher)Matchers.containsString((String)"Content-Range: bytes 0-9/80"));
            MatcherAssert.assertThat((Object)body, (org.hamcrest.Matcher)Matchers.containsString((String)"Content-Range: bytes 20-29/80"));
            MatcherAssert.assertThat((Object)response.getContent(), (org.hamcrest.Matcher)Matchers.startsWith((String)("--" + boundary)));
            MatcherAssert.assertThat((Object)response.getContent(), (org.hamcrest.Matcher)Matchers.endsWith((String)(boundary + "--\r\n")));
        });
        scenarios.addScenario("Multiple ranges (x4)", "GET /context/data.txt HTTP/1.1\r\nHost: localhost\r\nRange: bytes=0-9,20-29,40-49,70-79\r\n\r\n", 206, response -> {
            String body = response.getContent();
            MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((String)"Content-Type", (String)"multipart/byteranges"));
            MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((String)"Content-Length", (String)("" + body.length())));
            HttpField contentType = response.getField(HttpHeader.CONTENT_TYPE);
            String boundary = DefaultServletTest.getContentTypeBoundary(contentType);
            MatcherAssert.assertThat((String)("Boundary expected: " + contentType.getValue()), (Object)boundary, (org.hamcrest.Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((Object)body, (org.hamcrest.Matcher)Matchers.containsString((String)"Content-Range: bytes 0-9/80"));
            MatcherAssert.assertThat((Object)body, (org.hamcrest.Matcher)Matchers.containsString((String)"Content-Range: bytes 20-29/80"));
            MatcherAssert.assertThat((Object)body, (org.hamcrest.Matcher)Matchers.containsString((String)"Content-Range: bytes 70-79/80"));
            MatcherAssert.assertThat((Object)response.getContent(), (org.hamcrest.Matcher)Matchers.startsWith((String)("--" + boundary)));
            MatcherAssert.assertThat((Object)response.getContent(), (org.hamcrest.Matcher)Matchers.endsWith((String)(boundary + "--\r\n")));
        });
        scenarios.addScenario("Multiple ranges (x4) with empty range request", "GET /context/data.txt HTTP/1.1\r\nHost: localhost\r\nRange: bytes=0-9,20-29,40-49,60-60,70-79\r\n\r\n", 206, response -> {
            String body = response.getContent();
            MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((String)"Content-Type", (String)"multipart/byteranges"));
            MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((String)"Content-Length", (String)("" + body.length())));
            HttpField contentType = response.getField(HttpHeader.CONTENT_TYPE);
            String boundary = DefaultServletTest.getContentTypeBoundary(contentType);
            MatcherAssert.assertThat((String)("Boundary expected: " + contentType.getValue()), (Object)boundary, (org.hamcrest.Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((Object)body, (org.hamcrest.Matcher)Matchers.containsString((String)"Content-Range: bytes 0-9/80"));
            MatcherAssert.assertThat((Object)body, (org.hamcrest.Matcher)Matchers.containsString((String)"Content-Range: bytes 20-29/80"));
            MatcherAssert.assertThat((Object)body, (org.hamcrest.Matcher)Matchers.containsString((String)"Content-Range: bytes 60-60/80"));
            MatcherAssert.assertThat((Object)body, (org.hamcrest.Matcher)Matchers.containsString((String)"Content-Range: bytes 70-79/80"));
            MatcherAssert.assertThat((Object)response.getContent(), (org.hamcrest.Matcher)Matchers.startsWith((String)("--" + boundary)));
            MatcherAssert.assertThat((Object)response.getContent(), (org.hamcrest.Matcher)Matchers.endsWith((String)(boundary + "--\r\n")));
        });
        scenarios.addScenario("No mimetype resource - no range requested", "GET /context/nofilesuffix HTTP/1.1\r\nHost: localhost\r\n\r\n", 200, response -> MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.ACCEPT_RANGES, (String)"bytes")));
        scenarios.addScenario("No mimetype resource - simple range request", "GET /context/nofilesuffix HTTP/1.1\r\nHost: localhost\r\nRange: bytes=0-9\r\n\r\n", 206, response -> {
            MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.CONTENT_LENGTH, (String)"10"));
            MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.CONTENT_RANGE, (String)"bytes 0-9/80"));
            MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)Matchers.not((org.hamcrest.Matcher)HttpFieldsMatchers.containsHeader((HttpHeader)HttpHeader.CONTENT_TYPE)));
        });
        scenarios.addScenario("No mimetype resource - multiple ranges (x3)", "GET /context/nofilesuffix HTTP/1.1\r\nHost: localhost\r\nRange: bytes=0-9,20-29,40-49\r\n\r\n", 206, response -> {
            String body = response.getContent();
            MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((String)"Content-Type", (String)"multipart/byteranges"));
            MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((String)"Content-Length", (String)("" + body.length())));
            HttpField contentType = response.getField(HttpHeader.CONTENT_TYPE);
            String boundary = DefaultServletTest.getContentTypeBoundary(contentType);
            MatcherAssert.assertThat((String)("Boundary expected: " + contentType.getValue()), (Object)boundary, (org.hamcrest.Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((Object)body, (org.hamcrest.Matcher)Matchers.containsString((String)"Content-Range: bytes 0-9/80"));
            MatcherAssert.assertThat((Object)body, (org.hamcrest.Matcher)Matchers.containsString((String)"Content-Range: bytes 20-29/80"));
            MatcherAssert.assertThat((Object)response.getContent(), (org.hamcrest.Matcher)Matchers.startsWith((String)("--" + boundary)));
            MatcherAssert.assertThat((Object)response.getContent(), (org.hamcrest.Matcher)Matchers.endsWith((String)(boundary + "--\r\n")));
        });
        scenarios.addScenario("No mimetype resource - multiple ranges (x5) with empty range request", "GET /context/nofilesuffix HTTP/1.1\r\nHost: localhost\r\nRange: bytes=0-9,20-29,40-49,60-60,70-79\r\n\r\n", 206, response -> {
            String body = response.getContent();
            MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((String)"Content-Type", (String)"multipart/byteranges"));
            MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((String)"Content-Length", (String)("" + body.length())));
            HttpField contentType = response.getField(HttpHeader.CONTENT_TYPE);
            String boundary = DefaultServletTest.getContentTypeBoundary(contentType);
            MatcherAssert.assertThat((String)("Boundary expected: " + contentType.getValue()), (Object)boundary, (org.hamcrest.Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((Object)body, (org.hamcrest.Matcher)Matchers.containsString((String)"Content-Range: bytes 0-9/80"));
            MatcherAssert.assertThat((Object)body, (org.hamcrest.Matcher)Matchers.containsString((String)"Content-Range: bytes 20-29/80"));
            MatcherAssert.assertThat((Object)body, (org.hamcrest.Matcher)Matchers.containsString((String)"Content-Range: bytes 40-49/80"));
            MatcherAssert.assertThat((Object)body, (org.hamcrest.Matcher)Matchers.containsString((String)"Content-Range: bytes 60-60/80"));
            MatcherAssert.assertThat((Object)body, (org.hamcrest.Matcher)Matchers.containsString((String)"Content-Range: bytes 70-79/80"));
            MatcherAssert.assertThat((Object)response.getContent(), (org.hamcrest.Matcher)Matchers.startsWith((String)("--" + boundary)));
            MatcherAssert.assertThat((Object)response.getContent(), (org.hamcrest.Matcher)Matchers.endsWith((String)(boundary + "--\r\n")));
        });
        return scenarios.stream();
    }

    @ParameterizedTest
    @MethodSource(value={"rangeScenarios"})
    public void testRangeRequests(Scenario scenario) throws Exception {
        FS.ensureDirExists((Path)this.docRoot);
        Path data = this.docRoot.resolve("data.txt");
        this.createFile(data, "01234567890123456789012345678901234567890123456789012345678901234567890123456789");
        Path nofilesuffix = this.docRoot.resolve("nofilesuffix");
        this.createFile(nofilesuffix, "01234567890123456789012345678901234567890123456789012345678901234567890123456789");
        ServletHolder defholder = this.context.addServlet(DefaultServlet.class, "/");
        defholder.setInitParameter("dirAllowed", "false");
        defholder.setInitParameter("redirectWelcome", "false");
        defholder.setInitParameter("welcomeServlets", "false");
        defholder.setInitParameter("gzip", "false");
        defholder.setInitParameter("acceptRanges", "true");
        String rawResponse = this.connector.getResponse(scenario.rawRequest);
        HttpTester.Response response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)scenario.expectedStatus));
        if (scenario.extraAsserts != null) {
            scenario.extraAsserts.accept(response);
        }
    }

    @Test
    public void testFiltered() throws Exception {
        FS.ensureDirExists((Path)this.docRoot);
        Path file0 = this.docRoot.resolve("data0.txt");
        this.createFile(file0, "Hello Text 0");
        Path image = this.docRoot.resolve("image.jpg");
        this.createFile(image, "not an image");
        ServletHolder defholder = this.context.addServlet(DefaultServlet.class, "/");
        defholder.setInitParameter("dirAllowed", "false");
        defholder.setInitParameter("redirectWelcome", "false");
        defholder.setInitParameter("welcomeServlets", "false");
        defholder.setInitParameter("gzip", "false");
        String rawResponse = this.connector.getResponse("GET /context/data0.txt HTTP/1.0\r\n\r\n");
        HttpTester.Response response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.CONTENT_LENGTH, (String)"12"));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.CONTENT_TYPE, (String)"text/plain"));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)Matchers.not((org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.CONTENT_TYPE, (String)"charset=")));
        String body = response.getContent();
        MatcherAssert.assertThat((Object)body, (org.hamcrest.Matcher)Matchers.not((org.hamcrest.Matcher)Matchers.containsString((String)"Extra Info")));
        this.server.stop();
        this.context.addFilter(OutputFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        this.server.start();
        rawResponse = this.connector.getResponse("GET /context/data0.txt HTTP/1.0\r\n\r\n");
        response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)200));
        body = response.getContent();
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.CONTENT_LENGTH, (String)("" + body.length())));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.CONTENT_TYPE, (String)"text/plain"));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.CONTENT_TYPE, (String)"charset="));
        MatcherAssert.assertThat((Object)body, (org.hamcrest.Matcher)Matchers.containsString((String)"Extra Info"));
        rawResponse = this.connector.getResponse("GET /context/image.jpg HTTP/1.0\r\n\r\n");
        response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)200));
        body = response.getContent();
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.CONTENT_LENGTH, (String)("" + body.length())));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.CONTENT_TYPE, (String)"image/jpeg"));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.CONTENT_TYPE, (String)"charset=utf-8"));
        MatcherAssert.assertThat((Object)body, (org.hamcrest.Matcher)Matchers.containsString((String)"Extra Info"));
        this.server.stop();
        this.context.getServletHandler().setFilterMappings(new FilterMapping[0]);
        this.context.getServletHandler().setFilters(new FilterHolder[0]);
        this.context.addFilter(WriterFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        this.server.start();
        rawResponse = this.connector.getResponse("GET /context/data0.txt HTTP/1.0\r\n\r\n");
        response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)200));
        body = response.getContent();
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.CONTENT_TYPE, (String)"text/plain"));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)Matchers.not((org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.CONTENT_TYPE, (String)"charset=")));
        MatcherAssert.assertThat((Object)body, (org.hamcrest.Matcher)Matchers.containsString((String)"Extra Info"));
    }

    @Test
    public void testGzip() throws Exception {
        FS.ensureDirExists((Path)this.docRoot);
        Path file0 = this.docRoot.resolve("data0.txt");
        this.createFile(file0, "Hello Text 0");
        Path file0gz = this.docRoot.resolve("data0.txt.gz");
        this.createFile(file0gz, "fake gzip");
        ServletHolder defholder = this.context.addServlet(DefaultServlet.class, "/");
        defholder.setInitParameter("dirAllowed", "false");
        defholder.setInitParameter("redirectWelcome", "false");
        defholder.setInitParameter("welcomeServlets", "false");
        defholder.setInitParameter("gzip", "true");
        defholder.setInitParameter("etags", "true");
        String rawResponse = this.connector.getResponse("GET /context/data0.txt HTTP/1.0\r\nHost:localhost:8080\r\n\r\n");
        HttpTester.Response response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.CONTENT_LENGTH, (String)"12"));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.CONTENT_TYPE, (String)"text/plain"));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.VARY, (String)"Accept-Encoding"));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeader((HttpHeader)HttpHeader.ETAG));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)Matchers.not((org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.CONTENT_ENCODING, (String)"gzip")));
        String body = response.getContent();
        MatcherAssert.assertThat((Object)body, (org.hamcrest.Matcher)Matchers.containsString((String)"Hello Text 0"));
        String etag = response.get(HttpHeader.ETAG);
        String etagGzip = etag.replaceFirst("([^\"]*)\"(.*)\"", "$1\"$2--gzip\"");
        rawResponse = this.connector.getResponse("GET /context/data0.txt HTTP/1.0\r\nHost:localhost:8080\r\nAccept-Encoding:gzip\r\n\r\n");
        response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.CONTENT_LENGTH, (String)"9"));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.CONTENT_TYPE, (String)"text/plain"));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.VARY, (String)"Accept-Encoding"));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.CONTENT_ENCODING, (String)"gzip"));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.ETAG, (String)etagGzip));
        body = response.getContent();
        MatcherAssert.assertThat((Object)body, (org.hamcrest.Matcher)Matchers.containsString((String)"fake gzip"));
        rawResponse = this.connector.getResponse("GET /context/data0.txt.gz HTTP/1.0\r\nHost:localhost:8080\r\nAccept-Encoding:gzip\r\n\r\n");
        response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.CONTENT_LENGTH, (String)"9"));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.CONTENT_TYPE, (String)"application/gzip"));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)Matchers.not((org.hamcrest.Matcher)HttpFieldsMatchers.containsHeader((HttpHeader)HttpHeader.VARY)));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)Matchers.not((org.hamcrest.Matcher)HttpFieldsMatchers.containsHeader((HttpHeader)HttpHeader.CONTENT_ENCODING)));
        MatcherAssert.assertThat((String)"Should not contain gzip variant", (Object)response, (org.hamcrest.Matcher)Matchers.not((org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.ETAG, (String)etagGzip)));
        MatcherAssert.assertThat((String)"Should have a different ETag", (Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeader((HttpHeader)HttpHeader.ETAG));
        body = response.getContent();
        MatcherAssert.assertThat((Object)body, (org.hamcrest.Matcher)Matchers.containsString((String)"fake gzip"));
        rawResponse = this.connector.getResponse("GET /context/data0.txt.gz HTTP/1.0\r\nHost:localhost:8080\r\nAccept-Encoding:gzip\r\nIf-None-Match: W/\"wobble\"\r\n\r\n");
        response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.CONTENT_LENGTH, (String)"9"));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.CONTENT_TYPE, (String)"application/gzip"));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)Matchers.not((org.hamcrest.Matcher)HttpFieldsMatchers.containsHeader((HttpHeader)HttpHeader.VARY)));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)Matchers.not((org.hamcrest.Matcher)HttpFieldsMatchers.containsHeader((HttpHeader)HttpHeader.CONTENT_ENCODING)));
        MatcherAssert.assertThat((String)"Should not contain gzip variant", (Object)response, (org.hamcrest.Matcher)Matchers.not((org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.ETAG, (String)etagGzip)));
        MatcherAssert.assertThat((String)"Should have a different ETag", (Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeader((HttpHeader)HttpHeader.ETAG));
        body = response.getContent();
        MatcherAssert.assertThat((Object)body, (org.hamcrest.Matcher)Matchers.containsString((String)"fake gzip"));
        String badEtagGzip = etag.replaceFirst("([^\"]*)\"(.*)\"", "$1\"$2X--gzip\"");
        rawResponse = this.connector.getResponse("GET /context/data0.txt HTTP/1.0\r\nHost:localhost:8080\r\nAccept-Encoding:gzip\r\nIf-None-Match: " + badEtagGzip + "\r\n\r\n");
        response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((org.hamcrest.Matcher)Matchers.not((Object)304)));
        rawResponse = this.connector.getResponse("GET /context/data0.txt HTTP/1.0\r\nHost:localhost:8080\r\nAccept-Encoding:gzip\r\nIf-None-Match: " + etagGzip + "\r\n\r\n");
        response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)304));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.ETAG, (String)etagGzip));
        rawResponse = this.connector.getResponse("GET /context/data0.txt HTTP/1.0\r\nHost:localhost:8080\r\nAccept-Encoding:gzip\r\nIf-None-Match: " + etag + "\r\n\r\n");
        response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)304));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.ETAG, (String)etag));
        rawResponse = this.connector.getResponse("GET /context/data0.txt HTTP/1.0\r\nHost:localhost:8080\r\nAccept-Encoding:gzip\r\nIf-None-Match: W/\"foobar\"," + etagGzip + "\r\n\r\n");
        response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)304));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.ETAG, (String)etagGzip));
        rawResponse = this.connector.getResponse("GET /context/data0.txt HTTP/1.0\r\nHost:localhost:8080\r\nAccept-Encoding:gzip\r\nIf-None-Match: W/\"foobar\"," + etag + "\r\n\r\n");
        response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)304));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.ETAG, (String)etag));
    }

    @Test
    public void testCachedGzip() throws Exception {
        FS.ensureDirExists((Path)this.docRoot);
        Path file0 = this.docRoot.resolve("data0.txt");
        this.createFile(file0, "Hello Text 0");
        Path file0gz = this.docRoot.resolve("data0.txt.gz");
        this.createFile(file0gz, "fake gzip");
        ServletHolder defholder = this.context.addServlet(DefaultServlet.class, "/");
        defholder.setInitParameter("dirAllowed", "false");
        defholder.setInitParameter("redirectWelcome", "false");
        defholder.setInitParameter("welcomeServlets", "false");
        defholder.setInitParameter("gzip", "true");
        defholder.setInitParameter("etags", "true");
        defholder.setInitParameter("maxCachedFiles", "1024");
        defholder.setInitParameter("maxCachedFileSize", "200000000");
        defholder.setInitParameter("maxCacheSize", "256000000");
        String rawResponse = this.connector.getResponse("GET /context/data0.txt HTTP/1.0\r\nHost:localhost:8080\r\n\r\n");
        HttpTester.Response response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.CONTENT_LENGTH, (String)"12"));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.CONTENT_TYPE, (String)"text/plain"));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.VARY, (String)"Accept-Encoding"));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)Matchers.not((org.hamcrest.Matcher)HttpFieldsMatchers.containsHeader((HttpHeader)HttpHeader.CONTENT_ENCODING)));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeader((HttpHeader)HttpHeader.ETAG));
        String body = response.getContent();
        MatcherAssert.assertThat((Object)body, (org.hamcrest.Matcher)Matchers.containsString((String)"Hello Text 0"));
        String etag = response.get(HttpHeader.ETAG);
        String etagGzip = etag.replaceFirst("([^\"]*)\"(.*)\"", "$1\"$2--gzip\"");
        rawResponse = this.connector.getResponse("GET /context/data0.txt HTTP/1.0\r\nHost:localhost:8080\r\nAccept-Encoding:gzip\r\n\r\n");
        response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.CONTENT_LENGTH, (String)"9"));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.CONTENT_TYPE, (String)"text/plain"));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.VARY, (String)"Accept-Encoding"));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.CONTENT_ENCODING, (String)"gzip"));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.ETAG, (String)etagGzip));
        body = response.getContent();
        MatcherAssert.assertThat((Object)body, (org.hamcrest.Matcher)Matchers.containsString((String)"fake gzip"));
        rawResponse = this.connector.getResponse("GET /context/data0.txt.gz HTTP/1.0\r\nHost:localhost:8080\r\nAccept-Encoding:gzip\r\n\r\n");
        response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.CONTENT_LENGTH, (String)"9"));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.CONTENT_TYPE, (String)"application/gzip"));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)Matchers.not((org.hamcrest.Matcher)HttpFieldsMatchers.containsHeader((HttpHeader)HttpHeader.VARY)));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)Matchers.not((org.hamcrest.Matcher)HttpFieldsMatchers.containsHeader((HttpHeader)HttpHeader.CONTENT_ENCODING)));
        MatcherAssert.assertThat((String)"Should not contain gzip variant", (Object)response, (org.hamcrest.Matcher)Matchers.not((org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.ETAG, (String)etagGzip)));
        MatcherAssert.assertThat((String)"Should have a different ETag", (Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeader((HttpHeader)HttpHeader.ETAG));
        body = response.getContent();
        MatcherAssert.assertThat((Object)body, (org.hamcrest.Matcher)Matchers.containsString((String)"fake gzip"));
        rawResponse = this.connector.getResponse("GET /context/data0.txt HTTP/1.0\r\nHost:localhost:8080\r\nAccept-Encoding:gzip\r\nIf-None-Match: " + etagGzip + "\r\n\r\n");
        response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)304));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.ETAG, (String)etagGzip));
        rawResponse = this.connector.getResponse("GET /context/data0.txt HTTP/1.0\r\nHost:localhost:8080\r\nAccept-Encoding:gzip\r\nIf-None-Match: " + etag + "\r\n\r\n");
        response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)304));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.ETAG, (String)etag));
        rawResponse = this.connector.getResponse("GET /context/data0.txt HTTP/1.0\r\nHost:localhost:8080\r\nAccept-Encoding:gzip\r\nIf-None-Match: W/\"foobar\"," + etagGzip + "\r\n\r\n");
        response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)304));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.ETAG, (String)etagGzip));
        rawResponse = this.connector.getResponse("GET /context/data0.txt HTTP/1.0\r\nHost:localhost:8080\r\nAccept-Encoding:gzip\r\nIf-None-Match: W/\"foobar\"," + etag + "\r\n\r\n");
        response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)304));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.ETAG, (String)etag));
    }

    @Test
    public void testBrotli() throws Exception {
        this.createFile(this.docRoot.resolve("data0.txt"), "Hello Text 0");
        this.createFile(this.docRoot.resolve("data0.txt.br"), "fake brotli");
        ServletHolder defholder = this.context.addServlet(DefaultServlet.class, "/");
        defholder.setInitParameter("dirAllowed", "false");
        defholder.setInitParameter("redirectWelcome", "false");
        defholder.setInitParameter("welcomeServlets", "false");
        defholder.setInitParameter("precompressed", "true");
        defholder.setInitParameter("etags", "true");
        String rawResponse = this.connector.getResponse("GET /context/data0.txt HTTP/1.0\r\nHost:localhost:8080\r\n\r\n");
        HttpTester.Response response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.CONTENT_LENGTH, (String)"12"));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.CONTENT_TYPE, (String)"text/plain"));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.VARY, (String)"Accept-Encoding"));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)Matchers.not((org.hamcrest.Matcher)HttpFieldsMatchers.containsHeader((HttpHeader)HttpHeader.CONTENT_ENCODING)));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeader((HttpHeader)HttpHeader.ETAG));
        String body = response.getContent();
        MatcherAssert.assertThat((Object)body, (org.hamcrest.Matcher)Matchers.containsString((String)"Hello Text 0"));
        String etag = response.get(HttpHeader.ETAG);
        String etagBr = etag.replaceFirst("([^\"]*)\"(.*)\"", "$1\"$2--br\"");
        rawResponse = this.connector.getResponse("GET /context/data0.txt HTTP/1.0\r\nHost:localhost:8080\r\nAccept-Encoding:gzip;q=0.9,br\r\n\r\n");
        response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.CONTENT_LENGTH, (String)"11"));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.CONTENT_TYPE, (String)"text/plain"));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.VARY, (String)"Accept-Encoding"));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.CONTENT_ENCODING, (String)"br"));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.ETAG, (String)etagBr));
        body = response.getContent();
        MatcherAssert.assertThat((Object)body, (org.hamcrest.Matcher)Matchers.containsString((String)"fake br"));
        rawResponse = this.connector.getResponse("GET /context/data0.txt.br HTTP/1.0\r\nHost:localhost:8080\r\nAccept-Encoding:br,gzip\r\n\r\n");
        response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.CONTENT_LENGTH, (String)"11"));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.CONTENT_TYPE, (String)"application/brotli"));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)Matchers.not((org.hamcrest.Matcher)HttpFieldsMatchers.containsHeader((HttpHeader)HttpHeader.VARY)));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)Matchers.not((org.hamcrest.Matcher)HttpFieldsMatchers.containsHeader((HttpHeader)HttpHeader.CONTENT_ENCODING)));
        MatcherAssert.assertThat((String)"Should not contain br variant", (Object)response, (org.hamcrest.Matcher)Matchers.not((org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.ETAG, (String)etagBr)));
        MatcherAssert.assertThat((String)"Should have a different ETag", (Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeader((HttpHeader)HttpHeader.ETAG));
        body = response.getContent();
        MatcherAssert.assertThat((Object)body, (org.hamcrest.Matcher)Matchers.containsString((String)"fake br"));
        rawResponse = this.connector.getResponse("GET /context/data0.txt.br HTTP/1.0\r\nHost:localhost:8080\r\nAccept-Encoding:gzip\r\nIf-None-Match: W/\"wobble\"\r\n\r\n");
        response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.CONTENT_LENGTH, (String)"11"));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.CONTENT_TYPE, (String)"application/brotli"));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)Matchers.not((org.hamcrest.Matcher)HttpFieldsMatchers.containsHeader((HttpHeader)HttpHeader.VARY)));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)Matchers.not((org.hamcrest.Matcher)HttpFieldsMatchers.containsHeader((HttpHeader)HttpHeader.CONTENT_ENCODING)));
        MatcherAssert.assertThat((String)"Should not contain br variant", (Object)response, (org.hamcrest.Matcher)Matchers.not((org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.ETAG, (String)etagBr)));
        MatcherAssert.assertThat((String)"Should have a different ETag", (Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeader((HttpHeader)HttpHeader.ETAG));
        body = response.getContent();
        MatcherAssert.assertThat((Object)body, (org.hamcrest.Matcher)Matchers.containsString((String)"fake br"));
        rawResponse = this.connector.getResponse("GET /context/data0.txt HTTP/1.0\r\nHost:localhost:8080\r\nAccept-Encoding:br\r\nIf-None-Match: " + etagBr + "\r\n\r\n");
        response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)304));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.ETAG, (String)etagBr));
        rawResponse = this.connector.getResponse("GET /context/data0.txt HTTP/1.0\r\nHost:localhost:8080\r\nAccept-Encoding:br\r\nIf-None-Match: " + etag + "\r\n\r\n");
        response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)304));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.ETAG, (String)etag));
        rawResponse = this.connector.getResponse("GET /context/data0.txt HTTP/1.0\r\nHost:localhost:8080\r\nAccept-Encoding:br\r\nIf-None-Match: W/\"foobar\"," + etagBr + "\r\n\r\n");
        response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)304));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.ETAG, (String)etagBr));
        rawResponse = this.connector.getResponse("GET /context/data0.txt HTTP/1.0\r\nHost:localhost:8080\r\nAccept-Encoding:br\r\nIf-None-Match: W/\"foobar\"," + etag + "\r\n\r\n");
        response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)304));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.ETAG, (String)etag));
    }

    @Test
    public void testCachedBrotli() throws Exception {
        this.createFile(this.docRoot.resolve("data0.txt"), "Hello Text 0");
        this.createFile(this.docRoot.resolve("data0.txt.br"), "fake brotli");
        ServletHolder defholder = this.context.addServlet(DefaultServlet.class, "/");
        defholder.setInitParameter("dirAllowed", "false");
        defholder.setInitParameter("redirectWelcome", "false");
        defholder.setInitParameter("welcomeServlets", "false");
        defholder.setInitParameter("precompressed", "true");
        defholder.setInitParameter("etags", "true");
        defholder.setInitParameter("maxCachedFiles", "1024");
        defholder.setInitParameter("maxCachedFileSize", "200000000");
        defholder.setInitParameter("maxCacheSize", "256000000");
        String rawResponse = this.connector.getResponse("GET /context/data0.txt HTTP/1.0\r\nHost:localhost:8080\r\n\r\n");
        HttpTester.Response response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.CONTENT_LENGTH, (String)"12"));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.CONTENT_TYPE, (String)"text/plain"));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.VARY, (String)"Accept-Encoding"));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)Matchers.not((org.hamcrest.Matcher)HttpFieldsMatchers.containsHeader((HttpHeader)HttpHeader.CONTENT_ENCODING)));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeader((HttpHeader)HttpHeader.ETAG));
        String body = response.getContent();
        MatcherAssert.assertThat((Object)body, (org.hamcrest.Matcher)Matchers.containsString((String)"Hello Text 0"));
        String etag = response.get(HttpHeader.ETAG);
        String etagBr = etag.replaceFirst("([^\"]*)\"(.*)\"", "$1\"$2--br\"");
        rawResponse = this.connector.getResponse("GET /context/data0.txt HTTP/1.0\r\nHost:localhost:8080\r\nAccept-Encoding:br\r\n\r\n");
        response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.CONTENT_LENGTH, (String)"11"));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.CONTENT_TYPE, (String)"text/plain"));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.VARY, (String)"Accept-Encoding"));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.CONTENT_ENCODING, (String)"br"));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.ETAG, (String)etagBr));
        body = response.getContent();
        MatcherAssert.assertThat((Object)body, (org.hamcrest.Matcher)Matchers.containsString((String)"fake brotli"));
        rawResponse = this.connector.getResponse("GET /context/data0.txt.br HTTP/1.0\r\nHost:localhost:8080\r\nAccept-Encoding:br\r\n\r\n");
        response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.CONTENT_LENGTH, (String)"11"));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.CONTENT_TYPE, (String)"application/brotli"));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)Matchers.not((org.hamcrest.Matcher)HttpFieldsMatchers.containsHeader((HttpHeader)HttpHeader.VARY)));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)Matchers.not((org.hamcrest.Matcher)HttpFieldsMatchers.containsHeader((HttpHeader)HttpHeader.CONTENT_ENCODING)));
        MatcherAssert.assertThat((String)"Should not contain br variant", (Object)response, (org.hamcrest.Matcher)Matchers.not((org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.ETAG, (String)etagBr)));
        MatcherAssert.assertThat((String)"Should have a different ETag", (Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeader((HttpHeader)HttpHeader.ETAG));
        body = response.getContent();
        MatcherAssert.assertThat((Object)body, (org.hamcrest.Matcher)Matchers.containsString((String)"fake brotli"));
        rawResponse = this.connector.getResponse("GET /context/data0.txt HTTP/1.0\r\nHost:localhost:8080\r\nAccept-Encoding:br\r\nIf-None-Match: " + etagBr + "\r\n\r\n");
        response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)304));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.ETAG, (String)etagBr));
        rawResponse = this.connector.getResponse("GET /context/data0.txt HTTP/1.0\r\nHost:localhost:8080\r\nAccept-Encoding:br\r\nIf-None-Match: " + etag + "\r\n\r\n");
        response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)304));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.ETAG, (String)etag));
        rawResponse = this.connector.getResponse("GET /context/data0.txt HTTP/1.0\r\nHost:localhost:8080\r\nAccept-Encoding:br\r\nIf-None-Match: W/\"foobar\"," + etagBr + "\r\n\r\n");
        response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)304));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.ETAG, (String)etagBr));
        rawResponse = this.connector.getResponse("GET /context/data0.txt HTTP/1.0\r\nHost:localhost:8080\r\nAccept-Encoding:br\r\nIf-None-Match: W/\"foobar\"," + etag + "\r\n\r\n");
        response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)304));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.ETAG, (String)etag));
    }

    @Test
    public void testDefaultBrotliOverGzip() throws Exception {
        this.createFile(this.docRoot.resolve("data0.txt"), "Hello Text 0");
        this.createFile(this.docRoot.resolve("data0.txt.br"), "fake brotli");
        this.createFile(this.docRoot.resolve("data0.txt.gz"), "fake gzip");
        ServletHolder defholder = this.context.addServlet(DefaultServlet.class, "/");
        defholder.setInitParameter("precompressed", "true");
        defholder.setInitParameter("resourceBase", this.docRoot.toString());
        String rawResponse = this.connector.getResponse("GET /context/data0.txt HTTP/1.0\r\nHost:localhost:8080\r\nAccept-Encoding:gzip, compress, br\r\n\r\n");
        HttpTester.Response response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.CONTENT_LENGTH, (String)"11"));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.CONTENT_TYPE, (String)"text/plain"));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.VARY, (String)"Accept-Encoding"));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.CONTENT_ENCODING, (String)"br"));
        String body = response.getContent();
        MatcherAssert.assertThat((Object)body, (org.hamcrest.Matcher)Matchers.containsString((String)"fake brotli"));
        rawResponse = this.connector.getResponse("GET /context/data0.txt HTTP/1.0\r\nHost:localhost:8080\r\nAccept-Encoding:gzip, compress, br;q=0.9\r\n\r\n");
        response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.CONTENT_LENGTH, (String)"9"));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.CONTENT_TYPE, (String)"text/plain"));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.VARY, (String)"Accept-Encoding"));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.CONTENT_ENCODING, (String)"gzip"));
        body = response.getContent();
        MatcherAssert.assertThat((Object)body, (org.hamcrest.Matcher)Matchers.containsString((String)"fake gzip"));
    }

    @Test
    public void testCustomCompressionFormats() throws Exception {
        this.createFile(this.docRoot.resolve("data0.txt"), "Hello Text 0");
        this.createFile(this.docRoot.resolve("data0.txt.br"), "fake brotli");
        this.createFile(this.docRoot.resolve("data0.txt.gz"), "fake gzip");
        this.createFile(this.docRoot.resolve("data0.txt.bz2"), "fake bzip2");
        ServletHolder defholder = this.context.addServlet(DefaultServlet.class, "/");
        defholder.setInitParameter("precompressed", "bzip2=.bz2,gzip=.gz,br=.br");
        defholder.setInitParameter("resourceBase", this.docRoot.toString());
        String rawResponse = this.connector.getResponse("GET /context/data0.txt HTTP/1.0\r\nHost:localhost:8080\r\nAccept-Encoding:bzip2, br, gzip\r\n\r\n");
        HttpTester.Response response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.CONTENT_LENGTH, (String)"10"));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.CONTENT_TYPE, (String)"text/plain"));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.VARY, (String)"Accept-Encoding"));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.CONTENT_ENCODING, (String)"bzip2"));
        String body = response.getContent();
        MatcherAssert.assertThat((Object)body, (org.hamcrest.Matcher)Matchers.containsString((String)"fake bzip2"));
        rawResponse = this.connector.getResponse("GET /context/data0.txt HTTP/1.0\r\nHost:localhost:8080\r\nAccept-Encoding:br, gzip\r\n\r\n");
        response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.CONTENT_LENGTH, (String)"9"));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.CONTENT_TYPE, (String)"text/plain"));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.VARY, (String)"Accept-Encoding"));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.CONTENT_ENCODING, (String)"gzip"));
        body = response.getContent();
        MatcherAssert.assertThat((Object)body, (org.hamcrest.Matcher)Matchers.containsString((String)"fake gzip"));
    }

    @Test
    public void testControlCharacter() throws Exception {
        FS.ensureDirExists((Path)this.docRoot);
        ServletHolder defholder = this.context.addServlet(DefaultServlet.class, "/");
        defholder.setInitParameter("resourceBase", this.docRoot.toFile().getAbsolutePath());
        try (StacklessLogging ignore = new StacklessLogging(new Class[]{ResourceService.class});){
            String rawResponse = this.connector.getResponse("GET /context/%0a HTTP/1.1\r\nHost: local\r\nConnection: close\r\n\r\n");
            HttpTester.Response response = HttpTester.parseResponse((String)rawResponse);
            MatcherAssert.assertThat((String)"Response.status", (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.anyOf((org.hamcrest.Matcher)Matchers.is((Object)404), (org.hamcrest.Matcher)Matchers.is((Object)500)));
            MatcherAssert.assertThat((String)"Response.content", (Object)response.getContent(), (org.hamcrest.Matcher)Matchers.is((org.hamcrest.Matcher)Matchers.not((org.hamcrest.Matcher)Matchers.containsString((String)this.docRoot.toString()))));
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"Hello World", "Now is the time for all good men to come to the aid of the party"})
    public void testIfModified(String content) throws Exception {
        Path file = this.docRoot.resolve("file.txt");
        ServletHolder defholder = this.context.addServlet(DefaultServlet.class, "/");
        defholder.setInitParameter("maxCacheSize", "4096");
        defholder.setInitParameter("maxCachedFileSize", "25");
        defholder.setInitParameter("maxCachedFiles", "100");
        String rawResponse = this.connector.getResponse("GET /context/file.txt HTTP/1.0\r\n\r\n");
        HttpTester.Response response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)404));
        this.createFile(file, content);
        rawResponse = this.connector.getResponse("GET /context/file.txt HTTP/1.1\r\nHost:test\r\nConnection:close\r\n\r\n");
        response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeader((HttpHeader)HttpHeader.LAST_MODIFIED));
        String lastModified = response.get(HttpHeader.LAST_MODIFIED);
        rawResponse = this.connector.getResponse("GET /context/file.txt HTTP/1.1\r\nHost:test\r\nConnection:close\r\nIf-Modified-Since: " + lastModified + "\r\n\r\n");
        response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)304));
        rawResponse = this.connector.getResponse("GET /context/file.txt HTTP/1.1\r\nHost:test\r\nConnection:close\r\nIf-Modified-Since: " + DateGenerator.formatDate((long)(System.currentTimeMillis() - 10000L)) + "\r\n\r\n");
        response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)200));
        rawResponse = this.connector.getResponse("GET /context/file.txt HTTP/1.1\r\nHost:test\r\nConnection:close\r\nIf-Modified-Since: " + DateGenerator.formatDate((long)(System.currentTimeMillis() + 10000L)) + "\r\n\r\n");
        response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)304));
        rawResponse = this.connector.getResponse("GET /context/file.txt HTTP/1.1\r\nHost:test\r\nConnection:close\r\nIf-Unmodified-Since: " + DateGenerator.formatDate((long)(System.currentTimeMillis() + 10000L)) + "\r\n\r\n");
        response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)200));
        rawResponse = this.connector.getResponse("GET /context/file.txt HTTP/1.1\r\nHost:test\r\nConnection:close\r\nIf-Unmodified-Since: " + DateGenerator.formatDate((long)(System.currentTimeMillis() - 10000L)) + "\r\n\r\n");
        response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)412));
    }

    @ParameterizedTest
    @ValueSource(strings={"Hello World", "Now is the time for all good men to come to the aid of the party"})
    public void testIfETag(String content) throws Exception {
        this.createFile(this.docRoot.resolve("file.txt"), content);
        ServletHolder defholder = this.context.addServlet(DefaultServlet.class, "/");
        defholder.setInitParameter("maxCacheSize", "4096");
        defholder.setInitParameter("maxCachedFileSize", "25");
        defholder.setInitParameter("maxCachedFiles", "100");
        defholder.setInitParameter("etags", "true");
        String rawResponse = this.connector.getResponse("GET /context/file.txt HTTP/1.1\r\nHost:test\r\nConnection:close\r\n\r\n");
        HttpTester.Response response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)HttpFieldsMatchers.containsHeader((HttpHeader)HttpHeader.ETAG));
        String etag = response.get(HttpHeader.ETAG);
        rawResponse = this.connector.getResponse("GET /context/file.txt HTTP/1.1\r\nHost:test\r\nConnection:close\r\nIf-None-Match: " + etag + "\r\n\r\n");
        response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)304));
        rawResponse = this.connector.getResponse("GET /context/file.txt HTTP/1.1\r\nHost:test\r\nConnection:close\r\nIf-None-Match: wibble," + etag + ",wobble\r\n\r\n");
        response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)304));
        rawResponse = this.connector.getResponse("GET /context/file.txt HTTP/1.1\r\nHost:test\r\nConnection:close\r\nIf-None-Match: wibble\r\n\r\n");
        response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)200));
        rawResponse = this.connector.getResponse("GET /context/file.txt HTTP/1.1\r\nHost:test\r\nConnection:close\r\nIf-None-Match: wibble, wobble\r\n\r\n");
        response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)200));
        rawResponse = this.connector.getResponse("GET /context/file.txt HTTP/1.1\r\nHost:test\r\nConnection:close\r\nIf-Match: " + etag + "\r\n\r\n");
        response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)200));
        rawResponse = this.connector.getResponse("GET /context/file.txt HTTP/1.1\r\nHost:test\r\nConnection:close\r\nIf-Match: wibble," + etag + ",wobble\r\n\r\n");
        response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)200));
        rawResponse = this.connector.getResponse("GET /context/file.txt HTTP/1.1\r\nHost:test\r\nConnection:close\r\nIf-Match: wibble\r\n\r\n");
        response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)412));
        rawResponse = this.connector.getResponse("GET /context/file.txt HTTP/1.1\r\nHost:test\r\nConnection:close\r\nIf-Match: wibble, wobble\r\n\r\n");
        response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)response.toString(), (Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)412));
    }

    @Test
    public void testGetUtf8NfcFile() throws Exception {
        FS.ensureEmpty((Path)this.docRoot);
        this.context.addServlet(DefaultServlet.class, "/");
        this.context.addAliasCheck((ContextHandler.AliasCheck)new SameFileAliasChecker());
        String filename = "swedish-" + new String(TypeUtil.fromHexString((String)"C3A5"), StandardCharsets.UTF_8) + ".txt";
        this.createFile(this.docRoot.resolve(filename), "hi a-with-circle");
        String rawResponse = this.connector.getResponse("GET /context/swedish-%C3%A5.txt HTTP/1.1\r\nHost:test\r\nConnection:close\r\n\r\n");
        HttpTester.Response response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response.getContent(), (org.hamcrest.Matcher)Matchers.is((Object)"hi a-with-circle"));
        rawResponse = this.connector.getResponse("GET /context/swedish-a%CC%8A.txt HTTP/1.1\r\nHost:test\r\nConnection:close\r\n\r\n");
        response = HttpTester.parseResponse((String)rawResponse);
        if (OS.MAC.isCurrentOs()) {
            MatcherAssert.assertThat((Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)200));
            MatcherAssert.assertThat((Object)response.getContent(), (org.hamcrest.Matcher)Matchers.is((Object)"hi a-with-circle"));
        } else {
            MatcherAssert.assertThat((Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)404));
        }
    }

    @Test
    public void testGetUtf8NfdFile() throws Exception {
        FS.ensureEmpty((Path)this.docRoot);
        this.context.addServlet(DefaultServlet.class, "/");
        this.context.addAliasCheck((ContextHandler.AliasCheck)new SameFileAliasChecker());
        String filename = "swedish-" + new String(TypeUtil.fromHexString((String)"61CC8A"), StandardCharsets.UTF_8) + ".txt";
        this.createFile(this.docRoot.resolve(filename), "hi a-with-circle");
        String rawResponse = this.connector.getResponse("GET /context/swedish-a%CC%8A.txt HTTP/1.1\r\nHost:test\r\nConnection:close\r\n\r\n");
        HttpTester.Response response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response.getContent(), (org.hamcrest.Matcher)Matchers.is((Object)"hi a-with-circle"));
        rawResponse = this.connector.getResponse("GET /context/swedish-%C3%A5.txt HTTP/1.1\r\nHost:test\r\nConnection:close\r\n\r\n");
        response = HttpTester.parseResponse((String)rawResponse);
        if (OS.MAC.isCurrentOs()) {
            MatcherAssert.assertThat((Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)200));
            MatcherAssert.assertThat((Object)response.getContent(), (org.hamcrest.Matcher)Matchers.is((Object)"hi a-with-circle"));
        } else {
            MatcherAssert.assertThat((Object)response.getStatus(), (org.hamcrest.Matcher)Matchers.is((Object)404));
        }
    }

    private void createFile(Path path, String str) throws IOException {
        try (OutputStream out = Files.newOutputStream(path, new OpenOption[0]);){
            out.write(str.getBytes(StandardCharsets.UTF_8));
            out.flush();
        }
    }

    private boolean deleteFile(Path file) throws IOException {
        if (!Files.exists(file, new LinkOption[0])) {
            return true;
        }
        try {
            Files.delete(file);
        }
        catch (IOException ignore) {
            Path deletedDir = MavenTestingUtils.getTargetTestingPath((String)".deleted");
            FS.ensureDirExists((Path)deletedDir);
            Path dest = Files.createTempFile(deletedDir, file.getFileName().toString(), "deleted", new FileAttribute[0]);
            try {
                Files.move(file, dest, new CopyOption[0]);
            }
            catch (IOException | UnsupportedOperationException e) {
                System.err.println("WARNING: unable to move file out of the way: " + file);
            }
        }
        return !Files.exists(file, new LinkOption[0]);
    }

    private static String getContentTypeBoundary(HttpField contentType) {
        Pattern pat = Pattern.compile("boundary=([a-zA-Z0-9]*)");
        for (String value : contentType.getValues()) {
            Matcher mat = pat.matcher(value);
            if (!mat.find()) continue;
            return mat.group(1);
        }
        return null;
    }

    private static Path assumeMkDirSupported(Path path, String subpath) {
        Path ret = null;
        try {
            ret = path.resolve(subpath);
            if (Files.exists(ret, new LinkOption[0])) {
                return ret;
            }
            Files.createDirectories(ret, new FileAttribute[0]);
        }
        catch (IOException | InvalidPathException exception) {
            // empty catch block
        }
        Assumptions.assumeTrue((ret != null ? 1 : 0) != 0, (String)("Directory creation not supported on OS: " + path + File.separator + subpath));
        Assumptions.assumeTrue((boolean)Files.exists(ret, new LinkOption[0]), (String)("Directory creation not supported on OS: " + ret));
        return ret;
    }

    public static class Scenario {
        private final String description;
        public final String rawRequest;
        public final int expectedStatus;
        public Consumer<HttpTester.Response> extraAsserts;

        public Scenario(String description, String rawRequest, int expectedStatus) {
            this.description = description;
            this.rawRequest = rawRequest;
            this.expectedStatus = expectedStatus;
        }

        public Scenario(String description, String rawRequest, int expectedStatus, Consumer<HttpTester.Response> extraAsserts) {
            this(description, rawRequest, expectedStatus);
            this.extraAsserts = extraAsserts;
        }

        public String toString() {
            return this.description;
        }
    }

    public static class Scenarios
    extends ArrayList<Arguments> {
        public void addScenario(String description, String rawRequest, int expectedStatus) {
            this.add(Arguments.of((Object[])new Object[]{new Scenario(description, rawRequest, expectedStatus)}));
        }

        public void addScenario(String description, String rawRequest, int expectedStatus, Consumer<HttpTester.Response> extraAsserts) {
            this.add(Arguments.of((Object[])new Object[]{new Scenario(description, rawRequest, expectedStatus, extraAsserts)}));
        }
    }

    public static class WriterFilter
    implements Filter {
        public void init(FilterConfig filterConfig) {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            response.getWriter().println("Extra Info");
            chain.doFilter(request, response);
        }

        public void destroy() {
        }
    }

    public static class OutputFilter
    implements Filter {
        public void init(FilterConfig filterConfig) {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            response.getOutputStream().println("Extra Info");
            response.setCharacterEncoding("utf-8");
            chain.doFilter(request, response);
        }

        public void destroy() {
        }
    }
}

