/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.io.IOException;
import java.nio.file.Path;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.toolchain.test.MavenTestingUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class CacheControlHeaderTest {
    private Server server;
    private LocalConnector connector;

    public void startServer(boolean forceFilter) throws Exception {
        this.server = new Server();
        HttpConnectionFactory httpConnectionFactory = new HttpConnectionFactory(new HttpConfiguration());
        this.connector = new LocalConnector(this.server, null, null, null, -1, new ConnectionFactory[]{httpConnectionFactory});
        ServletContextHandler context = new ServletContextHandler();
        ServletHolder servletHolder = new ServletHolder();
        servletHolder.setServlet((Servlet)new DefaultServlet());
        servletHolder.setInitParameter("cacheControl", "max-age=3600,public");
        Path resBase = MavenTestingUtils.getTestResourcePathDir((String)"contextResources");
        servletHolder.setInitParameter("resourceBase", resBase.toFile().toURI().toASCIIString());
        context.addServlet(servletHolder, "/*");
        if (forceFilter) {
            context.addFilter(ForceCacheControlFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        }
        this.server.setHandler((Handler)context);
        this.server.addConnector((Connector)this.connector);
        this.server.start();
    }

    public void stopServer() throws Exception {
        if (this.server != null && this.server.isRunning()) {
            this.server.stop();
        }
    }

    @Test
    public void testCacheControlFilterOverride() throws Exception {
        try {
            this.startServer(true);
            StringBuffer req1 = new StringBuffer();
            req1.append("GET /content.txt HTTP/1.1\r\n");
            req1.append("Host: local\r\n");
            req1.append("Accept: */*\r\n");
            req1.append("Connection: close\r\n");
            req1.append("\r\n");
            String response = this.connector.getResponse(req1.toString());
            MatcherAssert.assertThat((String)"Response status", (Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
            MatcherAssert.assertThat((String)"Response headers", (Object)response, (Matcher)Matchers.containsString((String)(HttpHeader.CACHE_CONTROL.asString() + ": max-age=0,private")));
        }
        finally {
            this.stopServer();
        }
    }

    @Test
    public void testCacheControlDefaultServlet() throws Exception {
        try {
            this.startServer(false);
            StringBuffer req1 = new StringBuffer();
            req1.append("GET /content.txt HTTP/1.1\r\n");
            req1.append("Host: local\r\n");
            req1.append("Accept: */*\r\n");
            req1.append("Connection: close\r\n");
            req1.append("\r\n");
            String response = this.connector.getResponse(req1.toString());
            MatcherAssert.assertThat((String)"Response status", (Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
            MatcherAssert.assertThat((String)"Response headers", (Object)response, (Matcher)Matchers.containsString((String)(HttpHeader.CACHE_CONTROL.asString() + ": max-age=3600,public")));
        }
        finally {
            this.stopServer();
        }
    }

    public static class ForceCacheControlFilter
    implements Filter {
        public void init(FilterConfig filterConfig) throws ServletException {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            httpResponse.setHeader(HttpHeader.CACHE_CONTROL.asString(), "max-age=0,private");
            chain.doFilter(request, response);
        }

        public void destroy() {
        }
    }
}

