/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.toolchain.test.MavenTestingUtils;
import org.eclipse.jetty.util.IO;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ServletContextResourcesTest {
    private Server server;
    private LocalConnector connector;
    private ServletContextHandler context;

    @BeforeEach
    public void init() throws Exception {
        this.server = new Server();
        this.connector = new LocalConnector(this.server);
        ((HttpConfiguration.ConnectionFactory)this.connector.getConnectionFactory(HttpConfiguration.ConnectionFactory.class)).getHttpConfiguration().setSendServerVersion(false);
        Path resBase = MavenTestingUtils.getTestResourcePathDir((String)"contextResources");
        this.context = new ServletContextHandler();
        this.context.setContextPath("/context");
        this.context.setResourceBase(resBase.toFile().toURI().toASCIIString());
        this.server.setHandler((Handler)this.context);
        this.server.addConnector((Connector)this.connector);
        this.server.start();
    }

    @AfterEach
    public void destroy() throws Exception {
        this.server.stop();
        this.server.join();
    }

    @Test
    public void testGetResourceAsStreamRoot() throws Exception {
        this.context.addServlet(ResourceAsStreamServlet.class, "/*");
        StringBuffer req1 = new StringBuffer();
        req1.append("GET /context/ HTTP/1.1\r\n");
        req1.append("Host: local\r\n");
        req1.append("Connection: close\r\n");
        req1.append("\r\n");
        String response = this.connector.getResponse(req1.toString());
        MatcherAssert.assertThat((String)"Response", (Object)response, (Matcher)Matchers.containsString((String)"Resource '/': <null>"));
    }

    @Test
    public void testGetResourceAsStreamContent() throws Exception {
        this.context.addServlet(ResourceAsStreamServlet.class, "/*");
        StringBuffer req1 = new StringBuffer();
        req1.append("GET /context/content.txt HTTP/1.1\r\n");
        req1.append("Host: local\r\n");
        req1.append("Connection: close\r\n");
        req1.append("\r\n");
        String response = this.connector.getResponse(req1.toString());
        MatcherAssert.assertThat((String)"Response", (Object)response, (Matcher)Matchers.containsString((String)"Resource '/content.txt': content goes here"));
    }

    public static class ResourceAsStreamServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            resp.setContentType("text/plain");
            resp.setCharacterEncoding("utf-8");
            String pathInfo = req.getPathInfo();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try (InputStream in = req.getServletContext().getResourceAsStream(pathInfo);){
                if (in == null) {
                    out.write("<null>".getBytes(StandardCharsets.UTF_8));
                } else {
                    IO.copy((InputStream)in, (OutputStream)out);
                }
            }
            String resourceContents = new String(out.toByteArray(), StandardCharsets.UTF_8);
            resp.getWriter().printf("Resource '%s': %s", pathInfo, resourceContents);
        }
    }
}

