/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import javax.servlet.AsyncContext;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpTester;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.component.LifeCycle;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;

public class AsyncDispatchEncodingTest {
    private Server server;
    private LocalConnector localConnector;

    public Server startServer(ServletContextHandler servletContextHandler) throws Exception {
        this.server = new Server();
        this.localConnector = new LocalConnector(this.server);
        this.server.addConnector((Connector)this.localConnector);
        HandlerList handlers = new HandlerList();
        handlers.addHandler((Handler)servletContextHandler);
        handlers.addHandler((Handler)new DefaultHandler());
        this.server.setHandler((Handler)handlers);
        this.server.start();
        return this.server;
    }

    @AfterEach
    public void stopServer() {
        LifeCycle.stop((Object)this.server);
    }

    @Test
    public void testAsyncDispatchBadClientQuery() throws Exception {
        ServletContextHandler contextHandler = new ServletContextHandler();
        contextHandler.setContextPath("/");
        ServletHolder asyncHolder = new ServletHolder((Servlet)new HttpServlet(){

            protected void doGet(HttpServletRequest req, HttpServletResponse resp) {
                AsyncContext asyncContext = req.startAsync();
                asyncContext.dispatch("/simple/?msg=Greetings%20Earthling");
            }
        });
        asyncHolder.setAsyncSupported(true);
        contextHandler.addServlet(asyncHolder, "/dispatch/");
        ServletHolder simpleHolder = new ServletHolder((Servlet)new HttpServlet(){

            protected void doGet(HttpServletRequest req, HttpServletResponse resp) {
                resp.setStatus(444);
            }
        });
        simpleHolder.setAsyncSupported(true);
        contextHandler.addServlet(simpleHolder, "/simple/*");
        this.startServer(contextHandler);
        StringBuilder rawReq = new StringBuilder();
        rawReq.append("GET /dispatch/?search=%E8. HTTP/1.1\r\n");
        rawReq.append("Host: local\r\n");
        rawReq.append("Connection: close\r\n");
        rawReq.append("\r\n");
        String rawResp = this.localConnector.getResponse(rawReq.toString());
        HttpTester.Response resp = HttpTester.parseResponse((String)rawResp);
        MatcherAssert.assertThat((String)"Response.status", (Object)resp.getStatus(), (Matcher)Matchers.is((Object)400));
    }

    @Test
    public void testAsyncDispatchBadAppQuery() throws Exception {
        ServletContextHandler contextHandler = new ServletContextHandler();
        contextHandler.setContextPath("/");
        ServletHolder asyncHolder = new ServletHolder((Servlet)new HttpServlet(){

            protected void doGet(HttpServletRequest req, HttpServletResponse resp) {
                AsyncContext asyncContext = req.startAsync();
                asyncContext.dispatch("/simple/?msg=%E8.");
            }
        });
        asyncHolder.setAsyncSupported(true);
        contextHandler.addServlet(asyncHolder, "/dispatch/");
        ServletHolder simpleHolder = new ServletHolder((Servlet)new HttpServlet(){

            protected void doGet(HttpServletRequest req, HttpServletResponse resp) {
                resp.setStatus(444);
            }
        });
        simpleHolder.setAsyncSupported(true);
        contextHandler.addServlet(simpleHolder, "/simple/*");
        this.startServer(contextHandler);
        StringBuilder rawReq = new StringBuilder();
        rawReq.append("GET /dispatch/?search=Invitation%20Sent HTTP/1.1\r\n");
        rawReq.append("Host: local\r\n");
        rawReq.append("Connection: close\r\n");
        rawReq.append("\r\n");
        String rawResp = this.localConnector.getResponse(rawReq.toString());
        HttpTester.Response resp = HttpTester.parseResponse((String)rawResp);
        MatcherAssert.assertThat((String)"Response.status", (Object)resp.getStatus(), (Matcher)Matchers.is((Object)500));
    }
}

