/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeoutException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.toolchain.test.jupiter.WorkDir;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.resource.PathResource;
import org.eclipse.jetty.util.resource.Resource;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class GzipHandlerIsHandledTest {
    public WorkDir workDir;
    private Server server;
    private HttpClient client;
    public LinkedBlockingQueue<String> events = new LinkedBlockingQueue();

    @BeforeEach
    public void setUp() throws Exception {
        this.server = new Server();
        ServerConnector connector = new ServerConnector(this.server);
        connector.setPort(0);
        this.server.addConnector((Connector)connector);
        HandlerCollection handlers = new HandlerCollection();
        ResourceHandler resourceHandler = new ResourceHandler();
        resourceHandler.setBaseResource((Resource)new PathResource(this.workDir.getPath()));
        resourceHandler.setDirectoriesListed(true);
        resourceHandler.setHandler((Handler)new EventHandler(this.events, "ResourceHandler"));
        GzipHandler gzipHandler = new GzipHandler();
        gzipHandler.setMinGzipSize(32);
        gzipHandler.setHandler((Handler)new EventHandler(this.events, "GzipHandler-wrapped-handler"));
        handlers.setHandlers(new Handler[]{resourceHandler, gzipHandler, new DefaultHandler()});
        this.server.setHandler((Handler)handlers);
        this.server.start();
        this.client = new HttpClient();
        this.client.start();
    }

    @AfterEach
    public void tearDown() {
        LifeCycle.stop((Object)this.client);
        LifeCycle.stop((Object)this.server);
    }

    @Test
    public void testRequest() throws ExecutionException, InterruptedException, TimeoutException {
        ContentResponse response = this.client.GET(this.server.getURI().resolve("/"));
        MatcherAssert.assertThat((String)"response.status", (Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((String)"response.content", (Object)response.getContentAsString(), (Matcher)Matchers.containsString((String)"Directory: /"));
        MatcherAssert.assertThat((String)"One event should have been recorded", (Object)this.events.size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((String)"Event indicating that GzipHandler-wrapped-handler ran", (Object)((String)this.events.remove()), (Matcher)Matchers.is((Object)"GzipHandler-wrapped-handler [request.isHandled=true, response.isCommitted=true]"));
    }

    private static class EventHandler
    extends AbstractHandler {
        private final LinkedBlockingQueue<String> events;
        private final String action;

        public EventHandler(LinkedBlockingQueue<String> events, String action) {
            this.events = events;
            this.action = action;
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            this.events.offer(String.format("%s [request.isHandled=%b, response.isCommitted=%b]", this.action, baseRequest.isHandled(), response.isCommitted()));
        }
    }
}

