/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URI;
import java.util.ArrayList;
import javax.servlet.DispatcherType;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.toolchain.test.IO;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class IncludedServletTest {
    private Server server;
    private URI baseUri;

    @BeforeEach
    public void startServer() throws Exception {
        this.server = new Server();
        ServerConnector connector = new ServerConnector(this.server);
        connector.setHost("localhost");
        connector.setPort(0);
        this.server.addConnector((Connector)connector);
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/");
        context.addServlet(TopServlet.class, "/top");
        context.addServlet(IncludedServlet.class, "/included");
        context.addServlet(IncludedAttrServlet.class, "/attr/*");
        this.server.setHandler((Handler)context);
        this.server.start();
        int port = connector.getLocalPort();
        String host = connector.getHost();
        this.baseUri = URI.create("http://" + host + ":" + port + "/");
    }

    @AfterEach
    public void stopServer() throws Exception {
        this.server.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTopWithIncludedHeader() throws IOException {
        URI uri = this.baseUri.resolve("/top");
        System.out.println("GET (String): " + uri.toASCIIString());
        InputStream in = null;
        InputStreamReader reader = null;
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)uri.toURL().openConnection();
            connection.connect();
            if (200 != connection.getResponseCode()) {
                String body = this.getPotentialBody(connection);
                String err = String.format("GET request failed (%d %s) %s%n%s", connection.getResponseCode(), connection.getResponseMessage(), uri.toASCIIString(), body);
                throw new IOException(err);
            }
            in = connection.getInputStream();
            reader = new InputStreamReader(in);
            StringWriter writer = new StringWriter();
            IO.copy((Reader)reader, (Writer)writer);
            String response = writer.toString();
            MatcherAssert.assertThat((String)"Response", (Object)response, (Matcher)Matchers.containsString((String)"<h2> Hello, this is the top page."));
            MatcherAssert.assertThat((String)"Response", (Object)response, (Matcher)Matchers.containsString((String)"<h3> This is the included page"));
            MatcherAssert.assertThat((String)"Response Header[main-page-key]", (Object)connection.getHeaderField("main-page-key"), (Matcher)Matchers.is((Object)"main-page-value"));
            MatcherAssert.assertThat((String)"Response Header[included-page-key]", (Object)connection.getHeaderField("included-page-key"), (Matcher)Matchers.is((Object)"included-page-value"));
        }
        catch (Throwable throwable) {
            IO.close(reader);
            IO.close(in);
            throw throwable;
        }
        IO.close((Closeable)reader);
        IO.close((Closeable)in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPotentialBody(HttpURLConnection connection) {
        String string;
        InputStream in = null;
        InputStreamReader reader = null;
        try {
            in = connection.getInputStream();
            reader = new InputStreamReader(in);
            StringWriter writer = new StringWriter();
            IO.copy((Reader)reader, (Writer)writer);
            string = writer.toString();
        }
        catch (IOException e) {
            String string2;
            try {
                string2 = "<no body:" + e.getMessage() + ">";
            }
            catch (Throwable throwable) {
                IO.close(reader);
                IO.close((Closeable)in);
                throw throwable;
            }
            IO.close((Closeable)reader);
            IO.close((Closeable)in);
            return string2;
        }
        IO.close((Closeable)reader);
        IO.close((Closeable)in);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIncludeAttributes() throws IOException {
        URI uri = this.baseUri.resolve("/attr/one");
        InputStream in = null;
        BufferedReader reader = null;
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)uri.toURL().openConnection();
            connection.connect();
            MatcherAssert.assertThat((Object)connection.getResponseCode(), (Matcher)Matchers.is((Object)200));
            in = connection.getInputStream();
            reader = new BufferedReader(new InputStreamReader(in));
            ArrayList<String> result = new ArrayList<String>();
            String line = reader.readLine();
            while (line != null) {
                result.add(line);
                line = reader.readLine();
            }
            MatcherAssert.assertThat(result, (Matcher)Matchers.contains((Object[])new String[]{"BEFORE0: javax.servlet.include.context_path='null'", "BEFORE0: javax.servlet.include.servlet_path='null'", "BEFORE0: javax.servlet.include.path_info='null'", "BEFORE1: javax.servlet.include.context_path=''", "BEFORE1: javax.servlet.include.servlet_path='/attr'", "BEFORE1: javax.servlet.include.path_info='/one'", "DURING: javax.servlet.include.context_path=''", "DURING: javax.servlet.include.servlet_path='/attr'", "DURING: javax.servlet.include.path_info='/two'", "AFTER1: javax.servlet.include.context_path=''", "AFTER1: javax.servlet.include.servlet_path='/attr'", "AFTER1: javax.servlet.include.path_info='/one'", "AFTER0: javax.servlet.include.context_path='null'", "AFTER0: javax.servlet.include.servlet_path='null'", "AFTER0: javax.servlet.include.path_info='null'"}));
        }
        catch (Throwable throwable) {
            IO.close(reader);
            IO.close(in);
            throw throwable;
        }
        IO.close((Closeable)reader);
        IO.close((Closeable)in);
    }

    public static class TopServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            req.getRequestDispatcher("/included").include((ServletRequest)req, (ServletResponse)resp);
            resp.setHeader("main-page-key", "main-page-value");
            PrintWriter out = resp.getWriter();
            out.println("<h2> Hello, this is the top page.");
        }
    }

    public static class IncludedServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            String headerPrefix = "";
            if (req.getDispatcherType() == DispatcherType.INCLUDE) {
                headerPrefix = "org.eclipse.jetty.server.include.";
            }
            resp.setHeader(headerPrefix + "included-page-key", "included-page-value");
            resp.getWriter().println("<h3> This is the included page");
        }
    }

    public static class IncludedAttrServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            if (req.getDispatcherType() == DispatcherType.INCLUDE) {
                if (req.getAttribute("included") == null) {
                    req.setAttribute("included", (Object)Boolean.TRUE);
                    this.dumpAttrs("BEFORE1", req, resp.getOutputStream());
                    req.getRequestDispatcher("two").include((ServletRequest)req, (ServletResponse)resp);
                    this.dumpAttrs("AFTER1", req, resp.getOutputStream());
                } else {
                    this.dumpAttrs("DURING", req, resp.getOutputStream());
                }
            } else {
                resp.setContentType("text/plain");
                this.dumpAttrs("BEFORE0", req, resp.getOutputStream());
                req.getRequestDispatcher("one").include((ServletRequest)req, (ServletResponse)resp);
                this.dumpAttrs("AFTER0", req, resp.getOutputStream());
            }
        }

        private void dumpAttrs(String tag, HttpServletRequest req, ServletOutputStream out) throws IOException {
            out.println(String.format("%s: %s='%s'", tag, "javax.servlet.include.context_path", req.getAttribute("javax.servlet.include.context_path")));
            out.println(String.format("%s: %s='%s'", tag, "javax.servlet.include.servlet_path", req.getAttribute("javax.servlet.include.servlet_path")));
            out.println(String.format("%s: %s='%s'", tag, "javax.servlet.include.path_info", req.getAttribute("javax.servlet.include.path_info")));
        }
    }
}

