/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.log.StacklessLogging;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class PostServletTest {
    private static final Logger LOG = Log.getLogger(PostServletTest.class);
    private static final AtomicBoolean posted = new AtomicBoolean(false);
    private static final AtomicReference<Throwable> ex0 = new AtomicReference();
    private static final AtomicReference<Throwable> ex1 = new AtomicReference();
    private static CountDownLatch complete;
    private Server server;
    private LocalConnector connector;

    @BeforeEach
    public void startServer() throws Exception {
        complete = new CountDownLatch(1);
        ex0.set(null);
        ex1.set(null);
        posted.set(false);
        this.server = new Server();
        this.connector = new LocalConnector(this.server);
        this.server.addConnector((Connector)this.connector);
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/");
        context.addServlet(BasicReadPostServlet.class, "/post");
        this.server.setHandler((Handler)context);
        this.server.start();
    }

    @AfterEach
    public void stopServer() throws Exception {
        this.server.stop();
    }

    @Test
    public void testGoodPost() throws Exception {
        StringBuilder req = new StringBuilder();
        req.append("POST /post HTTP/1.1\r\n");
        req.append("Host: localhost\r\n");
        req.append("Transfer-Encoding: chunked\r\n");
        req.append("\r\n");
        req.append("6\r\n");
        req.append("Hello ");
        req.append("\r\n");
        req.append("7\r\n");
        req.append("World!\n");
        req.append("\r\n");
        req.append("0\r\n");
        req.append("\r\n");
        String resp = this.connector.getResponse(req.toString());
        MatcherAssert.assertThat((String)"resp", (Object)resp, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((String)"resp", (Object)resp, (Matcher)Matchers.containsString((String)"chunked"));
        MatcherAssert.assertThat((String)"resp", (Object)resp, (Matcher)Matchers.containsString((String)"read 6"));
        MatcherAssert.assertThat((String)"resp", (Object)resp, (Matcher)Matchers.containsString((String)"read 7"));
        MatcherAssert.assertThat((String)"resp", (Object)resp, (Matcher)Matchers.containsString((String)"\r\n0\r\n"));
        MatcherAssert.assertThat((Object)ex0.get(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)ex1.get(), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testBadPost() throws Exception {
        StringBuilder req = new StringBuilder(16384);
        req.append("POST /post HTTP/1.1\r\n");
        req.append("Host: localhost\r\n");
        req.append("Transfer-Encoding: chunked\r\n");
        req.append("\r\n");
        int i = 1024;
        while (i-- > 0) {
            req.append("xxxxxxxxxxxx");
        }
        req.append("\r\n");
        req.append("\r\n");
        String resp = this.connector.getResponse(req.toString());
        MatcherAssert.assertThat((Object)resp, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200 OK"));
        Assertions.assertTrue((boolean)complete.await(5L, TimeUnit.SECONDS));
        MatcherAssert.assertThat((Object)ex0.get(), (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)ex1.get(), (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testDeferredBadPost() throws Exception {
        StringBuilder req = new StringBuilder(16384);
        req.append("POST /post HTTP/1.1\r\n");
        req.append("Host: localhost\r\n");
        req.append("Transfer-Encoding: chunked\r\n");
        req.append("\r\n");
        LocalConnector.LocalEndPoint endp = this.connector.executeRequest(req.toString());
        Thread.sleep(1000L);
        Assertions.assertFalse((boolean)posted.get());
        req.setLength(0);
        int i = 1024;
        while (i-- > 0) {
            req.append("xxxxxxxxxxxx");
        }
        req.append("\r\n");
        req.append("\r\n");
        endp.addInput(req.toString());
        endp.waitUntilClosedOrIdleFor(1L, TimeUnit.SECONDS);
        String resp = endp.takeOutputString();
        MatcherAssert.assertThat((Object)resp, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200 OK"));
        Assertions.assertTrue((boolean)complete.await(5L, TimeUnit.SECONDS));
        MatcherAssert.assertThat((Object)ex0.get(), (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)ex1.get(), (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testBadSplitPost() throws Exception {
        StringBuilder req = new StringBuilder();
        req.append("POST /post HTTP/1.1\r\n");
        req.append("Host: localhost\r\n");
        req.append("Connection: close\r\n");
        req.append("Transfer-Encoding: chunked\r\n");
        req.append("\r\n");
        req.append("6\r\n");
        req.append("Hello ");
        req.append("\r\n");
        try (StacklessLogging scope = new StacklessLogging(new Class[]{ServletHandler.class});){
            LocalConnector.LocalEndPoint endp = this.connector.executeRequest(req.toString());
            req.setLength(0);
            while (!posted.get()) {
                Thread.sleep(100L);
            }
            Thread.sleep(100L);
            req.append("x\r\n");
            req.append("World\n");
            req.append("\r\n");
            req.append("0\r\n");
            req.append("\r\n");
            endp.addInput(req.toString());
            endp.waitUntilClosedOrIdleFor(1L, TimeUnit.SECONDS);
            String resp = endp.takeOutputString();
            MatcherAssert.assertThat((String)"resp", (Object)resp, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 "));
            MatcherAssert.assertThat((String)"resp", (Object)resp, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"\r\n0\r\n")));
        }
        Assertions.assertTrue((boolean)complete.await(5L, TimeUnit.SECONDS));
        MatcherAssert.assertThat((Object)ex0.get(), (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)ex1.get(), (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
    }

    public static class BasicReadPostServlet
    extends HttpServlet {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doPost(HttpServletRequest request, HttpServletResponse response) {
            posted.set(true);
            byte[] buffer = new byte[1024];
            try {
                int len = request.getInputStream().read(buffer);
                while (len > 0) {
                    response.getOutputStream().println("read " + len);
                    response.getOutputStream().flush();
                    len = request.getInputStream().read(buffer);
                }
            }
            catch (Exception e) {
                ex0.set(e);
                try {
                    request.getInputStream().read(buffer);
                }
                catch (Exception ex) {
                    ex1.set(ex);
                    LOG.warn(ex.toString(), new Object[0]);
                }
            }
            finally {
                complete.countDown();
            }
        }
    }
}

