/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.io.IOException;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpTester;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.component.LifeCycle;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ServletWrapperTest {
    private Server server;
    private LocalConnector localConnector;

    @BeforeEach
    public void startServer() throws Exception {
        this.server = new Server();
        this.localConnector = new LocalConnector(this.server);
        this.server.addConnector((Connector)this.localConnector);
        ServerConnector connector = new ServerConnector(this.server);
        connector.setPort(0);
        this.server.addConnector((Connector)connector);
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/");
        ServletHolder servletHolder = context.addServlet(HelloServlet.class, "/hello");
        servletHolder.setAsyncSupported(false);
        FilterHolder filterHolder = context.addFilter(WrapFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        filterHolder.setAsyncSupported(true);
        HandlerList handlers = new HandlerList();
        handlers.addHandler((Handler)context);
        handlers.addHandler((Handler)new DefaultHandler());
        this.server.setHandler((Handler)handlers);
        this.server.start();
    }

    @AfterEach
    public void stopServer() {
        LifeCycle.stop((Object)this.server);
    }

    @Test
    public void testWrapper() throws Exception {
        StringBuilder req = new StringBuilder();
        req.append("GET /hello HTTP/1.1\r\n");
        req.append("Host: local\r\n");
        req.append("Connection: close\r\n");
        req.append("\r\n");
        String rawResponse = this.localConnector.getResponse(req.toString());
        HttpTester.Response resp = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((String)"Response.status", (Object)resp.getStatus(), (Matcher)Matchers.is((Object)200));
    }

    public static class HelloServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            resp.setContentType("text/plain");
            resp.setCharacterEncoding("utf-8");
            resp.getWriter().println("Hello Test");
        }
    }

    public static class WrapFilter
    implements Filter {
        public void init(FilterConfig filterConfig) throws ServletException {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
                chain.doFilter(request, response);
                return;
            }
            Object httpRequest = (HttpServletRequest)request;
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            httpRequest = new NoopRequestWrapper((HttpServletRequest)httpRequest);
            chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
        }

        public void destroy() {
        }
    }

    public static class NoopRequestWrapper
    extends HttpServletRequestWrapper {
        public NoopRequestWrapper(HttpServletRequest request) {
            super(request);
        }
    }
}

