/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlets;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.EventListener;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.PushBuilder;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class PushSessionCacheFilter
implements Filter {
    private static final String RESPONSE_ATTR = "PushSessionCacheFilter.response";
    private static final String TARGET_ATTR = "PushSessionCacheFilter.target";
    private static final String TIMESTAMP_ATTR = "PushSessionCacheFilter.timestamp";
    private static final Logger LOG = Log.getLogger(PushSessionCacheFilter.class);
    private final ConcurrentMap<String, Target> _cache = new ConcurrentHashMap<String, Target>();
    private long _associateDelay = 5000L;

    public void init(FilterConfig config) throws ServletException {
        if (config.getInitParameter("associateDelay") != null) {
            this._associateDelay = Long.parseLong(config.getInitParameter("associateDelay"));
        }
        config.getServletContext().addListener((EventListener)new ServletRequestListener(){

            public void requestDestroyed(ServletRequestEvent sre) {
                String referer;
                HttpServletRequest request = (HttpServletRequest)sre.getServletRequest();
                Target target = (Target)request.getAttribute(PushSessionCacheFilter.TARGET_ATTR);
                if (target == null) {
                    return;
                }
                HttpServletResponse response = (HttpServletResponse)request.getAttribute(PushSessionCacheFilter.RESPONSE_ATTR);
                target._etag = response.getHeader(HttpHeader.ETAG.asString());
                target._lastModified = response.getHeader(HttpHeader.LAST_MODIFIED.asString());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Served {} for {}", new Object[]{response.getStatus(), request.getRequestURI()});
                }
                if ((referer = request.getHeader(HttpHeader.REFERER.asString())) != null) {
                    HttpSession session;
                    ConcurrentHashMap timestamps;
                    Long last;
                    Target refererTarget;
                    HttpURI refererUri = new HttpURI(referer);
                    if (request.getServerName().equals(refererUri.getHost()) && (refererTarget = (Target)PushSessionCacheFilter.this._cache.get(refererUri.getPath())) != null && (last = (Long)(timestamps = (ConcurrentHashMap)(session = request.getSession()).getAttribute(PushSessionCacheFilter.TIMESTAMP_ATTR)).get(refererTarget._path)) != null && TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - last) < PushSessionCacheFilter.this._associateDelay && refererTarget._associated.putIfAbsent(target._path, target) == null && LOG.isDebugEnabled()) {
                        LOG.debug("ASSOCIATE {}->{}", new Object[]{refererTarget._path, target._path});
                    }
                }
            }

            public void requestInitialized(ServletRequestEvent sre) {
            }
        });
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        req.setAttribute(RESPONSE_ATTR, (Object)resp);
        HttpServletRequest request = (HttpServletRequest)req;
        String uri = request.getRequestURI();
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} {}", new Object[]{request.getMethod(), uri});
        }
        HttpSession session = request.getSession(true);
        Target target = (Target)this._cache.get(uri);
        if (target == null) {
            Target t = new Target(uri);
            target = this._cache.putIfAbsent(uri, t);
            target = target == null ? t : target;
        }
        request.setAttribute(TARGET_ATTR, (Object)target);
        ConcurrentHashMap<String, Long> timestamps = (ConcurrentHashMap<String, Long>)session.getAttribute(TIMESTAMP_ATTR);
        if (timestamps == null) {
            timestamps = new ConcurrentHashMap<String, Long>();
            session.setAttribute(TIMESTAMP_ATTR, timestamps);
        }
        timestamps.put(uri, System.nanoTime());
        PushBuilder builder = request.newPushBuilder();
        if (builder != null && !target._associated.isEmpty()) {
            boolean conditional = request.getHeader(HttpHeader.IF_NONE_MATCH.asString()) != null || request.getHeader(HttpHeader.IF_MODIFIED_SINCE.asString()) != null;
            ArrayDeque<Target> queue = new ArrayDeque<Target>();
            queue.offer(target);
            while (!queue.isEmpty()) {
                Target parent = (Target)queue.poll();
                builder.addHeader("X-Pusher", PushSessionCacheFilter.class.toString());
                for (Target child : parent._associated.values()) {
                    queue.offer(child);
                    String path = child._path;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("PUSH {} <- {}", new Object[]{path, uri});
                    }
                    builder.path(path).setHeader(HttpHeader.IF_NONE_MATCH.asString(), conditional ? child._etag : null).setHeader(HttpHeader.IF_MODIFIED_SINCE.asString(), conditional ? child._lastModified : null);
                }
            }
        }
        chain.doFilter(req, resp);
    }

    public void destroy() {
        this._cache.clear();
    }

    private static class Target {
        private final String _path;
        private final ConcurrentMap<String, Target> _associated = new ConcurrentHashMap<String, Target>();
        private volatile String _etag;
        private volatile String _lastModified;

        private Target(String path) {
            this._path = path;
        }

        public String toString() {
            return String.format("Target{p=%s,e=%s,m=%s,a=%d}", this._path, this._etag, this._lastModified, this._associated.size());
        }
    }
}

