/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlets;

import java.io.IOException;
import java.util.HashSet;
import java.util.Queue;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.eclipse.jetty.continuation.Continuation;
import org.eclipse.jetty.continuation.ContinuationListener;
import org.eclipse.jetty.continuation.ContinuationSupport;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.thread.Timeout;

public class DoSFilter
implements Filter {
    static final String __TRACKER = "DoSFilter.Tracker";
    static final String __THROTTLED = "DoSFilter.Throttled";
    static final int __DEFAULT_MAX_REQUESTS_PER_SEC = 25;
    static final int __DEFAULT_DELAY_MS = 100;
    static final int __DEFAULT_THROTTLE = 5;
    static final int __DEFAULT_WAIT_MS = 50;
    static final long __DEFAULT_THROTTLE_MS = 30000L;
    static final long __DEFAULT_MAX_REQUEST_MS_INIT_PARAM = 30000L;
    static final long __DEFAULT_MAX_IDLE_TRACKER_MS_INIT_PARAM = 30000L;
    static final String MAX_REQUESTS_PER_S_INIT_PARAM = "maxRequestsPerSec";
    static final String DELAY_MS_INIT_PARAM = "delayMs";
    static final String THROTTLED_REQUESTS_INIT_PARAM = "throttledRequests";
    static final String MAX_WAIT_INIT_PARAM = "maxWaitMs";
    static final String THROTTLE_MS_INIT_PARAM = "throttleMs";
    static final String MAX_REQUEST_MS_INIT_PARAM = "maxRequestMs";
    static final String MAX_IDLE_TRACKER_MS_INIT_PARAM = "maxIdleTrackerMs";
    static final String INSERT_HEADERS_INIT_PARAM = "insertHeaders";
    static final String TRACK_SESSIONS_INIT_PARAM = "trackSessions";
    static final String REMOTE_PORT_INIT_PARAM = "remotePort";
    static final String IP_WHITELIST_INIT_PARAM = "ipWhitelist";
    static final int USER_AUTH = 2;
    static final int USER_SESSION = 2;
    static final int USER_IP = 1;
    static final int USER_UNKNOWN = 0;
    ServletContext _context;
    protected long _delayMs;
    protected long _throttleMs;
    protected long _waitMs;
    protected long _maxRequestMs;
    protected long _maxIdleTrackerMs;
    protected boolean _insertHeaders;
    protected boolean _trackSessions;
    protected boolean _remotePort;
    protected Semaphore _passes;
    protected Queue<Continuation>[] _queue;
    protected ContinuationListener[] _listener;
    protected int _maxRequestsPerSec;
    protected final ConcurrentHashMap<String, RateTracker> _rateTrackers = new ConcurrentHashMap();
    private HashSet<String> _whitelist;
    private final Timeout _requestTimeoutQ = new Timeout();
    private final Timeout _trackerTimeoutQ = new Timeout();
    private Thread _timerThread;
    private volatile boolean _running;

    public void init(FilterConfig filterConfig) {
        this._context = filterConfig.getServletContext();
        this._queue = new Queue[this.getMaxPriority() + 1];
        this._listener = new ContinuationListener[this.getMaxPriority() + 1];
        for (int p = 0; p < this._queue.length; ++p) {
            this._queue[p] = new ConcurrentLinkedQueue<Continuation>();
            final int priority = p;
            this._listener[p] = new ContinuationListener(){

                public void onComplete(Continuation continuation) {
                }

                public void onTimeout(Continuation continuation) {
                    DoSFilter.this._queue[priority].remove(continuation);
                }
            };
        }
        int baseRateLimit = 25;
        if (filterConfig.getInitParameter(MAX_REQUESTS_PER_S_INIT_PARAM) != null) {
            baseRateLimit = Integer.parseInt(filterConfig.getInitParameter(MAX_REQUESTS_PER_S_INIT_PARAM));
        }
        this._maxRequestsPerSec = baseRateLimit;
        long delay = 100L;
        if (filterConfig.getInitParameter(DELAY_MS_INIT_PARAM) != null) {
            delay = Integer.parseInt(filterConfig.getInitParameter(DELAY_MS_INIT_PARAM));
        }
        this._delayMs = delay;
        int passes = 5;
        if (filterConfig.getInitParameter(THROTTLED_REQUESTS_INIT_PARAM) != null) {
            passes = Integer.parseInt(filterConfig.getInitParameter(THROTTLED_REQUESTS_INIT_PARAM));
        }
        this._passes = new Semaphore(passes, true);
        long wait = 50L;
        if (filterConfig.getInitParameter(MAX_WAIT_INIT_PARAM) != null) {
            wait = Integer.parseInt(filterConfig.getInitParameter(MAX_WAIT_INIT_PARAM));
        }
        this._waitMs = wait;
        long suspend = 30000L;
        if (filterConfig.getInitParameter(THROTTLE_MS_INIT_PARAM) != null) {
            suspend = Integer.parseInt(filterConfig.getInitParameter(THROTTLE_MS_INIT_PARAM));
        }
        this._throttleMs = suspend;
        long maxRequestMs = 30000L;
        if (filterConfig.getInitParameter(MAX_REQUEST_MS_INIT_PARAM) != null) {
            maxRequestMs = Long.parseLong(filterConfig.getInitParameter(MAX_REQUEST_MS_INIT_PARAM));
        }
        this._maxRequestMs = maxRequestMs;
        long maxIdleTrackerMs = 30000L;
        if (filterConfig.getInitParameter(MAX_IDLE_TRACKER_MS_INIT_PARAM) != null) {
            maxIdleTrackerMs = Long.parseLong(filterConfig.getInitParameter(MAX_IDLE_TRACKER_MS_INIT_PARAM));
        }
        this._maxIdleTrackerMs = maxIdleTrackerMs;
        String whitelistString = "";
        if (filterConfig.getInitParameter(IP_WHITELIST_INIT_PARAM) != null) {
            whitelistString = filterConfig.getInitParameter(IP_WHITELIST_INIT_PARAM);
        }
        if (whitelistString.length() == 0) {
            this._whitelist = new HashSet();
        } else {
            StringTokenizer tokenizer = new StringTokenizer(whitelistString, ",");
            this._whitelist = new HashSet(tokenizer.countTokens());
            while (tokenizer.hasMoreTokens()) {
                this._whitelist.add(tokenizer.nextToken().trim());
            }
            Log.info((String)"Whitelisted IP addresses: {}", (Object)this._whitelist.toString());
        }
        String tmp = filterConfig.getInitParameter(INSERT_HEADERS_INIT_PARAM);
        this._insertHeaders = tmp == null || Boolean.parseBoolean(tmp);
        tmp = filterConfig.getInitParameter(TRACK_SESSIONS_INIT_PARAM);
        this._trackSessions = tmp == null || Boolean.parseBoolean(tmp);
        tmp = filterConfig.getInitParameter(REMOTE_PORT_INIT_PARAM);
        this._remotePort = tmp != null && Boolean.parseBoolean(tmp);
        this._requestTimeoutQ.setNow();
        this._requestTimeoutQ.setDuration(this._maxRequestMs);
        this._trackerTimeoutQ.setNow();
        this._trackerTimeoutQ.setDuration(this._maxIdleTrackerMs);
        this._running = true;
        this._timerThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    while (DoSFilter.this._running) {
                        Timeout timeout = DoSFilter.this._requestTimeoutQ;
                        synchronized (timeout) {
                            DoSFilter.this._requestTimeoutQ.setNow();
                            DoSFilter.this._requestTimeoutQ.tick();
                            DoSFilter.this._trackerTimeoutQ.setNow(DoSFilter.this._requestTimeoutQ.getNow());
                            DoSFilter.this._trackerTimeoutQ.tick();
                        }
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            Log.ignore((Throwable)e);
                        }
                    }
                }
                finally {
                    Log.info((String)"DoSFilter timer exited");
                }
            }
        };
        this._timerThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterchain) throws IOException, ServletException {
        HttpServletRequest srequest = (HttpServletRequest)request;
        HttpServletResponse sresponse = (HttpServletResponse)response;
        long now = this._requestTimeoutQ.getNow();
        RateTracker tracker = (RateTracker)((Object)request.getAttribute(__TRACKER));
        if (tracker == null) {
            tracker = this.getRateTracker(request);
            boolean overRateLimit = tracker.isRateExceeded(now);
            if (!overRateLimit) {
                this.doFilterChain(filterchain, srequest, sresponse);
                return;
            }
            Log.warn((String)("DOS ALERT: ip=" + srequest.getRemoteAddr() + ",session=" + srequest.getRequestedSessionId() + ",user=" + srequest.getUserPrincipal()));
            switch ((int)this._delayMs) {
                case -1: {
                    if (this._insertHeaders) {
                        ((HttpServletResponse)response).addHeader("DoSFilter", "unavailable");
                    }
                    ((HttpServletResponse)response).sendError(503);
                    return;
                }
                case 0: {
                    request.setAttribute(__TRACKER, (Object)tracker);
                    break;
                }
                default: {
                    if (this._insertHeaders) {
                        ((HttpServletResponse)response).addHeader("DoSFilter", "delayed");
                    }
                    Continuation continuation = ContinuationSupport.getContinuation((ServletRequest)request);
                    request.setAttribute(__TRACKER, (Object)tracker);
                    if (this._delayMs > 0L) {
                        continuation.setTimeout(this._delayMs);
                    }
                    continuation.suspend();
                    return;
                }
            }
        }
        boolean accepted = false;
        try {
            accepted = this._passes.tryAcquire(this._waitMs, TimeUnit.MILLISECONDS);
            if (!accepted) {
                Continuation continuation = ContinuationSupport.getContinuation((ServletRequest)request);
                Boolean throttled = (Boolean)request.getAttribute(__THROTTLED);
                if (throttled != Boolean.TRUE && this._throttleMs > 0L) {
                    int priority = this.getPriority(request, tracker);
                    request.setAttribute(__THROTTLED, (Object)Boolean.TRUE);
                    if (this._insertHeaders) {
                        ((HttpServletResponse)response).addHeader("DoSFilter", "throttled");
                    }
                    if (this._throttleMs > 0L) {
                        continuation.setTimeout(this._throttleMs);
                    }
                    continuation.suspend();
                    continuation.addContinuationListener(this._listener[priority]);
                    this._queue[priority].add(continuation);
                    return;
                }
                if (request.getAttribute("javax.servlet.resumed") == Boolean.TRUE) {
                    this._passes.acquire();
                    accepted = true;
                }
            }
            if (accepted) {
                this.doFilterChain(filterchain, srequest, sresponse);
            } else {
                if (this._insertHeaders) {
                    ((HttpServletResponse)response).addHeader("DoSFilter", "unavailable");
                }
                ((HttpServletResponse)response).sendError(503);
            }
        }
        catch (InterruptedException e) {
            this._context.log("DoS", (Throwable)e);
            ((HttpServletResponse)response).sendError(503);
        }
        finally {
            if (accepted) {
                int p = this._queue.length;
                while (p-- > 0) {
                    Continuation continuation = this._queue[p].poll();
                    if (continuation == null || !continuation.isSuspended()) continue;
                    continuation.resume();
                    break;
                }
                this._passes.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterChain(FilterChain chain, final HttpServletRequest request, final HttpServletResponse response) throws IOException, ServletException {
        Timeout timeout;
        final Thread thread = Thread.currentThread();
        Timeout.Task requestTimeout = new Timeout.Task(){

            public void expired() {
                DoSFilter.this.closeConnection(request, response, thread);
            }
        };
        try {
            timeout = this._requestTimeoutQ;
            synchronized (timeout) {
                this._requestTimeoutQ.schedule(requestTimeout);
            }
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            timeout = this._requestTimeoutQ;
            synchronized (timeout) {
                requestTimeout.cancel();
            }
        }
    }

    protected void closeConnection(HttpServletRequest request, HttpServletResponse response, Thread thread) {
        if (!response.isCommitted()) {
            response.setHeader("Connection", "close");
        }
        try {
            try {
                response.getWriter().close();
            }
            catch (IllegalStateException e) {
                response.getOutputStream().close();
            }
        }
        catch (IOException e) {
            Log.warn((Throwable)e);
        }
        thread.interrupt();
    }

    protected int getPriority(ServletRequest request, RateTracker tracker) {
        if (this.extractUserId(request) != null) {
            return 2;
        }
        if (tracker != null) {
            return tracker.getType();
        }
        return 0;
    }

    protected int getMaxPriority() {
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RateTracker getRateTracker(ServletRequest request) {
        int type;
        HttpServletRequest srequest = (HttpServletRequest)request;
        String loadId = this.extractUserId(request);
        HttpSession session = srequest.getSession(false);
        if (this._trackSessions && session != null && !session.isNew()) {
            loadId = session.getId();
            type = 2;
        } else {
            loadId = this._remotePort ? request.getRemoteAddr() + request.getRemotePort() : request.getRemoteAddr();
            type = 1;
        }
        RateTracker tracker = this._rateTrackers.get(loadId);
        if (tracker == null) {
            RateTracker t = this._whitelist.contains(request.getRemoteAddr()) ? new FixedRateTracker(loadId, type, this._maxRequestsPerSec) : new RateTracker(loadId, type, this._maxRequestsPerSec);
            tracker = this._rateTrackers.putIfAbsent(loadId, t);
            if (tracker == null) {
                tracker = t;
            }
            if (type == 1) {
                Timeout timeout = this._trackerTimeoutQ;
                synchronized (timeout) {
                    this._trackerTimeoutQ.schedule((Timeout.Task)tracker);
                }
            } else if (session != null) {
                session.setAttribute(__TRACKER, (Object)tracker);
            }
        }
        return tracker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this._running = false;
        this._timerThread.interrupt();
        Timeout timeout = this._requestTimeoutQ;
        synchronized (timeout) {
            this._requestTimeoutQ.cancelAll();
            this._trackerTimeoutQ.cancelAll();
        }
    }

    protected String extractUserId(ServletRequest request) {
        return null;
    }

    class FixedRateTracker
    extends RateTracker {
        public FixedRateTracker(String id, int type, int numRecentRequestsTracked) {
            super(id, type, numRecentRequestsTracked);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isRateExceeded(long now) {
            FixedRateTracker fixedRateTracker = this;
            synchronized (fixedRateTracker) {
                this._timestamps[this._next] = now;
                this._next = (this._next + 1) % this._timestamps.length;
            }
            return false;
        }
    }

    class RateTracker
    extends Timeout.Task
    implements HttpSessionBindingListener {
        protected final String _id;
        protected final int _type;
        protected final long[] _timestamps;
        protected int _next;

        public RateTracker(String id, int type, int maxRequestsPerSecond) {
            this._id = id;
            this._type = type;
            this._timestamps = new long[maxRequestsPerSecond];
            this._next = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isRateExceeded(long now) {
            long last;
            RateTracker rateTracker = this;
            synchronized (rateTracker) {
                last = this._timestamps[this._next];
                this._timestamps[this._next] = now;
                this._next = (this._next + 1) % this._timestamps.length;
            }
            boolean exceeded = last != 0L && now - last < 1000L;
            return exceeded;
        }

        public String getId() {
            return this._id;
        }

        public int getType() {
            return this._type;
        }

        public void valueBound(HttpSessionBindingEvent event) {
        }

        public void valueUnbound(HttpSessionBindingEvent event) {
            DoSFilter.this._rateTrackers.remove(this._id);
        }

        public void expired() {
            boolean hasRecentRequest;
            long now = DoSFilter.this._trackerTimeoutQ.getNow();
            int latestIndex = this._next == 0 ? 3 : (this._next - 1) % this._timestamps.length;
            long last = this._timestamps[latestIndex];
            boolean bl = hasRecentRequest = last != 0L && now - last < 1000L;
            if (hasRecentRequest) {
                this.reschedule();
            } else {
                DoSFilter.this._rateTrackers.remove(this._id);
            }
        }
    }
}

