/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlets;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.continuation.Continuation;
import org.eclipse.jetty.continuation.ContinuationSupport;
import org.eclipse.jetty.http.HttpHeaderValues;
import org.eclipse.jetty.http.HttpHeaders;
import org.eclipse.jetty.http.HttpSchemes;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.PathMap;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.util.HostMap;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

public class ProxyServlet
implements Servlet {
    protected Logger _log;
    protected HttpClient _client;
    protected String _hostHeader;
    protected HashSet<String> _DontProxyHeaders = new HashSet();
    protected ServletConfig _config;
    protected ServletContext _context;
    protected HostMap<PathMap> _white;
    protected HostMap<PathMap> _black;

    public ProxyServlet() {
        this._DontProxyHeaders.add("proxy-connection");
        this._DontProxyHeaders.add("connection");
        this._DontProxyHeaders.add("keep-alive");
        this._DontProxyHeaders.add("transfer-encoding");
        this._DontProxyHeaders.add("te");
        this._DontProxyHeaders.add("trailer");
        this._DontProxyHeaders.add("proxy-authorization");
        this._DontProxyHeaders.add("proxy-authenticate");
        this._DontProxyHeaders.add("upgrade");
        this._white = new HostMap();
        this._black = new HostMap();
    }

    public void init(ServletConfig config) throws ServletException {
        this._config = config;
        this._context = config.getServletContext();
        this._hostHeader = config.getInitParameter("HostHeader");
        try {
            String black;
            String white;
            this._log = this.createLogger(config);
            this._client = this.createHttpClient(config);
            if (this._context != null) {
                this._context.setAttribute(config.getServletName() + ".ThreadPool", (Object)this._client.getThreadPool());
                this._context.setAttribute(config.getServletName() + ".HttpClient", (Object)this._client);
            }
            if ((white = config.getInitParameter("whiteList")) != null) {
                this.parseList(white, this._white);
            }
            if ((black = config.getInitParameter("blackList")) != null) {
                this.parseList(black, this._black);
            }
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void destroy() {
        try {
            this._client.stop();
        }
        catch (Exception x) {
            this._log.debug((Throwable)x);
        }
    }

    protected Logger createLogger(ServletConfig config) {
        return Log.getLogger((String)("org.eclipse.jetty.servlets." + config.getServletName()));
    }

    protected HttpClient createHttpClient(ServletConfig config) throws Exception {
        HttpClient client = new HttpClient();
        client.setConnectorType(2);
        String t = config.getInitParameter("maxThreads");
        if (t != null) {
            client.setThreadPool((ThreadPool)new QueuedThreadPool(Integer.parseInt(t)));
        } else {
            client.setThreadPool((ThreadPool)new QueuedThreadPool());
        }
        ((QueuedThreadPool)client.getThreadPool()).setName(config.getServletName());
        t = config.getInitParameter("maxConnections");
        if (t != null) {
            client.setMaxConnectionsPerAddress(Integer.parseInt(t));
        }
        if ((t = config.getInitParameter("timeout")) != null) {
            client.setTimeout(Long.parseLong(t));
        }
        if ((t = config.getInitParameter("idleTimeout")) != null) {
            client.setIdleTimeout(Long.parseLong(t));
        }
        if ((t = config.getInitParameter("requestHeaderSize")) != null) {
            client.setRequestHeaderSize(Integer.parseInt(t));
        }
        if ((t = config.getInitParameter("requestBufferSize")) != null) {
            client.setRequestBufferSize(Integer.parseInt(t));
        }
        if ((t = config.getInitParameter("responseHeaderSize")) != null) {
            client.setResponseHeaderSize(Integer.parseInt(t));
        }
        if ((t = config.getInitParameter("responseBufferSize")) != null) {
            client.setResponseBufferSize(Integer.parseInt(t));
        }
        client.start();
        return client;
    }

    private void parseList(String list, HostMap<PathMap> hostMap) {
        if (list != null && list.length() > 0) {
            StringTokenizer entries = new StringTokenizer(list, ",");
            while (entries.hasMoreTokens()) {
                String entry = entries.nextToken();
                int idx = entry.indexOf(47);
                String host = idx > 0 ? entry.substring(0, idx) : entry;
                String path = idx > 0 ? entry.substring(idx) : "/*";
                PathMap pathMap = (PathMap)hostMap.get((Object)(host = host.trim()));
                if (pathMap == null) {
                    pathMap = new PathMap(true);
                    hostMap.put(host, (Object)pathMap);
                }
                if (path == null) continue;
                pathMap.put((Object)path, (Object)path);
            }
        }
    }

    public boolean validateDestination(String host, String path) {
        Object blackObj;
        if (this._white.size() > 0) {
            boolean match = false;
            Object whiteObj = this._white.getLazyMatches(host);
            if (whiteObj != null) {
                Object entry;
                PathMap pathMap;
                List<Object> whiteList = whiteObj instanceof List ? (List<Object>)whiteObj : Collections.singletonList(whiteObj);
                Iterator<Object> i$ = whiteList.iterator();
                while (i$.hasNext() && !(match = (pathMap = (PathMap)((Map.Entry)(entry = i$.next())).getValue()) != null && (pathMap.size() == 0 || pathMap.match(path) != null))) {
                }
            }
            if (!match) {
                return false;
            }
        }
        if (this._black.size() > 0 && (blackObj = this._black.getLazyMatches(host)) != null) {
            List<Object> blackList = blackObj instanceof List ? (List<Object>)blackObj : Collections.singletonList(blackObj);
            for (Object entry : blackList) {
                PathMap pathMap = (PathMap)((Map.Entry)entry).getValue();
                if (pathMap == null || pathMap.size() != 0 && pathMap.match(path) == null) continue;
                return false;
            }
        }
        return true;
    }

    public ServletConfig getServletConfig() {
        return this._config;
    }

    public String getHostHeader() {
        return this._hostHeader;
    }

    public void setHostHeader(String hostHeader) {
        this._hostHeader = hostHeader;
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        final int debug = this._log.isDebugEnabled() ? req.hashCode() : 0;
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        if ("CONNECT".equalsIgnoreCase(request.getMethod())) {
            this.handleConnect(request, response);
        } else {
            ServletInputStream in = request.getInputStream();
            ServletOutputStream out = response.getOutputStream();
            final Continuation continuation = ContinuationSupport.getContinuation((ServletRequest)request);
            if (!continuation.isInitial()) {
                response.sendError(504);
            } else {
                long ctimeout;
                String connectionHdr;
                String uri = request.getRequestURI();
                if (request.getQueryString() != null) {
                    uri = uri + "?" + request.getQueryString();
                }
                HttpURI url = this.proxyHttpURI(request.getScheme(), request.getServerName(), request.getServerPort(), uri);
                if (debug != 0) {
                    this._log.debug(debug + " proxy " + uri + "-->" + url, new Object[0]);
                }
                if (url == null) {
                    response.sendError(403);
                    return;
                }
                HttpExchange exchange = new HttpExchange((OutputStream)out, response, request){
                    final /* synthetic */ OutputStream val$out;
                    final /* synthetic */ HttpServletResponse val$response;
                    final /* synthetic */ HttpServletRequest val$request;
                    {
                        this.val$out = outputStream;
                        this.val$response = httpServletResponse;
                        this.val$request = httpServletRequest;
                    }

                    protected void onRequestCommitted() throws IOException {
                    }

                    protected void onRequestComplete() throws IOException {
                    }

                    protected void onResponseComplete() throws IOException {
                        if (debug != 0) {
                            ProxyServlet.this._log.debug(debug + " complete", new Object[0]);
                        }
                        continuation.complete();
                    }

                    protected void onResponseContent(Buffer content) throws IOException {
                        if (debug != 0) {
                            ProxyServlet.this._log.debug(debug + " content" + content.length(), new Object[0]);
                        }
                        content.writeTo(this.val$out);
                    }

                    protected void onResponseHeaderComplete() throws IOException {
                    }

                    protected void onResponseStatus(Buffer version, int status, Buffer reason) throws IOException {
                        if (debug != 0) {
                            ProxyServlet.this._log.debug(debug + " " + version + " " + status + " " + reason, new Object[0]);
                        }
                        if (reason != null && reason.length() > 0) {
                            this.val$response.setStatus(status, reason.toString());
                        } else {
                            this.val$response.setStatus(status);
                        }
                    }

                    protected void onResponseHeader(Buffer name, Buffer value) throws IOException {
                        String s = name.toString().toLowerCase();
                        if (!ProxyServlet.this._DontProxyHeaders.contains(s) || HttpHeaders.CONNECTION_BUFFER.equals(name) && HttpHeaderValues.CLOSE_BUFFER.equals(value)) {
                            if (debug != 0) {
                                ProxyServlet.this._log.debug(debug + " " + name + ": " + value, new Object[0]);
                            }
                            this.val$response.addHeader(name.toString(), value.toString());
                        } else if (debug != 0) {
                            ProxyServlet.this._log.debug(debug + " " + name + "! " + value, new Object[0]);
                        }
                    }

                    protected void onConnectionFailed(Throwable ex) {
                        ProxyServlet.this.handleOnConnectionFailed(ex, this.val$request, this.val$response);
                        if (!continuation.isInitial()) {
                            continuation.complete();
                        }
                    }

                    protected void onException(Throwable ex) {
                        if (ex instanceof EofException) {
                            ProxyServlet.this._log.ignore(ex);
                            return;
                        }
                        ProxyServlet.this.handleOnException(ex, this.val$request, this.val$response);
                        if (!continuation.isInitial()) {
                            continuation.complete();
                        }
                    }

                    protected void onExpire() {
                        ProxyServlet.this.handleOnExpire(this.val$request, this.val$response);
                        continuation.complete();
                    }
                };
                exchange.setScheme("https".equals(request.getScheme()) ? HttpSchemes.HTTPS_BUFFER : HttpSchemes.HTTP_BUFFER);
                exchange.setMethod(request.getMethod());
                exchange.setURL(url.toString());
                exchange.setVersion(request.getProtocol());
                if (debug != 0) {
                    this._log.debug(debug + " " + request.getMethod() + " " + url + " " + request.getProtocol(), new Object[0]);
                }
                if ((connectionHdr = request.getHeader("Connection")) != null && (connectionHdr = connectionHdr.toLowerCase()).indexOf("keep-alive") < 0 && connectionHdr.indexOf("close") < 0) {
                    connectionHdr = null;
                }
                if (this._hostHeader != null) {
                    exchange.setRequestHeader("Host", this._hostHeader);
                }
                boolean xForwardedFor = false;
                boolean hasContent = false;
                long contentLength = -1L;
                Enumeration enm = request.getHeaderNames();
                while (enm.hasMoreElements()) {
                    String hdr = (String)enm.nextElement();
                    String lhdr = hdr.toLowerCase();
                    if (this._DontProxyHeaders.contains(lhdr) || connectionHdr != null && connectionHdr.indexOf(lhdr) >= 0 || this._hostHeader != null && "host".equals(lhdr)) continue;
                    if ("content-type".equals(lhdr)) {
                        hasContent = true;
                    } else if ("content-length".equals(lhdr)) {
                        contentLength = request.getContentLength();
                        exchange.setRequestHeader("Content-Length", Long.toString(contentLength));
                        if (contentLength > 0L) {
                            hasContent = true;
                        }
                    } else if ("x-forwarded-for".equals(lhdr)) {
                        xForwardedFor = true;
                    }
                    Enumeration vals = request.getHeaders(hdr);
                    while (vals.hasMoreElements()) {
                        String val = (String)vals.nextElement();
                        if (val == null) continue;
                        if (debug != 0) {
                            this._log.debug(debug + " " + hdr + ": " + val, new Object[0]);
                        }
                        exchange.setRequestHeader(hdr, val);
                    }
                }
                exchange.setRequestHeader("Via", "1.1 (jetty)");
                if (!xForwardedFor) {
                    exchange.addRequestHeader("X-Forwarded-For", request.getRemoteAddr());
                    exchange.addRequestHeader("X-Forwarded-Proto", request.getScheme());
                    exchange.addRequestHeader("X-Forwarded-Host", request.getHeader("Host"));
                    exchange.addRequestHeader("X-Forwarded-Server", request.getLocalName());
                }
                if (hasContent) {
                    exchange.setRequestContentSource((InputStream)in);
                }
                this.customizeExchange(exchange, request);
                long l = ctimeout = this._client.getTimeout() > exchange.getTimeout() ? this._client.getTimeout() : exchange.getTimeout();
                if (ctimeout == 0L) {
                    continuation.setTimeout(0L);
                } else {
                    continuation.setTimeout(ctimeout + 1000L);
                }
                this.customizeContinuation(continuation);
                continuation.suspend((ServletResponse)response);
                this._client.send(exchange);
            }
        }
    }

    public void handleConnect(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String uri = request.getRequestURI();
        String port = "";
        String host = "";
        int c = uri.indexOf(58);
        if (c >= 0) {
            port = uri.substring(c + 1);
            host = uri.substring(0, c);
            if (host.indexOf(47) > 0) {
                host = host.substring(host.indexOf(47) + 1);
            }
        }
        InetSocketAddress inetAddress = new InetSocketAddress(host, Integer.parseInt(port));
        ServletInputStream in = request.getInputStream();
        ServletOutputStream out = response.getOutputStream();
        Socket socket = new Socket(inetAddress.getAddress(), inetAddress.getPort());
        response.setStatus(200);
        response.setHeader("Connection", "close");
        response.flushBuffer();
        IO.copyThread((InputStream)socket.getInputStream(), (OutputStream)out);
        IO.copy((InputStream)in, (OutputStream)socket.getOutputStream());
    }

    protected HttpURI proxyHttpURI(String scheme, String serverName, int serverPort, String uri) throws MalformedURLException {
        if (!this.validateDestination(serverName, uri)) {
            return null;
        }
        return new HttpURI(scheme + "://" + serverName + ":" + serverPort + uri);
    }

    public String getServletInfo() {
        return "Proxy Servlet";
    }

    protected void customizeExchange(HttpExchange exchange, HttpServletRequest request) {
    }

    protected void customizeContinuation(Continuation continuation) {
    }

    protected void handleOnConnectionFailed(Throwable ex, HttpServletRequest request, HttpServletResponse response) {
        this.handleOnException(ex, request, response);
    }

    protected void handleOnException(Throwable ex, HttpServletRequest request, HttpServletResponse response) {
        if (ex instanceof IOException) {
            this._log.warn(ex.toString(), new Object[0]);
            this._log.debug(ex);
        } else {
            this._log.warn(ex);
        }
        if (!response.isCommitted()) {
            response.setStatus(500);
        }
    }

    protected void handleOnExpire(HttpServletRequest request, HttpServletResponse response) {
        if (!response.isCommitted()) {
            response.setStatus(504);
        }
    }

    public static class Transparent
    extends ProxyServlet {
        String _prefix;
        String _proxyTo;

        public Transparent() {
        }

        public Transparent(String prefix, String host, int port) {
            this(prefix, "http", host, port, null);
        }

        public Transparent(String prefix, String schema, String host, int port, String path) {
            try {
                if (prefix != null) {
                    this._prefix = new URI(prefix).normalize().toString();
                }
                this._proxyTo = new URI(schema, null, host, port, path, null, null).normalize().toString();
            }
            catch (URISyntaxException ex) {
                this._log.debug("Invalid URI syntax", (Throwable)ex);
            }
        }

        @Override
        public void init(ServletConfig config) throws ServletException {
            super.init(config);
            String prefix = config.getInitParameter("Prefix");
            this._prefix = prefix == null ? this._prefix : prefix;
            String contextPath = this._context.getContextPath();
            this._prefix = this._prefix == null ? contextPath : contextPath + this._prefix;
            String proxyTo = config.getInitParameter("ProxyTo");
            String string = this._proxyTo = proxyTo == null ? this._proxyTo : proxyTo;
            if (this._proxyTo == null) {
                throw new UnavailableException("ProxyTo parameter is requred.");
            }
            if (!this._prefix.startsWith("/")) {
                throw new UnavailableException("Prefix parameter must start with a '/'.");
            }
            this._log.info(config.getServletName() + " @ " + this._prefix + " to " + this._proxyTo, new Object[0]);
        }

        @Override
        protected HttpURI proxyHttpURI(String scheme, String serverName, int serverPort, String uri) throws MalformedURLException {
            try {
                if (!uri.startsWith(this._prefix)) {
                    return null;
                }
                URI dstUri = new URI(this._proxyTo + uri.substring(this._prefix.length())).normalize();
                if (!this.validateDestination(dstUri.getHost(), dstUri.getPath())) {
                    return null;
                }
                return new HttpURI(dstUri.toString());
            }
            catch (URISyntaxException ex) {
                throw new MalformedURLException(ex.getMessage());
            }
        }
    }
}

