/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlets;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.servlet.AsyncContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.servlets.EventSource;

public abstract class EventSourceServlet
extends HttpServlet {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final byte[] CRLF = new byte[]{13, 10};
    private static final byte[] EVENT_FIELD;
    private static final byte[] DATA_FIELD;
    private static final byte[] COMMENT_FIELD;
    private ScheduledExecutorService scheduler;
    private int heartBeatPeriod = 10;

    public void init() throws ServletException {
        String heartBeatPeriodParam = this.getServletConfig().getInitParameter("heartBeatPeriod");
        if (heartBeatPeriodParam != null) {
            this.heartBeatPeriod = Integer.parseInt(heartBeatPeriodParam);
        }
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
    }

    public void destroy() {
        if (this.scheduler != null) {
            this.scheduler.shutdown();
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Enumeration acceptValues = request.getHeaders("Accept");
        while (acceptValues.hasMoreElements()) {
            String accept = (String)acceptValues.nextElement();
            if (!accept.equals("text/event-stream")) continue;
            EventSource eventSource = this.newEventSource(request);
            if (eventSource == null) {
                response.sendError(503);
            } else {
                this.respond(request, response);
                AsyncContext async = request.startAsync();
                async.setTimeout(0L);
                EventSourceEmitter emitter = new EventSourceEmitter(eventSource, async);
                emitter.scheduleHeartBeat();
                this.open(eventSource, emitter);
            }
            return;
        }
        super.doGet(request, response);
    }

    protected abstract EventSource newEventSource(HttpServletRequest var1);

    protected void respond(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setStatus(200);
        response.setCharacterEncoding(UTF_8.name());
        response.setContentType("text/event-stream");
        response.addHeader("Connection", "close");
        response.flushBuffer();
    }

    protected void open(EventSource eventSource, EventSource.Emitter emitter) throws IOException {
        eventSource.onOpen(emitter);
    }

    static {
        try {
            EVENT_FIELD = "event: ".getBytes(UTF_8.name());
            DATA_FIELD = "data: ".getBytes(UTF_8.name());
            COMMENT_FIELD = ": ".getBytes(UTF_8.name());
        }
        catch (UnsupportedEncodingException x) {
            throw new RuntimeException(x);
        }
    }

    protected class EventSourceEmitter
    implements EventSource.Emitter,
    Runnable {
        private final EventSource eventSource;
        private final AsyncContext async;
        private final ServletOutputStream output;
        private Future<?> heartBeat;
        private boolean closed;

        public EventSourceEmitter(EventSource eventSource, AsyncContext async) throws IOException {
            this.eventSource = eventSource;
            this.async = async;
            this.output = async.getResponse().getOutputStream();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void event(String name, String data) throws IOException {
            EventSourceEmitter eventSourceEmitter = this;
            synchronized (eventSourceEmitter) {
                this.output.write(EVENT_FIELD);
                this.output.write(name.getBytes(UTF_8.name()));
                this.output.write(CRLF);
                this.data(data);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void data(String data) throws IOException {
            EventSourceEmitter eventSourceEmitter = this;
            synchronized (eventSourceEmitter) {
                String line;
                BufferedReader reader = new BufferedReader(new StringReader(data));
                while ((line = reader.readLine()) != null) {
                    this.output.write(DATA_FIELD);
                    this.output.write(line.getBytes(UTF_8.name()));
                    this.output.write(CRLF);
                }
                this.output.write(CRLF);
                this.flush();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void comment(String comment) throws IOException {
            EventSourceEmitter eventSourceEmitter = this;
            synchronized (eventSourceEmitter) {
                this.output.write(COMMENT_FIELD);
                this.output.write(comment.getBytes(UTF_8.name()));
                this.output.write(CRLF);
                this.output.write(CRLF);
                this.flush();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                EventSourceEmitter eventSourceEmitter = this;
                synchronized (eventSourceEmitter) {
                    this.output.write(13);
                    this.flush();
                    this.output.write(10);
                    this.flush();
                }
                this.scheduleHeartBeat();
            }
            catch (IOException x) {
                this.close();
                this.eventSource.onClose();
            }
        }

        protected void flush() throws IOException {
            this.async.getResponse().flushBuffer();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            EventSourceEmitter eventSourceEmitter = this;
            synchronized (eventSourceEmitter) {
                this.closed = true;
                this.heartBeat.cancel(false);
            }
            this.async.complete();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void scheduleHeartBeat() {
            EventSourceEmitter eventSourceEmitter = this;
            synchronized (eventSourceEmitter) {
                if (!this.closed) {
                    this.heartBeat = EventSourceServlet.this.scheduler.schedule(this, (long)EventSourceServlet.this.heartBeatPeriod, TimeUnit.SECONDS);
                }
            }
        }
    }
}

