/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlets;

import java.io.IOException;
import java.util.EventListener;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.server.PushBuilder;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class PushSessionCacheFilter
implements Filter {
    private static final String TARGET_ATTR = "PushCacheFilter.target";
    private static final String TIMESTAMP_ATTR = "PushCacheFilter.timestamp";
    private static final Logger LOG = Log.getLogger(PushSessionCacheFilter.class);
    private final ConcurrentMap<String, Target> _cache = new ConcurrentHashMap<String, Target>();
    private long _associateDelay = 5000L;

    public void init(FilterConfig config) throws ServletException {
        if (config.getInitParameter("associateDelay") != null) {
            this._associateDelay = Long.valueOf(config.getInitParameter("associateDelay"));
        }
        config.getServletContext().addListener((EventListener)new ServletRequestListener(){

            public void requestDestroyed(ServletRequestEvent sre) {
                String referer;
                Request request = Request.getBaseRequest((ServletRequest)sre.getServletRequest());
                Target target = (Target)request.getAttribute(PushSessionCacheFilter.TARGET_ATTR);
                if (target == null) {
                    return;
                }
                Response response = request.getResponse();
                target._etag = response.getHttpFields().get(HttpHeader.ETAG);
                target._lastModified = response.getHttpFields().get(HttpHeader.LAST_MODIFIED);
                if (request.isPush()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Pushed {} for {}", new Object[]{request.getResponse().getStatus(), request.getRequestURI()});
                    }
                    return;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Served {} for {}", new Object[]{request.getResponse().getStatus(), request.getRequestURI()});
                }
                if ((referer = request.getHttpFields().get(HttpHeader.REFERER)) != null) {
                    HttpSession session;
                    ConcurrentHashMap timestamps;
                    Long last;
                    Target referer_target;
                    HttpURI referer_uri = new HttpURI(referer);
                    if (request.getServerName().equals(referer_uri.getHost()) && (referer_target = (Target)PushSessionCacheFilter.this._cache.get(referer_uri.getPath())) != null && (last = (Long)(timestamps = (ConcurrentHashMap)(session = request.getSession()).getAttribute(PushSessionCacheFilter.TIMESTAMP_ATTR)).get(referer_target._path)) != null && System.currentTimeMillis() - last < PushSessionCacheFilter.this._associateDelay && referer_target._associated.putIfAbsent(target._path, target) == null && LOG.isDebugEnabled()) {
                        LOG.debug("ASSOCIATE {}->{}", new Object[]{referer_target._path, target._path});
                    }
                }
            }

            public void requestInitialized(ServletRequestEvent sre) {
            }
        });
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Request baseRequest = Request.getBaseRequest((ServletRequest)request);
        String uri = baseRequest.getRequestURI();
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} {} push={}", new Object[]{baseRequest.getMethod(), uri, baseRequest.isPush()});
        }
        HttpSession session = baseRequest.getSession(true);
        Target target = (Target)this._cache.get(uri);
        if (target == null) {
            Target t = new Target(uri);
            target = this._cache.putIfAbsent(uri, t);
            target = target == null ? t : target;
        }
        request.setAttribute(TARGET_ATTR, (Object)target);
        ConcurrentHashMap<String, Long> timestamps = (ConcurrentHashMap<String, Long>)session.getAttribute(TIMESTAMP_ATTR);
        if (timestamps == null) {
            timestamps = new ConcurrentHashMap<String, Long>();
            session.setAttribute(TIMESTAMP_ATTR, timestamps);
        }
        timestamps.put(uri, System.currentTimeMillis());
        if (baseRequest.isPushSupported() && target._associated.size() > 0) {
            PushBuilder builder = baseRequest.getPushBuilder();
            builder.addHeader("X-Pusher", PushSessionCacheFilter.class.toString());
            for (Target associated : target._associated.values()) {
                String path = associated._path;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("PUSH {} <- {}", new Object[]{path, uri});
                }
                builder.path(path).etag(associated._etag).lastModified(associated._lastModified).push();
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    public static class Target {
        final String _path;
        final ConcurrentMap<String, Target> _associated = new ConcurrentHashMap<String, Target>();
        volatile String _etag;
        volatile String _lastModified;

        public Target(String path) {
            this._path = path;
        }

        public String toString() {
            return String.format("Target{p=%s,e=%s,m=%s,a=%d}", this._path, this._etag, this._lastModified, this._associated.size());
        }
    }
}

