/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.session;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http.Syntax;
import org.eclipse.jetty.server.Context;
import org.eclipse.jetty.server.HttpStream;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.session.DefaultSessionCache;
import org.eclipse.jetty.session.DefaultSessionIdManager;
import org.eclipse.jetty.session.ManagedSession;
import org.eclipse.jetty.session.NullSessionDataStore;
import org.eclipse.jetty.session.SessionCache;
import org.eclipse.jetty.session.SessionCacheFactory;
import org.eclipse.jetty.session.SessionConfig;
import org.eclipse.jetty.session.SessionContext;
import org.eclipse.jetty.session.SessionDataStore;
import org.eclipse.jetty.session.SessionDataStoreFactory;
import org.eclipse.jetty.session.SessionIdManager;
import org.eclipse.jetty.session.SessionInactivityTimer;
import org.eclipse.jetty.session.SessionManager;
import org.eclipse.jetty.session.UnreadableSessionDataException;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.statistic.CounterStatistic;
import org.eclipse.jetty.util.statistic.SampleStatistic;
import org.eclipse.jetty.util.thread.AutoLock;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSessionManager
extends ContainerLifeCycle
implements SessionManager,
SessionConfig.Mutable {
    static final Logger LOG = LoggerFactory.getLogger(AbstractSessionManager.class);
    private final Set<String> _candidateSessionIdsForExpiry = ConcurrentHashMap.newKeySet();
    private final SampleStatistic _sessionTimeStats = new SampleStatistic();
    private final CounterStatistic _sessionsCreatedStats = new CounterStatistic();
    private int _dftMaxIdleSecs = -1;
    private boolean _usingURLs;
    private boolean _usingCookies = true;
    private SessionIdManager _sessionIdManager;
    private ClassLoader _loader;
    private Context _context;
    private SessionContext _sessionContext;
    private SessionCache _sessionCache;
    private Scheduler _scheduler;
    private boolean _ownScheduler = false;
    private String _sessionCookie = "JSESSIONID";
    private String _sessionIdPathParameterName = "jsessionid";
    private String _sessionIdPathParameterNamePrefix = ";" + this._sessionIdPathParameterName + "=";
    private final Map<String, String> _sessionAttributes = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
    private Map<String, String> _sessionAttributesSecure;
    private boolean _secureRequestOnly = true;
    private int _refreshCookieAge;
    private boolean _checkingRemoteSessionIdEncoding;

    public HttpCookie access(ManagedSession session, boolean secure) {
        if (session == null) {
            return null;
        }
        long now = System.currentTimeMillis();
        if (session.access(now) && this.isUsingCookies() && (session.isSetCookieNeeded() || this.getMaxCookieAge() > 0 && this.getRefreshCookieAge() > 0 && (now - session.getCookieSetTime()) / 1000L > (long)this.getRefreshCookieAge())) {
            return this.getSessionCookie(session, secure);
        }
        return null;
    }

    @Override
    public long calculateInactivityTimeout(String id, long timeRemainingMs, long maxInactiveMs) {
        long time;
        int evictionPolicy = this._sessionCache.getEvictionPolicy();
        if (maxInactiveMs <= 0L) {
            if (evictionPolicy < 1) {
                time = -1L;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Session {} is immortal && no inactivity eviction", (Object)id);
                }
            } else {
                time = TimeUnit.SECONDS.toMillis(evictionPolicy);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Session {} is immortal; evict after {} sec inactivity", (Object)id, (Object)evictionPolicy);
                }
            }
        } else if (evictionPolicy == -1) {
            long l = time = timeRemainingMs > 0L ? timeRemainingMs : 0L;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Session {} no eviction", (Object)id);
            }
        } else if (evictionPolicy == 0) {
            time = -1L;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Session {} evict on exit", (Object)id);
            }
        } else {
            long l = time = timeRemainingMs > 0L ? Math.min(maxInactiveMs, TimeUnit.SECONDS.toMillis(evictionPolicy)) : 0L;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Session {} timer set to lesser of maxInactive={} and inactivityEvict={}", new Object[]{id, maxInactiveMs, evictionPolicy});
            }
        }
        return time;
    }

    @Override
    public void commit(ManagedSession session) {
        if (session == null) {
            return;
        }
        try {
            this._sessionCache.commit(session);
        }
        catch (Exception e) {
            LOG.warn("Unable to commit Session {}", (Object)session, (Object)e);
        }
    }

    @Override
    public void complete(ManagedSession session) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Complete called with session {}", (Object)session);
        }
        if (session == null) {
            return;
        }
        try {
            this._sessionCache.release(session);
        }
        catch (Exception e) {
            LOG.warn("Unable to release Session {}", (Object)session, (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStart() throws Exception {
        String contextPath;
        Server server = this.getServer();
        this._context = ContextHandler.getCurrentContext();
        this._loader = Thread.currentThread().getContextClassLoader();
        String string = contextPath = this._context == null ? "/" : this._context.getContextPath();
        if (!"/".equals(contextPath) && this.getSessionPath() == null) {
            this.setSessionPath(contextPath);
        }
        Server server2 = server;
        synchronized (server2) {
            if (this._sessionCache == null) {
                SessionCacheFactory ssFactory = (SessionCacheFactory)server.getBean(SessionCacheFactory.class);
                this.setSessionCache(ssFactory != null ? ssFactory.getSessionCache(this) : new DefaultSessionCache(this));
                SessionDataStoreFactory sdsFactory = (SessionDataStoreFactory)server.getBean(SessionDataStoreFactory.class);
                SessionDataStore sds = sdsFactory != null ? sdsFactory.getSessionDataStore(this) : new NullSessionDataStore();
                this._sessionCache.setSessionDataStore(sds);
            }
            if (this._sessionIdManager == null) {
                this._sessionIdManager = (SessionIdManager)server.getBean(SessionIdManager.class);
                if (this._sessionIdManager == null) {
                    ClassLoader serverLoader = server.getClass().getClassLoader();
                    try {
                        Thread.currentThread().setContextClassLoader(serverLoader);
                        this._sessionIdManager = new DefaultSessionIdManager(server);
                        server.addBean((Object)this._sessionIdManager, true);
                        this._sessionIdManager.start();
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(this._loader);
                    }
                }
                this.addBean(this._sessionIdManager, false);
            }
            this._scheduler = server.getScheduler();
            if (this._scheduler == null) {
                this._scheduler = new ScheduledExecutorScheduler(String.format("Session-Scheduler-%x", this.hashCode()), false);
                this._ownScheduler = true;
                this._scheduler.start();
            }
        }
        this._sessionContext = new SessionContext(this);
        this._sessionCache.initialize(this._sessionContext);
        this.secureRequestOnlyAttributes();
        super.doStart();
    }

    @Override
    public Context getContext() {
        return this._context;
    }

    @Override
    public int getMaxCookieAge() {
        String mca = this._sessionAttributes.get("Max-Age");
        return mca == null ? -1 : Integer.parseInt(mca);
    }

    @Override
    public void setMaxCookieAge(int maxCookieAge) {
        this._sessionAttributes.put("Max-Age", Integer.toString(maxCookieAge));
        this.secureRequestOnlyAttributes();
    }

    @Override
    public int getMaxInactiveInterval() {
        return this._dftMaxIdleSecs;
    }

    @Override
    public void setMaxInactiveInterval(int seconds) {
        this._dftMaxIdleSecs = seconds;
        if (LOG.isDebugEnabled()) {
            if (this._dftMaxIdleSecs <= 0) {
                LOG.debug("Sessions created by this manager are immortal (default maxInactiveInterval={})", (Object)this._dftMaxIdleSecs);
            } else {
                LOG.debug("SessionManager default maxInactiveInterval={}", (Object)this._dftMaxIdleSecs);
            }
        }
    }

    @Override
    public int getRefreshCookieAge() {
        return this._refreshCookieAge;
    }

    @Override
    public void setRefreshCookieAge(int ageInSeconds) {
        this._refreshCookieAge = ageInSeconds;
    }

    public abstract Server getServer();

    @Override
    public ManagedSession getManagedSession(String extendedId) {
        String id = this.getSessionIdManager().getId(extendedId);
        try {
            ManagedSession session = this._sessionCache.get(id);
            if (session != null) {
                if (session.isExpiredAt(System.currentTimeMillis())) {
                    try {
                        session.invalidate();
                    }
                    catch (Exception e) {
                        LOG.warn("Invalidating session {} found to be expired when requested", (Object)id, (Object)e);
                    }
                    return null;
                }
                session.setExtendedId(this._sessionIdManager.getExtendedId(id, null));
            }
            if (session != null && !session.getExtendedId().equals(extendedId)) {
                session.onIdChanged();
            }
            return session;
        }
        catch (UnreadableSessionDataException e) {
            LOG.warn("Error loading session {}", (Object)id, (Object)e);
            try {
                this.getSessionIdManager().invalidateAll(id);
            }
            catch (Exception x) {
                LOG.warn("Error cross-context invalidating unreadable session {}", (Object)id, (Object)x);
            }
            return null;
        }
        catch (Exception other) {
            LOG.warn("Unable to get Session", (Throwable)other);
            return null;
        }
    }

    @Override
    public SessionCache getSessionCache() {
        return this._sessionCache;
    }

    @Override
    public void setSessionCache(SessionCache cache) {
        this.updateBean(this._sessionCache, cache);
        this._sessionCache = cache;
    }

    @Override
    public String getSessionComment() {
        return this._sessionAttributes.get("Comment");
    }

    @Override
    public void setSessionComment(String sessionComment) {
        this._sessionAttributes.put("Comment", sessionComment);
        this.secureRequestOnlyAttributes();
    }

    @Override
    public HttpCookie.SameSite getSameSite() {
        return HttpCookie.SameSite.from((String)this._sessionAttributes.get("SameSite"));
    }

    @Override
    public void setSameSite(HttpCookie.SameSite sessionSameSite) {
        this._sessionAttributes.put("SameSite", sessionSameSite.getAttributeValue());
        this.secureRequestOnlyAttributes();
    }

    public SessionContext getSessionContext() {
        return this._sessionContext;
    }

    @Override
    public String getSessionCookie() {
        return this._sessionCookie;
    }

    @Override
    public void setSessionCookie(String cookieName) {
        if (StringUtil.isBlank((String)cookieName)) {
            throw new IllegalArgumentException("Blank cookie name");
        }
        Syntax.requireValidRFC2616Token((String)cookieName, (String)"Bad Session cookie name");
        this._sessionCookie = cookieName;
    }

    @Override
    public String getSessionDomain() {
        return this._sessionAttributes.get("Domain");
    }

    @Override
    public void setSessionDomain(String domain) {
        this._sessionAttributes.put("Domain", domain);
        this.secureRequestOnlyAttributes();
    }

    public void setSessionAttribute(String name, String value) {
        this._sessionAttributes.put(name, value);
        this.secureRequestOnlyAttributes();
    }

    public String getSessionAttribute(String name) {
        return this._sessionAttributes.get(name);
    }

    public Map<String, String> getSessionAttributes() {
        return Collections.unmodifiableMap(this._sessionAttributes);
    }

    @Override
    public SessionIdManager getSessionIdManager() {
        return this._sessionIdManager;
    }

    @Override
    public void setSessionIdManager(SessionIdManager sessionIdManager) {
        this.updateBean(this._sessionIdManager, sessionIdManager);
        this._sessionIdManager = sessionIdManager;
    }

    @Override
    public String getSessionIdPathParameterName() {
        return this._sessionIdPathParameterName;
    }

    @Override
    public void setSessionIdPathParameterName(String param) {
        this._sessionIdPathParameterName = param == null || "none".equals(param) ? null : param;
        this._sessionIdPathParameterNamePrefix = param == null || "none".equals(param) ? null : ";" + this._sessionIdPathParameterName + "=";
    }

    @Override
    public String getSessionIdPathParameterNamePrefix() {
        return this._sessionIdPathParameterNamePrefix;
    }

    @Override
    public String getSessionPath() {
        return this._sessionAttributes.get("Path");
    }

    @Override
    public void setSessionPath(String sessionPath) {
        this._sessionAttributes.put("Path", sessionPath);
        this.secureRequestOnlyAttributes();
    }

    @Override
    @ManagedAttribute(value="mean time sessions remain valid (in s)")
    public double getSessionTimeMean() {
        return this._sessionTimeStats.getMean();
    }

    @Override
    @ManagedAttribute(value="standard deviation a session remained valid (in s)")
    public double getSessionTimeStdDev() {
        return this._sessionTimeStats.getStdDev();
    }

    @Override
    @ManagedAttribute(value="total time sessions have remained valid")
    public long getSessionTimeTotal() {
        return this._sessionTimeStats.getTotal();
    }

    @Override
    @ManagedAttribute(value="number of sessions created by this context")
    public int getSessionsCreated() {
        return (int)this._sessionsCreatedStats.getCurrent();
    }

    @Override
    public void invalidate(String id) throws Exception {
        block8: {
            if (StringUtil.isBlank((String)id)) {
                return;
            }
            try {
                ManagedSession session = this._sessionCache.delete(id);
                if (session == null) break block8;
                try {
                    if (!session.beginInvalidate()) break block8;
                    try {
                        this.callSessionDestroyedListeners(session);
                    }
                    catch (Exception e) {
                        LOG.warn("Error during Session destroy listener", (Throwable)e);
                    }
                    session.finishInvalidate();
                }
                catch (IllegalStateException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Session {} already invalid", (Object)session, (Object)e);
                    }
                }
            }
            catch (Exception e) {
                LOG.warn("Unable to delete Session {}", (Object)id, (Object)e);
            }
        }
    }

    @Override
    public boolean isCheckingRemoteSessionIdEncoding() {
        return this._checkingRemoteSessionIdEncoding;
    }

    @Override
    public void setCheckingRemoteSessionIdEncoding(boolean remote) {
        this._checkingRemoteSessionIdEncoding = remote;
    }

    @Override
    public boolean isHttpOnly() {
        return Boolean.parseBoolean(this._sessionAttributes.get("HttpOnly"));
    }

    @Override
    public void setHttpOnly(boolean httpOnly) {
        this._sessionAttributes.put("HttpOnly", Boolean.toString(httpOnly));
    }

    @Override
    public boolean isIdInUse(String id) throws Exception {
        return this._sessionCache.exists(id);
    }

    @Override
    public boolean isSecureCookies() {
        return Boolean.parseBoolean(this._sessionAttributes.get("Secure"));
    }

    @Override
    public void setSecureCookies(boolean secure) {
        this._sessionAttributes.put("Secure", Boolean.toString(secure));
        this.secureRequestOnlyAttributes();
    }

    @Override
    public boolean isSecureRequestOnly() {
        return this._secureRequestOnly;
    }

    @Override
    public void setSecureRequestOnly(boolean secureRequestOnly) {
        this._secureRequestOnly = secureRequestOnly;
        this.secureRequestOnlyAttributes();
    }

    private void secureRequestOnlyAttributes() {
        if (this.isSecureRequestOnly() && !Boolean.parseBoolean(this._sessionAttributes.get("Secure"))) {
            TreeMap<String, String> attributes = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
            attributes.putAll(this._sessionAttributes);
            attributes.put("Secure", Boolean.TRUE.toString());
            this._sessionAttributesSecure = attributes;
        } else {
            this._sessionAttributesSecure = this._sessionAttributes;
        }
    }

    @Override
    public boolean isUsingCookies() {
        return this._usingCookies;
    }

    @Override
    public void setUsingCookies(boolean usingCookies) {
        this._usingCookies = usingCookies;
    }

    @Override
    public boolean isUsingURLs() {
        return this._usingURLs;
    }

    @Override
    public void setUsingURLs(boolean usingURLs) {
        this._usingURLs = usingURLs;
    }

    @Override
    public void newSession(Request request, String requestedSessionId, Consumer<ManagedSession> consumer) {
        long created = System.currentTimeMillis();
        String id = this._sessionIdManager.newSessionId(request, requestedSessionId, created);
        ManagedSession session = this._sessionCache.newSession(id, created, this._dftMaxIdleSecs > 0 ? (long)this._dftMaxIdleSecs * 1000L : -1L);
        session.setExtendedId(this._sessionIdManager.getExtendedId(id, request));
        session.getSessionData().setLastNode(this._sessionIdManager.getWorkerName());
        try {
            this._sessionCache.add(id, session);
            this._sessionsCreatedStats.increment();
            if (request != null && request.getConnectionMetaData().isSecure()) {
                session.setAttribute("org.eclipse.jetty.security.sessionCreatedSecure", Boolean.TRUE);
            }
            consumer.accept(session);
            this.callSessionCreatedListeners(session);
        }
        catch (Exception e) {
            LOG.warn("Unable to add Session {}", (Object)id, (Object)e);
        }
    }

    @Override
    public SessionInactivityTimer newSessionInactivityTimer(ManagedSession session) {
        return new SessionInactivityTimer(this, session, this._scheduler);
    }

    @Override
    public void recordSessionTime(ManagedSession session) {
        this._sessionTimeStats.record(Math.round((double)(System.currentTimeMillis() - session.getSessionData().getCreated()) / 1000.0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renewSessionId(String oldId, String oldExtendedId, String newId, String newExtendedId) {
        ManagedSession session = null;
        try {
            session = this._sessionCache.renewSessionId(oldId, newId, oldExtendedId, newExtendedId);
            if (session == null) {
                return;
            }
            this.callSessionIdListeners(session, oldId);
        }
        catch (Exception e) {
            LOG.warn("Unable to renew Session Id {}:{} -> {}:{}", new Object[]{oldId, oldExtendedId, newId, newExtendedId, e});
        }
        finally {
            if (session != null) {
                try {
                    this._sessionCache.release(session);
                }
                catch (Exception e) {
                    LOG.warn("Unable to release {}", (Object)newId, (Object)e);
                }
            }
        }
    }

    @Override
    public void scavenge() {
        if (this.isStopping() || this.isStopped()) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} scavenging sessions", (Object)this);
        }
        String[] ss = this._candidateSessionIdsForExpiry.toArray(new String[0]);
        Set<String> candidates = new HashSet<String>(Arrays.asList(ss));
        this._candidateSessionIdsForExpiry.removeAll(candidates);
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} scavenging session ids {}", (Object)this, candidates);
        }
        try {
            candidates = this._sessionCache.checkExpiration(candidates);
            for (String id : candidates) {
                try {
                    this.getSessionIdManager().expireAll(id);
                }
                catch (Exception e) {
                    LOG.warn("Unable to expire Session {}", (Object)id, (Object)e);
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to check expiration on {}", (Object)candidates.stream().map(Objects::toString).collect(Collectors.joining(", ", "[", "]")), (Object)e);
        }
    }

    @Override
    public void sessionTimerExpired(ManagedSession session, long now) {
        if (session == null) {
            return;
        }
        try (AutoLock lock = session.lock();){
            if (session.isExpiredAt(now)) {
                if (this._sessionIdManager.getSessionHouseKeeper() != null && this._sessionIdManager.getSessionHouseKeeper().getIntervalSec() > 0L) {
                    this._candidateSessionIdsForExpiry.add(session.getId());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Session {} is candidate for expiry", (Object)session.getId());
                    }
                }
            } else {
                this._sessionCache.checkInactiveSession(session);
            }
        }
    }

    protected void addSessionStreamWrapper(Request request) {
        request.addHttpStreamWrapper(s -> new SessionStreamWrapper((HttpStream)s, this, request));
    }

    protected void doStop() throws Exception {
        this.shutdownSessions();
        this._sessionCache.stop();
        if (this._ownScheduler && this._scheduler != null) {
            this._scheduler.stop();
        }
        this._scheduler = null;
        super.doStop();
        this._loader = null;
    }

    protected RequestedSession resolveRequestedSessionId(Request request) {
        HttpURI uri;
        String param;
        int start;
        List cookies;
        String requestedSessionId = null;
        boolean requestedSessionIdFromCookie = false;
        ManagedSession session = null;
        if (this.isUsingCookies() && (cookies = Request.getCookies((Request)request)) != null && cookies.size() > 0) {
            String sessionCookie = this.getSessionCookie();
            for (HttpCookie cookie : cookies) {
                ManagedSession s;
                if (!sessionCookie.equalsIgnoreCase(cookie.getName())) continue;
                String id = cookie.getValue();
                requestedSessionIdFromCookie = true;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Got Session ID {} from cookie {}", (Object)id, (Object)sessionCookie);
                }
                if (session == null) {
                    s = this.getManagedSession(id);
                    if (s != null && s.isValid()) {
                        requestedSessionId = id;
                        session = s;
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("Selected session {}", (Object)session);
                        continue;
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("No session found for session cookie id {}", (Object)id);
                    }
                    if (requestedSessionId != null) continue;
                    requestedSessionId = id;
                    continue;
                }
                if (!session.getId().equals(this.getSessionIdManager().getId(id))) {
                    block14: {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Multiple different valid session ids: {}, {}", (Object)requestedSessionId, (Object)id);
                        }
                        if ((s = this.getManagedSession(id)) == null || !s.isValid()) continue;
                        try {
                            this._sessionCache.release(session);
                            this._sessionCache.release(s);
                        }
                        catch (Exception x) {
                            if (!LOG.isDebugEnabled()) break block14;
                            LOG.debug("Error releasing duplicate valid session: {}", (Object)id);
                        }
                    }
                    throw new BadMessageException("Duplicate valid session cookies: " + requestedSessionId + " ," + id);
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Duplicate valid session cookie id: {}", (Object)id);
            }
        }
        if (this.isUsingURLs() && requestedSessionId == null && (start = (param = (param = (uri = request.getHttpURI()).getParam()) == null ? "" : param.trim()).indexOf(this.getSessionIdPathParameterName())) >= 0) {
            char c;
            int i;
            int s = start;
            if (param.charAt(s += this.getSessionIdPathParameterName().length()) == '=') {
                ++s;
            }
            for (i = s; i < param.length() && (c = param.charAt(i)) != ';' && c != '#' && c != '?' && c != '/'; ++i) {
            }
            requestedSessionId = param.substring(s, i);
            requestedSessionIdFromCookie = false;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Got Session ID {} from URL", (Object)requestedSessionId);
            }
            session = this.getManagedSession(requestedSessionId);
        }
        return new RequestedSession(session != null && session.isValid() ? session : null, requestedSessionId, requestedSessionIdFromCookie);
    }

    private void shutdownSessions() throws Exception {
        this._sessionCache.shutdown();
    }

    @Override
    public HttpCookie getSessionCookie(ManagedSession session, boolean requestIsSecure) {
        if (this.isUsingCookies()) {
            String name = this.getSessionCookie();
            if (name == null) {
                name = this._sessionAttributes.get("name");
            }
            if (name == null) {
                name = "JSESSIONID";
            }
            if (this.isSecureRequestOnly() && requestIsSecure && this._sessionAttributesSecure != null && this._sessionAttributes != this._sessionAttributesSecure) {
                return session.generateSetCookie(name, this._sessionAttributesSecure);
            }
            return session.generateSetCookie(name, this._sessionAttributes);
        }
        return null;
    }

    public record RequestedSession(ManagedSession session, String sessionId, boolean sessionIdFromCookie) {
    }

    private class SessionStreamWrapper
    extends HttpStream.Wrapper {
        private final SessionManager _sessionManager;
        private final Request _request;
        private final Context _context;

        public SessionStreamWrapper(HttpStream wrapped, SessionManager sessionManager, Request request) {
            super(wrapped);
            this._sessionManager = sessionManager;
            this._request = request;
            this._context = this._request.getContext();
        }

        public void failed(Throwable x) {
            this._context.run(this::doComplete, this._request);
            super.failed(x);
        }

        public void send(MetaData.Request metadataRequest, MetaData.Response metadataResponse, boolean last, ByteBuffer content, Callback callback) {
            if (metadataResponse != null) {
                this._context.run(this::doCommit, this._request);
            }
            super.send(metadataRequest, metadataResponse, last, content, callback);
        }

        public void succeeded() {
            this._context.run(this::doComplete, this._request);
            super.succeeded();
        }

        private void doCommit() {
            AbstractSessionManager.this.commit(this._sessionManager.getManagedSession(this._request));
        }

        private void doComplete() {
            AbstractSessionManager.this.complete(this._sessionManager.getManagedSession(this._request));
        }
    }
}

