/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.session;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Condition;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Session;
import org.eclipse.jetty.session.SessionData;
import org.eclipse.jetty.session.SessionInactivityTimer;
import org.eclipse.jetty.session.SessionManager;
import org.eclipse.jetty.util.thread.AutoLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedSession
implements Session {
    private static final Logger LOG = LoggerFactory.getLogger(ManagedSession.class);
    public static final String SESSION_CREATED_SECURE = "org.eclipse.jetty.security.sessionCreatedSecure";
    private final Session.API _api;
    protected final SessionData _sessionData;
    protected final SessionManager _manager;
    protected String _extendedId;
    protected long _requests;
    protected boolean _needSetCookie;
    protected boolean _newSession;
    protected State _state = State.VALID;
    protected AutoLock _lock = new AutoLock();
    protected Condition _stateChangeCompleted = this._lock.newCondition();
    protected boolean _resident = false;
    protected final SessionInactivityTimer _sessionInactivityTimer;

    public ManagedSession(SessionManager manager, SessionData data) {
        this._manager = manager;
        this._sessionData = data;
        if (this._sessionData.getLastSaved() <= 0L) {
            this._newSession = true;
            this._sessionData.setDirty(true);
        }
        this._sessionInactivityTimer = manager.newSessionInactivityTimer(this);
        this._api = this._manager.newSessionAPIWrapper(this);
        if (this._api != null && this._api.getSession() != this) {
            throw new IllegalStateException("Session.API must wrap this session");
        }
    }

    public <T extends Session.API> T getApi() {
        return (T)this._api;
    }

    public long getRequests() {
        try (AutoLock l = this._lock.lock();){
            long l2 = this._requests;
            return l2;
        }
    }

    public void setExtendedId(String extendedId) {
        this._extendedId = extendedId;
    }

    public HttpCookie generateSetCookie(String name, Map<String, String> attributes) {
        HttpCookie sessionCookie = HttpCookie.from((String)name, (String)this.getExtendedId(), attributes);
        this.onSetCookieGenerated();
        return sessionCookie;
    }

    void onSetCookieGenerated() {
        try (AutoLock l = this._lock.lock();){
            this._sessionData.setCookieSet(this._sessionData.getAccessed());
            this._needSetCookie = false;
        }
    }

    protected void use() {
        try (AutoLock l = this._lock.lock();){
            ++this._requests;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Session {} in use, stopping timer, active requests={}", (Object)this.getId(), (Object)this._requests);
            }
            this._sessionInactivityTimer.cancel();
        }
    }

    public boolean access(long time) {
        try (AutoLock l = this._lock.lock();){
            if (!this.isValid() || !this.isResident()) {
                boolean bl = false;
                return bl;
            }
            this._newSession = false;
            long lastAccessed = this._sessionData.getAccessed();
            this._sessionData.setAccessed(time);
            this._sessionData.setLastAccessed(lastAccessed);
            this._sessionData.calcAndSetExpiry(time);
            if (this.isExpiredAt(time)) {
                this.invalidate();
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }

    public void commit() {
        this._manager.commit(this);
    }

    public void complete() {
        this._manager.complete(this);
    }

    void release() {
        try (AutoLock l = this._lock.lock();){
            --this._requests;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Session {} complete, active requests={}", (Object)this.getId(), (Object)this._requests);
            }
            if (this._requests == 0L) {
                long now = System.currentTimeMillis();
                this._sessionData.calcAndSetExpiry(now);
                this._sessionInactivityTimer.schedule(this.calculateInactivityTimeout(now));
            }
        }
    }

    public boolean isExpiredAt(long time) {
        try (AutoLock l = this._lock.lock();){
            boolean bl = this._sessionData.isExpiredAt(time);
            return bl;
        }
    }

    protected boolean isIdleLongerThan(int sec) {
        long now = System.currentTimeMillis();
        try (AutoLock l = this._lock.lock();){
            boolean bl = this._sessionData.getAccessed() + (long)(sec * 1000) <= now;
            return bl;
        }
    }

    protected void callSessionAttributeListeners(String name, Object newValue, Object oldValue) {
        if (newValue == null || !newValue.equals(oldValue)) {
            if (oldValue != null) {
                this._manager.callUnboundBindingListener(this, name, oldValue);
            }
            if (newValue != null) {
                this._manager.callBoundBindingListener(this, name, newValue);
            }
            if (this._manager == null) {
                throw new IllegalStateException("No session manager for session " + this._sessionData.getId());
            }
            this._manager.callSessionAttributeListeners(this, name, oldValue, newValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void didActivate() {
        boolean dirty = this.getSessionData().isDirty();
        try {
            for (String name : this._sessionData.getKeys()) {
                Object value = this._sessionData.getAttribute(name);
                this._manager.callSessionActivationListener(this, name, value);
            }
        }
        finally {
            this.getSessionData().setDirty(dirty);
        }
    }

    public void willPassivate() {
        for (String name : this._sessionData.getKeys()) {
            Object value = this._sessionData.getAttribute(name);
            this._manager.callSessionPassivationListener(this, name, value);
        }
    }

    public boolean isValid() {
        try (AutoLock l = this._lock.lock();){
            boolean bl = this._state == State.VALID;
            return bl;
        }
    }

    public boolean isInvalidOrInvalidating() {
        try (AutoLock l = this._lock.lock();){
            boolean bl = this._state == State.INVALID || this._state == State.INVALIDATING;
            return bl;
        }
    }

    public long getCookieSetTime() {
        try (AutoLock l = this._lock.lock();){
            long l2 = this._sessionData.getCookieSet();
            return l2;
        }
    }

    public long getCreationTime() throws IllegalStateException {
        try (AutoLock l = this._lock.lock();){
            this.checkValidForRead();
            long l2 = this._sessionData.getCreated();
            return l2;
        }
    }

    public String getId() {
        try (AutoLock l = this._lock.lock();){
            String string = this._sessionData.getId();
            return string;
        }
    }

    public String getExtendedId() {
        return this._extendedId;
    }

    public String getVHost() {
        return this._sessionData.getVhost();
    }

    public long getLastAccessedTime() {
        try (AutoLock l = this._lock.lock();){
            this.checkValidForRead();
            long l2 = this._sessionData.getLastAccessed();
            return l2;
        }
    }

    public void setMaxInactiveInterval(int secs) {
        try (AutoLock l = this._lock.lock();){
            this._sessionData.setMaxInactiveMs((long)secs * 1000L);
            this._sessionData.calcAndSetExpiry();
            this._sessionData.setDirty(true);
            if (LOG.isDebugEnabled()) {
                if (secs <= 0) {
                    LOG.debug("Session {} is now immortal (maxInactiveInterval={})", (Object)this._sessionData.getId(), (Object)secs);
                } else {
                    LOG.debug("Session {} maxInactiveInterval={}", (Object)this._sessionData.getId(), (Object)secs);
                }
            }
        }
    }

    public long calculateInactivityTimeout(long now) {
        long time = 0L;
        try (AutoLock l = this._lock.lock();){
            time = this.getSessionManager().calculateInactivityTimeout(this.getId(), this._sessionData.getExpiry() - now, this._sessionData.getMaxInactiveMs());
        }
        return time;
    }

    public int getMaxInactiveInterval() {
        try (AutoLock l = this._lock.lock();){
            long maxInactiveMs = this._sessionData.getMaxInactiveMs();
            int n = (int)(maxInactiveMs < 0L ? -1L : maxInactiveMs / 1000L);
            return n;
        }
    }

    public SessionManager getSessionManager() {
        return this._manager;
    }

    protected void checkValidForWrite() throws IllegalStateException {
        if (this._state == State.INVALID) {
            throw new IllegalStateException("Not valid for write: id=" + this._sessionData.getId() + " created=" + this._sessionData.getCreated() + " accessed=" + this._sessionData.getAccessed() + " lastaccessed=" + this._sessionData.getLastAccessed() + " maxInactiveMs=" + this._sessionData.getMaxInactiveMs() + " expiry=" + this._sessionData.getExpiry());
        }
        if (this._state == State.INVALIDATING) {
            return;
        }
        if (!this.isResident()) {
            throw new IllegalStateException("Not valid for write: id=" + this._sessionData.getId() + " not resident");
        }
    }

    protected void checkValidForRead() throws IllegalStateException {
        if (this._state == State.INVALID) {
            throw new IllegalStateException("Invalid for read: id=" + this._sessionData.getId() + " created=" + this._sessionData.getCreated() + " accessed=" + this._sessionData.getAccessed() + " lastaccessed=" + this._sessionData.getLastAccessed() + " maxInactiveMs=" + this._sessionData.getMaxInactiveMs() + " expiry=" + this._sessionData.getExpiry());
        }
        if (this._state == State.INVALIDATING) {
            return;
        }
        if (!this.isResident()) {
            throw new IllegalStateException("Invalid for read: id=" + this._sessionData.getId() + " not resident");
        }
    }

    public Object getAttribute(String name) {
        try (AutoLock l = this._lock.lock();){
            this.checkValidForRead();
            Object object = this._sessionData.getAttribute(name);
            return object;
        }
    }

    public Set<String> getAttributeNameSet() {
        try (AutoLock l = this._lock.lock();){
            this.checkValidForRead();
            Set<String> set = Collections.unmodifiableSet(this._sessionData.getKeys());
            return set;
        }
    }

    public Object setAttribute(String name, Object value) {
        Object old = null;
        try (AutoLock l = this._lock.lock();){
            this.checkValidForWrite();
            old = this._sessionData.setAttribute(name, value);
        }
        if (value == null && old == null) {
            return null;
        }
        this.callSessionAttributeListeners(name, value, old);
        return old;
    }

    public Object removeAttribute(String name) {
        return this.setAttribute(name, null);
    }

    /*
     * Unable to fully structure code
     */
    public void renewId(Request request, Response response) {
        if (this._manager == null) {
            throw new IllegalStateException("No session manager for session " + this._sessionData.getId());
        }
        if (response != null && response.isCommitted()) {
            throw new IllegalStateException("Response committed " + this._sessionData.getId());
        }
        oldId = null;
        extendedId = null;
        l = this._lock.lock();
        try {
            block21: while (true) {
                switch (1.$SwitchMap$org$eclipse$jetty$session$ManagedSession$State[this._state.ordinal()]) {
                    case 1: 
                    case 2: {
                        throw new IllegalStateException();
                    }
                    case 3: {
                        try {
                            this._stateChangeCompleted.await();
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    continue block21;
                    case 4: {
                        this._state = State.CHANGING;
                        break block21;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                break;
            }
            oldId = this._sessionData.getId();
            extendedId = this.getExtendedId();
        }
        finally {
            if (l != null) {
                l.close();
            }
        }
        newId = this._manager.getSessionIdManager().renewSessionId(oldId, extendedId, request);
        l = this._lock.lock();
        try {
            switch (1.$SwitchMap$org$eclipse$jetty$session$ManagedSession$State[this._state.ordinal()]) {
                case 3: {
                    if (oldId.equals(newId)) {
                        throw new IllegalStateException("Unable to change session id");
                    }
                    this._sessionData.setId(newId);
                    this.setExtendedId(this._manager.getSessionIdManager().getExtendedId(newId, request));
                    this.onIdChanged();
                    this._state = State.VALID;
                    this._stateChangeCompleted.signalAll();
                    ** break;
lbl46:
                    // 1 sources

                    break;
                }
                case 1: 
                case 2: {
                    throw new IllegalStateException("Session invalid");
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        finally {
            if (l != null) {
                l.close();
            }
        }
        if (response != null && this.isSetCookieNeeded()) {
            Response.replaceCookie((Response)response, (HttpCookie)this.getSessionManager().getSessionCookie(this, request.isSecure()));
        }
        if (ManagedSession.LOG.isDebugEnabled()) {
            ManagedSession.LOG.debug("renew {}->{}", (Object)oldId, (Object)newId);
        }
    }

    public void invalidate() {
        block8: {
            if (this._manager == null) {
                throw new IllegalStateException("No session manager for session " + this._sessionData.getId());
            }
            boolean result = this.beginInvalidate();
            try {
                if (!result) break block8;
                try {
                    this._manager.callSessionDestroyedListeners(this);
                }
                catch (Exception e) {
                    LOG.warn("Error during Session destroy listener", (Throwable)e);
                }
                finally {
                    this.finishInvalidate();
                    this._manager.getSessionIdManager().invalidateAll(this._sessionData.getId());
                }
            }
            catch (Exception e) {
                LOG.warn("Unable to invalidate Session {}", (Object)this, (Object)e);
            }
        }
    }

    public AutoLock lock() {
        return this._lock.lock();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean beginInvalidate() {
        boolean result = false;
        try (AutoLock l = this._lock.lock();){
            block13: while (true) {
                switch (1.$SwitchMap$org$eclipse$jetty$session$ManagedSession$State[this._state.ordinal()]) {
                    case 1: {
                        throw new IllegalStateException();
                    }
                    case 2: {
                        if (!LOG.isDebugEnabled()) return result;
                        LOG.debug("Session {} already being invalidated", (Object)this._sessionData.getId());
                        return result;
                    }
                    case 3: {
                        try {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Session {} waiting for id change to complete", (Object)this._sessionData.getId());
                            }
                            this._stateChangeCompleted.await();
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    continue block13;
                    case 4: {
                        result = true;
                        this._state = State.INVALIDATING;
                        return result;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishInvalidate() throws IllegalStateException {
        try (AutoLock l = this._lock.lock();){
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("invalidate {}", (Object)this._sessionData.getId());
                }
                if (this._state == State.VALID || this._state == State.INVALIDATING) {
                    Set<String> keys = null;
                    do {
                        keys = this._sessionData.getKeys();
                        for (String key : keys) {
                            Object old = this._sessionData.setAttribute(key, null);
                            if (old == null) continue;
                            this.callSessionAttributeListeners(key, null, old);
                        }
                    } while (!keys.isEmpty());
                }
            }
            finally {
                this._state = State.INVALID;
                this._manager.recordSessionTime(this);
                this._stateChangeCompleted.signalAll();
            }
        }
    }

    public boolean isNew() throws IllegalStateException {
        try (AutoLock l = this._lock.lock();){
            this.checkValidForRead();
            boolean bl = this._newSession;
            return bl;
        }
    }

    public void onIdChanged() {
        try (AutoLock l = this._lock.lock();){
            if (this.getSessionManager().isUsingCookies()) {
                this._needSetCookie = true;
            }
        }
    }

    public boolean isSetCookieNeeded() {
        try (AutoLock l = this._lock.lock();){
            boolean bl = this._needSetCookie;
            return bl;
        }
    }

    public SessionData getSessionData() {
        return this._sessionData;
    }

    public void setResident(boolean resident) {
        this._resident = resident;
        if (!this._resident) {
            this._sessionInactivityTimer.destroy();
        }
    }

    public boolean isResident() {
        return this._resident;
    }

    public String toString() {
        try (AutoLock l = this._lock.lock();){
            String string = String.format("%s@%x{id=%s,x=%s,req=%d,res=%b}", this.getClass().getSimpleName(), this.hashCode(), this._sessionData.getId(), this._extendedId, this._requests, this._resident);
            return string;
        }
    }

    public static enum State {
        VALID,
        INVALID,
        INVALIDATING,
        CHANGING;

    }

    public static enum IdState {
        SET,
        CHANGING;

    }
}

