/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.session;

import java.util.function.Consumer;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.server.Context;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Session;
import org.eclipse.jetty.session.ManagedSession;
import org.eclipse.jetty.session.SessionCache;
import org.eclipse.jetty.session.SessionConfig;
import org.eclipse.jetty.session.SessionIdManager;
import org.eclipse.jetty.session.SessionInactivityTimer;
import org.eclipse.jetty.util.component.LifeCycle;

public interface SessionManager
extends LifeCycle,
SessionConfig {
    public static final String __SessionCookieProperty = "org.eclipse.jetty.servlet.SessionCookie";
    public static final String __DefaultSessionCookie = "JSESSIONID";
    public static final String __SessionIdPathParameterNameProperty = "org.eclipse.jetty.servlet.SessionIdPathParameterName";
    public static final String __DefaultSessionIdPathParameterName = "jsessionid";
    public static final String __CheckRemoteSessionEncoding = "org.eclipse.jetty.servlet.CheckingRemoteSessionIdEncoding";
    public static final String __SessionDomainProperty = "org.eclipse.jetty.servlet.SessionDomain";
    public static final String __DefaultSessionDomain = null;
    public static final String __SessionPathProperty = "org.eclipse.jetty.servlet.SessionPath";
    public static final String __MaxAgeProperty = "org.eclipse.jetty.servlet.MaxAge";

    public ManagedSession getManagedSession(String var1) throws Exception;

    public void newSession(Request var1, String var2, Consumer<ManagedSession> var3);

    public ManagedSession getManagedSession(Request var1);

    public Session.API newSessionAPIWrapper(ManagedSession var1);

    public void sessionTimerExpired(ManagedSession var1, long var2);

    public void commit(ManagedSession var1);

    public void complete(ManagedSession var1);

    public void invalidate(String var1) throws Exception;

    public void scavenge() throws Exception;

    public boolean isIdInUse(String var1) throws Exception;

    public HttpCookie getSessionCookie(ManagedSession var1, boolean var2);

    public void renewSessionId(String var1, String var2, String var3, String var4) throws Exception;

    public long calculateInactivityTimeout(String var1, long var2, long var4);

    public SessionInactivityTimer newSessionInactivityTimer(ManagedSession var1);

    public Context getContext();

    public SessionIdManager getSessionIdManager();

    public void setSessionIdManager(SessionIdManager var1);

    public SessionCache getSessionCache();

    public void setSessionCache(SessionCache var1);

    public void recordSessionTime(ManagedSession var1);

    public int getSessionsCreated();

    public String encodeURI(Request var1, String var2, boolean var3);

    default public void onSessionIdChanged(Session session, String oldId) {
    }

    default public void onSessionCreated(Session session) {
    }

    default public void onSessionDestroyed(Session session) {
    }

    default public void onSessionAttributeUpdate(Session session, String name, Object oldValue, Object newValue) {
    }

    default public void onSessionActivation(Session session) {
    }

    default public void onSessionPassivation(Session session) {
    }

    public double getSessionTimeStdDev();

    public double getSessionTimeMean();

    public long getSessionTimeTotal();
}

