/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.staticapp;

import java.net.URI;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.util.FileID;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.eclipse.jetty.util.resource.Resources;

public class StaticAppContext
extends ContextHandler {
    private final ResourceHandler resourceHandler;

    public StaticAppContext() {
        this(null, null);
    }

    public StaticAppContext(String contextPath) {
        this(contextPath, null);
    }

    public StaticAppContext(String contextPath, ResourceHandler resourceHandler) {
        if (contextPath != null) {
            this.setContextPath(contextPath);
        }
        this.resourceHandler = resourceHandler != null ? resourceHandler : this.newResourceHandler();
        this.setHandler((Handler)this.resourceHandler);
    }

    protected ResourceHandler newResourceHandler() {
        return new ResourceHandler();
    }

    public ResourceHandler getResourceHandler() {
        return this.resourceHandler;
    }

    protected void initializeDefault(String keyName, Object value) {
        switch (keyName) {
            case "jetty.deploy.baseResource.dirAllowed": {
                if (value instanceof String) {
                    String str = (String)value;
                    this.getResourceHandler().setDirAllowed(Boolean.parseBoolean(str));
                    break;
                }
                if (!(value instanceof Boolean)) break;
                Boolean bool = (Boolean)value;
                this.getResourceHandler().setDirAllowed(bool.booleanValue());
            }
        }
    }

    public void setBaseResource(Resource baseResource) {
        if (baseResource == null || Resources.isDirectory((Resource)baseResource)) {
            super.setBaseResource(baseResource);
        } else if (Resources.isReadableFile((Resource)baseResource)) {
            URI uri = baseResource.getURI();
            if (!"jar".equals(uri.getScheme()) && FileID.isArchive((URI)uri)) {
                Resource jarResource = ResourceFactory.of((Container)this).newJarFileResource(uri);
                super.setBaseResource(jarResource);
            } else {
                super.setBaseResource(baseResource);
            }
        }
    }
}

