/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.component;

import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jetty.util.Uptime;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

@ManagedObject(value="Abstract Implementation of LifeCycle")
public abstract class AbstractLifeCycle
implements LifeCycle {
    private static final Logger LOG = Log.getLogger(AbstractLifeCycle.class);
    public static final String STOPPED = State.STOPPED.toString();
    public static final String FAILED = State.FAILED.toString();
    public static final String STARTING = State.STARTING.toString();
    public static final String STARTED = State.STARTED.toString();
    public static final String STOPPING = State.STOPPING.toString();
    private final List<EventListener> _eventListener = new CopyOnWriteArrayList<EventListener>();
    private final Object _lock = new Object();
    private volatile State _state = State.STOPPED;
    private long _stopTimeout = 30000L;

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void start() throws Exception {
        Object object = this._lock;
        synchronized (object) {
            try {
                switch (this._state) {
                    case STARTED: {
                        return;
                    }
                    case STARTING: 
                    case STOPPING: {
                        throw new IllegalStateException(this.getState());
                    }
                }
                try {
                    this.setStarting();
                    this.doStart();
                    this.setStarted();
                }
                catch (StopException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(e);
                    }
                    this.setStopping();
                    this.doStop();
                    this.setStopped();
                }
            }
            catch (Throwable e) {
                this.setFailed(e);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void stop() throws Exception {
        Object object = this._lock;
        synchronized (object) {
            try {
                switch (this._state) {
                    case STOPPED: {
                        return;
                    }
                    case STARTING: 
                    case STOPPING: {
                        throw new IllegalStateException(this.getState());
                    }
                }
                this.setStopping();
                this.doStop();
                this.setStopped();
            }
            catch (Throwable e) {
                this.setFailed(e);
                throw e;
            }
        }
    }

    @Override
    public boolean isRunning() {
        State state = this._state;
        switch (state) {
            case STARTED: 
            case STARTING: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isStarted() {
        return this._state == State.STARTED;
    }

    @Override
    public boolean isStarting() {
        return this._state == State.STARTING;
    }

    @Override
    public boolean isStopping() {
        return this._state == State.STOPPING;
    }

    @Override
    public boolean isStopped() {
        return this._state == State.STOPPED;
    }

    @Override
    public boolean isFailed() {
        return this._state == State.FAILED;
    }

    public List<EventListener> getEventListeners() {
        return this._eventListener;
    }

    public void setEventListeners(Collection<EventListener> eventListeners) {
        for (EventListener l : this._eventListener) {
            if (eventListeners.contains(l)) continue;
            this.removeEventListener(l);
        }
        for (EventListener l : eventListeners) {
            if (this._eventListener.contains(l)) continue;
            this.addEventListener(l);
        }
    }

    @Override
    public boolean addEventListener(EventListener listener) {
        if (this._eventListener.contains(listener)) {
            return false;
        }
        this._eventListener.add(listener);
        return true;
    }

    @Override
    public boolean removeEventListener(EventListener listener) {
        return this._eventListener.remove(listener);
    }

    @ManagedAttribute(value="Lifecycle State for this instance", readonly=true)
    public String getState() {
        return this._state.toString();
    }

    public static String getState(LifeCycle lc) {
        if (lc instanceof AbstractLifeCycle) {
            return ((AbstractLifeCycle)lc)._state.toString();
        }
        if (lc.isStarting()) {
            return State.STARTING.toString();
        }
        if (lc.isStarted()) {
            return State.STARTED.toString();
        }
        if (lc.isStopping()) {
            return State.STOPPING.toString();
        }
        if (lc.isStopped()) {
            return State.STOPPED.toString();
        }
        return State.FAILED.toString();
    }

    private void setStarted() {
        if (this._state == State.STARTING) {
            this._state = State.STARTED;
            if (LOG.isDebugEnabled()) {
                LOG.debug("STARTED @{}ms {}", Uptime.getUptime(), this);
            }
            for (EventListener listener : this._eventListener) {
                if (!(listener instanceof LifeCycle.Listener)) continue;
                ((LifeCycle.Listener)listener).lifeCycleStarted(this);
            }
        }
    }

    private void setStarting() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("STARTING {}", this);
        }
        this._state = State.STARTING;
        for (EventListener listener : this._eventListener) {
            if (!(listener instanceof LifeCycle.Listener)) continue;
            ((LifeCycle.Listener)listener).lifeCycleStarting(this);
        }
    }

    private void setStopping() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("STOPPING {}", this);
        }
        this._state = State.STOPPING;
        for (EventListener listener : this._eventListener) {
            if (!(listener instanceof LifeCycle.Listener)) continue;
            ((LifeCycle.Listener)listener).lifeCycleStopping(this);
        }
    }

    private void setStopped() {
        if (this._state == State.STOPPING) {
            this._state = State.STOPPED;
            if (LOG.isDebugEnabled()) {
                LOG.debug("STOPPED {}", this);
            }
            for (EventListener listener : this._eventListener) {
                if (!(listener instanceof LifeCycle.Listener)) continue;
                ((LifeCycle.Listener)listener).lifeCycleStopped(this);
            }
        }
    }

    private void setFailed(Throwable th) {
        this._state = State.FAILED;
        if (LOG.isDebugEnabled()) {
            LOG.warn("FAILED " + this + ": " + th, th);
        }
        for (EventListener listener : this._eventListener) {
            if (!(listener instanceof LifeCycle.Listener)) continue;
            ((LifeCycle.Listener)listener).lifeCycleFailure(this, th);
        }
    }

    @ManagedAttribute(value="The stop timeout in milliseconds")
    public long getStopTimeout() {
        return this._stopTimeout;
    }

    public void setStopTimeout(long stopTimeout) {
        this._stopTimeout = stopTimeout;
    }

    public String toString() {
        Class<?> clazz = this.getClass();
        String name = clazz.getSimpleName();
        if ((name == null || name.length() == 0) && clazz.getSuperclass() != null) {
            clazz = clazz.getSuperclass();
            name = clazz.getSimpleName();
        }
        return String.format("%s@%x{%s}", name, this.hashCode(), this.getState());
    }

    public class StopException
    extends RuntimeException {
    }

    public static abstract class AbstractLifeCycleListener
    implements LifeCycle.Listener {
        @Override
        public void lifeCycleFailure(LifeCycle event, Throwable cause) {
        }

        @Override
        public void lifeCycleStarted(LifeCycle event) {
        }

        @Override
        public void lifeCycleStarting(LifeCycle event) {
        }

        @Override
        public void lifeCycleStopped(LifeCycle event) {
        }

        @Override
        public void lifeCycleStopping(LifeCycle event) {
        }
    }

    static enum State {
        STOPPED,
        STARTING,
        STARTED,
        STOPPING,
        FAILED;

    }
}

