/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IncludeExcludeSet;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Scanner
extends AbstractLifeCycle {
    public static final int DEFAULT_SCAN_DEPTH = 1;
    public static final int MAX_SCAN_DEPTH = Integer.MAX_VALUE;
    private static final Logger LOG = LoggerFactory.getLogger(Scanner.class);
    private static final AtomicInteger SCANNER_IDS = new AtomicInteger();
    private int _scanInterval;
    private final AtomicInteger _scanCount = new AtomicInteger(0);
    private final List<Listener> _listeners = new CopyOnWriteArrayList<Listener>();
    private Map<String, MetaData> _prevScan;
    private FilenameFilter _filter;
    private final Map<Path, IncludeExcludeSet<PathMatcher, Path>> _scannables = new ConcurrentHashMap<Path, IncludeExcludeSet<PathMatcher, Path>>();
    private boolean _reportExisting = true;
    private boolean _reportDirs = true;
    private Scheduler.Task _task;
    private Scheduler _scheduler;
    private int _scanDepth = 1;

    public int getScanInterval() {
        return this._scanInterval;
    }

    public void setScanInterval(int scanInterval) {
        if (this.isRunning()) {
            throw new IllegalStateException("Scanner started");
        }
        this._scanInterval = scanInterval;
    }

    public void setScanDirs(List<File> dirs) {
        if (this.isRunning()) {
            throw new IllegalStateException("Scanner started");
        }
        this._scannables.clear();
        if (dirs == null) {
            return;
        }
        for (File f : dirs) {
            if (f.isDirectory()) {
                this.addDirectory(f.toPath());
                continue;
            }
            this.addFile(f.toPath());
        }
    }

    public void addFile(Path p) {
        if (this.isRunning()) {
            throw new IllegalStateException("Scanner started");
        }
        if (p == null) {
            throw new IllegalStateException("Null path");
        }
        if (!Files.exists(p, new LinkOption[0]) || Files.isDirectory(p, new LinkOption[0])) {
            throw new IllegalStateException("Not file or doesn't exist: " + p);
        }
        try {
            this._scannables.putIfAbsent(p.toRealPath(new LinkOption[0]), new IncludeExcludeSet(PathMatcherSet.class));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public IncludeExcludeSet<PathMatcher, Path> addDirectory(Path p) {
        if (this.isRunning()) {
            throw new IllegalStateException("Scanner started");
        }
        if (p == null) {
            throw new IllegalStateException("Null path");
        }
        if (!Files.exists(p, new LinkOption[0]) || !Files.isDirectory(p, new LinkOption[0])) {
            throw new IllegalStateException("Not directory or doesn't exist: " + p);
        }
        try {
            IncludeExcludeSet<PathMatcher, Path> includesExcludes = new IncludeExcludeSet<PathMatcher, Path>(PathMatcherSet.class);
            IncludeExcludeSet prev = this._scannables.putIfAbsent(p.toRealPath(new LinkOption[0]), includesExcludes);
            if (prev != null) {
                includesExcludes = prev;
            }
            return includesExcludes;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Deprecated
    public void setFilenameFilter(FilenameFilter filter) {
        this._filter = filter;
    }

    @Deprecated
    public FilenameFilter getFilenameFilter() {
        return this._filter;
    }

    public Set<Path> getScannables() {
        return Collections.unmodifiableSet(this._scannables.keySet());
    }

    public int getScanDepth() {
        return this._scanDepth;
    }

    public void setScanDepth(int scanDepth) {
        if (this.isRunning()) {
            throw new IllegalStateException("Scanner started");
        }
        this._scanDepth = scanDepth;
    }

    public void setReportExistingFilesOnStartup(boolean reportExisting) {
        if (this.isRunning()) {
            throw new IllegalStateException("Scanner started");
        }
        this._reportExisting = reportExisting;
    }

    public boolean getReportExistingFilesOnStartup() {
        return this._reportExisting;
    }

    public void setReportDirs(boolean dirs) {
        if (this.isRunning()) {
            throw new IllegalStateException("Scanner started");
        }
        this._reportDirs = dirs;
    }

    public boolean getReportDirs() {
        return this._reportDirs;
    }

    public void addListener(Listener listener) {
        if (listener == null) {
            return;
        }
        this._listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        if (listener == null) {
            return;
        }
        this._listeners.remove(listener);
    }

    @Override
    public void doStart() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Scanner start: rprtExists={}, depth={}, rprtDirs={}, interval={}, filter={}, scannables={}", new Object[]{this._reportExisting, this._scanDepth, this._reportDirs, this._scanInterval, this._filter, this._scannables});
        }
        if (this._reportExisting) {
            this.scan();
            this.scan();
        } else {
            this._prevScan = this.scanFiles();
        }
        this._scheduler = new ScheduledExecutorScheduler("Scanner-" + SCANNER_IDS.getAndIncrement(), true, 1);
        this._scheduler.start();
        this.schedule();
    }

    private void schedule() {
        if (this.isRunning() && this.getScanInterval() > 0) {
            this._task = this._scheduler.schedule(new ScanTask(), 1010L * (long)this.getScanInterval(), TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void doStop() throws Exception {
        Scheduler.Task task = this._task;
        this._task = null;
        if (task != null) {
            task.cancel();
        }
        Scheduler scheduler = this._scheduler;
        this._scheduler = null;
        if (scheduler != null) {
            scheduler.stop();
        }
    }

    public void reset() {
        if (!this.isStopped()) {
            throw new IllegalStateException("Not stopped");
        }
        this._scannables.clear();
        this._prevScan = null;
    }

    public boolean exists(String path) {
        for (Path p : this._scannables.keySet()) {
            if (!p.resolve(path).toFile().exists()) continue;
            return true;
        }
        return false;
    }

    public void nudge() {
        if (!this.isRunning()) {
            throw new IllegalStateException("Scanner not running");
        }
        this.scan(Callback.NOOP);
    }

    public void scan(Callback complete) {
        Scheduler scheduler = this._scheduler;
        if (!this.isRunning() || scheduler == null) {
            complete.failed(new IllegalStateException("Scanner not running"));
            return;
        }
        scheduler.schedule(() -> {
            try {
                this.scan();
                complete.succeeded();
            }
            catch (Throwable t) {
                complete.failed(t);
            }
        }, 0L, TimeUnit.MILLISECONDS);
    }

    void scan() {
        int cycle = this._scanCount.incrementAndGet();
        this.reportScanStart(cycle);
        Map<String, MetaData> currentScan = this.scanFiles();
        this.reportDifferences(currentScan, this._prevScan == null ? Collections.emptyMap() : Collections.unmodifiableMap(this._prevScan));
        this._prevScan = currentScan;
        this.reportScanEnd(cycle);
    }

    private Map<String, MetaData> scanFiles() {
        HashMap<String, MetaData> currentScan = new HashMap<String, MetaData>();
        for (Path p : this._scannables.keySet()) {
            try {
                Files.walkFileTree(p, EnumSet.allOf(FileVisitOption.class), this._scanDepth, new Visitor(p, this._scannables.get(p), currentScan));
            }
            catch (IOException e) {
                LOG.warn("Error scanning files.", (Throwable)e);
            }
        }
        return currentScan;
    }

    private void reportDifferences(Map<String, MetaData> currentScan, Map<String, MetaData> oldScan) {
        HashMap<String, Notification> changes = new HashMap<String, Notification>();
        HashSet<String> oldScanKeys = new HashSet<String>(oldScan.keySet());
        oldScanKeys.removeAll(currentScan.keySet());
        for (String string : oldScanKeys) {
            changes.put(string, Notification.REMOVED);
        }
        for (String string : currentScan.keySet()) {
            MetaData current = currentScan.get(string);
            MetaData previous = oldScan.get(string);
            if (previous == null) {
                current._status = Status.ADDED;
                continue;
            }
            if (current.isModified(previous)) {
                if (previous._status == Status.ADDED) {
                    current._status = Status.ADDED;
                    continue;
                }
                current._status = Status.CHANGED;
                continue;
            }
            if (previous._status == Status.ADDED) {
                changes.put(string, Notification.ADDED);
            } else if (previous._status == Status.CHANGED) {
                changes.put(string, Notification.CHANGED);
            }
            current._status = Status.STABLE;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("scanned {}", this._scannables.keySet());
        }
        block7: for (Map.Entry entry : changes.entrySet()) {
            switch ((Notification)((Object)entry.getValue())) {
                case ADDED: {
                    this.reportAddition((String)entry.getKey());
                    continue block7;
                }
                case CHANGED: {
                    this.reportChange((String)entry.getKey());
                    continue block7;
                }
                case REMOVED: {
                    this.reportRemoval((String)entry.getKey());
                    continue block7;
                }
            }
            LOG.warn("Unknown file change: {}", entry.getValue());
        }
        this.reportBulkChanges(changes.keySet());
    }

    private void warn(Object listener, String filename, Throwable th) {
        LOG.warn("{} failed on '{}'", new Object[]{listener, filename, th});
    }

    private void reportAddition(String filename) {
        for (Listener l : this._listeners) {
            try {
                if (!(l instanceof DiscreteListener)) continue;
                ((DiscreteListener)l).fileAdded(filename);
            }
            catch (Throwable e) {
                this.warn(l, filename, e);
            }
        }
    }

    private void reportRemoval(String filename) {
        for (Listener l : this._listeners) {
            try {
                if (!(l instanceof DiscreteListener)) continue;
                ((DiscreteListener)l).fileRemoved(filename);
            }
            catch (Throwable e) {
                this.warn(l, filename, e);
            }
        }
    }

    private void reportChange(String filename) {
        if (filename == null) {
            return;
        }
        for (Listener l : this._listeners) {
            try {
                if (!(l instanceof DiscreteListener)) continue;
                ((DiscreteListener)l).fileChanged(filename);
            }
            catch (Throwable e) {
                this.warn(l, filename, e);
            }
        }
    }

    private void reportBulkChanges(Set<String> filenames) {
        if (filenames == null || filenames.isEmpty()) {
            return;
        }
        for (Listener l : this._listeners) {
            try {
                if (!(l instanceof BulkListener)) continue;
                ((BulkListener)l).filesChanged(filenames);
            }
            catch (Throwable e) {
                this.warn(l, filenames.toString(), e);
            }
        }
    }

    private void reportScanStart(int cycle) {
        for (Listener listener : this._listeners) {
            try {
                if (!(listener instanceof ScanCycleListener)) continue;
                ((ScanCycleListener)listener).scanStarted(cycle);
            }
            catch (Exception e) {
                LOG.warn("{} failed on scan start for cycle {}", new Object[]{listener, cycle, e});
            }
        }
    }

    private void reportScanEnd(int cycle) {
        for (Listener listener : this._listeners) {
            try {
                if (!(listener instanceof ScanCycleListener)) continue;
                ((ScanCycleListener)listener).scanEnded(cycle);
            }
            catch (Exception e) {
                LOG.warn("{} failed on scan end for cycle {}", new Object[]{listener, cycle, e});
            }
        }
    }

    public static interface ScanCycleListener
    extends Listener {
        default public void scanStarted(int cycle) throws Exception {
        }

        default public void scanEnded(int cycle) throws Exception {
        }
    }

    public static interface BulkListener
    extends Listener {
        public void filesChanged(Set<String> var1) throws Exception;
    }

    public static interface DiscreteListener
    extends Listener {
        public void fileChanged(String var1) throws Exception;

        public void fileAdded(String var1) throws Exception;

        public void fileRemoved(String var1) throws Exception;
    }

    public static interface Listener {
    }

    private class Visitor
    implements FileVisitor<Path> {
        Map<String, MetaData> scanInfoMap;
        IncludeExcludeSet<PathMatcher, Path> rootIncludesExcludes;
        Path root;

        public Visitor(Path root, IncludeExcludeSet<PathMatcher, Path> rootIncludesExcludes, Map<String, MetaData> scanInfoMap) {
            this.root = root;
            this.rootIncludesExcludes = rootIncludesExcludes;
            this.scanInfoMap = scanInfoMap;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            if (!Files.exists(dir, new LinkOption[0])) {
                return FileVisitResult.SKIP_SUBTREE;
            }
            File f = dir.toFile();
            if (Scanner.this._reportDirs && !this.scanInfoMap.containsKey(f.getCanonicalPath())) {
                boolean accepted = false;
                if (this.rootIncludesExcludes != null && !this.rootIncludesExcludes.isEmpty()) {
                    accepted = this.rootIncludesExcludes.test(dir);
                } else if (Scanner.this._filter == null || Scanner.this._filter.accept(f.getParentFile(), f.getName())) {
                    accepted = true;
                }
                if (accepted) {
                    this.scanInfoMap.put(f.getCanonicalPath(), new MetaData(f.lastModified(), f.isDirectory() ? 0L : f.length()));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("scan accepted dir {} mod={}", (Object)f, (Object)f.lastModified());
                    }
                }
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (!Files.exists(file, new LinkOption[0])) {
                return FileVisitResult.CONTINUE;
            }
            File f = file.toFile();
            boolean accepted = false;
            if (f.isFile() || f.isDirectory() && Scanner.this._reportDirs && !this.scanInfoMap.containsKey(f.getCanonicalPath())) {
                if (this.rootIncludesExcludes != null && !this.rootIncludesExcludes.isEmpty()) {
                    accepted = this.rootIncludesExcludes.test(file);
                } else if (Scanner.this._filter == null || Scanner.this._filter.accept(f.getParentFile(), f.getName())) {
                    accepted = true;
                }
            }
            if (accepted) {
                this.scanInfoMap.put(f.getCanonicalPath(), new MetaData(f.lastModified(), f.isDirectory() ? 0L : f.length()));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("scan accepted {} mod={}", (Object)f, (Object)f.lastModified());
                }
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
            LOG.warn("FileVisit failed: {}", (Object)file, (Object)exc);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            return FileVisitResult.CONTINUE;
        }
    }

    private class ScanTask
    implements Runnable {
        private ScanTask() {
        }

        @Override
        public void run() {
            Scanner.this.scan();
            Scanner.this.schedule();
        }
    }

    private static class MetaData {
        final long _lastModified;
        final long _size;
        Status _status;

        public MetaData(long lastModified, long size) {
            this._lastModified = lastModified;
            this._size = size;
        }

        public boolean isModified(MetaData m) {
            return m._lastModified != this._lastModified || m._size != this._size;
        }

        public String toString() {
            return "[lm=" + this._lastModified + ",sz=" + this._size + ",s=" + this._status + "]";
        }
    }

    static class PathMatcherSet
    extends HashSet<PathMatcher>
    implements Predicate<Path> {
        PathMatcherSet() {
        }

        @Override
        public boolean test(Path p) {
            for (PathMatcher pm : this) {
                if (!pm.matches(p)) continue;
                return true;
            }
            return false;
        }
    }

    static enum Notification {
        ADDED,
        CHANGED,
        REMOVED;

    }

    private static enum Status {
        ADDED,
        CHANGED,
        REMOVED,
        STABLE;

    }
}

