/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.resource;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Path;
import java.util.Objects;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.resource.Resource;

public class MemoryResource
extends Resource {
    private final URI _uri;
    private final long _created = System.currentTimeMillis();
    private final byte[] _bytes;

    MemoryResource(URL url) {
        try {
            this._uri = Objects.requireNonNull(url).toURI();
            try (InputStream in = url.openStream();){
                this._bytes = IO.readBytes(in);
            }
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Path getPath() {
        return Path.of(this._uri);
    }

    @Override
    public boolean isContainedIn(Resource r) {
        return this.getPath().startsWith(r.getPath());
    }

    @Override
    public URI getURI() {
        return this._uri;
    }

    @Override
    public String getName() {
        return this.getPath().toAbsolutePath().toString();
    }

    @Override
    public long lastModified() {
        return this._created;
    }

    @Override
    public long length() {
        return this._bytes.length;
    }

    @Override
    public InputStream newInputStream() throws IOException {
        return new ByteArrayInputStream(this._bytes);
    }

    @Override
    public ReadableByteChannel newReadableByteChannel() throws IOException {
        return Channels.newChannel(this.newInputStream());
    }

    @Override
    public boolean exists() {
        return true;
    }

    public String toString() {
        return this.getName();
    }
}

