/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.resource;

import java.io.IOException;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import org.eclipse.jetty.util.Index;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathResource
extends Resource {
    private static final Logger LOG = LoggerFactory.getLogger(PathResource.class);
    public static Index<String> ALLOWED_SCHEMES = new Index.Builder().caseSensitive(false).with("file").with("jrt").build();
    private final Path path;
    private final Path alias;
    private final URI uri;

    private Path checkAliasPath() {
        Path normal;
        Path abs = this.path;
        if (!URIUtil.equalsIgnoreEncodings(this.uri, this.path.toUri())) {
            try {
                return Paths.get(this.uri).toRealPath(new LinkOption[0]);
            }
            catch (IOException ioe) {
                LOG.trace("IGNORED", (Throwable)ioe);
            }
        }
        if (!abs.isAbsolute()) {
            abs = this.path.toAbsolutePath();
        }
        if (!PathResource.isSameName(abs, normal = this.path.normalize())) {
            return normal;
        }
        try {
            Path real;
            if (Files.isSymbolicLink(this.path)) {
                return this.path.getParent().resolve(Files.readSymbolicLink(this.path));
            }
            if (Files.exists(this.path, new LinkOption[0]) && !PathResource.isSameName(abs, real = abs.toRealPath(new LinkOption[0]))) {
                return real;
            }
        }
        catch (IOException e) {
            LOG.trace("IGNORED", (Throwable)e);
        }
        catch (Exception e) {
            LOG.warn("bad alias ({} {}) for {}", new Object[]{e.getClass().getName(), e.getMessage(), this.path});
        }
        return null;
    }

    public static boolean isSameName(Path pathA, Path pathB) {
        int bCount;
        int aCount = pathA.getNameCount();
        if (aCount != (bCount = pathB.getNameCount())) {
            return false;
        }
        int i = bCount;
        while (i-- > 0) {
            if (pathA.getName(i).toString().equals(pathB.getName(i).toString())) continue;
            return false;
        }
        return true;
    }

    PathResource(URI uri) {
        this(uri, false);
    }

    PathResource(URI uri, boolean bypassAllowedSchemeCheck) {
        if (!uri.isAbsolute()) {
            throw new IllegalArgumentException("not an absolute uri: " + uri);
        }
        if (!bypassAllowedSchemeCheck && !ALLOWED_SCHEMES.contains(uri.getScheme())) {
            throw new IllegalArgumentException("not an allowed scheme: " + uri);
        }
        try {
            this.path = Paths.get(uri);
            String uriString = uri.toString();
            if (Files.isDirectory(this.path, new LinkOption[0]) && !uriString.endsWith("/")) {
                uri = URI.create(uriString + "/");
            }
            this.uri = uri;
            this.alias = this.checkAliasPath();
        }
        catch (FileSystemNotFoundException e) {
            throw new IllegalStateException("No FileSystem mounted for : " + uri, e);
        }
    }

    @Override
    public boolean isSame(Resource resource) {
        block3: {
            try {
                if (resource instanceof PathResource) {
                    Path path = resource.getPath();
                    return Files.isSameFile(this.getPath(), path);
                }
            }
            catch (IOException e) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug("ignored", (Throwable)e);
            }
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PathResource other = (PathResource)obj;
        return !(this.path == null ? other.path != null : !this.path.equals(other.path));
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    @Override
    public String getName() {
        return this.path.toAbsolutePath().toString();
    }

    @Override
    public boolean isMemoryMappable() {
        return "file".equalsIgnoreCase(this.uri.getScheme());
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    @Override
    public boolean isContainedIn(Resource r) {
        return r.getClass() == PathResource.class && this.path.startsWith(r.getPath());
    }

    @Override
    public boolean isAlias() {
        return this.alias != null;
    }

    public Path getAliasPath() {
        return this.alias;
    }

    @Override
    public URI getAlias() {
        return this.alias == null ? null : this.alias.toUri();
    }

    @Override
    public void copyTo(Path destination) throws IOException {
        if (this.isDirectory()) {
            Files.walkFileTree(this.path, new TreeCopyFileVisitor(this.path, destination));
        } else {
            Files.copy(this.path, destination, new CopyOption[0]);
        }
    }

    public String toString() {
        return this.uri.toASCIIString();
    }

    private static class TreeCopyFileVisitor
    extends SimpleFileVisitor<Path> {
        private final String relativeTo;
        private final Path target;

        public TreeCopyFileVisitor(Path relativeTo, Path target) {
            this.relativeTo = relativeTo.getRoot().relativize(relativeTo).toString();
            this.target = target;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            Path resolvedTarget = this.target.resolve(dir.getRoot().resolve(this.relativeTo).relativize(dir).toString());
            if (Files.notExists(resolvedTarget, new LinkOption[0])) {
                Files.createDirectories(resolvedTarget, new FileAttribute[0]);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Path resolvedTarget = this.target.resolve(file.getRoot().resolve(this.relativeTo).relativize(file).toString());
            Files.copy(file, resolvedTarget, StandardCopyOption.REPLACE_EXISTING);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) {
            return FileVisitResult.CONTINUE;
        }
    }
}

