/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.ProviderNotFoundException;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.resource.MountedPathResource;
import org.eclipse.jetty.util.resource.PathResource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Resource {
    private static final Logger LOG = LoggerFactory.getLogger(Resource.class);
    private static final LinkOption[] NO_FOLLOW_LINKS = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
    private static final LinkOption[] FOLLOW_LINKS = new LinkOption[0];

    public static ResourceCollection combine(List<Resource> resources) {
        if (resources == null || resources.isEmpty()) {
            throw new IllegalArgumentException("No resources");
        }
        return new ResourceCollection(resources);
    }

    public static ResourceCollection combine(Resource ... resources) {
        if (resources == null || resources.length == 0) {
            throw new IllegalArgumentException("No resources");
        }
        return new ResourceCollection(List.of(resources));
    }

    public static String dump(Resource resource) {
        if (resource == null) {
            return "null exists=false directory=false lm=-1";
        }
        return "%s exists=%b directory=%b lm=%d".formatted(resource.toString(), resource.exists(), resource.isDirectory(), resource.lastModified());
    }

    static Resource create(URI uri) {
        try {
            if (!uri.isAbsolute()) {
                uri = uri.toString().startsWith("/") ? new URI("file", uri.toString(), null) : Paths.get("", new String[0]).toAbsolutePath().toUri().resolve(uri);
            }
            if (PathResource.ALLOWED_SCHEMES.contains(uri.getScheme())) {
                return new PathResource(uri);
            }
            return new MountedPathResource(uri);
        }
        catch (IOException | URISyntaxException | ProviderNotFoundException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public abstract Path getPath();

    public abstract boolean isContainedIn(Resource var1);

    public boolean isSame(Resource resource) {
        return this.equals(resource);
    }

    public boolean exists() {
        return Files.exists(this.getPath(), NO_FOLLOW_LINKS);
    }

    public boolean isDirectory() {
        return Files.isDirectory(this.getPath(), FOLLOW_LINKS);
    }

    public long lastModified() {
        try {
            FileTime ft = Files.getLastModifiedTime(this.getPath(), FOLLOW_LINKS);
            return ft.toMillis();
        }
        catch (IOException e) {
            LOG.trace("IGNORED", (Throwable)e);
            return 0L;
        }
    }

    public long length() {
        try {
            return Files.size(this.getPath());
        }
        catch (IOException e) {
            return 0L;
        }
    }

    public abstract URI getURI();

    public abstract String getName();

    public InputStream newInputStream() throws IOException {
        return Files.newInputStream(this.getPath(), StandardOpenOption.READ);
    }

    public ReadableByteChannel newReadableByteChannel() throws IOException {
        return Files.newByteChannel(this.getPath(), StandardOpenOption.READ);
    }

    public boolean isMemoryMappable() {
        return false;
    }

    public List<String> list() {
        block13: {
            ArrayList<String> arrayList;
            block12: {
                if (!this.isDirectory()) {
                    return null;
                }
                DirectoryStream<Path> dir = Files.newDirectoryStream(this.getPath());
                try {
                    ArrayList<String> entries = new ArrayList<String>();
                    for (Path entry : dir) {
                        Object name = entry.getFileName().toString();
                        if (Files.isDirectory(entry, new LinkOption[0])) {
                            name = (String)name + "/";
                        }
                        entries.add((String)name);
                    }
                    arrayList = entries;
                    if (dir == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (dir != null) {
                            try {
                                dir.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (DirectoryIteratorException e) {
                        LOG.debug("Directory list failure", (Throwable)e);
                        break block13;
                    }
                    catch (IOException e) {
                        LOG.debug("Directory list access failure", (Throwable)e);
                    }
                }
                dir.close();
            }
            return arrayList;
        }
        return null;
    }

    public Resource resolve(String subUriPath) {
        URI resolvedUri;
        if (URIUtil.isNotNormalWithinSelf(subUriPath)) {
            throw new IllegalArgumentException(subUriPath);
        }
        if ("/".equals(subUriPath)) {
            return this;
        }
        while (subUriPath.startsWith("/")) {
            subUriPath = subUriPath.substring(1);
        }
        URI uri = this.getURI();
        if (uri.isOpaque()) {
            String scheme = uri.getScheme();
            URI subUri = URI.create(uri.getSchemeSpecificPart());
            if (subUri.isOpaque()) {
                throw new IllegalArgumentException("Unsupported doubly opaque URI: " + uri);
            }
            if (!subUri.getPath().endsWith("/")) {
                subUri = URI.create(subUri + "/");
            }
            URI subUriResolved = subUri.resolve(subUriPath);
            resolvedUri = URI.create(scheme + ":" + subUriResolved);
        } else {
            if (!uri.getPath().endsWith("/")) {
                uri = URI.create(uri + "/");
            }
            resolvedUri = uri.resolve(subUriPath);
        }
        return Resource.create(resolvedUri);
    }

    public boolean isAlias() {
        return this.getAlias() != null;
    }

    public URI getAlias() {
        return null;
    }

    public void copyTo(Path destination) throws IOException {
        if (Files.exists(destination, new LinkOption[0])) {
            throw new IllegalArgumentException(destination + " exists");
        }
        Path src = this.getPath();
        if (src != null) {
            Files.copy(src, destination, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
            return;
        }
        try (InputStream in = this.newInputStream();
             OutputStream out = Files.newOutputStream(destination, new OpenOption[0]);){
            IO.copy(in, out);
        }
    }

    public String getWeakETag() {
        return this.getWeakETag("");
    }

    public String getWeakETag(String suffix) {
        StringBuilder b = new StringBuilder(32);
        b.append("W/\"");
        String name = this.getName();
        int length = name.length();
        long lhash = 0L;
        for (int i = 0; i < length; ++i) {
            lhash = 31L * lhash + (long)name.charAt(i);
        }
        Base64.Encoder encoder = Base64.getEncoder().withoutPadding();
        b.append(encoder.encodeToString(Resource.longToBytes(this.lastModified() ^ lhash)));
        b.append(encoder.encodeToString(Resource.longToBytes(this.length() ^ lhash)));
        b.append(suffix);
        b.append('\"');
        return b.toString();
    }

    private static byte[] longToBytes(long value) {
        byte[] result = new byte[8];
        for (int i = 7; i >= 0; --i) {
            result[i] = (byte)(value & 0xFFL);
            value >>= 8;
        }
        return result;
    }

    public Collection<Resource> getAllResources() {
        try {
            ArrayList<Resource> deep = new ArrayList<Resource>();
            List<String> list = this.list();
            if (list != null) {
                for (String i : list) {
                    Resource r = this.resolve(i);
                    if (r.isDirectory()) {
                        deep.addAll(r.getAllResources());
                        continue;
                    }
                    deep.add(r);
                }
            }
            return deep;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

