/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.resource;

import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.component.DumpableCollection;
import org.eclipse.jetty.util.resource.FileSystemPool;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ResourceFactoryInternals {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceFactoryInternals.class);
    static ResourceFactory ROOT = new ResourceFactory(){

        @Override
        public Resource newResource(URI uri) {
            FileSystemPool.Mount mount = ResourceFactoryInternals.mountIfNeeded(uri);
            if (mount != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.warn("Leaked {} for {}", new Object[]{mount, uri, new Throwable()});
                } else {
                    LOG.warn("Leaked {} for {}", (Object)mount, (Object)uri);
                }
            }
            return Resource.create(uri);
        }

        @Override
        public Resource newResource(String resource) {
            return this.newResource(URIUtil.toURI(resource));
        }
    };

    ResourceFactoryInternals() {
    }

    static FileSystemPool.Mount mountIfNeeded(URI uri) {
        if (uri == null) {
            return null;
        }
        String scheme = uri.getScheme();
        if (scheme == null || !scheme.equalsIgnoreCase("jar")) {
            return null;
        }
        try {
            return FileSystemPool.INSTANCE.mount(uri);
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException(ioe);
        }
    }

    static class LifeCycle
    extends AbstractLifeCycle
    implements ResourceFactory.LifeCycle {
        private final List<FileSystemPool.Mount> _mounts = new CopyOnWriteArrayList<FileSystemPool.Mount>();

        LifeCycle() {
        }

        @Override
        public Resource newResource(URI uri) {
            FileSystemPool.Mount mount = ResourceFactoryInternals.mountIfNeeded(uri);
            if (mount != null) {
                this._mounts.add(mount);
            }
            return Resource.create(uri);
        }

        @Override
        protected void doStop() throws Exception {
            for (FileSystemPool.Mount mount : this._mounts) {
                IO.close(mount);
            }
            this._mounts.clear();
            super.doStop();
        }

        @Override
        public void dump(Appendable out, String indent) throws IOException {
            Dumpable.dumpObjects(out, indent, this, new DumpableCollection("mounts", this._mounts));
        }
    }

    static class Closeable
    implements ResourceFactory.Closeable {
        private final List<FileSystemPool.Mount> _mounts = new CopyOnWriteArrayList<FileSystemPool.Mount>();

        Closeable() {
        }

        @Override
        public Resource newResource(URI uri) {
            FileSystemPool.Mount mount = ResourceFactoryInternals.mountIfNeeded(uri);
            if (mount != null) {
                this._mounts.add(mount);
            }
            return Resource.create(uri);
        }

        @Override
        public void close() {
            for (FileSystemPool.Mount mount : this._mounts) {
                IO.close(mount);
            }
            this._mounts.clear();
        }
    }
}

