/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.stream.Stream;
import org.eclipse.jetty.util.FileID;
import org.eclipse.jetty.util.HostPort;
import org.eclipse.jetty.util.Index;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.Utf8Appendable;
import org.eclipse.jetty.util.Utf8StringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class URIUtil {
    private static final Logger LOG = LoggerFactory.getLogger(URIUtil.class);
    private static final Index<String> KNOWN_SCHEMES = new Index.Builder().caseSensitive(false).with("file:").with("jrt:").with("jar:").build();
    public static final String SLASH = "/";
    public static final String HTTP = "http";
    public static final String HTTPS = "https";
    public static final Charset __CHARSET = StandardCharsets.UTF_8;
    public static final boolean[] __uriSupportedCharacters = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, true, false, true, true, true, true, true, true, true, true, true, false, true, true, true, true, true, true, true, true, true, true, true, false, false, true, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, true, false};

    private URIUtil() {
    }

    public static String encodePath(String path) {
        if (path == null || path.length() == 0) {
            return path;
        }
        StringBuilder buf = URIUtil.encodePath(null, path, 0);
        return buf == null ? path : buf.toString();
    }

    public static StringBuilder encodePath(StringBuilder buf, String path) {
        return URIUtil.encodePath(buf, path, 0);
    }

    private static StringBuilder encodePath(StringBuilder buf, String path, int offset) {
        int i;
        byte[] bytes = null;
        if (buf == null) {
            block41: for (i = offset; i < path.length(); ++i) {
                char c = path.charAt(i);
                switch (c) {
                    case ' ': 
                    case '\"': 
                    case '#': 
                    case '%': 
                    case '\'': 
                    case ';': 
                    case '<': 
                    case '>': 
                    case '?': 
                    case '[': 
                    case '\\': 
                    case ']': 
                    case '^': 
                    case '`': 
                    case '{': 
                    case '|': 
                    case '}': {
                        buf = new StringBuilder(path.length() * 2);
                        break block41;
                    }
                    default: {
                        if (c >= ' ' && c < '\u007f') continue block41;
                        bytes = path.getBytes(__CHARSET);
                        buf = new StringBuilder(path.length() * 2);
                        break block41;
                    }
                }
            }
            if (buf == null) {
                return null;
            }
        }
        block42: for (i = offset; i < path.length(); ++i) {
            char c = path.charAt(i);
            switch (c) {
                case '%': {
                    buf.append("%25");
                    continue block42;
                }
                case '?': {
                    buf.append("%3F");
                    continue block42;
                }
                case ';': {
                    buf.append("%3B");
                    continue block42;
                }
                case '#': {
                    buf.append("%23");
                    continue block42;
                }
                case '\"': {
                    buf.append("%22");
                    continue block42;
                }
                case '\'': {
                    buf.append("%27");
                    continue block42;
                }
                case '<': {
                    buf.append("%3C");
                    continue block42;
                }
                case '>': {
                    buf.append("%3E");
                    continue block42;
                }
                case ' ': {
                    buf.append("%20");
                    continue block42;
                }
                case '[': {
                    buf.append("%5B");
                    continue block42;
                }
                case '\\': {
                    buf.append("%5C");
                    continue block42;
                }
                case ']': {
                    buf.append("%5D");
                    continue block42;
                }
                case '^': {
                    buf.append("%5E");
                    continue block42;
                }
                case '`': {
                    buf.append("%60");
                    continue block42;
                }
                case '{': {
                    buf.append("%7B");
                    continue block42;
                }
                case '|': {
                    buf.append("%7C");
                    continue block42;
                }
                case '}': {
                    buf.append("%7D");
                    continue block42;
                }
                default: {
                    if (c < ' ' || c >= '\u007f') {
                        bytes = path.getBytes(__CHARSET);
                        break block42;
                    }
                    buf.append(c);
                }
            }
        }
        if (bytes != null) {
            while (i < bytes.length) {
                void var5_7 = bytes[i];
                switch (var5_7) {
                    case 37: {
                        buf.append("%25");
                        break;
                    }
                    case 63: {
                        buf.append("%3F");
                        break;
                    }
                    case 59: {
                        buf.append("%3B");
                        break;
                    }
                    case 35: {
                        buf.append("%23");
                        break;
                    }
                    case 34: {
                        buf.append("%22");
                        break;
                    }
                    case 39: {
                        buf.append("%27");
                        break;
                    }
                    case 60: {
                        buf.append("%3C");
                        break;
                    }
                    case 62: {
                        buf.append("%3E");
                        break;
                    }
                    case 32: {
                        buf.append("%20");
                        break;
                    }
                    case 91: {
                        buf.append("%5B");
                        break;
                    }
                    case 92: {
                        buf.append("%5C");
                        break;
                    }
                    case 93: {
                        buf.append("%5D");
                        break;
                    }
                    case 94: {
                        buf.append("%5E");
                        break;
                    }
                    case 96: {
                        buf.append("%60");
                        break;
                    }
                    case 123: {
                        buf.append("%7B");
                        break;
                    }
                    case 124: {
                        buf.append("%7C");
                        break;
                    }
                    case 125: {
                        buf.append("%7D");
                        break;
                    }
                    default: {
                        if (var5_7 < 32 || var5_7 >= 127) {
                            buf.append('%');
                            TypeUtil.toHex((byte)var5_7, (Appendable)buf);
                            break;
                        }
                        buf.append((char)var5_7);
                    }
                }
                ++i;
            }
        }
        return buf;
    }

    public static String encodeSpaces(String str) {
        return StringUtil.replace(str, " ", "%20");
    }

    public static String encodeSpecific(String str, String charsToEncode) {
        if (str == null || str.length() == 0) {
            return null;
        }
        if (charsToEncode == null || charsToEncode.length() == 0) {
            return str;
        }
        char[] find = charsToEncode.toCharArray();
        int len = str.length();
        StringBuilder ret = new StringBuilder((int)((double)len * 0.2));
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            boolean escaped = false;
            for (char f : find) {
                if (c != f) continue;
                escaped = true;
                ret.append('%');
                int d = 0xF & (0xF0 & c) >> 4;
                ret.append((char)((d > 9 ? 55 : 48) + d));
                d = 0xF & c;
                ret.append((char)((d > 9 ? 55 : 48) + d));
                break;
            }
            if (escaped) continue;
            ret.append(c);
        }
        return ret.toString();
    }

    public static String decodeSpecific(String str, String charsToDecode) {
        if (str == null || str.length() == 0) {
            return null;
        }
        if (charsToDecode == null || charsToDecode.length() == 0) {
            return str;
        }
        int idx = str.indexOf(37);
        if (idx == -1) {
            return str;
        }
        char[] find = charsToDecode.toCharArray();
        int len = str.length();
        Utf8StringBuilder ret = new Utf8StringBuilder(len);
        ret.append(str, 0, idx);
        block3: for (int i = idx; i < len; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '%': {
                    if (i + 2 < len) {
                        char u = str.charAt(i + 1);
                        char l = str.charAt(i + 2);
                        char result = (char)(0xFF & TypeUtil.convertHexDigit(u) * 16 + TypeUtil.convertHexDigit(l));
                        boolean decoded = false;
                        for (char f : find) {
                            if (f != result) continue;
                            ret.append(result);
                            decoded = true;
                            break;
                        }
                        if (decoded) {
                            i += 2;
                            continue block3;
                        }
                        ret.append(c);
                        continue block3;
                    }
                    throw new IllegalArgumentException("Bad URI % encoding");
                }
                default: {
                    ret.append(c);
                }
            }
        }
        return ret.toString();
    }

    public static StringBuilder encodeString(StringBuilder buf, String path, String encode) {
        char c;
        int i;
        if (buf == null) {
            for (i = 0; i < path.length(); ++i) {
                c = path.charAt(i);
                if (c != '%' && encode.indexOf(c) < 0) continue;
                buf = new StringBuilder(path.length() << 1);
                break;
            }
            if (buf == null) {
                return null;
            }
        }
        for (i = 0; i < path.length(); ++i) {
            c = path.charAt(i);
            if (c == '%' || encode.indexOf(c) >= 0) {
                buf.append('%');
                StringUtil.append(buf, (byte)(0xFF & c), 16);
                continue;
            }
            buf.append(c);
        }
        return buf;
    }

    public static String decodePath(String path) {
        return URIUtil.decodePath(path, 0, path.length());
    }

    public static String decodePath(String path, int offset, int length) {
        try {
            Utf8StringBuilder builder = null;
            int end = offset + length;
            block8: for (int i = offset; i < end; ++i) {
                char c = path.charAt(i);
                switch (c) {
                    case '%': {
                        if (builder == null) {
                            builder = new Utf8StringBuilder(path.length());
                            builder.append(path, offset, i - offset);
                        }
                        if (i + 2 < end) {
                            char u = path.charAt(i + 1);
                            if (u == 'u') {
                                byte[] bytes;
                                int[] codePoints = new int[]{0xFFFF & TypeUtil.parseInt(path, i + 2, 4, 16)};
                                String str = new String(codePoints, 0, 1);
                                for (byte b : bytes = str.getBytes(StandardCharsets.UTF_8)) {
                                    builder.append(b);
                                }
                                i += 5;
                                continue block8;
                            }
                            builder.append((byte)(0xFF & TypeUtil.convertHexDigit(u) * 16 + TypeUtil.convertHexDigit(path.charAt(i + 2))));
                            i += 2;
                            continue block8;
                        }
                        throw new IllegalArgumentException("Bad URI % encoding");
                    }
                    case ';': {
                        if (builder == null) {
                            builder = new Utf8StringBuilder(path.length());
                            builder.append(path, offset, i - offset);
                        }
                        while (++i < end) {
                            if (path.charAt(i) != '/') continue;
                            builder.append('/');
                            continue block8;
                        }
                        continue block8;
                    }
                    default: {
                        if (builder == null) continue block8;
                        builder.append(c);
                    }
                }
            }
            if (builder != null) {
                return builder.toString();
            }
            if (offset == 0 && length == path.length()) {
                return path;
            }
            return path.substring(offset, end);
        }
        catch (Utf8Appendable.NotUtf8Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} {}", (Object)path.substring(offset, offset + length), (Object)e.toString());
            }
            return URIUtil.decodeISO88591Path(path, offset, length);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("cannot decode URI", e);
        }
    }

    private static boolean isSafe(int code) {
        return code >= __uriSupportedCharacters.length || __uriSupportedCharacters[code];
    }

    private static boolean isSafeElseEncode(int code, Utf8StringBuilder builder) {
        if (URIUtil.isSafe(code)) {
            return true;
        }
        URIUtil.encodeCodepoint(code, builder);
        return false;
    }

    private static void encodeCodepoint(int code, Utf8StringBuilder builder) {
        if (code <= 127) {
            builder.append('%');
            URIUtil.appendHexValue(builder, (byte)code);
        } else {
            byte[] bytes;
            int[] codePoints = new int[]{code};
            String str = new String(codePoints, 0, 1);
            for (byte b : bytes = str.getBytes(StandardCharsets.UTF_8)) {
                builder.append('%');
                URIUtil.appendHexValue(builder, b);
            }
        }
    }

    private static void appendHexValue(Utf8StringBuilder builder, byte value) {
        byte d = (byte)((0xF0 & value) >> 4);
        builder.append((char)((d > 9 ? 55 : 48) + d));
        d = (byte)(0xF & value);
        builder.append((char)((d > 9 ? 55 : 48) + d));
    }

    public static String canonicalPath(String path) {
        if (path == null) {
            return null;
        }
        try {
            Utf8StringBuilder builder = null;
            int end = path.length();
            boolean slash = true;
            boolean normal = true;
            for (int i = 0; i < end; ++i) {
                char c = path.charAt(i);
                block1 : switch (c) {
                    case '%': {
                        if (builder == null) {
                            builder = new Utf8StringBuilder(path.length());
                            builder.append(path, 0, i);
                        }
                        if (i + 2 < end) {
                            int code;
                            char u = path.charAt(i + 1);
                            if (u == 'u') {
                                code = TypeUtil.parseInt(path, i + 2, 4, 16);
                                if (URIUtil.isSafeElseEncode(code, builder)) {
                                    char[] chars;
                                    for (char ch : chars = Character.toChars(code)) {
                                        builder.append(ch);
                                        if (slash && ch == '.') {
                                            normal = false;
                                        }
                                        slash = false;
                                    }
                                }
                                i += 5;
                                break;
                            }
                            code = TypeUtil.convertHexDigit(u) * 16 + TypeUtil.convertHexDigit(path.charAt(i + 2));
                            if (URIUtil.isSafeElseEncode(code, builder)) {
                                builder.append((byte)(0xFF & code));
                                if (slash && code == 46) {
                                    normal = false;
                                }
                            }
                            i += 2;
                            break;
                        }
                        throw new IllegalArgumentException("Bad URI % encoding");
                    }
                    case ';': {
                        if (builder == null) {
                            builder = new Utf8StringBuilder(path.length());
                            builder.append(path, 0, i);
                        }
                        while (++i < end) {
                            if (path.charAt(i) != '/') continue;
                            builder.append('/');
                            break block1;
                        }
                        break;
                    }
                    case '/': {
                        if (builder == null) break;
                        builder.append(c);
                        break;
                    }
                    case '.': {
                        if (slash) {
                            normal = false;
                        }
                        if (builder == null) break;
                        builder.append(c);
                        break;
                    }
                    default: {
                        if (builder == null && !URIUtil.isSafe(c)) {
                            builder = new Utf8StringBuilder(path.length());
                            builder.append(path, 0, i);
                        }
                        if (builder == null || !URIUtil.isSafeElseEncode(c, builder)) break;
                        builder.append(c);
                    }
                }
                slash = c == '/';
            }
            String canonical = builder != null ? builder.toString() : path;
            return normal ? canonical : URIUtil.normalizePath(canonical);
        }
        catch (Utf8Appendable.NotUtf8Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} {}", (Object)path, (Object)e.toString());
            }
            throw e;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("cannot decode URI", e);
        }
    }

    private static String decodeISO88591Path(String path, int offset, int length) {
        StringBuilder builder = null;
        int end = offset + length;
        block4: for (int i = offset; i < end; ++i) {
            char c = path.charAt(i);
            switch (c) {
                case '%': {
                    if (builder == null) {
                        builder = new StringBuilder(path.length());
                        builder.append(path, offset, i - offset);
                    }
                    if (i + 2 < end) {
                        char u = path.charAt(i + 1);
                        if (u == 'u') {
                            builder.append((char)(0xFFFF & TypeUtil.parseInt(path, i + 2, 4, 16)));
                            i += 5;
                            continue block4;
                        }
                        builder.append((char)(0xFF & TypeUtil.convertHexDigit(u) * 16 + TypeUtil.convertHexDigit(path.charAt(i + 2))));
                        i += 2;
                        continue block4;
                    }
                    throw new IllegalArgumentException();
                }
                case ';': {
                    if (builder == null) {
                        builder = new StringBuilder(path.length());
                        builder.append(path, offset, i - offset);
                    }
                    while (++i < end) {
                        if (path.charAt(i) != '/') continue;
                        builder.append('/');
                        continue block4;
                    }
                    continue block4;
                }
                default: {
                    if (builder == null) continue block4;
                    builder.append(c);
                }
            }
        }
        if (builder != null) {
            return builder.toString();
        }
        if (offset == 0 && length == path.length()) {
            return path;
        }
        return path.substring(offset, end);
    }

    public static String addEncodedPaths(String p1, String p2) {
        if (p1 == null || p1.length() == 0) {
            if (p1 != null && p2 == null) {
                return p1;
            }
            return p2;
        }
        if (p2 == null || p2.length() == 0) {
            return p1;
        }
        int split = p1.indexOf(59);
        if (split < 0) {
            split = p1.indexOf(63);
        }
        if (split == 0) {
            return p2 + p1;
        }
        if (split < 0) {
            split = p1.length();
        }
        StringBuilder buf = new StringBuilder(p1.length() + p2.length() + 2);
        buf.append(p1);
        if (buf.charAt(split - 1) == '/') {
            if (p2.startsWith(SLASH)) {
                buf.deleteCharAt(split - 1);
                buf.insert(split - 1, p2);
            } else {
                buf.insert(split, p2);
            }
        } else if (p2.startsWith(SLASH)) {
            buf.insert(split, p2);
        } else {
            buf.insert(split, '/');
            buf.insert(split + 1, p2);
        }
        return buf.toString();
    }

    public static String addPaths(String p1, String p2) {
        if (p1 == null || p1.length() == 0) {
            if (p1 != null && p2 == null) {
                return p1;
            }
            return p2;
        }
        if (p2 == null || p2.length() == 0) {
            return p1;
        }
        boolean p1EndsWithSlash = p1.endsWith(SLASH);
        boolean p2StartsWithSlash = p2.startsWith(SLASH);
        if (p1EndsWithSlash && p2StartsWithSlash) {
            if (p2.length() == 1) {
                return p1;
            }
            if (p1.length() == 1) {
                return p2;
            }
        }
        StringBuilder buf = new StringBuilder(p1.length() + p2.length() + 2);
        buf.append(p1);
        if (p1.endsWith(SLASH)) {
            if (p2.startsWith(SLASH)) {
                buf.setLength(buf.length() - 1);
            }
        } else if (!p2.startsWith(SLASH)) {
            buf.append(SLASH);
        }
        buf.append(p2);
        return buf.toString();
    }

    public static String addPathQuery(String path, String query) {
        if (StringUtil.isBlank(query)) {
            return path;
        }
        if (path.indexOf(63) >= 0) {
            return path + "&" + query;
        }
        return path + "?" + query;
    }

    public static String getUriLastPathSegment(URI uri) {
        String ssp = uri.getSchemeSpecificPart();
        int idx = ssp.indexOf("!/");
        if (idx != -1) {
            ssp = ssp.substring(0, idx);
        }
        if (ssp.endsWith(SLASH)) {
            ssp = ssp.substring(0, ssp.length() - 1);
        }
        if ((idx = ssp.lastIndexOf(47)) != -1) {
            ssp = ssp.substring(idx + 1);
        }
        return ssp;
    }

    public static String parentPath(String p) {
        if (p == null || SLASH.equals(p)) {
            return null;
        }
        int slash = p.lastIndexOf(47, p.length() - 2);
        if (slash >= 0) {
            return p.substring(0, slash + 1);
        }
        return null;
    }

    public static String normalizePathQuery(String pathQuery) {
        int i;
        if (pathQuery == null || pathQuery.isEmpty()) {
            return pathQuery;
        }
        boolean slash = true;
        int end = pathQuery.length();
        block10: for (i = 0; i < end; ++i) {
            char c = pathQuery.charAt(i);
            switch (c) {
                case '/': {
                    slash = true;
                    continue block10;
                }
                case '.': {
                    if (slash) break block10;
                    slash = false;
                    continue block10;
                }
                case '#': 
                case '?': {
                    return pathQuery;
                }
                default: {
                    slash = false;
                }
            }
        }
        if (i == end) {
            return pathQuery;
        }
        StringBuilder canonical = new StringBuilder(pathQuery.length());
        canonical.append(pathQuery, 0, i);
        int dots = 1;
        ++i;
        block11: while (i < end) {
            char c = pathQuery.charAt(i);
            switch (c) {
                case '/': {
                    if (URIUtil.doDotsSlash(canonical, dots)) {
                        return null;
                    }
                    slash = true;
                    dots = 0;
                    break;
                }
                case '#': 
                case '?': {
                    break block11;
                }
                case '.': {
                    if (dots > 0) {
                        ++dots;
                    } else if (slash) {
                        dots = 1;
                    } else {
                        canonical.append('.');
                    }
                    slash = false;
                    break;
                }
                default: {
                    while (dots-- > 0) {
                        canonical.append('.');
                    }
                    canonical.append(c);
                    dots = 0;
                    slash = false;
                }
            }
            ++i;
        }
        if (URIUtil.doDots(canonical, dots)) {
            return null;
        }
        if (i < end) {
            canonical.append(pathQuery, i, end);
        }
        return canonical.toString();
    }

    public static boolean isNotNormalWithinSelf(String path) {
        return URIUtil.normalizePath(path) == null;
    }

    public static String normalizePath(String path) {
        int i;
        if (path == null || path.isEmpty()) {
            return path;
        }
        boolean slash = true;
        int end = path.length();
        block8: for (i = 0; i < end; ++i) {
            char c = path.charAt(i);
            switch (c) {
                case '/': {
                    slash = true;
                    continue block8;
                }
                case '.': {
                    if (slash) break block8;
                    slash = false;
                    continue block8;
                }
                default: {
                    slash = false;
                }
            }
        }
        if (i == end) {
            return path;
        }
        StringBuilder canonical = new StringBuilder(path.length());
        canonical.append(path, 0, i);
        int dots = 1;
        ++i;
        while (i < end) {
            char c = path.charAt(i);
            switch (c) {
                case '/': {
                    if (URIUtil.doDotsSlash(canonical, dots)) {
                        return null;
                    }
                    slash = true;
                    dots = 0;
                    break;
                }
                case '.': {
                    if (dots > 0) {
                        ++dots;
                    } else if (slash) {
                        dots = 1;
                    } else {
                        canonical.append('.');
                    }
                    slash = false;
                    break;
                }
                default: {
                    while (dots-- > 0) {
                        canonical.append('.');
                    }
                    canonical.append(c);
                    dots = 0;
                    slash = false;
                }
            }
            ++i;
        }
        if (URIUtil.doDots(canonical, dots)) {
            return null;
        }
        return canonical.toString();
    }

    private static boolean doDots(StringBuilder canonical, int dots) {
        switch (dots) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                if (canonical.length() < 2) {
                    return true;
                }
                canonical.setLength(canonical.length() - 1);
                canonical.setLength(canonical.lastIndexOf(SLASH) + 1);
                break;
            }
            default: {
                while (dots-- > 0) {
                    canonical.append('.');
                }
                break block0;
            }
        }
        return false;
    }

    private static boolean doDotsSlash(StringBuilder canonical, int dots) {
        switch (dots) {
            case 0: {
                canonical.append('/');
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                if (canonical.length() < 2) {
                    return true;
                }
                canonical.setLength(canonical.length() - 1);
                canonical.setLength(canonical.lastIndexOf(SLASH) + 1);
                break;
            }
            default: {
                while (dots-- > 0) {
                    canonical.append('.');
                }
                canonical.append('/');
            }
        }
        return false;
    }

    public static String compactPath(String path) {
        int i;
        if (path == null || path.length() == 0) {
            return path;
        }
        int state = 0;
        int end = path.length();
        block8: for (i = 0; i < end; ++i) {
            char c = path.charAt(i);
            switch (c) {
                case '?': {
                    return path;
                }
                case '/': {
                    if (++state != 2) continue block8;
                    break block8;
                }
                default: {
                    state = 0;
                }
            }
        }
        if (state < 2) {
            return path;
        }
        StringBuilder buf = new StringBuilder(path.length());
        buf.append(path, 0, i);
        block9: while (i < end) {
            char c = path.charAt(i);
            switch (c) {
                case '?': {
                    buf.append(path, i, end);
                    break block9;
                }
                case '/': {
                    if (state++ != 0) break;
                    buf.append(c);
                    break;
                }
                default: {
                    state = 0;
                    buf.append(c);
                }
            }
            ++i;
        }
        return buf.toString();
    }

    public static boolean hasScheme(String uri) {
        for (int i = 0; i < uri.length(); ++i) {
            char c = uri.charAt(i);
            if (c == ':') {
                return true;
            }
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || i > 0 && (c >= '0' && c <= '9' || c == '.' || c == '+' || c == '-'))) break;
        }
        return false;
    }

    public static String newURI(String scheme, String server, int port, String path, String query) {
        StringBuilder builder = URIUtil.newURIBuilder(scheme, server, port);
        builder.append(path);
        if (query != null && query.length() > 0) {
            builder.append('?').append(query);
        }
        return builder.toString();
    }

    public static StringBuilder newURIBuilder(String scheme, String server, int port) {
        StringBuilder builder = new StringBuilder();
        URIUtil.appendSchemeHostPort(builder, scheme, server, port);
        return builder;
    }

    public static void appendSchemeHostPort(StringBuilder url, String scheme, String server, int port) {
        url.append(scheme).append("://").append(HostPort.normalizeHost(server));
        if (port > 0) {
            switch (scheme) {
                case "http": {
                    if (port == 80) break;
                    url.append(':').append(port);
                    break;
                }
                case "https": {
                    if (port == 443) break;
                    url.append(':').append(port);
                    break;
                }
                default: {
                    url.append(':').append(port);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void appendSchemeHostPort(StringBuffer url, String scheme, String server, int port) {
        StringBuffer stringBuffer = url;
        synchronized (stringBuffer) {
            url.append(scheme).append("://").append(HostPort.normalizeHost(server));
            if (port > 0) {
                switch (scheme) {
                    case "http": {
                        if (port == 80) break;
                        url.append(':').append(port);
                        break;
                    }
                    case "https": {
                        if (port == 443) break;
                        url.append(':').append(port);
                        break;
                    }
                    default: {
                        url.append(':').append(port);
                    }
                }
            }
        }
    }

    static boolean equalsIgnoreEncodings(String uriA, String uriB) {
        try {
            String safeDecodedUriA = URIUtil.ensureSafeEncoding(uriA);
            String safeDecodedUriB = URIUtil.ensureSafeEncoding(uriB);
            return safeDecodedUriA.equals(safeDecodedUriB);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    static String ensureSafeEncoding(String path) {
        if (path == null) {
            return null;
        }
        if ("".equals(path) || SLASH.equals(path)) {
            return path;
        }
        int offset = 0;
        int length = path.length();
        try {
            Utf8StringBuilder builder = null;
            int end = offset + length;
            for (int i = offset; i < end; ++i) {
                char c = path.charAt(i);
                if (c == '%') {
                    if (builder == null) {
                        builder = new Utf8StringBuilder(path.length());
                        builder.append(path, offset, i - offset);
                    }
                    if (i + 2 < end) {
                        char u = path.charAt(i + 1);
                        if (u == 'u') {
                            if (TypeUtil.isHex(path, i + 2, 4)) {
                                int codepoint = 0xFFFF & TypeUtil.parseInt(path, i + 2, 4, 16);
                                URIUtil.encodeCodepoint(codepoint, builder);
                                i += 5;
                                continue;
                            }
                            builder.append("%25");
                            continue;
                        }
                        if (TypeUtil.isHex(path, i + 1, 2)) {
                            byte b = (byte)(0xFF & TypeUtil.convertHexDigit(u) * 16 + TypeUtil.convertHexDigit(path.charAt(i + 2)));
                            if (URIUtil.mustBeEncoded(b) || b == 47) {
                                URIUtil.encodeCodepoint(b, builder);
                            } else {
                                builder.append(b);
                            }
                            i += 2;
                            continue;
                        }
                        builder.append("%25");
                        continue;
                    }
                    builder.append("%25");
                    continue;
                }
                if (URIUtil.mustBeEncoded(c)) {
                    if (builder == null) {
                        builder = new Utf8StringBuilder(path.length());
                        builder.append(path, offset, i - offset);
                    }
                    URIUtil.encodeCodepoint(c, builder);
                    continue;
                }
                if (builder == null) continue;
                builder.append(c);
            }
            if (builder != null) {
                return builder.toString();
            }
            return path;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("cannot decode URI", e);
        }
    }

    private static boolean mustBeEncoded(int codepoint) {
        if (codepoint > 127) {
            return true;
        }
        if (codepoint <= 31 || codepoint == 127) {
            return true;
        }
        if (codepoint == 34 || codepoint == 60 || codepoint == 62 || codepoint == 37 || codepoint == 123 || codepoint == 125 || codepoint == 124 || codepoint == 92 || codepoint == 94 || codepoint == 96) {
            return true;
        }
        if (codepoint == 32 || codepoint == 91 || codepoint == 93) {
            return true;
        }
        return codepoint == 63 || codepoint == 35;
    }

    public static boolean equalsIgnoreEncodings(URI uriA, URI uriB) {
        if (uriA.equals(uriB)) {
            return true;
        }
        if (uriA.toASCIIString().equals(uriB.toASCIIString())) {
            return true;
        }
        if (uriA.getScheme() == null ? uriB.getScheme() != null : !uriA.getScheme().equalsIgnoreCase(uriB.getScheme())) {
            return false;
        }
        if ("jar".equalsIgnoreCase(uriA.getScheme())) {
            URI uriAssp = URI.create(uriA.getRawSchemeSpecificPart());
            URI uriBssp = URI.create(uriB.getRawSchemeSpecificPart());
            return URIUtil.equalsIgnoreEncodings(uriAssp, uriBssp);
        }
        if (uriA.getAuthority() == null ? uriB.getAuthority() != null : !uriA.getAuthority().equals(uriB.getAuthority())) {
            return false;
        }
        return URIUtil.equalsIgnoreEncodings(uriA.getRawPath(), uriB.getRawPath());
    }

    public static URI addPath(URI uri, String path) {
        Objects.requireNonNull(uri, "URI");
        if (path == null || "".equals(path)) {
            return uri;
        }
        int pathLen = (path = URIUtil.compactPath(path)).length();
        if (pathLen == 0) {
            return uri;
        }
        String base = URIUtil.correctFileURI(uri).toASCIIString();
        path = URIUtil.ensureSafeEncoding(path);
        pathLen = path.length();
        if (base.length() == 0) {
            return URI.create(path);
        }
        StringBuilder buf = new StringBuilder(base.length() + pathLen * 3);
        buf.append(base);
        if (buf.charAt(base.length() - 1) != '/') {
            buf.append('/');
        }
        int offset = path.charAt(0) == '/' ? 1 : 0;
        buf.append(path, offset, pathLen);
        return URI.create(buf.toString());
    }

    public static String addQueries(String query1, String query2) {
        if (StringUtil.isEmpty(query1)) {
            return query2;
        }
        if (StringUtil.isEmpty(query2)) {
            return query1;
        }
        return query1 + "&" + query2;
    }

    public static URI correctFileURI(URI uri) {
        if (uri == null || uri.getScheme() == null) {
            return uri;
        }
        if (!uri.getScheme().equalsIgnoreCase("file") && !uri.getScheme().equalsIgnoreCase("jar")) {
            return uri;
        }
        if (uri.getRawAuthority() != null) {
            return uri;
        }
        if (!uri.isAbsolute()) {
            return uri;
        }
        String rawURI = uri.toASCIIString();
        int colon = rawURI.indexOf(":/");
        if (colon < 0) {
            return uri;
        }
        int end = -1;
        if (rawURI.charAt(colon + 2) != '/') {
            end = colon + 2;
        }
        if (end >= 0) {
            return URI.create(rawURI.substring(0, colon) + ":///" + rawURI.substring(end));
        }
        return uri;
    }

    public static List<URI> split(String str) {
        ArrayList<URI> uris = new ArrayList<URI>();
        StringTokenizer tokenizer = new StringTokenizer(str, ",;|");
        while (tokenizer.hasMoreTokens()) {
            String reference = tokenizer.nextToken();
            try {
                if (reference.endsWith("/*") || reference.endsWith("\\*")) {
                    String dir = reference.substring(0, reference.length() - 2);
                    Path pathDir = Paths.get(dir, new String[0]);
                    if (!Files.exists(pathDir, new LinkOption[0]) || !Files.isDirectory(pathDir, new LinkOption[0])) continue;
                    try {
                        Stream<Path> listStream = Files.list(pathDir);
                        try {
                            listStream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(FileID::isLibArchive).sorted(Comparator.naturalOrder()).forEach(path -> uris.add(URIUtil.toJarFileUri(path.toUri())));
                            continue;
                        }
                        finally {
                            if (listStream == null) continue;
                            listStream.close();
                            continue;
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Unable to process directory glob listing: " + reference, e);
                    }
                }
                URI refUri = URIUtil.toURI(reference);
                uris.add(URIUtil.toJarFileUri(refUri));
            }
            catch (Exception e) {
                LOG.warn("Invalid Resource Reference: " + reference);
                throw e;
            }
        }
        return uris;
    }

    public static URI toJarFileUri(URI uri) {
        boolean hasInternalReference;
        Objects.requireNonNull(uri, "URI");
        String scheme = Objects.requireNonNull(uri.getScheme(), "URI scheme");
        if (!FileID.isArchive(uri)) {
            return uri;
        }
        boolean bl = hasInternalReference = uri.getRawSchemeSpecificPart().indexOf("!/") > 0;
        if (scheme.equalsIgnoreCase("jar")) {
            if (uri.getRawSchemeSpecificPart().startsWith("file:")) {
                if (hasInternalReference) {
                    return uri;
                }
                return URI.create(uri.toASCIIString() + "!/");
            }
        } else if (scheme.equalsIgnoreCase("file")) {
            String rawUri = uri.toASCIIString();
            if (hasInternalReference) {
                return URI.create("jar:" + rawUri);
            }
            return URI.create("jar:" + rawUri + "!/");
        }
        throw new IllegalArgumentException("Cannot make %s into `jar:file:` URI".formatted(uri));
    }

    public static URI toURI(String resource) {
        Objects.requireNonNull(resource);
        return KNOWN_SCHEMES.getBest(resource) != null ? URIUtil.correctFileURI(URI.create(resource)) : Paths.get(resource, new String[0]).toUri();
    }

    public static URI unwrapContainer(URI uri) {
        Objects.requireNonNull(uri);
        String scheme = uri.getScheme();
        if (scheme == null || !scheme.equalsIgnoreCase("jar")) {
            return uri;
        }
        String spec = uri.getRawSchemeSpecificPart();
        int sep = spec.indexOf("!/");
        if (sep != -1) {
            spec = spec.substring(0, sep);
        }
        return URI.create(spec);
    }

    public static URI uriJarPrefix(URI uri, String encodedSuffix) {
        if (uri == null) {
            throw new IllegalArgumentException("URI must not be null");
        }
        if (encodedSuffix == null) {
            throw new IllegalArgumentException("Encoded Suffix must not be null");
        }
        if (!encodedSuffix.startsWith("!/")) {
            throw new IllegalArgumentException("Suffix must start with \"!/\"");
        }
        String uriString = uri.toASCIIString();
        int bangSlash = uriString.indexOf("!/");
        if (bangSlash >= 0) {
            uriString = uriString.substring(0, bangSlash);
        }
        if (uri.getScheme().equalsIgnoreCase("jar")) {
            return URI.create(uriString + encodedSuffix);
        }
        if (uri.getScheme().equalsIgnoreCase("file")) {
            return URI.create("jar:" + uriString + encodedSuffix);
        }
        throw new IllegalArgumentException("Unsupported URI scheme: " + uri);
    }

    public static Stream<URI> streamOf(URLClassLoader urlClassLoader) {
        URL[] urls = urlClassLoader.getURLs();
        return Stream.of(urls).filter(Objects::nonNull).map(URL::toString).map(URI::create).map(URIUtil::unwrapContainer).map(URIUtil::correctFileURI);
    }
}

