/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.resource;

import java.io.IOException;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jetty.util.Index;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathResource
extends Resource {
    private static final Logger LOG = LoggerFactory.getLogger(PathResource.class);
    public static Index<String> ALLOWED_SCHEMES = new Index.Builder().caseSensitive(false).with("file").with("jrt").build();
    private final Path path;
    private final URI uri;
    private boolean targetResolved = false;
    private Path targetPath;

    public static boolean isSameName(Path pathA, Path pathB) {
        int bCount;
        int aCount = pathA.getNameCount();
        if (aCount != (bCount = pathB.getNameCount())) {
            return false;
        }
        int i = bCount;
        while (i-- > 0) {
            if (pathA.getName(i).toString().equals(pathB.getName(i).toString())) continue;
            return false;
        }
        return true;
    }

    PathResource(URI uri) {
        this(uri, false);
    }

    PathResource(URI uri, boolean bypassAllowedSchemeCheck) {
        this(Paths.get(uri.normalize()), uri, bypassAllowedSchemeCheck);
    }

    PathResource(Path path) {
        this(path, path.toUri(), true);
    }

    PathResource(Path path, URI uri, boolean bypassAllowedSchemeCheck) {
        if (!uri.isAbsolute()) {
            throw new IllegalArgumentException("not an absolute uri: " + uri);
        }
        if (!bypassAllowedSchemeCheck && !ALLOWED_SCHEMES.contains(uri.getScheme())) {
            throw new IllegalArgumentException("not an allowed scheme: " + uri);
        }
        String uriString = uri.toASCIIString();
        if (Files.isDirectory(path, new LinkOption[0]) && !uriString.endsWith("/")) {
            uri = URIUtil.correctFileURI(URI.create(uriString + "/"));
        }
        this.path = path;
        this.uri = uri;
    }

    @Override
    public boolean exists() {
        return Files.exists(this.targetPath != null ? this.targetPath : this.path, new LinkOption[0]);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PathResource other = (PathResource)obj;
        return Objects.equals(this.path, other.path);
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    @Override
    public List<Resource> list() {
        block11: {
            List list;
            block10: {
                if (!this.isDirectory()) {
                    return List.of();
                }
                Stream<Path> dirStream = Files.list(this.getPath());
                try {
                    list = dirStream.map(PathResource::new).collect(Collectors.toCollection(ArrayList::new));
                    if (dirStream == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (dirStream != null) {
                            try {
                                dirStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (DirectoryIteratorException e) {
                        LOG.debug("Directory list failure", (Throwable)e);
                        break block11;
                    }
                    catch (IOException e) {
                        LOG.debug("Directory list access failure", (Throwable)e);
                    }
                }
                dirStream.close();
            }
            return list;
        }
        return List.of();
    }

    @Override
    public String getName() {
        return this.path.toAbsolutePath().toString();
    }

    @Override
    public String getFileName() {
        Path fn = this.path.getFileName();
        if (fn == null) {
            return "";
        }
        return fn.toString();
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    public int hashCode() {
        return Objects.hashCode(this.path);
    }

    @Override
    public boolean isContainedIn(Resource r) {
        if (r == null) {
            return false;
        }
        return r.getClass() == PathResource.class && this.path.startsWith(r.getPath());
    }

    @Override
    public URI getTargetURI() {
        if (!this.targetResolved) {
            this.targetPath = this.resolveTargetPath();
            this.targetResolved = true;
        }
        if (this.targetPath == null) {
            return null;
        }
        return this.targetPath.toUri();
    }

    private Path resolveTargetPath() {
        Path normal;
        Path abs = this.path;
        if (!Files.exists(this.path, new LinkOption[0])) {
            return null;
        }
        if (!URIUtil.equalsIgnoreEncodings(this.uri, PathResource.toUri(this.path))) {
            try {
                Path ref = Paths.get(this.uri.normalize());
                return ref.toRealPath(new LinkOption[0]);
            }
            catch (IOException ioe) {
                LOG.trace("IGNORED", (Throwable)ioe);
            }
        }
        if (!abs.isAbsolute()) {
            abs = this.path.toAbsolutePath();
        }
        if (!PathResource.isSameName(abs, normal = this.path.normalize())) {
            return normal;
        }
        try {
            Path real;
            if (Files.isSymbolicLink(this.path)) {
                return this.path.getParent().resolve(Files.readSymbolicLink(this.path));
            }
            if (Files.exists(this.path, new LinkOption[0]) && !PathResource.isSameName(abs, real = abs.toRealPath(new LinkOption[0]))) {
                return real;
            }
        }
        catch (IOException e) {
            LOG.trace("IGNORED", (Throwable)e);
        }
        catch (Exception e) {
            LOG.warn("bad alias ({} {}) for {}", new Object[]{e.getClass().getName(), e.getMessage(), this.path});
        }
        return null;
    }

    @Override
    public void copyTo(Path destination) throws IOException {
        if (this.isDirectory()) {
            Files.walkFileTree(this.path, new TreeCopyFileVisitor(this.path, destination));
        } else {
            Files.copy(this.path, destination, new CopyOption[0]);
        }
    }

    private static URI toUri(Path path) {
        URI pathUri = path.toUri();
        String rawUri = path.toUri().toASCIIString();
        if (Files.isDirectory(path, new LinkOption[0]) && !rawUri.endsWith("/")) {
            return URI.create(rawUri + "/");
        }
        return pathUri;
    }

    public String toString() {
        return this.uri.toASCIIString();
    }

    private static class TreeCopyFileVisitor
    extends SimpleFileVisitor<Path> {
        private final String relativeTo;
        private final Path target;

        public TreeCopyFileVisitor(Path relativeTo, Path target) {
            this.relativeTo = relativeTo.getRoot().relativize(relativeTo).toString();
            this.target = target;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            Path resolvedTarget = this.target.resolve(dir.getRoot().resolve(this.relativeTo).relativize(dir).toString());
            if (Files.notExists(resolvedTarget, new LinkOption[0])) {
                Files.createDirectories(resolvedTarget, new FileAttribute[0]);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Path resolvedTarget = this.target.resolve(file.getRoot().resolve(this.relativeTo).relativize(file).toString());
            Files.copy(file, resolvedTarget, StandardCopyOption.REPLACE_EXISTING);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) {
            return FileVisitResult.CONTINUE;
        }
    }
}

