/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.resource;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.resource.Resource;

public class ResourceCollection
extends Resource {
    private final List<Resource> _resources;

    ResourceCollection(List<Resource> resources) {
        ArrayList<Resource> res = new ArrayList<Resource>();
        ResourceCollection.gatherUniqueFlatResourceList(res, resources);
        this._resources = Collections.unmodifiableList(res);
    }

    private static void gatherUniqueFlatResourceList(List<Resource> unique, List<Resource> resources) {
        if (resources == null || resources.isEmpty()) {
            throw new IllegalArgumentException("Empty Resource collection");
        }
        for (Resource r : resources) {
            if (r == null) {
                throw new IllegalArgumentException("Null Resource entry encountered");
            }
            if (r instanceof ResourceCollection) {
                ResourceCollection resourceCollection = (ResourceCollection)r;
                ResourceCollection.gatherUniqueFlatResourceList(unique, resourceCollection.getResources());
                continue;
            }
            if (unique.contains(r)) continue;
            if (!r.exists()) {
                throw new IllegalArgumentException("Does not exist: " + r);
            }
            if (!r.isDirectory()) {
                throw new IllegalArgumentException("Non-Directory not allowed: " + r);
            }
            unique.add(r);
        }
    }

    public List<Resource> getResources() {
        return this._resources;
    }

    @Override
    public Resource resolve(String subUriPath) {
        if (URIUtil.isNotNormalWithinSelf(subUriPath)) {
            throw new IllegalArgumentException(subUriPath);
        }
        if (subUriPath.length() == 0 || "/".equals(subUriPath)) {
            return this;
        }
        ArrayList<Resource> resources = null;
        Resource addedResource = null;
        for (Resource res : this._resources) {
            addedResource = res.resolve(subUriPath);
            if (!addedResource.exists()) continue;
            if (!addedResource.isDirectory()) {
                return addedResource;
            }
            if (resources == null) {
                resources = new ArrayList<Resource>();
            }
            resources.add(addedResource);
        }
        if (resources == null) {
            return addedResource;
        }
        if (resources.size() == 1) {
            return (Resource)resources.get(0);
        }
        return new ResourceCollection((List<Resource>)resources);
    }

    @Override
    public boolean exists() {
        for (Resource r : this._resources) {
            if (!r.exists()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Path getPath() {
        for (Resource r : this._resources) {
            Path p = r.getPath();
            if (p == null) continue;
            return p;
        }
        return null;
    }

    @Override
    public InputStream newInputStream() throws IOException {
        for (Resource r : this._resources) {
            InputStream is;
            if (!r.exists() || (is = r.newInputStream()) == null) continue;
            return is;
        }
        throw new FileNotFoundException("Resource does not exist");
    }

    @Override
    public ReadableByteChannel newReadableByteChannel() throws IOException {
        for (Resource r : this._resources) {
            ReadableByteChannel channel = r.newReadableByteChannel();
            if (channel == null) continue;
            return channel;
        }
        return null;
    }

    @Override
    public String getName() {
        for (Resource r : this._resources) {
            String name = r.getName();
            if (name == null) continue;
            return name;
        }
        return null;
    }

    @Override
    public String getFileName() {
        for (Resource r : this._resources) {
            String filename = r.getFileName();
            if (filename == null) continue;
            return filename;
        }
        return null;
    }

    @Override
    public URI getURI() {
        for (Resource r : this._resources) {
            URI uri = r.getURI();
            if (uri == null) continue;
            return uri;
        }
        return null;
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    @Override
    public Instant lastModified() {
        Instant instant = null;
        for (Resource r : this._resources) {
            Instant lm = r.lastModified();
            if (instant != null && !lm.isAfter(instant)) continue;
            instant = lm;
        }
        return instant;
    }

    @Override
    public long length() {
        return -1L;
    }

    @Override
    public Iterator<Resource> iterator() {
        return this._resources.iterator();
    }

    @Override
    public List<Resource> list() {
        ArrayList<Resource> result = new ArrayList<Resource>();
        for (Resource r : this._resources) {
            if (r.isDirectory()) {
                result.addAll(r.list());
                continue;
            }
            result.add(r);
        }
        return result;
    }

    @Override
    public void copyTo(Path destination) throws IOException {
        int r = this._resources.size();
        while (r-- > 0) {
            this._resources.get(r).copyTo(destination);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceCollection other = (ResourceCollection)o;
        return Objects.equals(this._resources, other._resources);
    }

    public int hashCode() {
        return Objects.hash(this._resources);
    }

    public String toString() {
        return this._resources.stream().map(Resource::getName).collect(Collectors.joining(", ", "[", "]"));
    }

    @Override
    public boolean isContainedIn(Resource r) {
        return false;
    }
}

