/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.thread;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.util.thread.Invocable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializedInvoker {
    private static final Logger LOG = LoggerFactory.getLogger(SerializedInvoker.class);
    private final AtomicReference<Link> _tail = new AtomicReference();

    public Runnable offer(Runnable task) {
        if (task == null) {
            return null;
        }
        Link link = new Link(task);
        Link penultimate = this._tail.getAndSet(link);
        if (penultimate == null) {
            return link;
        }
        penultimate._next.lazySet(link);
        return null;
    }

    public Runnable offer(Runnable ... tasks) {
        Runnable runnable = null;
        for (Runnable task : tasks) {
            if (runnable == null) {
                runnable = this.offer(task);
                continue;
            }
            this.offer(task);
        }
        return runnable;
    }

    public void run(Runnable task) {
        Runnable todo = this.offer(task);
        if (todo != null) {
            todo.run();
        }
    }

    public void run(Runnable ... tasks) {
        Runnable todo = this.offer(tasks);
        if (todo != null) {
            todo.run();
        }
    }

    protected void onError(Runnable task, Throwable t) {
        LOG.warn("Serialized invocation error", t);
    }

    private class Link
    implements Runnable,
    Invocable {
        private final Runnable _task;
        private final AtomicReference<Link> _next = new AtomicReference();

        public Link(Runnable task) {
            this._task = task;
        }

        @Override
        public Invocable.InvocationType getInvocationType() {
            return Invocable.InvocationType.BLOCKING;
        }

        Link next() {
            if (SerializedInvoker.this._tail.compareAndSet(this, null)) {
                return null;
            }
            Link next;
            while ((next = this._next.get()) == null) {
                Thread.onSpinWait();
            }
            return next;
        }

        @Override
        public void run() {
            for (Link link = this; link != null; link = link.next()) {
                try {
                    link._task.run();
                    continue;
                }
                catch (Throwable t) {
                    SerializedInvoker.this.onError(link._task, t);
                }
            }
        }
    }
}

