/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Locale;

public class FileID {
    public static String getBasename(Path path) {
        Path filename = path.getFileName();
        if (filename == null) {
            return "";
        }
        String basename = filename.toString();
        int dot = basename.lastIndexOf(46);
        if (dot >= 0) {
            basename = basename.substring(0, dot);
        }
        return basename;
    }

    public static String getFileName(URI uri) {
        if (uri == null) {
            return "";
        }
        String path = uri.getPath();
        if (path == null || "/".equals(path)) {
            return "";
        }
        int idx = path.lastIndexOf(47);
        if (idx >= 0) {
            return path.substring(idx + 1);
        }
        return path;
    }

    public static String getExtension(URI uri) {
        if (uri == null) {
            return null;
        }
        if (uri.getScheme() == null) {
            return null;
        }
        String path = null;
        if (uri.getScheme().equalsIgnoreCase("jar")) {
            URI sspUri = URI.create(uri.getRawSchemeSpecificPart());
            if (!sspUri.getScheme().equalsIgnoreCase("file")) {
                return null;
            }
            path = sspUri.getPath();
        } else {
            path = uri.getPath();
        }
        int jarEnd = path.indexOf("!/");
        if (jarEnd >= 0) {
            return FileID.getExtension(path.substring(0, jarEnd));
        }
        return FileID.getExtension(path);
    }

    public static String getExtension(Path path) {
        if (path == null) {
            return null;
        }
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            return null;
        }
        return FileID.getExtension(path.getFileName().toString());
    }

    public static String getExtension(String filename) {
        int lastDot;
        if (filename == null) {
            return null;
        }
        if (filename.endsWith("/") || filename.endsWith("\\")) {
            return null;
        }
        int lastSlash = filename.lastIndexOf(File.separator);
        if (lastSlash >= 0) {
            filename = filename.substring(lastSlash + 1);
        }
        if ((lastDot = filename.lastIndexOf(46)) <= 0) {
            return null;
        }
        return filename.substring(lastDot + 1).toLowerCase(Locale.ENGLISH);
    }

    public static boolean isExtension(Path path, String ... extensions) {
        return FileID.matchesExtension(FileID.getExtension(path), extensions);
    }

    public static boolean isExtension(URI uri, String ... extensions) {
        return FileID.matchesExtension(FileID.getExtension(uri), extensions);
    }

    public static boolean isExtension(String filename, String ... extensions) {
        return FileID.matchesExtension(FileID.getExtension(filename), extensions);
    }

    private static boolean matchesExtension(String ext, String ... extensions) {
        if (ext == null) {
            return false;
        }
        for (String extension : extensions) {
            if (!ext.equals(extension)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasNamedPathSegment(Path path, String segmentName) {
        if (path == null) {
            return false;
        }
        int segmentCount = path.getNameCount();
        for (int i = segmentCount - 1; i >= 0; --i) {
            Path segment = path.getName(i);
            if (!segment.getFileName().toString().equalsIgnoreCase(segmentName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isArchive(Path path) {
        return FileID.isExtension(path, "jar", "war", "zip");
    }

    public static boolean isArchive(String filename) {
        return FileID.isExtension(filename, "jar", "war", "zip");
    }

    public static boolean isArchive(URI uri) {
        return FileID.isExtension(uri, "jar", "war", "zip");
    }

    public static boolean isLibArchive(Path path) {
        return FileID.isExtension(path, "jar", "zip");
    }

    public static boolean isLibArchive(String filename) {
        return FileID.isExtension(filename, "jar", "zip");
    }

    public static boolean isLibArchive(URI uri) {
        return FileID.isExtension(uri, "jar", "zip");
    }

    public static boolean isClassFile(Path path) {
        String filename = path.getFileName().toString();
        if (!filename.toLowerCase(Locale.ENGLISH).endsWith(".class")) {
            return false;
        }
        int start = 0;
        int end = filename.length() - 6;
        if (end <= start) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(filename.charAt(0))) {
            return false;
        }
        for (int i = start + 1; i < end; ++i) {
            if (Character.isJavaIdentifierPart(filename.codePointAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isHidden(Path base, Path path) {
        Path relative = base.relativize(path);
        int count = relative.getNameCount();
        for (int i = 0; i < count; ++i) {
            Path segment = relative.getName(i);
            String segmentName = segment.toString();
            if (segmentName.isBlank()) continue;
            if (segmentName.charAt(0) == '.') {
                return true;
            }
            try {
                if (!Files.isHidden(segment)) continue;
                return true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isJavaArchive(URI uri) {
        return FileID.isExtension(uri, "jar");
    }

    public static boolean isJavaArchive(Path path) {
        return FileID.isExtension(path, "jar");
    }

    public static boolean isJavaArchive(String filename) {
        return FileID.isExtension(filename, "jar");
    }

    public static boolean isMetaInfVersions(Path path) {
        if (path.getNameCount() < 3) {
            return false;
        }
        Path path0 = path.getName(0);
        Path path1 = path.getName(1);
        Path path2 = path.getName(2);
        return path0.toString().equals("META-INF") && path1.toString().equals("versions") && path2.getFileName().toString().matches("[0-9]+");
    }

    public static boolean isNotMetaInfVersions(Path path) {
        return !FileID.isMetaInfVersions(path);
    }

    public static boolean isNotModuleInfoClass(Path path) {
        Path filenameSegment = path.getFileName();
        if (filenameSegment == null) {
            return true;
        }
        return !filenameSegment.toString().equalsIgnoreCase("module-info.class");
    }

    public static boolean isTld(Path path) {
        if (path == null) {
            return false;
        }
        if (!FileID.hasNamedPathSegment(path, "META-INF")) {
            return false;
        }
        return FileID.isExtension(path, "tld");
    }

    public static boolean isWebArchive(Path path) {
        return FileID.isExtension(path, "war");
    }

    public static boolean isWebArchive(URI uri) {
        return FileID.isExtension(uri, "war");
    }

    public static boolean isWebArchive(String filename) {
        return FileID.isExtension(filename, "war");
    }

    public static boolean isXml(Path path) {
        return FileID.isExtension(path, "xml");
    }

    public static boolean isXml(String filename) {
        return FileID.isExtension(filename, "xml");
    }
}

