/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.resource;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Path;
import java.time.Instant;
import org.eclipse.jetty.util.FileID;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;

public class URLResourceFactory
implements ResourceFactory {
    private int connectTimeout = 1000;
    private boolean useCaches = true;

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public boolean isUseCaches() {
        return this.useCaches;
    }

    public void setUseCaches(boolean useCaches) {
        this.useCaches = useCaches;
    }

    @Override
    public Resource newResource(URI uri) {
        try {
            return new URLResource(uri, this.connectTimeout, this.useCaches);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Bad URI: " + String.valueOf(uri), e);
        }
    }

    private static class URLResource
    extends Resource {
        private final URI uri;
        private final URL url;
        private final int connectTimeout;
        private final boolean useCaches;

        public URLResource(URI uri, int connectTimeout, boolean useCaches) throws MalformedURLException {
            this.uri = uri;
            this.url = uri.toURL();
            this.connectTimeout = connectTimeout;
            this.useCaches = useCaches;
        }

        private URLConnection newConnection() throws IOException {
            URLConnection urlConnection = this.url.openConnection();
            urlConnection.setUseCaches(this.useCaches);
            urlConnection.setConnectTimeout(this.connectTimeout);
            return urlConnection;
        }

        @Override
        public Path getPath() {
            return null;
        }

        @Override
        public boolean isContainedIn(Resource r) {
            return false;
        }

        @Override
        public boolean isDirectory() {
            return this.uri.getPath().endsWith("/");
        }

        @Override
        public boolean isReadable() {
            return this.exists();
        }

        @Override
        public URI getURI() {
            return this.uri;
        }

        @Override
        public String getName() {
            return this.uri.toASCIIString();
        }

        @Override
        public String getFileName() {
            return FileID.getFileName(this.uri);
        }

        @Override
        public Resource resolve(String subUriPath) {
            URI newURI = this.uri.resolve(subUriPath);
            try {
                return new URLResource(newURI, this.connectTimeout, this.useCaches);
            }
            catch (MalformedURLException e) {
                return null;
            }
        }

        @Override
        public boolean exists() {
            try {
                this.newConnection();
                return true;
            }
            catch (IOException e) {
                return false;
            }
        }

        @Override
        public InputStream newInputStream() throws IOException {
            URLConnection urlConnection = this.newConnection();
            return urlConnection.getInputStream();
        }

        @Override
        public Instant lastModified() {
            try {
                URLConnection urlConnection = this.newConnection();
                return Instant.ofEpochMilli(urlConnection.getLastModified());
            }
            catch (IOException e) {
                return Instant.EPOCH;
            }
        }

        @Override
        public long length() {
            try {
                URLConnection urlConnection = this.newConnection();
                return urlConnection.getContentLengthLong();
            }
            catch (IOException e) {
                return -1L;
            }
        }

        @Override
        public ReadableByteChannel newReadableByteChannel() {
            return null;
        }

        @Override
        public boolean isAlias() {
            return false;
        }

        @Override
        public URI getRealURI() {
            return this.getURI();
        }

        public String toString() {
            return String.format("URLResource@%X(%s)", this.uri.hashCode(), this.uri.toASCIIString());
        }
    }
}

