/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.jetty.util.thread.Invocable;

public class ExceptionUtil {
    public static <T extends Throwable> T as(Class<T> type, Throwable throwable) throws IllegalArgumentException {
        if (throwable == null) {
            return null;
        }
        if (type.isInstance(throwable)) {
            Throwable t = throwable;
            return (T)t;
        }
        try {
            Constructor<T> constructor = type.getConstructor(Throwable.class);
            return (T)((Throwable)constructor.newInstance(throwable));
        }
        catch (Exception e) {
            IllegalArgumentException iae = new IllegalArgumentException(e);
            if (ExceptionUtil.areNotAssociated(iae, throwable)) {
                iae.addSuppressed(throwable);
            }
            throw iae;
        }
        catch (Throwable t) {
            if (ExceptionUtil.areNotAssociated(t, throwable)) {
                t.addSuppressed(throwable);
            }
            throw t;
        }
    }

    public static void ifExceptionThrow(Throwable throwable) throws Error, Exception {
        if (throwable == null) {
            return;
        }
        if (throwable instanceof Error) {
            Error error = (Error)throwable;
            throw error;
        }
        if (throwable instanceof Exception) {
            Exception exception = (Exception)throwable;
            throw exception;
        }
        throw new RuntimeException(throwable);
    }

    public static void ifExceptionThrowUnchecked(Throwable throwable) throws Error, RuntimeException {
        if (throwable == null) {
            return;
        }
        if (throwable instanceof RuntimeException) {
            RuntimeException runtimeException = (RuntimeException)throwable;
            throw runtimeException;
        }
        if (throwable instanceof Error) {
            Error error = (Error)throwable;
            throw error;
        }
        throw new RuntimeException(throwable);
    }

    public static <T extends Throwable> void ifExceptionThrowAs(Class<T> type, Throwable throwable) throws Error, RuntimeException, T, IllegalArgumentException {
        if (throwable == null) {
            return;
        }
        if (throwable instanceof Error) {
            Error error = (Error)throwable;
            throw error;
        }
        if (throwable instanceof RuntimeException) {
            RuntimeException runtimeException = (RuntimeException)throwable;
            throw runtimeException;
        }
        throw ExceptionUtil.as(type, throwable);
    }

    public static <T extends Throwable> void ifExceptionThrowAllAs(Class<T> type, Throwable throwable) throws T {
        if (throwable == null) {
            return;
        }
        throw ExceptionUtil.as(type, throwable);
    }

    public static boolean areNotAssociated(Throwable t1, Throwable t2) {
        if (t1 == null || t2 == null) {
            return false;
        }
        while (t1 != null) {
            for (Throwable two = t2; two != null; two = two.getCause()) {
                if (t1 == two) {
                    return false;
                }
                if (t1.getCause() == two) {
                    return false;
                }
                if (Arrays.asList(t1.getSuppressed()).contains(two)) {
                    return false;
                }
                if (!Arrays.asList(two.getSuppressed()).contains(t1)) continue;
                return false;
            }
            t1 = t1.getCause();
        }
        return true;
    }

    public static <T extends Throwable> T withSuppressed(T t, List<Throwable> errors) {
        if (errors != null) {
            errors.stream().filter(e -> ExceptionUtil.areNotAssociated(t, e)).forEach(t::addSuppressed);
        }
        return t;
    }

    public static Throwable combine(Throwable t1, Throwable t2) {
        if (t1 == null) {
            return t2;
        }
        if (ExceptionUtil.areNotAssociated(t1, t2)) {
            t1.addSuppressed(t2);
        }
        return t1;
    }

    private ExceptionUtil() {
    }

    public static <T> T get(CompletableFuture<T> completableFuture) {
        try {
            return completableFuture.get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    public static class MultiException {
        private Throwable _multiException;

        public void add(Throwable t) {
            this._multiException = ExceptionUtil.combine(this._multiException, t);
        }

        public void ifExceptionThrow() throws Exception {
            ExceptionUtil.ifExceptionThrow(this._multiException);
        }

        public void ifExceptionThrowRuntime() {
            ExceptionUtil.ifExceptionThrowUnchecked(this._multiException);
        }

        public <T extends Throwable> void ifExceptionThrowAs(Class<T> type) throws T {
            ExceptionUtil.ifExceptionThrowAs(type, this._multiException);
        }

        public void callAndCatch(Invocable.Callable task) {
            try {
                if (task != null) {
                    task.call();
                }
            }
            catch (Throwable t) {
                this.add(t);
            }
        }
    }
}

