/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.resource;

import java.io.IOException;
import java.net.URI;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jetty.util.Index;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathResource
extends Resource {
    private static final Logger LOG = LoggerFactory.getLogger(PathResource.class);
    public static Index<String> SUPPORTED_SCHEMES = new Index.Builder().caseSensitive(false).with("file").with("jrt").build();
    private final Path path;
    private final URI uri;
    private Boolean alias;
    private Path realPath;

    public static boolean isSameName(Path pathA, Path pathB) {
        int bCount;
        int aCount = pathA.getNameCount();
        if (aCount != (bCount = pathB.getNameCount())) {
            return false;
        }
        int i = bCount;
        while (i-- > 0) {
            if (pathA.getName(i).toString().equals(pathB.getName(i).toString())) continue;
            return false;
        }
        return true;
    }

    PathResource(URI uri) {
        this(uri, false);
    }

    PathResource(URI uri, boolean bypassAllowedSchemeCheck) {
        this(Paths.get(uri), uri, bypassAllowedSchemeCheck);
    }

    PathResource(Path path) {
        this(path, path.toUri(), true);
    }

    PathResource(Path path, URI uri, boolean bypassAllowedSchemeCheck) {
        String uriString;
        if (!uri.isAbsolute()) {
            throw new IllegalArgumentException("not an absolute uri: " + String.valueOf(uri));
        }
        if (!bypassAllowedSchemeCheck && !SUPPORTED_SCHEMES.contains(uri.getScheme())) {
            throw new IllegalArgumentException("not an allowed scheme: " + String.valueOf(uri));
        }
        if (Files.isDirectory(path, new LinkOption[0]) && !(uriString = uri.toASCIIString()).endsWith("/")) {
            uri = URIUtil.correctFileURI(URI.create(uriString + "/"));
        }
        this.path = path;
        this.uri = uri;
    }

    @Override
    public boolean exists() {
        if (this.alias == null) {
            return Files.exists(this.path, new LinkOption[0]);
        }
        if (this.realPath == null) {
            return false;
        }
        return Files.exists(this.realPath, new LinkOption[0]);
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    @Override
    public boolean contains(Resource other) {
        if (other == null) {
            return false;
        }
        Path thisPath = this.getPath();
        if (thisPath == null) {
            throw new UnsupportedOperationException("Resources without a Path must implement contains");
        }
        Path otherPath = other.getPath();
        return otherPath != null && otherPath.getFileSystem().equals(thisPath.getFileSystem()) && otherPath.startsWith(thisPath);
    }

    public Path getRealPath() {
        this.resolveAlias();
        return this.realPath;
    }

    @Override
    public URI getRealURI() {
        Path realPath = this.getRealPath();
        return realPath == null ? null : realPath.toUri();
    }

    @Override
    public List<Resource> list() {
        block11: {
            List list;
            block10: {
                if (!this.isDirectory()) {
                    return List.of();
                }
                Stream<Path> dirStream = Files.list(this.getPath());
                try {
                    list = dirStream.map(PathResource::new).collect(Collectors.toCollection(ArrayList::new));
                    if (dirStream == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (dirStream != null) {
                            try {
                                dirStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (DirectoryIteratorException e) {
                        LOG.debug("Directory list failure", (Throwable)e);
                        break block11;
                    }
                    catch (IOException e) {
                        LOG.debug("Directory list access failure", (Throwable)e);
                    }
                }
                dirStream.close();
            }
            return list;
        }
        return List.of();
    }

    @Override
    public boolean isAlias() {
        this.resolveAlias();
        return this.alias != null && this.alias != false;
    }

    @Override
    public String getName() {
        return this.path.toAbsolutePath().toString();
    }

    @Override
    public String getFileName() {
        Path fn = this.path.getFileName();
        if (fn == null) {
            return "";
        }
        return fn.toString();
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public Resource resolve(String subUriPath) {
        if (URIUtil.isNotNormalWithinSelf(subUriPath)) {
            throw new IllegalArgumentException(subUriPath);
        }
        if ("/".equals(subUriPath)) {
            return this;
        }
        URI uri = this.getURI();
        URI resolvedUri = URIUtil.addPath(uri, subUriPath);
        Path path = Paths.get(resolvedUri);
        if (Files.exists(path, new LinkOption[0])) {
            return this.newResource(path, resolvedUri);
        }
        return null;
    }

    protected Resource newResource(Path path, URI uri) {
        return new PathResource(path, uri, true);
    }

    @Override
    public boolean isDirectory() {
        return Files.isDirectory(this.getPath(), LinkOption.NOFOLLOW_LINKS);
    }

    @Override
    public boolean isReadable() {
        return Files.isReadable(this.getPath());
    }

    @Override
    public Instant lastModified() {
        Path path = this.getPath();
        if (path == null) {
            return Instant.EPOCH;
        }
        if (!Files.exists(path, new LinkOption[0])) {
            return Instant.EPOCH;
        }
        try {
            FileTime ft = Files.getLastModifiedTime(path, LinkOption.NOFOLLOW_LINKS);
            return ft.toInstant();
        }
        catch (IOException e) {
            LOG.trace("IGNORED", (Throwable)e);
            return Instant.EPOCH;
        }
    }

    @Override
    public long length() {
        try {
            return Files.size(this.getPath());
        }
        catch (IOException e) {
            return 0L;
        }
    }

    private void resolveAlias() {
        if (this.alias == null) {
            try {
                this.realPath = this.path.toRealPath(new LinkOption[0]);
            }
            catch (Exception e) {
                if (e instanceof IOException) {
                    LOG.trace("IGNORED", (Throwable)e);
                } else {
                    LOG.warn("bad alias ({} {}) for {}", new Object[]{e.getClass().getName(), e.getMessage(), this.path});
                }
                return;
            }
            this.alias = !PathResource.isSameName(this.path, this.realPath) || !Objects.equals(this.uri, this.toUri(this.realPath));
        }
    }

    protected URI toUri(Path path) {
        URI pathUri = path.toUri();
        String rawUri = pathUri.toASCIIString();
        if (Files.isDirectory(path, new LinkOption[0]) && !rawUri.endsWith("/")) {
            return URI.create(rawUri + "/");
        }
        return pathUri;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PathResource other = (PathResource)obj;
        return Objects.equals(this.path, other.path) && Objects.equals(this.uri, other.uri);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.uri);
    }

    public String toString() {
        return this.uri.toASCIIString();
    }
}

