/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.InvocableBiConsumer;
import org.eclipse.jetty.util.NoOp;
import org.eclipse.jetty.util.thread.Invocable;

public interface Promise<C> {
    default public void succeeded(C result) {
    }

    default public void failed(Throwable x) {
    }

    public static <T> Promise<T> noop() {
        return Invocable.noop();
    }

    public static <T> void completeWith(Promise<T> promise, CompletableFuture<T> completable) {
        completable.whenComplete((o, x) -> {
            if (x == null) {
                promise.succeeded(o);
            } else {
                promise.failed((Throwable)x);
            }
        });
    }

    public static <T> Promise<T> from(final Consumer<T> success, final Consumer<Throwable> failure) {
        return new Promise<T>(){

            @Override
            public void succeeded(T result) {
                success.accept(result);
            }

            @Override
            public void failed(Throwable x) {
                failure.accept(x);
            }
        };
    }

    public static <T> Promise<T> from(final CompletableFuture<? super T> completable) {
        if (completable instanceof Promise) {
            return (Promise)((Object)completable);
        }
        return new Promise<T>(){

            @Override
            public void succeeded(T result) {
                completable.complete(result);
            }

            @Override
            public void failed(Throwable x) {
                completable.completeExceptionally(x);
            }
        };
    }

    public static interface Invocable<R>
    extends org.eclipse.jetty.util.thread.Invocable,
    Promise<R> {
        public static <T> Invocable<T> noop() {
            return NoOp.NOOP;
        }

        public static <T> Callback toCallback(Invocable<T> promise, T result) {
            return Callback.from(promise.getInvocationType(), () -> promise.succeeded(result), promise::failed);
        }

        public static <W, T> Invocable<W> toPromise(final Invocable<T> promise, final Function<W, T> mapper) {
            return new Abstract<W>(promise.getInvocationType()){

                @Override
                public void succeeded(W result) {
                    promise.succeeded(mapper.apply(result));
                }

                @Override
                public void failed(Throwable x) {
                    promise.failed(x);
                }
            };
        }

        public static <W> Invocable<W> toPromise(final CompletableFuture<W> completable) {
            return new Abstract<W>(Invocable.InvocationType.BLOCKING){

                @Override
                public void succeeded(W result) {
                    completable.complete(result);
                }

                @Override
                public void failed(Throwable x) {
                    completable.completeExceptionally(x);
                }
            };
        }

        public static <R> BiConsumer<R, Throwable> toBiConsumer(final Invocable<R> promise) {
            return new InvocableBiConsumer<R>(promise.getInvocationType()){

                @Override
                public void accept(R result, Throwable failure) {
                    if (failure == null) {
                        promise.succeeded(result);
                    } else {
                        promise.failed(failure);
                    }
                }
            };
        }

        public static <T> Invocable<T> from(Invocable.InvocationType invocationType, final Consumer<T> success, final Consumer<Throwable> failure) {
            return new Abstract<T>(invocationType){

                @Override
                public void succeeded(T result) {
                    success.accept(result);
                }

                @Override
                public void failed(Throwable x) {
                    failure.accept(x);
                }
            };
        }

        public static <T> Invocable<T> from(Invocable.InvocationType invocationType, final BiConsumer<T, Throwable> consumer) {
            return new Abstract<T>(invocationType){

                @Override
                public void succeeded(T result) {
                    consumer.accept(result, null);
                }

                @Override
                public void failed(Throwable x) {
                    consumer.accept(null, x);
                }
            };
        }

        public static <T> Invocable<T> from(final Invocable<T> promise, final Runnable afterComplete) {
            return new Abstract<T>(promise.getInvocationType()){

                @Override
                public void succeeded(T result) {
                    try {
                        promise.succeeded(result);
                    }
                    finally {
                        afterComplete.run();
                    }
                }

                @Override
                public void failed(Throwable x) {
                    try {
                        promise.failed(x);
                    }
                    finally {
                        afterComplete.run();
                    }
                }
            };
        }

        public static <T> Invocable<T> from(final Runnable beforeComplete, final Invocable<T> promise) {
            return new Abstract<T>(promise.getInvocationType()){

                @Override
                public void succeeded(T result) {
                    try {
                        beforeComplete.run();
                    }
                    finally {
                        promise.succeeded(result);
                    }
                }

                @Override
                public void failed(Throwable x) {
                    try {
                        beforeComplete.run();
                    }
                    finally {
                        promise.failed(x);
                    }
                }
            };
        }

        public static abstract class NonBlocking<T>
        extends Abstract<T> {
            public NonBlocking() {
                super(Invocable.InvocationType.NON_BLOCKING);
            }
        }

        public static abstract class Abstract<T>
        implements Invocable<T> {
            private final Invocable.InvocationType invocationType;

            protected Abstract(Invocable.InvocationType invocationType) {
                this.invocationType = invocationType;
            }

            @Override
            public Invocable.InvocationType getInvocationType() {
                return this.invocationType;
            }
        }
    }

    public static abstract class Task<T>
    implements Promise<T>,
    Runnable {
        private final Runnable onSuccess;
        private final Consumer<Throwable> onFailure;

        public Task() {
            this.onSuccess = null;
            this.onFailure = null;
        }

        public Task(Runnable onSuccess, Consumer<Throwable> onFailure) {
            this.onSuccess = Objects.requireNonNull(onSuccess);
            this.onFailure = Objects.requireNonNull(onFailure);
        }

        @Override
        public void succeeded(T result) {
            if (this.onSuccess != null) {
                this.onSuccess.run();
            }
        }

        @Override
        public void failed(Throwable x) {
            if (this.onFailure != null) {
                this.onFailure.accept(x);
            }
        }
    }

    public static class Wrapper<W>
    implements Promise<W> {
        private final Promise<W> promise;

        public Wrapper(Promise<W> promise) {
            this.promise = Objects.requireNonNull(promise);
        }

        public Promise<W> getWrapped() {
            return this.promise;
        }

        @Override
        public void succeeded(W result) {
            this.promise.succeeded(result);
        }

        @Override
        public void failed(Throwable x) {
            this.promise.failed(x);
        }
    }

    public static class Completable<S>
    extends CompletableFuture<S>
    implements Promise<S> {
        public static <R> Completable<R> with(Consumer<Promise<R>> consumer) {
            Completable completable = new Completable();
            consumer.accept(completable);
            return completable;
        }

        @Override
        public void succeeded(S result) {
            this.complete(result);
        }

        @Override
        public void failed(Throwable x) {
            this.completeExceptionally(x);
        }
    }
}

