/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.log;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.log.LoggerLog;
import org.eclipse.jetty.util.log.StdErrLog;

public class Log {
    private static final String[] __nestedEx = new String[]{"getTargetException", "getTargetError", "getException", "getRootCause"};
    private static final Class[] __noArgs = new Class[0];
    public static final String EXCEPTION = "EXCEPTION ";
    public static final String IGNORED = "IGNORED";
    public static final String IGNORED_FMT = "IGNORED: {}";
    public static final String NOT_IMPLEMENTED = "NOT IMPLEMENTED ";
    public static String __logClass;
    public static boolean __verbose;
    public static boolean __ignored;
    private static Logger __log;
    private static boolean _initialized;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean initialized() {
        if (__log != null) {
            return true;
        }
        Class<Log> clazz = Log.class;
        synchronized (Log.class) {
            if (_initialized) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return __log != null;
            }
            _initialized = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            Class log_class = null;
            try {
                log_class = Loader.loadClass(Log.class, __logClass);
                if (__log == null || !__log.getClass().equals(log_class)) {
                    __log = (Logger)log_class.newInstance();
                    __log.info("Logging to {} via {}", __log, log_class.getName());
                }
            }
            catch (NoClassDefFoundError e) {
                Log.initStandardLogging(e);
            }
            catch (Exception e) {
                Log.initStandardLogging(e);
            }
            return __log != null;
        }
    }

    private static void initStandardLogging(Throwable e) {
        if (__log == null) {
            Class<StdErrLog> log_class = StdErrLog.class;
            __log = new StdErrLog();
            __log.info("Logging to {} via {}", __log, log_class.getName());
            if (e != null && __verbose) {
                e.printStackTrace();
            }
        }
    }

    public static void setLog(Logger log) {
        __log = log;
    }

    public static Logger getLog() {
        Log.initialized();
        return __log;
    }

    public static void setLogToParent(String name) {
        ClassLoader loader = Log.class.getClassLoader();
        if (loader.getParent() != null) {
            try {
                Class<?> uberlog = loader.getParent().loadClass("org.eclipse.jetty.util.log.Log");
                Method getLogger = uberlog.getMethod("getLogger", String.class);
                Object logger = getLogger.invoke(null, name);
                Log.setLog(new LoggerLog(logger));
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Log.setLog(Log.getLogger(name));
    }

    public static void debug(Throwable th) {
        if (!Log.isDebugEnabled()) {
            return;
        }
        __log.debug(EXCEPTION, th);
        Log.unwind(th);
    }

    public static void debug(String msg) {
        if (!Log.initialized()) {
            return;
        }
        __log.debug(msg, null, null);
    }

    public static void debug(String msg, Object arg) {
        if (!Log.initialized()) {
            return;
        }
        __log.debug(msg, arg, null);
    }

    public static void debug(String msg, Object arg0, Object arg1) {
        if (!Log.initialized()) {
            return;
        }
        __log.debug(msg, arg0, arg1);
    }

    public static void ignore(Throwable th) {
        if (!Log.initialized()) {
            return;
        }
        if (__ignored) {
            __log.warn(IGNORED, th);
            Log.unwind(th);
        } else if (__verbose) {
            __log.warn(IGNORED, th);
            Log.unwind(th);
        }
    }

    public static void info(String msg) {
        if (!Log.initialized()) {
            return;
        }
        __log.info(msg, null, null);
    }

    public static void info(String msg, Object arg) {
        if (!Log.initialized()) {
            return;
        }
        __log.info(msg, arg, null);
    }

    public static void info(String msg, Object arg0, Object arg1) {
        if (!Log.initialized()) {
            return;
        }
        __log.info(msg, arg0, arg1);
    }

    public static boolean isDebugEnabled() {
        if (!Log.initialized()) {
            return false;
        }
        return __log.isDebugEnabled();
    }

    public static void warn(String msg) {
        if (!Log.initialized()) {
            return;
        }
        __log.warn(msg, null, null);
    }

    public static void warn(String msg, Object arg) {
        if (!Log.initialized()) {
            return;
        }
        __log.warn(msg, arg, null);
    }

    public static void warn(String msg, Object arg0, Object arg1) {
        if (!Log.initialized()) {
            return;
        }
        __log.warn(msg, arg0, arg1);
    }

    public static void warn(String msg, Throwable th) {
        if (!Log.initialized()) {
            return;
        }
        __log.warn(msg, th);
        Log.unwind(th);
    }

    public static void warn(Throwable th) {
        if (!Log.initialized()) {
            return;
        }
        __log.warn(EXCEPTION, th);
        Log.unwind(th);
    }

    public static Logger getLogger(String name) {
        if (!Log.initialized()) {
            return null;
        }
        if (name == null) {
            return __log;
        }
        return __log.getLogger(name);
    }

    private static void unwind(Throwable th) {
        if (th == null) {
            return;
        }
        for (int i = 0; i < __nestedEx.length; ++i) {
            try {
                Method get_target = th.getClass().getMethod(__nestedEx[i], __noArgs);
                Throwable th2 = (Throwable)get_target.invoke((Object)th, (Object[])null);
                if (th2 == null || th2 == th) continue;
                Log.warn("Nested in " + th + ":", th2);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                __logClass = System.getProperty("org.eclipse.jetty.util.log.class", "org.eclipse.jetty.util.log.Slf4jLog");
                __verbose = System.getProperty("VERBOSE", null) != null;
                __ignored = System.getProperty(Log.IGNORED, null) != null;
                return true;
            }
        });
    }
}

